/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationsListEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectCvsConfgurationPanel
extends JPanel {
    private final DefaultListModel myModel = new DefaultListModel();
    private final JList myList = new JList(this.myModel);
    private CvsRootConfiguration mySelection;
    private final Project myProject;
    private final MyObservable myObservable;

    public SelectCvsConfgurationPanel(Project project) {
        super(new BorderLayout(2, 4));
        this.myProject = project;
        this.add((Component)this.createListPanel(), "Center");
        this.add(this.createButtonPanel(), "East");
        this.myObservable = new MyObservable();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectCvsConfgurationPanel.this.mySelection = (CvsRootConfiguration)SelectCvsConfgurationPanel.this.myList.getSelectedValue();
                SelectCvsConfgurationPanel.this.myObservable.setChanged();
                SelectCvsConfgurationPanel.this.myObservable.notifyObservers(SelectCvsConfgurationPanel.this.mySelection);
            }
        });
        this.myList.setSelectionMode(0);
        this.fillModel(null);
    }

    private Component createButtonPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JButton jButton = new JButton(CvsBundle.message((String)"button.text.configure.cvs.roots", (Object[])new Object[0]));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectCvsConfgurationPanel.this.editConfigurations();
            }
        });
        result.add((Component)jButton, "North");
        return result;
    }

    private JPanel createListPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myList);
        result.add((Component)scrollPane, "Center");
        scrollPane.setFocusable(false);
        return result;
    }

    public void editConfigurations() {
        CvsConfigurationsListEditor cvsConfigurationsListEditor = new CvsConfigurationsListEditor(new ArrayList<CvsRootConfiguration>(this.getConfigurationList()), this.myProject);
        CvsRootConfiguration selectedConfiguration = this.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            cvsConfigurationsListEditor.selectConfiguration(selectedConfiguration);
        }
        cvsConfigurationsListEditor.show();
        if (cvsConfigurationsListEditor.isOK()) {
            this.getConfiguration().CONFIGURATIONS = new ArrayList<CvsRootConfiguration>(cvsConfigurationsListEditor.getConfigurations());
            this.fillModel(cvsConfigurationsListEditor.getSelectedConfiguration());
        }
    }

    private void fillModel(Object selectedConfiguration) {
        Object oldSelection = selectedConfiguration == null ? this.myList.getSelectedValue() : selectedConfiguration;
        this.myModel.removeAllElements();
        List<CvsRootConfiguration> configurations = this.getConfigurationList();
        for (CvsRootConfiguration configuration : configurations) {
            this.myModel.addElement(configuration);
        }
        this.myList.setSelectedValue(oldSelection, true);
        if (this.myList.getSelectedIndex() < 0 && this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    private List<CvsRootConfiguration> getConfigurationList() {
        return this.getConfiguration().CONFIGURATIONS;
    }

    private CvsApplicationLevelConfiguration getConfiguration() {
        return CvsApplicationLevelConfiguration.getInstance();
    }

    public CvsRootConfiguration getSelectedConfiguration() {
        return this.mySelection;
    }

    public Observable getObservable() {
        return this.myObservable;
    }

    public Component getJList() {
        return this.myList;
    }

    private static class MyObservable
    extends Observable {
        private MyObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }
}

