/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntElementImpl;
import com.intellij.lang.ant.psi.impl.reference.AntEntityReference;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntEntityRefImpl
extends AntElementImpl {
    private PsiReference[] myRefs;

    public AntEntityRefImpl(AntStructuredElement parent, XmlElement sourceElement) {
        super(parent, sourceElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myRefs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myRefs == null) {
            List<PsiReference> refList = PsiReferenceListSpinAllocator.alloc();
            try {
                for (PsiReference ref : this.getSourceElement().getReferences()) {
                    refList.add(new AntEntityReference(this, ref));
                }
                this.myRefs = refList.toArray(new PsiReference[refList.size()]);
            }
            finally {
                PsiReferenceListSpinAllocator.dispose(refList);
            }
        }
        // MONITOREXIT : object
        if (this.myRefs != null) return this.myRefs;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntEntityRefImpl.getReferences must not return null");
    }
}

