/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.extapi.psi.MetadataPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.AntLanguage;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.impl.AntFileImpl;
import com.intellij.lang.ant.psi.impl.reference.AntReferenceProvidersRegistry;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntElementImpl
extends MetadataPsiElementBase
implements AntElement {
    protected static final AntElement ourNull = new AntElementImpl(null, null){

        @NonNls
        public String getName() {
            return "AntNull";
        }

        @Override
        public boolean isValid() {
            return true;
        }
    };
    private final AntElement myParent;
    private volatile AntElement[] myChildren;
    private volatile PsiReference[] myReferences;
    private volatile PsiElement myPrev;
    private volatile PsiElement myNext;
    PsiManager myCachedManager;

    public AntElementImpl(AntElement parent, XmlElement sourceElement) {
        super((PsiElement)sourceElement);
        this.myParent = parent;
    }

    @NotNull
    public AntLanguage getLanguage() {
        AntLanguage antLanguage = AntSupport.getLanguage();
        if (antLanguage == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntElementImpl.getLanguage must not return null");
        }
        return antLanguage;
    }

    @Override
    public XmlElement getSourceElement() {
        return (XmlElement)super.getSourceElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntElement[");
            builder.append(this == ourNull ? "null" : this.getSourceElement().toString());
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    @Nullable
    public AntElement getAntParent() {
        return this.myParent;
    }

    @Override
    public AntProject getAntProject() {
        AntElementImpl element = this;
        while (!(element instanceof AntProject)) {
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (AntProject)((Object)element);
    }

    @Override
    public AntFile getAntFile() {
        AntElement element = this.getParent();
        while (!(element instanceof AntFile)) {
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (AntFile)element;
    }

    public AntElement getParent() {
        return this.myParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public AntElement[] getChildren() {
        AntElement[] antElementArray;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntFileImpl antFile;
            if (this.myChildren == null && (antFile = (AntFileImpl)this.getAntFile()) != null) {
                antFile.buildPropertiesIfNeeded();
            }
            if (this.myChildren != null) {
                // MONITOREXIT @DISABLED, blocks:[2, 8] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                antElementArray = this.myChildren;
                if (this.myChildren == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntElementImpl.getChildren must not return null");
                return antElementArray;
            }
            this.myChildren = this.getChildrenInner();
        }
        antElementArray = this.myChildren;
        if (this.myChildren != null) return antElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntElementImpl.getChildren must not return null");
    }

    @Nullable
    public AntElement getFirstChild() {
        AntElement[] children = this.getChildren();
        return children.length == 0 ? null : children[0];
    }

    @Nullable
    public PsiElement getLastChild() {
        AntElement[] children = this.getChildren();
        return children.length == 0 ? null : children[children.length - 1];
    }

    @Nullable
    public PsiElement getNextSibling() {
        AntElement parent;
        if (this.myNext == null && (parent = this.getAntParent()) != null) {
            PsiElement temp = null;
            for (PsiElement element : parent.getChildren()) {
                if (temp != null) {
                    this.myNext = element;
                    break;
                }
                if (element != this) continue;
                temp = element;
            }
        }
        return this.myNext;
    }

    @Nullable
    public PsiElement getPrevSibling() {
        if (this.myPrev == null) {
            PsiElement prev = null;
            AntElement parent = this.getAntParent();
            if (parent != null) {
                for (PsiElement element : parent.getChildren()) {
                    if (element == this) break;
                    prev = element;
                }
            }
            this.myPrev = prev;
        }
        return this.myPrev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myChildren = null;
            this.myReferences = null;
            this.myPrev = null;
            this.myNext = null;
            this.incModificationCount();
        }
    }

    @Override
    public void incModificationCount() {
        this.getAntFile().incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntElement lightFindElementAt(int offset) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myChildren == null) {
                return this;
            }
            TextRange ownRange = this.getTextRange();
            int offsetInFile = offset + ownRange.getStartOffset();
            for (AntElement element : this.getChildren()) {
                TextRange textRange = element.getTextRange();
                if (!textRange.contains(offsetInFile)) continue;
                return element.lightFindElementAt(offsetInFile - textRange.getStartOffset());
            }
            return ownRange.contains(offsetInFile) ? this : null;
        }
    }

    public PsiElement findElementAt(int offset) {
        if (!this.isValid()) {
            return null;
        }
        TextRange ownRange = this.getTextRange();
        int offsetInFile = offset + ownRange.getStartOffset();
        for (AntElement element : this.getChildren()) {
            TextRange textRange = element.getTextRange();
            if (!textRange.contains(offsetInFile)) continue;
            PsiElement elementAt = element.findElementAt(offsetInFile - textRange.getStartOffset());
            assert (elementAt == null || elementAt.isValid()) : element + ": " + offset;
            return elementAt;
        }
        return ownRange.contains(offsetInFile) ? this : null;
    }

    public ASTNode getNode() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        if (this.myReferences != null) {
            psiReferenceArray = this.myReferences;
            if (this.myReferences == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntElementImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        PsiReferenceProvider[] providers = AntReferenceProvidersRegistry.getProvidersByElement(this);
        List<PsiReference> result = PsiReferenceListSpinAllocator.alloc();
        for (PsiReferenceProvider provider : providers) {
            result.addAll(Arrays.asList(provider.getReferencesByElement((PsiElement)this, new ProcessingContext())));
        }
        this.myReferences = result.toArray(new PsiReference[result.size()]);
        PsiReference[] psiReferenceArray2 = this.myReferences;
        psiReferenceArray = psiReferenceArray2;
        if (psiReferenceArray2 != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntElementImpl.getReferences must not return null");
        finally {
            PsiReferenceListSpinAllocator.dispose(result);
        }
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.NULL_ROLE;
    }

    @Override
    public boolean canRename() {
        return this.isPhysical();
    }

    public boolean isPhysical() {
        return this.getSourceElement().isPhysical();
    }

    public boolean isValid() {
        return this.getSourceElement().isValid();
    }

    public PsiManager getManager() {
        PsiManager manager = this.myCachedManager;
        if (manager == null) {
            this.myCachedManager = manager = this.getSourceElement().getManager();
        }
        return manager;
    }

    protected AntElement[] getChildrenInner() {
        return AntElement.EMPTY_ARRAY;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntElementImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntElement(this);
    }

    protected AntElement clone() {
        AntElementImpl element = (AntElementImpl)super.clone();
        element.clearCaches();
        return element;
    }

    public Icon getElementIcon(int flags) {
        return this.getRole().getIcon();
    }
}

