#!/bin/sh
echo 'name: hashed-storage
version: 0.5.2
id: hashed-storage-0.5.2-b5d552dcc75dcc4fda0ff8b74d67f230

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.2
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.2
hs-libraries: HShashed-storage-0.5.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         binary-0.5.0.2-89481d508ae9510a91c30d5d669395e9
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         containers-0.3.0.0-7be04792060ce1514c52e2cb13a5c18a
         dataenc-0.13.0.2-77e66d9d0bbcfc11bb0bc20e59edae9f
         directory-1.0.1.1-7962558b34e6144244ddec948ea3bb41
         extensible-exceptions-0.1.1.1-28a83091e117b2e719d4a1c4a320a1c8
         filepath-1.1.0.4-1425f312faf5b8e9f4babf887e252326
         mmap-0.5.6-818140db7400cceed6cb02eb8cc0ca64
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         zlib-0.5.2.0-8e0dda775cfb8c74f8a32c600a1d6f70
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.2/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
