#!/bin/sh
echo 'name: crypto-api
version: 0.2.1
id: crypto-api-0.2.1-ed5a439f0220607c69a3575a34b18dae

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Dominic Steinitz (see Data.LargeWord module)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
description: A generic interface for cryptographic operations,
             platform independent quality RNG, property tests
             and known-answer tests (KATs) for common algorithms,
             and a basic benchmark infrastructure.
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Dominic Steinitz
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Data.LargeWord Crypto.Modes System.Crypto.Random Crypto.Random
                 Crypto.Padding
hidden-modules:
import-dirs: /usr/local/lib/ghc/crypto-api-0.2.1
library-dirs: /usr/local/lib/ghc/crypto-api-0.2.1
hs-libraries: HScrypto-api-0.2.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         cereal-0.3.0.0-969871fe078e0d7e344486d6f7f79155
         tagged-0.1.1-d28ce3501b73b125b8a64cd1a9fd75b6
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.2.1/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.2.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
