#!/bin/sh
echo 'name: ListLike
version: 1.0.1
id: ListLike-1.0.1-7c265cf1b3009427ee314314cd9eaaf3

license: LGPL
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
                 Data.ListLike.String Data.ListLike.Utils
hidden-modules:
import-dirs: /usr/local/lib/ghc/ListLike-1.0.1
library-dirs: /usr/local/lib/ghc/ListLike-1.0.1
hs-libraries: HSListLike-1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.1-d386e6865e2443d798e250f58dda005d
         base-4.2.0.2-af431bb15643ef1ce2792a51c33968b3
         bytestring-0.9.1.7-352f069cca85cb3f9e4c06bb76ec4cec
         containers-0.3.0.0-7be04792060ce1514c52e2cb13a5c18a
         haskell98-1.0.1.1-4d2891ad99eae334ff8234bcfbddce06
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-1.0.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-1.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
