/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.logging.Logger;

class ListCmd
extends Command {
    private static final Logger log = Logger.getLogger(ListCmd.class$("gnu.classpath.tools.keytool.ListCmd").getName());
    protected String _alias;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean rfc;
    private boolean all;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    public void setRfc(String string) {
        this.rfc = Boolean.valueOf(string);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(null);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        boolean bl = this.all = this._alias == null;
        if (!this.all) {
            this.setAliasParam(this._alias);
        }
        if (this.verbose & this.rfc) {
            if (Configuration.DEBUG) {
                log.fine("Both -v and -rfc options were found on the command line. Only the former will be considered");
            }
            this.rfc = false;
        }
        if (Configuration.DEBUG) {
            log.fine("-list handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
            log.fine("  -rfc=" + this.rfc);
        }
    }

    void start() throws KeyStoreException, CertificateEncodingException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        PrintWriter printWriter = new PrintWriter(this.outStream, true);
        printWriter.println(Messages.getFormattedString("ListCmd.21", this.store.getType()));
        printWriter.println(Messages.getFormattedString("ListCmd.22", this.store.getProvider().getName()));
        if (this.all) {
            if (Configuration.DEBUG) {
                log.fine("About to list all aliases in key store...");
            }
            printWriter.println();
            printWriter.println(Messages.getFormattedString("ListCmd.24", this.store.size()));
            Enumeration<String> enumeration = this.store.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (string == null) continue;
                this.list1Alias(string, printWriter);
            }
        } else {
            this.list1Alias(this.alias, printWriter);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("list", true);
        classpathToolParser.setHeader(Messages.getString("ListCmd.20"));
        classpathToolParser.setFooter(Messages.getString("ListCmd.19"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("ListCmd.18"));
        optionGroup.add(new Option(this, "alias", Messages.getString("ListCmd.17"), Messages.getString("ListCmd.16")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("ListCmd.15"), Messages.getString("ListCmd.14")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("ListCmd.13"), Messages.getString("ListCmd.12")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("ListCmd.11"), Messages.getString("ListCmd.10")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("ListCmd.9"), Messages.getString("ListCmd.8")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("ListCmd.7")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        optionGroup.add(new Option(this, "rfc", Messages.getString("ListCmd.6")){
            private /* synthetic */ ListCmd this$0;
            {
                this.this$0 = listCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.rfc = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void list1Alias(String string, PrintWriter printWriter) throws KeyStoreException, CertificateEncodingException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "list1Alias", string);
        }
        printWriter.println();
        printWriter.println(Messages.getFormattedString("ListCmd.30", string));
        printWriter.println(Messages.getFormattedString("ListCmd.31", this.store.getCreationDate(string)));
        if (this.store.isCertificateEntry(string)) {
            printWriter.println(Messages.getString("ListCmd.32"));
            Certificate certificate = this.store.getCertificate(string);
            this.print1Certificate(certificate, printWriter);
        } else if (this.store.isKeyEntry(string)) {
            printWriter.println(Messages.getString("ListCmd.33"));
            Certificate[] certificateArray = this.store.getCertificateChain(string);
            this.print1Chain(certificateArray, printWriter);
        } else {
            throw new IllegalArgumentException(Messages.getFormattedString("ListCmd.34", string));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "list1Alias");
        }
    }

    private void print1Chain(Certificate[] certificateArray, PrintWriter printWriter) throws CertificateEncodingException {
        if (!this.verbose && !this.rfc) {
            this.fingerprint(certificateArray[0], printWriter);
        } else {
            int n = certificateArray.length;
            printWriter.println(Messages.getFormattedString("ListCmd.38", n));
            printWriter.println(Messages.getString("ListCmd.39"));
            this.print1Certificate(certificateArray[0], printWriter);
            for (int i = 1; i < n; ++i) {
                printWriter.println();
                printWriter.println(Messages.getFormattedString("ListCmd.40", i + 1));
                this.print1Certificate(certificateArray[i], printWriter);
            }
            printWriter.println();
            printWriter.println(Messages.getString("ListCmd.42"));
        }
    }

    private void print1Certificate(Certificate certificate, PrintWriter printWriter) throws CertificateEncodingException {
        if (this.verbose) {
            this.printVerbose(certificate, printWriter);
        } else if (this.rfc) {
            this.printRFC1421(certificate, printWriter);
        } else {
            this.fingerprint(certificate, printWriter);
        }
    }

    private void printRFC1421(Certificate certificate, PrintWriter printWriter) throws CertificateEncodingException {
        byte[] byArray = certificate.getEncoded();
        String string = Base64.encode((byte[])byArray, (int)0, (int)byArray.length, (boolean)true);
        printWriter.println(Messages.getString("ListCmd.43"));
        printWriter.println(string);
        printWriter.println(Messages.getString("ListCmd.44"));
    }

    private void fingerprint(Certificate certificate, PrintWriter printWriter) throws CertificateEncodingException {
        byte[] byArray = certificate.getEncoded();
        String string = this.digestWithMD5(byArray);
        printWriter.println(Messages.getFormattedString("ListCmd.45", string));
    }

    ListCmd() {
    }
}

