/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String CANONICAL = "CANONICAL";
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    private static final OID CN;
    private static final OID C;
    private static final OID L;
    private static final OID ST;
    private static final OID STREET;
    private static final OID O;
    private static final OID OU;
    private static final OID DC;
    private static final OID UID;
    private transient List components = new LinkedList();
    private transient Map currentRdn = new LinkedHashMap();
    private transient boolean fixed;
    private transient byte[] encoded;
    private int sep;

    private X500Principal() {
        this.components.add(this.currentRdn);
    }

    public X500Principal(String string) {
        this();
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.parseString(string);
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("malformed name");
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }

    public X500Principal(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public X500Principal(InputStream inputStream) {
        this();
        try {
            this.parseDer(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public int hashCode() {
        int n = this.size();
        for (int i = 0; i < this.size(); ++i) {
            Map map = (Map)this.components.get(i);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                n = n * 31 + ((OID)entry.getKey()).hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X500Principal)) {
            return false;
        }
        if (this.size() != ((X500Principal)object).size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Map map = (Map)this.components.get(i);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                OID oID = (OID)entry.getKey();
                String string = (String)entry.getValue();
                String string2 = ((X500Principal)object).getComponent(oID, i);
                if (string2 == null) {
                    return false;
                }
                if (X500Principal.compressWS(string).equalsIgnoreCase(X500Principal.compressWS(string2))) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encodeDer();
        }
        return (byte[])this.encoded.clone();
    }

    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String string) {
        boolean bl = RFC2253.equalsIgnoreCase(string) || CANONICAL.equalsIgnoreCase(string);
        boolean bl2 = RFC1779.equalsIgnoreCase(string);
        boolean bl3 = CANONICAL.equalsIgnoreCase(string);
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("unsupported format " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                OID oID = (OID)entry.getKey();
                String string2 = (String)entry.getValue();
                if (oID.equals(CN)) {
                    stringBuffer.append("CN");
                } else if (oID.equals(C)) {
                    stringBuffer.append("C");
                } else if (oID.equals(L)) {
                    stringBuffer.append("L");
                } else if (oID.equals(ST)) {
                    stringBuffer.append("ST");
                } else if (oID.equals(STREET)) {
                    stringBuffer.append("STREET");
                } else if (oID.equals(O)) {
                    stringBuffer.append("O");
                } else if (oID.equals(OU)) {
                    stringBuffer.append("OU");
                } else if (oID.equals(DC) && bl) {
                    stringBuffer.append("DC");
                } else if (oID.equals(UID) && bl) {
                    stringBuffer.append("UID");
                } else {
                    stringBuffer.append(oID.toString());
                }
                stringBuffer.append('=');
                stringBuffer.append(string2);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append('+');
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        if (bl3) {
            return stringBuffer.toString().toUpperCase(Locale.US).toLowerCase(Locale.US);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getName(RFC2253);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.encoded != null) {
            this.encodeDer();
        }
        objectOutputStream.writeObject(this.encoded);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.parseDer(new ByteArrayInputStream(byArray));
    }

    private int size() {
        return this.components.size();
    }

    private String getComponent(OID oID, int n) {
        if (n >= this.size()) {
            return null;
        }
        return (String)((Map)this.components.get(n)).get(oID);
    }

    private void encodeDer() {
        ArrayList arrayList = new ArrayList(this.components.size());
        Object object = this.components.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            if (map.isEmpty()) continue;
            HashSet hashSet = new HashSet();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ArrayList arrayList2 = new ArrayList(2);
                arrayList2.add(new DERValue(6, entry.getKey()));
                arrayList2.add(new DERValue(12, entry.getValue()));
                hashSet.add(new DERValue(48, arrayList2));
            }
            arrayList.add(new DERValue(49, hashSet));
        }
        object = new DERValue(48, arrayList);
        this.encoded = ((DERValue)object).getEncoded();
    }

    private void parseString(String string) throws IOException {
        String string2;
        StringReader stringReader = new StringReader(string);
        while ((string2 = this.readAttributeType(stringReader)) != null) {
            String string3 = this.readAttributeValue(stringReader);
            this.putComponent(string2, string3);
            if (this.sep == 44) {
                this.newRelativeDistinguishedName();
            }
            if (this.sep != -1) continue;
            break;
        }
    }

    private String readAttributeType(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != 61) {
            if (n == -1) {
                if (stringBuffer.length() > 0) {
                    throw new EOFException("partial name read: " + stringBuffer);
                }
                return null;
            }
            if (n > 127) {
                throw new IOException("Invalid char: " + (char)n);
            }
            if (Character.isLetterOrDigit((char)n) || n == 45 || n == 46) {
                stringBuffer.append((char)n);
                continue;
            }
            throw new IOException("Invalid char: " + (char)n);
        }
        return stringBuffer.toString();
    }

    private String readAttributeValue(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        if (n == 35) {
            while (97 <= (n = reader.read()) && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                stringBuffer.append((char)n);
            }
            if (n == 43 || n == 44) {
                this.sep = n;
                String string = stringBuffer.toString();
                return new String(X500Principal.toByteArray(string));
            }
            throw new IOException("illegal character: " + (char)n);
        }
        if (n == 34) {
            while ((n = reader.read()) != 34) {
                if (n == 92) {
                    n = reader.read();
                    if (n == -1) {
                        throw new EOFException();
                    }
                    if (97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                        int n2 = Character.digit((char)n, 16) << 4;
                        n = reader.read();
                        if (!(97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n))) {
                            throw new IOException("illegal hex char");
                        }
                        stringBuffer.append((char)(n2 |= Character.digit((char)n, 16)));
                        continue;
                    }
                    stringBuffer.append((char)n);
                    continue;
                }
                stringBuffer.append((char)n);
            }
            this.sep = reader.read();
            if (this.sep != 43 && this.sep != 44) {
                throw new IOException("illegal character: " + (char)n);
            }
            return stringBuffer.toString();
        }
        while (true) {
            switch (n) {
                case 43: 
                case 44: {
                    this.sep = n;
                    return stringBuffer.toString();
                }
                case 92: {
                    n = reader.read();
                    if (n == -1) {
                        throw new EOFException();
                    }
                    if (97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                        int n3 = Character.digit((char)n, 16) << 4;
                        n = reader.read();
                        if (!(97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n))) {
                            throw new IOException("illegal hex char");
                        }
                        stringBuffer.append((char)(n3 |= Character.digit((char)n, 16)));
                        break;
                    }
                    stringBuffer.append((char)n);
                    break;
                }
                case 35: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    throw new IOException("illegal character: " + (char)n);
                }
                case -1: {
                    this.sep = -1;
                    return stringBuffer.toString();
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
            n = reader.read();
        }
    }

    private void parseDer(InputStream inputStream) throws IOException {
        DERReader dERReader = new DERReader(inputStream);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed Name");
        }
        this.encoded = dERValue.getEncoded();
        int n = 0;
        while (n < dERValue.getLength()) {
            DERValue dERValue2;
            DERValue dERValue3 = dERReader.read();
            if (!dERValue3.isConstructed()) {
                throw new IOException("badly formed RDNSequence");
            }
            for (int i = 0; i < dERValue3.getLength(); i += dERValue2.getEncodedLength()) {
                dERValue2 = dERReader.read();
                if (!dERValue2.isConstructed()) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                DERValue dERValue4 = dERReader.read();
                if (dERValue4.getTag() != 6) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                OID oID = (OID)dERValue4.getValue();
                dERValue4 = dERReader.read();
                if (!(dERValue4.getValue() instanceof String)) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                String string = (String)dERValue4.getValue();
                this.putComponent(oID, string);
            }
            if ((n += dERValue3.getEncodedLength()) >= dERValue.getLength()) continue;
            this.newRelativeDistinguishedName();
        }
    }

    private void newRelativeDistinguishedName() {
        this.currentRdn = new LinkedHashMap();
        this.components.add(this.currentRdn);
    }

    private void putComponent(OID oID, String string) {
        this.currentRdn.put(oID, string);
    }

    private void putComponent(String string, String string2) {
        if ((string = string.trim().toLowerCase()).equals("cn")) {
            this.putComponent(CN, string2);
        } else if (string.equals("c")) {
            this.putComponent(C, string2);
        } else if (string.equals("l")) {
            this.putComponent(L, string2);
        } else if (string.equals("street")) {
            this.putComponent(STREET, string2);
        } else if (string.equals("st")) {
            this.putComponent(ST, string2);
        } else if (string.equals("o")) {
            this.putComponent(O, string2);
        } else if (string.equals("ou")) {
            this.putComponent(OU, string2);
        } else if (string.equals("dc")) {
            this.putComponent(DC, string2);
        } else if (string.equals("uid")) {
            this.putComponent(UID, string2);
        } else {
            this.putComponent(new OID(string), string2);
        }
    }

    private static String compressWS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                if (!Character.isWhitespace(c)) {
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c2);
            }
            c = c2;
        }
        return stringBuffer.toString().trim();
    }

    private static byte[] toByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)Character.digit(string.charAt(n2++), 16);
        }
        while (n2 < n) {
            byArray[n3] = (byte)(Character.digit(string.charAt(n2++), 16) << 4);
            int n4 = n3++;
            byArray[n4] = byArray[n4] | (byte)Character.digit(string.charAt(n2++), 16);
        }
        return byArray;
    }

    static {
        CANONICAL = CANONICAL;
        RFC1779 = RFC1779;
        RFC2253 = RFC2253;
        CN = new OID("2.5.4.3");
        C = new OID("2.5.4.6");
        L = new OID("2.5.4.7");
        ST = new OID("2.5.4.8");
        STREET = new OID("2.5.4.9");
        O = new OID("2.5.4.10");
        OU = new OID("2.5.4.11");
        DC = new OID("0.9.2342.19200300.100.1.25");
        UID = new OID("0.9.2342.19200300.100.1.1");
    }
}

