/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;

public class PBEKeySpec
implements KeySpec {
    private int iterationCount;
    private int keyLength;
    private char[] password;
    private byte[] salt;
    private boolean passwordValid;

    private /* synthetic */ void finit$() {
        this.passwordValid = true;
    }

    public PBEKeySpec(char[] cArray) {
        this.finit$();
        this.setPassword(cArray);
        this.salt = null;
        this.iterationCount = 0;
        this.keyLength = 0;
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n) {
        this.finit$();
        this.setPassword(cArray);
        this.setSalt(byArray);
        this.setIterationCount(n);
        this.keyLength = 0;
    }

    public PBEKeySpec(char[] cArray, byte[] byArray, int n, int n2) {
        this.finit$();
        this.setPassword(cArray);
        this.setSalt(byArray);
        this.setIterationCount(n);
        this.setKeyLength(n2);
    }

    public final void clearPassword() {
        if (this.password == null) {
            return;
        }
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        this.passwordValid = false;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final char[] getPassword() {
        if (!this.passwordValid) {
            throw new IllegalStateException("clearPassword() has been called, the password is no longer valid");
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (this.salt != null) {
            return (byte[])this.salt.clone();
        }
        return null;
    }

    private void setPassword(char[] cArray) {
        this.password = cArray != null ? (char[])cArray.clone() : new char[0];
        this.passwordValid = true;
    }

    private void setSalt(byte[] byArray) {
        if (byArray.length == 0) {
            throw new IllegalArgumentException("salt MUST NOT be an empty byte array");
        }
        this.salt = (byte[])byArray.clone();
    }

    private void setIterationCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("iterationCount MUST be positive");
        }
        this.iterationCount = n;
    }

    private void setKeyLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("keyLength MUST be positive");
        }
        this.keyLength = n;
    }
}

