/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import gnu.classpath.SystemProperties;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;

public class LogManager {
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    private static LogManager logManager;
    private static LoggingMXBean loggingBean;
    private Map loggers;
    private Properties properties;
    private final PropertyChangeSupport pcs;
    private static final String MANAGER_PROPERTY = "java.util.logging.manager";
    private static final String CONFIG_PROPERTY = "java.util.logging.config.class";
    private static final LoggingPermission controlPermission;

    private /* synthetic */ void finit$() {
        this.pcs = new PropertyChangeSupport(LogManager.class$("java.util.logging.LogManager"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected LogManager() {
        this.finit$();
        this.loggers = new HashMap();
    }

    public static synchronized LogManager getLogManager() {
        if (logManager == null) {
            logManager = LogManager.makeLogManager();
            LogManager.initLogManager();
        }
        return logManager;
    }

    private static LogManager makeLogManager() {
        String string = SystemProperties.getProperty(MANAGER_PROPERTY);
        LogManager logManager = (LogManager)LogManager.createInstance(string, LogManager.class$("java.util.logging.LogManager"), MANAGER_PROPERTY);
        if (logManager == null) {
            logManager = new LogManager();
        }
        return logManager;
    }

    private static void initLogManager() {
        LogManager logManager = LogManager.getLogManager();
        Logger.root.setLevel(Level.INFO);
        logManager.addLogger(Logger.root);
        Object object = LogManager.createInstance(System.getProperty(CONFIG_PROPERTY), LogManager.class$("java.lang.Object"), CONFIG_PROPERTY);
        try {
            if (object == null) {
                logManager.readConfiguration();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeListener.getClass();
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        String string;
        String string2 = logger.getName();
        WeakReference weakReference = (WeakReference)this.loggers.get(string2);
        if (weakReference != null) {
            if (weakReference.get() != null) {
                return false;
            }
            this.loggers.remove(weakReference);
        }
        if (string2 != null && !string2.equals("")) {
            this.checkAccess();
        }
        Logger logger2 = this.findAncestor(logger);
        this.loggers.put(string2, new WeakReference(logger));
        if (logger2 != logger.getParent()) {
            logger.setParent(logger2);
        }
        Level level = logger.getLevel();
        String string3 = string2;
        String string4 = string = logger2 != null ? logger2.getName() : "";
        while (level == null && !string3.equals(string)) {
            level = LogManager.getLevelProperty(string3 + ".level", level);
            int n = string3.lastIndexOf(46);
            if (n > -1) {
                string3 = string3.substring(0, n);
                continue;
            }
            string3 = "";
        }
        logger.setLevel(level);
        Iterator iterator = this.loggers.keySet().iterator();
        while (iterator.hasNext()) {
            Logger logger3 = (Logger)((WeakReference)this.loggers.get(iterator.next())).get();
            if (logger3 == null || logger3 == logger || logger3.getParent() != logger2 || !logger3.getName().startsWith(string2) || logger3.getName().charAt(string2.length()) != '.') continue;
            logger3.setParent(logger);
        }
        return true;
    }

    private synchronized Logger findAncestor(Logger logger) {
        String string = logger.getName();
        int n = string.length();
        Logger logger2 = Logger.root;
        int n2 = 0;
        if (logger == Logger.root) {
            return null;
        }
        Iterator iterator = this.loggers.keySet().iterator();
        while (iterator.hasNext()) {
            Logger logger3;
            String string2 = (String)iterator.next();
            int n3 = string2.length();
            if (n3 <= n2 || n <= n3 || !string.startsWith(string2) || string.charAt(n3) != '.' || (logger3 = (Logger)((WeakReference)this.loggers.get(string2)).get()) == null || logger3 == logger) continue;
            n2 = string2.length();
            logger2 = logger3;
        }
        return logger2;
    }

    public synchronized Logger getLogger(String string) {
        string.getClass();
        WeakReference weakReference = (WeakReference)this.loggers.get(string);
        if (weakReference != null) {
            return (Logger)weakReference.get();
        }
        return null;
    }

    public synchronized Enumeration getLoggerNames() {
        return Collections.enumeration(this.loggers.keySet());
    }

    public synchronized void reset() throws SecurityException {
        this.checkAccess();
        this.properties = new Properties();
        Iterator iterator = this.loggers.values().iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference == null) continue;
            Logger logger = (Logger)weakReference.get();
            if (logger == null) {
                iterator.remove();
                continue;
            }
            if (logger == Logger.root) continue;
            logger.resetLogger();
            logger.setLevel(null);
        }
        Logger.root.setLevel(Level.INFO);
        Logger.root.resetLogger();
    }

    public synchronized void readConfiguration() throws IOException, SecurityException {
        InputStream inputStream;
        String string;
        String string2 = System.getProperty("java.util.logging.config.file");
        if (string2 == null || string2.length() == 0) {
            string = System.getProperty("gnu.classpath.home.url") + "/logging.properties";
            try {
                inputStream = new URL(string).openStream();
            }
            catch (Exception exception) {
                inputStream = null;
            }
            if (inputStream == null) {
                String string3 = "handlers = java.util.logging.ConsoleHandler   \n.level=INFO \n";
                inputStream = new ByteArrayInputStream(string3.getBytes());
            }
        } else {
            inputStream = new FileInputStream(string2);
        }
        try {
            this.readConfiguration(inputStream);
        }
        finally {
            string = null;
            ((InputStream)inputStream).close();
        }
    }

    public synchronized void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        Properties properties = new Properties();
        properties.load(inputStream);
        this.reset();
        this.properties = properties;
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Object object3;
            String string = ((String)enumeration.nextElement()).trim();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            string2 = string2.trim();
            if ("handlers".equals(string)) {
                object3 = new StringTokenizer(string2);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    object = (Handler)LogManager.createInstance((String)object2, LogManager.class$("java.util.logging.Handler"), string);
                    Logger.root.addHandler((Handler)object);
                }
            }
            if (!string.endsWith(".level")) continue;
            object3 = string.substring(0, string.length() - 6);
            object2 = this.getLogger((String)object3);
            if (object2 == null) {
                object2 = Logger.getLogger((String)object3);
                this.addLogger((Logger)object2);
            }
            object = null;
            try {
                object = Level.parse(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogManager.warn("bad level '" + string2 + "'", illegalArgumentException);
            }
            if (object == null) continue;
            ((Logger)object2).setLevel((Level)object);
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public synchronized String getProperty(String string) {
        if (this.properties != null) {
            return this.properties.getProperty(string);
        }
        return null;
    }

    static int getIntProperty(String string, int n) {
        try {
            return Integer.parseInt(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    static int getIntPropertyClamped(String string, int n, int n2, int n3) {
        int n4 = LogManager.getIntProperty(string, n);
        if (n4 < n2 || n4 > n3) {
            n4 = n;
        }
        return n4;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        try {
            return Boolean.valueOf(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return bl;
        }
    }

    static Level getLevelProperty(String string, Level level) {
        try {
            return Level.parse(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return level;
        }
    }

    static final Class getClassProperty(String string, Class clazz) {
        String string2 = logManager.getProperty(string);
        if (string2 != null) {
            try {
                return LogManager.locateClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogManager.warn(string + " = " + string2, classNotFoundException);
            }
        }
        return clazz;
    }

    static final Object getInstanceProperty(String string, Class clazz, Class clazz2) {
        Class clazz3 = LogManager.getClassProperty(string, clazz2);
        if (clazz3 == null) {
            return null;
        }
        try {
            Object object = clazz3.newInstance();
            if (clazz.isInstance(object)) {
                return object;
            }
        }
        catch (InstantiationException instantiationException) {
            LogManager.warn(string + " = " + clazz3.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogManager.warn(string + " = " + clazz3.getName(), illegalAccessException);
        }
        if (clazz2 == null) {
            return null;
        }
        try {
            return clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public void checkAccess() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(controlPermission);
        }
    }

    private static final Object createInstance(String string, Class clazz, String string2) {
        Class clazz2 = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            clazz2 = LogManager.locateClass(string);
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz2.newInstance();
            }
            LogManager.warn(string2, string, "not an instance of " + clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogManager.warn(string2, string, "class not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogManager.warn(string2, string, "illegal access", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LogManager.warn(string2, string, instantiationException);
        }
        catch (LinkageError linkageError) {
            LogManager.warn(string2, string, "linkage error", linkageError);
        }
        return null;
    }

    private static final void warn(String string, String string2, Throwable throwable) {
        LogManager.warn(string, string2, null, throwable);
    }

    private static final void warn(String string, String string2, String string3) {
        LogManager.warn(string, string2, string3, null);
    }

    private static final void warn(String string, String string2, String string3, Throwable throwable) {
        LogManager.warn("error instantiating '" + string2 + "' referenced by " + string + (string3 == null ? "" : ", " + string3), throwable);
    }

    private static final void warn(String string, Throwable throwable) {
        System.err.println("WARNING: " + string);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    private static Class locateClass(String string) throws ClassNotFoundException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread == null ? null : thread.getContextClassLoader();
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader = ClassLoader.getSystemClassLoader();
            return Class.forName(string, true, classLoader);
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingBean == null) {
            loggingBean = new LoggingMXBean(null){
                private /* synthetic */ LogManager this$0;
                {
                    this.this$0 = logManager;
                }

                public String getLoggerLevel(String string) {
                    LogManager logManager = LogManager.getLogManager();
                    Logger logger = logManager.getLogger(string);
                    if (logger == null) {
                        return null;
                    }
                    Level level = logger.getLevel();
                    if (level == null) {
                        return "";
                    }
                    return level.getName();
                }

                public List getLoggerNames() {
                    LogManager logManager = LogManager.getLogManager();
                    return Collections.list(logManager.getLoggerNames());
                }

                public String getParentLoggerName(String string) {
                    LogManager logManager = LogManager.getLogManager();
                    Logger logger = logManager.getLogger(string);
                    if (logger == null) {
                        return null;
                    }
                    if ((logger = logger.getParent()) == null) {
                        return "";
                    }
                    return logger.getName();
                }

                public void setLoggerLevel(String string, String string2) {
                    LogManager logManager = LogManager.getLogManager();
                    Logger logger = logManager.getLogger(string);
                    if (logger == null) {
                        throw new IllegalArgumentException("no logger named " + string);
                    }
                    Level level = string2 == null ? null : Level.parse(string2);
                    logger.setLevel(level);
                }
            };
        }
        return loggingBean;
    }

    static {
        LOGGING_MXBEAN_NAME = LOGGING_MXBEAN_NAME;
        MANAGER_PROPERTY = MANAGER_PROPERTY;
        CONFIG_PROPERTY = CONFIG_PROPERTY;
        controlPermission = new LoggingPermission("control", null);
    }
}

