/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Path;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Root;
import gnu.xml.xpath.Selector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public final class Steps
extends Path {
    final LinkedList path;

    public Steps() {
        this(new LinkedList());
    }

    Steps(LinkedList linkedList) {
        this.path = linkedList;
    }

    public boolean matches(Node node2) {
        return this.matches(node2, this.path.size() - 1);
    }

    boolean matches(Node node2, int n) {
        Pattern pattern2 = (Pattern)this.path.get(n);
        if (!pattern2.matches(node2)) {
            return false;
        }
        if (n > 0) {
            Pattern pattern3 = (Pattern)this.path.get(n - 1);
            Iterator iterator = this.possibleContexts(pattern2, node2).iterator();
            while (iterator.hasNext()) {
                Node node3 = (Node)iterator.next();
                if (!pattern3.matches(node3) || !this.matches(node3, n - 1)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    Collection possibleContexts(Pattern pattern2, Node node2) {
        if (pattern2 instanceof Selector) {
            Selector selector = (Selector)pattern2;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            switch (selector.axis) {
                case 9: {
                    selector.addChildNodes(node2, linkedHashSet, false);
                    break;
                }
                case 0: {
                    selector.addChildNodes(node2, linkedHashSet, true);
                    break;
                }
                case 1: {
                    linkedHashSet.add(node2);
                    selector.addChildNodes(node2, linkedHashSet, true);
                    break;
                }
                case 3: {
                    selector.addParentNode(node2, linkedHashSet, false);
                    break;
                }
                case 4: {
                    selector.addParentNode(node2, linkedHashSet, true);
                    break;
                }
                case 5: {
                    linkedHashSet.add(node2);
                    selector.addParentNode(node2, linkedHashSet, true);
                    break;
                }
                case 11: {
                    selector.addFollowingNodes(node2, linkedHashSet, false);
                    break;
                }
                case 7: {
                    selector.addPrecedingNodes(node2, linkedHashSet, false);
                    break;
                }
                case 10: {
                    selector.addFollowingNodes(node2, linkedHashSet, true);
                    break;
                }
                case 6: {
                    selector.addPrecedingNodes(node2, linkedHashSet, true);
                    break;
                }
                case 2: 
                case 8: {
                    if (node2.getNodeType() != 2) break;
                    linkedHashSet.add(((Attr)node2).getOwnerElement());
                    break;
                }
                case 12: {
                    linkedHashSet.add(node2);
                }
            }
            return linkedHashSet;
        }
        return Collections.EMPTY_SET;
    }

    public Object evaluate(Node node2, int n, int n2) {
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        Object object = expr.evaluate(node2, n, n2);
        while (object instanceof Collection && iterator.hasNext()) {
            Path path = (Path)iterator.next();
            object = path.evaluate(node2, (Collection)object);
        }
        return object;
    }

    Collection evaluate(Node node2, Collection object) {
        Object object2;
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        if (expr instanceof Path) {
            object = ((Path)expr).evaluate(node2, (Collection)object);
        } else {
            object2 = new LinkedHashSet();
            int n = 1;
            int n2 = object.size();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Node node3 = (Node)iterator2.next();
                Object object3 = expr.evaluate(node3, n++, n2);
                if (!(object3 instanceof Collection)) continue;
                object2.addAll((Collection)object3);
            }
            object = object2;
        }
        while (iterator.hasNext()) {
            object2 = (Path)iterator.next();
            object = ((Path)object2).evaluate(node2, (Collection)object);
        }
        return object;
    }

    public Expr clone(Object object) {
        int n = this.path.size();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < n; ++i) {
            linkedList.add(((Expr)this.path.get(i)).clone(object));
        }
        return new Steps(linkedList);
    }

    public boolean references(QName qName) {
        Iterator iterator = this.path.iterator();
        while (iterator.hasNext()) {
            if (!((Expr)iterator.next()).references(qName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.path.iterator();
        Expr expr = (Expr)iterator.next();
        if (!(expr instanceof Root)) {
            stringBuffer.append(expr);
        }
        while (iterator.hasNext()) {
            expr = (Expr)iterator.next();
            stringBuffer.append('/');
            stringBuffer.append(expr);
        }
        return stringBuffer.toString();
    }
}

