/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.dssi;

import gnu.javax.sound.midi.dssi.DSSISynthesizer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class DSSIMidiDeviceProvider
extends MidiDeviceProvider {
    private static DSSIInfo[] infos;

    static native long dlopen_(String var0);

    static native void dlclose_(long var0);

    static native long getDSSIHandle_(long var0, long var2);

    static native String getDSSIName_(long var0);

    static native String getDSSICopyright_(long var0);

    static native String getDSSIVendor_(long var0);

    static native String getDSSILabel_(long var0);

    private static List examineLibrary(String string) {
        long l;
        ArrayList arrayList = new ArrayList();
        long l2 = 0L;
        long l3 = DSSIMidiDeviceProvider.dlopen_(string);
        if (l3 == 0L) {
            return arrayList;
        }
        while ((l = DSSIMidiDeviceProvider.getDSSIHandle_(l3, l2)) != 0L) {
            String string2 = DSSIMidiDeviceProvider.getDSSILabel_(l);
            String string3 = DSSIMidiDeviceProvider.getDSSICopyright_(l);
            String string4 = DSSIMidiDeviceProvider.getDSSIName_(l);
            String string5 = DSSIMidiDeviceProvider.getDSSIVendor_(l);
            arrayList.add(new DSSIInfo(string2, string5, string4, "DSSI-1", string, l2));
            ++l2;
        }
        DSSIMidiDeviceProvider.dlclose_(l3);
        return arrayList;
    }

    public MidiDevice.Info[] getDeviceInfo() {
        return infos;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        for (int i = 0; i < infos.length; ++i) {
            if (!info.equals(infos[i])) continue;
            return new DSSISynthesizer(infos[i], DSSIMidiDeviceProvider.infos[i].soname, DSSIMidiDeviceProvider.infos[i].index);
        }
        throw new IllegalArgumentException("Don't recognize MIDI device " + info);
    }

    static {
        File file = new File("/usr/lib/dssi/");
        String[] stringArray = file.list(new FilenameFilter(null){
            private /* synthetic */ DSSIMidiDeviceProvider this$0;
            {
                this.this$0 = dSSIMidiDeviceProvider;
            }

            public boolean accept(File file, String string) {
                return string.endsWith(".so");
            }
        });
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(DSSIMidiDeviceProvider.examineLibrary(new File(file, stringArray[i]).getAbsolutePath()));
        }
        infos = (DSSIInfo[])arrayList.toArray(new DSSIInfo[arrayList.size()]);
    }

    private static class DSSIInfo
    extends MidiDevice.Info {
        String soname;
        long index;

        public DSSIInfo(String string, String string2, String string3, String string4, String string5, long l) {
            super(string, string2, string3, string4);
            this.soname = string5;
            this.index = l;
        }
    }
}

