/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.16");
    private final Date notBefore;
    private final Date notAfter;

    public PrivateKeyUsagePeriod(byte[] byArray) throws IOException {
        super(byArray);
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed PrivateKeyUsagePeriod");
        }
        if (dERValue.getLength() > 0) {
            dERValue = dERReader.read();
        }
        if (dERValue.getTagClass() == 64 || dERValue.getTag() == 0) {
            this.notBefore = (Date)dERValue.getValueAs(24);
            dERValue = dERReader.read();
        } else {
            this.notBefore = null;
        }
        this.notAfter = dERValue.getTagClass() == 64 || dERValue.getTag() == 1 ? (Date)dERValue.getValueAs(24) : null;
    }

    public Date getNotBefore() {
        if (this.notBefore != null) {
            return (Date)this.notBefore.clone();
        }
        return null;
    }

    public Date getNotAfter() {
        if (this.notAfter != null) {
            return (Date)this.notAfter.clone();
        }
        return null;
    }

    public String toString() {
        return PrivateKeyUsagePeriod.class$("gnu.java.security.x509.ext.PrivateKeyUsagePeriod").getName() + " [ notBefore=" + this.notBefore + " notAfter=" + this.notAfter + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

