/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class GeneralNames {
    public static final int OTHER_NAME = 0;
    public static final int RFC822_NAME = 1;
    public static final int DNS_NAME = 2;
    public static final int X400_ADDRESS = 3;
    public static final int DIRECTORY_NAME = 4;
    public static final int EDI_PARTY_NAME = 5;
    public static final int URI = 6;
    public static final int IP_ADDRESS = 7;
    public static final int REGISTERED_ID = 8;
    private List names = new LinkedList();

    public GeneralNames(byte[] byArray) throws IOException {
        DERValue dERValue;
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue2 = dERReader.read();
        if (!dERValue2.isConstructed()) {
            throw new IOException("malformed GeneralNames");
        }
        boolean bl = false;
        for (int i = 0; i < dERValue2.getLength(); i += dERValue.getEncodedLength()) {
            dERValue = dERReader.read();
            ArrayList arrayList = new ArrayList(2);
            int n = dERValue.getTagClass();
            if (n != 128) {
                throw new IOException("malformed GeneralName: Tag class is " + n);
            }
            arrayList.add(dERValue.getTag());
            Object var9_9 = null;
            switch (dERValue.getTag()) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    arrayList.add(new String((byte[])dERValue.getValue()));
                    break;
                }
                case 0: {
                    byte[] byArray2 = dERValue.getEncoded();
                    byArray2[0] = 48;
                    arrayList.add(byArray2);
                    DERValue dERValue3 = dERReader.read();
                    dERValue3 = dERReader.read();
                    break;
                }
                case 5: {
                    arrayList.add(dERValue.getValue());
                    break;
                }
                case 4: {
                    byte[] byArray3 = dERValue.getEncoded();
                    byArray3[0] = 48;
                    DERReader dERReader2 = new DERReader(byArray3);
                    dERReader2.read();
                    arrayList.add(new X500Principal(dERReader2.read().getEncoded()).toString());
                    break;
                }
                case 7: {
                    arrayList.add(InetAddress.getByAddress((byte[])dERValue.getValue()).getHostAddress());
                    break;
                }
                case 8: {
                    byte[] byArray4 = dERValue.getEncoded();
                    byArray4[0] = 6;
                    arrayList.add(new OID(byArray4).toString());
                    break;
                }
                default: {
                    throw new IOException("unknown tag " + dERValue.getTag());
                }
            }
            this.names.add(arrayList);
        }
    }

    public List getNames() {
        ArrayList arrayList = new ArrayList(this.names.size());
        Iterator iterator = this.names.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            ArrayList arrayList2 = new ArrayList(2);
            arrayList2.add(list2.get(0));
            if (list2.get(1) instanceof byte[]) {
                arrayList2.add(((byte[])list2.get(1)).clone());
            } else {
                arrayList2.add(list2.get(1));
            }
            arrayList.add(Collections.unmodifiableList(arrayList2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        return GeneralNames.class$("gnu.java.security.x509.ext.GeneralNames").getName() + " [ " + this.names + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

