/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.rsa.RSASignatureFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SignatureFactory {
    private static Set names;

    private SignatureFactory() {
    }

    public static final ISignature getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        string = string.toLowerCase();
        ISignature iSignature = null;
        if (string.equalsIgnoreCase("dsa") || string.equals("dss")) {
            iSignature = new DSSSignature();
        } else if (string.startsWith("rsa-")) {
            iSignature = RSASignatureFactory.getInstance(string);
        }
        return iSignature;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet hashSet = new HashSet();
            hashSet.add("dss");
            hashSet.addAll(RSASignatureFactory.getNames());
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }
}

