/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.UnicastConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.UID;
import java.util.Vector;

public class UnicastRemoteCall
implements RemoteCall,
ProtocolConstants {
    private UnicastConnection conn;
    private Object result;
    private Object object;
    private int opnum;
    private long hash;
    Vector vec;
    int ptr;
    private ObjID objid;
    private ObjectOutput oout;
    private ObjectInput oin;

    UnicastRemoteCall(UnicastConnection unicastConnection) {
        this.conn = unicastConnection;
    }

    UnicastRemoteCall(UnicastConnection unicastConnection, ObjID objID, int n, long l) throws RemoteException {
        this.conn = unicastConnection;
        this.opnum = n;
        this.hash = l;
        this.objid = objID;
    }

    UnicastConnection getConnection() {
        return this.conn;
    }

    public ObjectOutput getOutputStream() throws IOException {
        if (this.vec == null) {
            this.vec = new Vector();
        }
        return new DummyObjectOutputStream(this);
    }

    public void releaseOutputStream() throws IOException {
        if (this.vec != null) {
            this.oout = this.conn.getObjectOutputStream();
            for (int i = 0; i < this.vec.size(); i += 2) {
                boolean bl = (Boolean)this.vec.elementAt(i);
                Object object = this.vec.elementAt(i + 1);
                if (!bl) {
                    this.oout.writeObject(object);
                    continue;
                }
                if (object instanceof Boolean) {
                    this.oout.writeBoolean((Boolean)object);
                    continue;
                }
                if (object instanceof Character) {
                    this.oout.writeChar(((Character)object).charValue());
                    continue;
                }
                if (object instanceof Byte) {
                    this.oout.writeByte(((Byte)object).byteValue());
                    continue;
                }
                if (object instanceof Short) {
                    this.oout.writeShort(((Short)object).shortValue());
                    continue;
                }
                if (object instanceof Integer) {
                    this.oout.writeInt((Integer)object);
                    continue;
                }
                if (!(object instanceof Long)) continue;
                this.oout.writeLong((Long)object);
            }
            this.vec = null;
        }
        if (this.oout != null) {
            this.oout.flush();
        }
    }

    public ObjectInput startInputStream() throws IOException {
        if (this.conn != null) {
            this.oin = this.conn.startObjectInputStream();
            return this.oin;
        }
        return this.getInputStream();
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.conn != null) {
            if (this.oin == null) {
                this.oin = this.conn.getObjectInputStream();
                return this.oin;
            }
            return this.oin;
        }
        this.ptr = 0;
        return new DummyObjectInputStream(this);
    }

    public void releaseInputStream() throws IOException {
    }

    public ObjectOutput getResultStream(boolean bl) throws IOException, StreamCorruptedException {
        this.vec = new Vector();
        return new DummyObjectOutputStream(this);
    }

    public void executeCall() throws Exception {
        byte by;
        ObjectInput objectInput;
        Object object;
        try {
            object = this.conn.getDataOutputStream();
            ((DataOutputStream)object).write(80);
            this.oout = this.conn.startObjectOutputStream();
            this.objid.write(this.oout);
            this.oout.writeInt(this.opnum);
            this.oout.writeLong(this.hash);
        }
        catch (IOException iOException) {
            throw new MarshalException("Try to write header but failed.", iOException);
        }
        try {
            this.releaseOutputStream();
            object = this.conn.getDataInputStream();
            if (((DataInputStream)object).readByte() != 81) {
                throw new RemoteException("Call not acked");
            }
            objectInput = this.startInputStream();
            by = objectInput.readByte();
            UID.read(objectInput);
        }
        catch (IOException iOException) {
            throw new UnmarshalException("Try to read header but failed:", iOException);
        }
        switch (by) {
            case 1: {
                return;
            }
            case 2: {
                try {
                    object = objectInput.readObject();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("Try to read exception object but failed", exception);
                }
                if (!(object instanceof Exception)) {
                    throw new UnmarshalException("Should be Exception type here: " + object);
                }
                throw (Exception)object;
            }
        }
        throw new UnmarshalException("Invalid return code");
    }

    public void done() throws IOException {
    }

    boolean isReturnValue() {
        return this.vec.size() > 0;
    }

    Object returnValue() {
        return this.vec.elementAt(1);
    }

    Object[] getArguments() {
        return this.vec.toArray();
    }

    Object getObject() {
        return this.object;
    }

    int getOpnum() {
        return this.opnum;
    }

    long getHash() {
        return this.hash;
    }

    void setReturnValue(Object object) {
        this.vec.removeAllElements();
        this.vec.addElement(object);
    }

    private class DummyObjectInputStream
    implements ObjectInput {
        private /* synthetic */ UnicastRemoteCall this$0;

        DummyObjectInputStream(UnicastRemoteCall unicastRemoteCall) {
            this.this$0 = unicastRemoteCall;
        }

        public boolean readBoolean() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Boolean)object;
        }

        public byte readByte() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Byte)object;
        }

        public char readChar() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return ((Character)object).charValue();
        }

        public double readDouble() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Double)object;
        }

        public float readFloat() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return ((Float)object).floatValue();
        }

        public int readInt() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Integer)object;
        }

        public long readLong() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Long)object;
        }

        public short readShort() throws IOException {
            Object object = this.this$0.vec.elementAt(this.this$0.ptr++);
            return (Short)object;
        }

        public Object readObject() throws IOException {
            return this.this$0.vec.elementAt(this.this$0.ptr++);
        }

        public int read(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public int read() throws IOException {
            throw new IOException("not required");
        }

        public long skip(long l) throws IOException {
            throw new IOException("not required");
        }

        public int available() throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public String readLine() throws IOException {
            throw new IOException("not required");
        }

        public String readUTF() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedByte() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedShort() throws IOException {
            throw new IOException("not required");
        }

        public int skipBytes(int n) throws IOException {
            throw new IOException("not required");
        }

        public void close() throws IOException {
        }
    }

    private class DummyObjectOutputStream
    implements ObjectOutput {
        private /* synthetic */ UnicastRemoteCall this$0;

        DummyObjectOutputStream(UnicastRemoteCall unicastRemoteCall) {
            this.this$0 = unicastRemoteCall;
        }

        public void writeBoolean(boolean bl) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(bl);
        }

        public void writeByte(int n) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Byte((byte)n));
        }

        public void writeChar(int n) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Character((char)n));
        }

        public void writeDouble(double d) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Double(d));
        }

        public void writeFloat(float f) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Float(f));
        }

        public void writeInt(int n) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Integer(n));
        }

        public void writeLong(long l) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Long(l));
        }

        public void writeShort(int n) throws IOException {
            this.this$0.vec.addElement(Boolean.TRUE);
            this.this$0.vec.addElement(new Short((short)n));
        }

        public void writeObject(Object object) throws IOException {
            this.this$0.vec.addElement(Boolean.FALSE);
            this.this$0.vec.addElement(object);
        }

        public void write(byte[] byArray) throws IOException {
            throw new IOException("not required");
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            throw new IOException("not required");
        }

        public void write(int n) throws IOException {
            throw new IOException("not required");
        }

        public void writeBytes(String string) throws IOException {
            throw new IOException("not required");
        }

        public void writeChars(String string) throws IOException {
            throw new IOException("not required");
        }

        public void writeUTF(String string) throws IOException {
            throw new IOException("not required");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

