/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.osgi.framework.Bundle;

public class LaunchTreeModel
extends AsynchronousTreeModel {
    public LaunchTreeModel(AsynchronousTreeViewer viewer) {
        super(viewer);
    }

    protected IAsynchronousContentAdapter getContentAdapter(Object element) {
        IAsynchronousContentAdapter contentAdapter = super.getContentAdapter(element);
        if (contentAdapter != null) {
            return contentAdapter;
        }
        AsynchronousContentAdapter legacyAdapter = this.getLegacyAdapter(element);
        if (legacyAdapter != null) {
            return legacyAdapter;
        }
        return null;
    }

    private AsynchronousContentAdapter getLegacyAdapter(Object element) {
        IWorkbenchAdapter nonDeferred;
        if (element instanceof IDeferredWorkbenchAdapter) {
            return new WrappedDeferredWorkbenchTreeAdapter((IDeferredWorkbenchAdapter)element, element);
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)element;
        IDeferredWorkbenchAdapter deferred = (IDeferredWorkbenchAdapter)adaptable.getAdapter(IDeferredWorkbenchAdapter.class);
        if (deferred != null) {
            DebugUIPlugin plugin = DebugUIPlugin.getDefault();
            Bundle bundle = plugin.getBundle(deferred.getClass());
            Bundle debugBundle = plugin.getBundle();
            if (!debugBundle.equals(bundle)) {
                return new WrappedDeferredWorkbenchTreeAdapter(deferred, element);
            }
        }
        if ((nonDeferred = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class)) != null) {
            DebugUIPlugin plugin = DebugUIPlugin.getDefault();
            Bundle bundle = plugin.getBundle(nonDeferred.getClass());
            Bundle debugBundle = plugin.getBundle();
            if (!debugBundle.equals(bundle = plugin.getBundle(nonDeferred.getClass()))) {
                return new WrappedWorkbenchTreeAdapter(nonDeferred);
            }
        }
        return null;
    }

    private class ElementCollector
    implements IElementCollector {
        List children = new ArrayList();

        private ElementCollector() {
        }

        public void add(Object element, IProgressMonitor monitor) {
            this.children.add(element);
        }

        public void add(Object[] elements, IProgressMonitor monitor) {
            int i = 0;
            while (i < elements.length) {
                this.children.add(elements[i]);
                ++i;
            }
        }

        public void done() {
        }

        public Object[] getChildren() {
            return this.children.toArray();
        }
    }

    private class WrappedDeferredWorkbenchTreeAdapter
    extends AsynchronousContentAdapter {
        private IDeferredWorkbenchAdapter fAdapter;
        private Object fElement;

        public WrappedDeferredWorkbenchTreeAdapter(IDeferredWorkbenchAdapter adapter, Object element) {
            this.fAdapter = adapter;
            this.fElement = element;
        }

        protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
            ElementCollector elementCollector = new ElementCollector();
            this.fAdapter.fetchDeferredChildren(this.fElement, (IElementCollector)elementCollector, (IProgressMonitor)new NullProgressMonitor());
            return elementCollector.getChildren();
        }

        protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
            if (element instanceof IStackFrame) {
                return false;
            }
            return this.fAdapter.isContainer();
        }

        protected boolean supportsPartId(String id) {
            return "org.eclipse.debug.ui.DebugView".equals(id);
        }
    }

    private class WrappedWorkbenchTreeAdapter
    extends AsynchronousContentAdapter {
        private IWorkbenchAdapter fAdapter;

        public WrappedWorkbenchTreeAdapter(IWorkbenchAdapter adapter) {
            this.fAdapter = adapter;
        }

        protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
            return this.fAdapter.getChildren(parent);
        }

        protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
            if (element instanceof IStackFrame) {
                return false;
            }
            return this.fAdapter.getChildren(element).length > 0;
        }

        protected boolean supportsPartId(String id) {
            return "org.eclipse.debug.ui.DebugView".equals(id);
        }
    }
}

