/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.WritableList;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class ValidationErrorList
extends ObservableList {
    private boolean isDirty = true;
    private final WritableList bindings;
    private final boolean usePartialErrors;
    private List dependencies = new ArrayList();
    private IChangeListener markDirtyChangeListener = new IChangeListener(){

        public void handleChange(IObservable source) {
            ValidationErrorList.this.markDirty();
        }
    };

    public ValidationErrorList(WritableList bindings, boolean usePartialErrors) {
        super(new ArrayList(), ValidationError.class);
        this.bindings = bindings;
        this.usePartialErrors = usePartialErrors;
        bindings.addChangeListener(this.markDirtyChangeListener);
    }

    protected void getterCalled() {
        this.recompute();
        super.getterCalled();
    }

    private void markDirty() {
        this.removeElementChangeListener();
        final List oldList = this.wrappedList;
        ListDiff listDiff = new ListDiff(){
            ListDiffEntry[] cachedDifferences = null;

            public ListDiffEntry[] getDifferences() {
                if (this.cachedDifferences == null) {
                    ValidationErrorList.this.recompute();
                    this.cachedDifferences = Diffs.computeListDiff(oldList, ValidationErrorList.this.wrappedList).getDifferences();
                }
                return this.cachedDifferences;
            }
        };
        this.wrappedList = new ArrayList();
        this.isDirty = true;
        this.fireListChange(listDiff);
    }

    private void recompute() {
        if (this.isDirty) {
            ArrayList<Object> newContents = new ArrayList<Object>();
            for (Binding binding : this.bindings) {
                IObservableValue validationError = this.usePartialErrors ? binding.getPartialValidationError() : binding.getValidationError();
                this.dependencies.add(validationError);
                validationError.addChangeListener(this.markDirtyChangeListener);
                Object validationErrorValue = validationError.getValue();
                if (validationErrorValue == null) continue;
                newContents.add(validationErrorValue);
            }
            this.wrappedList.addAll(newContents);
            this.isDirty = false;
        }
    }

    public void dispose() {
        this.bindings.removeChangeListener(this.markDirtyChangeListener);
        this.removeElementChangeListener();
        super.dispose();
    }

    private void removeElementChangeListener() {
        for (IObservableValue observableValue : this.dependencies) {
            observableValue.removeChangeListener(this.markDirtyChangeListener);
        }
    }

    public Object getElementType() {
        return ValidationError.class;
    }
}

