/*******************************************************************************
 * Copyright (c) 2001, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.rdb.connection.internal.ui.filter.SchemaFilterWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;


/**
 * Overrides SchemaFilterWizardPage to allow user to set a filter when creating
 * a new connection
 * @author Quy V. On, quyon@us.ibm.com
 */
public class ConnectionSelectionFilterWizardPage extends SchemaFilterWizardPage {
 
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    protected String myDefaultPredicate;    
    
    /**
     * Creates an instance of ConnectionSelectionFilterWizardPage
     * @param aName the name of this page
     */
    public ConnectionSelectionFilterWizardPage (String aName) {
        super(aName);
        String title = resourceLoader.queryString(
                "CUI_CONN_SELECT_EXT_FILTERPAGE_TITLE"); //$NON-NLS-1$ 
        setTitle(title);
    }
    
    /**
     * Creates an instance of ConnectionSelectionFilterWizardPage with a set of
     * default predicates
     * @param aName the name for this page
     * @param aDefaultPredicate the predicate to use in the filter
     */
    public ConnectionSelectionFilterWizardPage(String aName, String aDefaultPredicate) {
        this(aName);
        myDefaultPredicate = aDefaultPredicate;
    }
    
    public void createControl(Composite composite){
    	super.createControl(composite);
        setPageComplete(true);
    }
    
    /**
     * Gets the default predicate
     * @return the defalt predicate.
     */
    public String getDefaultPredicate() {
        return myDefaultPredicate;
    }
    
    /**
     * Sets the default predicate
     * @param aDefaultPredicate The default Predicate to set.
     */
    public void setDefaultPredicate(String aDefaultPredicate) {
        myDefaultPredicate = aDefaultPredicate;
    }
    
    /**
     * @see org.eclipse.wst.rdb.connection.internal.ui.filter.RDBFilterWizardPage#getConnectionFilter()
     */
    protected ConnectionFilter getConnectionFilter() {
        ConnectionFilter conFilter = new ConnectionFilterImpl(myDefaultPredicate);
        return conFilter;
    }
    
    /**
     * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
        if (visible) {
            getControl().setData(ConnectionSelectionWizard.SKIP, Boolean.FALSE);
        }
        super.setVisible(visible);
    }
}