/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Exadel Inc - additional implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.sqlscrapbook.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.services.IConnectedServerDialog;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

/**
 * @author ljulien
 */
public class SQLScrapbookUIAction implements IViewActionDelegate {

    private ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IConnectedServerDialog dialog = IServicesManager.INSTANCE.getConnectedServerDialog();
        int result = dialog.open();
        if (result == Window.OK) {
            IConnectionNode node = dialog.getUserSelection();
            if (node != null) {
                SQLScrapbookAction scrapbookAction = new SQLScrapbookAction();
                scrapbookAction.selectionChanged(null, new StructuredSelection(node.getConnectionInfo()));
                scrapbookAction.run(null);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}