/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.ServerTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerTreeLabelProvider;

public class ServerComposite
extends AbstractTreeComposite {
    protected IServer selection;
    protected ServerSelectionListener listener;
    protected ServerTreeContentProvider contentProvider;
    protected boolean initialSelection = true;
    protected byte viewOption;
    protected IModule module;
    protected String launchMode;
    protected boolean includeIncompatibleVersions;

    public ServerComposite(Composite parent, int style, ServerSelectionListener listener2, IModule module, String launchMode) {
        super(parent, style);
        this.module = module;
        this.launchMode = launchMode;
        this.listener = listener2;
        this.contentProvider = new ServerTreeContentProvider(1, module, launchMode);
        this.viewOption = 1;
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ServerTreeLabelProvider labelProvider = new ServerTreeLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    ServerComposite.this.treeViewer.refresh(true);
                } else {
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        ServerComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.expandToLevel(1);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ServerComposite.this.getSelection(event.getSelection());
                if (obj instanceof IServer) {
                    ServerComposite.this.selection = (IServer)obj;
                    ServerComposite.this.setDescription(ServerComposite.this.selection.getServerType().getRuntimeType().getDescription());
                } else {
                    ServerComposite.this.selection = null;
                    ServerComposite.this.setDescription("");
                }
                ServerComposite.this.listener.serverSelected(ServerComposite.this.selection);
            }
        });
    }

    public ServerComposite(Composite parent, int style, ServerSelectionListener listener2) {
        this(parent, style, listener2, null, null);
    }

    public void setIncludeIncompatibleVersions(boolean b) {
        this.includeIncompatibleVersions = b;
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider.setIncludeIncompatibleVersions(b);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(sel, true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    public void refreshAll() {
        ISelection sel = this.treeViewer.getSelection();
        this.contentProvider = new ServerTreeContentProvider(this.viewOption, this.module, this.launchMode);
        this.contentProvider.setIncludeIncompatibleVersions(this.includeIncompatibleVersions);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setSelection(sel);
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String getTitleLabel() {
        return Messages.wizNewServerSelectExisting;
    }

    protected String[] getComboOptions() {
        return new String[]{Messages.name, Messages.host, Messages.vendor, Messages.version};
    }

    protected void viewOptionSelected(byte option) {
        ISelection sel = this.treeViewer.getSelection();
        this.viewOption = option;
        this.contentProvider = new ServerTreeContentProvider(option, this.module, this.launchMode);
        this.contentProvider.setIncludeIncompatibleVersions(this.includeIncompatibleVersions);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setSelection(sel);
    }

    public IServer getSelectedServer() {
        return this.selection;
    }

    public void setSelection(IServer server) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)server), true);
    }

    public static interface ServerSelectionListener {
        public void serverSelected(IServer var1);
    }
}

