/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.dialogs.CommitDialog;
import org.tigris.subversion.subclipse.ui.operations.CommitOperation;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class CommitAction
extends WorkbenchWindowAction {
    protected String commitComment;
    protected IResource[] resourcesToCommit;
    protected String url;
    protected boolean hasUnaddedResources;
    protected boolean commit;
    protected boolean keepLocks;
    protected IResource[] selectedResources;
    private String proposedComment;
    private boolean sharing;

    public CommitAction() {
    }

    public CommitAction(String proposedComment) {
        this.proposedComment = proposedComment;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final IResource[] resources = this.getSelectedResources();
        final ArrayList resourcesToBeAdded = new ArrayList();
        final ArrayList resourcesToBeDeleted = new ArrayList();
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IResource[] modified = CommitAction.this.getModifiedResources(resources, monitor);
                        if (modified.length == 0) {
                            MessageDialog.openInformation((Shell)CommitAction.this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.noChanges"));
                            CommitAction.this.commit = false;
                        } else {
                            ProjectProperties projectProperties = ProjectProperties.getProjectProperties(modified[0]);
                            CommitAction.this.commit = CommitAction.this.confirmCommit(modified, projectProperties);
                        }
                        if (CommitAction.this.commit) {
                            int i = 0;
                            while (i < CommitAction.this.resourcesToCommit.length) {
                                IResource resource = CommitAction.this.resourcesToCommit[i];
                                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                                if (!svnResource.isManaged()) {
                                    resourcesToBeAdded.add(resource);
                                }
                                if (svnResource.getStatus().isMissing()) {
                                    resourcesToBeDeleted.add(resource);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, true, 2);
            if (!this.commit) {
                return;
            }
            new CommitOperation(this.getTargetPart(), resources, resourcesToBeAdded.toArray(new IResource[resourcesToBeAdded.size()]), resourcesToBeDeleted.toArray(new IResource[resourcesToBeDeleted.size()]), this.resourcesToCommit, this.commitComment, this.keepLocks).run();
        }
    }

    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        ArrayList<IResource> modified = new ArrayList<IResource>();
        ArrayList<IResource> unversionedFolders = new ArrayList<IResource>();
        this.hasUnaddedResources = false;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (svnResource.getRepository() != null) {
                if (resources.length == 1) {
                    this.url = svnResource.getStatus().getUrlString();
                    if (this.url == null || resource.getType() == 1) {
                        this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
                    }
                }
                GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
                command.run(iProgressMonitor);
                ISVNStatus[] statuses = command.getStatuses();
                int j = 0;
                while (j < statuses.length) {
                    ISVNLocalResource localResource;
                    IResource currentResource;
                    if ((SVNStatusUtils.isReadyForCommit((ISVNStatus)statuses[j]) || SVNStatusUtils.isMissing((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((ISVNStatus)statuses[j])) != null && !(localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)currentResource)).isIgnored()) {
                        if (!SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) {
                            this.hasUnaddedResources = true;
                            if (currentResource.getType() != 1 && !this.isSymLink(currentResource)) {
                                unversionedFolders.add(currentResource);
                            } else if ((this.sharing || SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_unadded_resources_on_commit")) && !modified.contains(currentResource)) {
                                modified.add(currentResource);
                            }
                        } else if (!modified.contains(currentResource)) {
                            modified.add(currentResource);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.sharing || SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_unadded_resources_on_commit")) {
            IResource[] unaddedResources = this.getUnaddedResources(unversionedFolders, iProgressMonitor);
            int i2 = 0;
            while (i2 < unaddedResources.length) {
                if (!modified.contains(unaddedResources[i2])) {
                    modified.add(unaddedResources[i2]);
                }
                ++i2;
            }
        }
        return modified.toArray(new IResource[modified.size()]);
    }

    protected boolean confirmCommit(IResource[] modifiedResources, ProjectProperties projectProperties) throws SVNException {
        if (this.onTagPath(modifiedResources) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.tag"))) {
            return false;
        }
        CommitDialog dialog = new CommitDialog(this.getShell(), modifiedResources, this.url, this.hasUnaddedResources, projectProperties);
        dialog.setSharing(this.sharing);
        if (this.proposedComment == null || this.proposedComment.length() == 0) {
            dialog.setComment(this.getProposedComment(modifiedResources));
        } else {
            dialog.setComment(this.proposedComment);
        }
        boolean commitOK = dialog.open() == 0;
        this.url = null;
        this.commitComment = dialog.getComment();
        this.resourcesToCommit = dialog.getSelectedResources();
        this.keepLocks = dialog.isKeepLocks();
        return commitOK;
    }

    private boolean onTagPath(IResource[] modifiedResources) throws SVNException {
        if (this.url == null) {
            IResource resource = modifiedResources[0];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            String firstUrl = svnResource.getStatus().getUrlString();
            if (firstUrl == null || resource.getType() == 1) {
                firstUrl = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
            if (firstUrl.indexOf("/tags/") != -1) {
                return true;
            }
        } else if (this.url.indexOf("/tags/") != -1) {
            return true;
        }
        return false;
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    private IResource[] getUnaddedResources(List resources, IProgressMonitor iProgressMonitor) throws SVNException {
        final ArrayList unadded = new ArrayList();
        final SVNException[] exception = new SVNException[1];
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!resource.exists()) continue;
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource aResource) {
                        block6: {
                            ISVNLocalResource svnResource;
                            block5: {
                                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)aResource);
                                if (!svnResource.isIgnored()) break block5;
                                return false;
                            }
                            if (!svnResource.isManaged()) break block6;
                            return true;
                        }
                        try {
                            if (aResource.getType() == 2 && CommitAction.this.isSymLink(aResource)) {
                                return false;
                            }
                        }
                        catch (SVNException e) {
                            exception[0] = e;
                        }
                        unadded.add(aResource);
                        return aResource.getType() == 2;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                throw SVNException.wrapException((CoreException)e);
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
        if (unadded.size() > 0) {
            this.hasUnaddedResources = true;
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    protected boolean isSymLink(IResource resource) {
        File file;
        block3: {
            file = resource.getLocation().toFile();
            try {
                if (file.exists()) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        String cnnpath = file.getCanonicalPath();
        String abspath = file.getAbsolutePath();
        return !abspath.equals(cnnpath);
    }

    protected IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return super.getSelectedResources();
        }
        return this.selectedResources;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = SVNProviderPlugin.getPlugin().getChangeSetManager().getSets();
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean hasOutgoingChanges() {
        try {
            return this.getModifiedResources(this.selectedResources, (IProgressMonitor)new NullProgressMonitor()).length > 0;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    public void setSharing(boolean sharing) {
        this.sharing = sharing;
    }

    protected String getImageId() {
        return "Menu Commit";
    }
}

