/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class RubyWordFinder {
    private static final char[] BOUNDARIES = new char[]{' ', '\n', '\t', '\r', '.', '(', ')', '{', '}', '[', ']', '=', '*', '+', '-', '\"', '\'', '#', ','};

    public static IRegion findWord(IDocument iDocument, int n) {
        int n2 = -1;
        int n3 = -1;
        try {
            char c;
            int n4 = n;
            while (n4 >= 0) {
                c = iDocument.getChar(n4);
                if (!RubyWordFinder.isRubyWordPart(c)) break;
                --n4;
            }
            n2 = n4;
            n4 = n;
            int n5 = iDocument.getLength();
            while (n4 < n5) {
                c = iDocument.getChar(n4);
                if (!RubyWordFinder.isRubyWordPart(c)) break;
                ++n4;
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {}
        if (n2 > -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }

    private static boolean isRubyWordPart(char c) {
        return !RubyWordFinder.isBoundary(c);
    }

    private static boolean isBoundary(char c) {
        return RubyWordFinder.contains(BOUNDARIES, c);
    }

    private static boolean contains(char[] cArray, char c) {
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

