/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ExecutionArguments {
    protected static final QualifiedName EXECUTION_ARGUMENTS_PROPERTY = new QualifiedName("org.rubypeople.rdt", "executionArguments");
    protected static final String ARGUMENT_SEPARATOR = "**<ArgBreak>**";
    protected String interpreterArguments;
    protected String rubyFileArguments;

    public static ExecutionArguments getExecutionArguments(IFile iFile) {
        try {
            String string = iFile.getPersistentProperty(EXECUTION_ARGUMENTS_PROPERTY);
            ExecutionArguments executionArguments = new ExecutionArguments();
            if (string != null) {
                int n = string.indexOf(ARGUMENT_SEPARATOR);
                executionArguments.setInterpreterArguments(string.substring(0, n));
                executionArguments.setRubyFileArguments(string.substring(n + ARGUMENT_SEPARATOR.length()));
            }
            return executionArguments;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setExecutionArguments(IFile iFile, ExecutionArguments executionArguments) {
        try {
            iFile.setPersistentProperty(EXECUTION_ARGUMENTS_PROPERTY, executionArguments.toPersistableFormat());
        }
        catch (CoreException coreException) {}
    }

    public void setInterpreterArguments(String string) {
        this.interpreterArguments = string;
    }

    public void setRubyFileArguments(String string) {
        this.rubyFileArguments = string;
    }

    public String toPersistableFormat() {
        return String.valueOf(this.interpreterArguments) + ARGUMENT_SEPARATOR + this.rubyFileArguments;
    }
}

