<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:template match="/ivy-report">
/* * directed graph dot input file. * * generated by ivy report */
            digraph G {
   	 "<xsl:value-of select="info/@organisation"/>-<xsl:value-of select="info/@module"/>" [label="<xsl:value-of select="info/@module"/>"];
     <xsl:for-each select="dependencies/module">
   	    "<xsl:value-of select="@organisation"/>-<xsl:value-of select="@name"/>" [label="<xsl:value-of select="@name"/>
   	    	<xsl:for-each select="revision">
                  <xsl:text>\n</xsl:text>
                  <xsl:value-of select="@name"/><xsl:if test="@error"> (error)</xsl:if><xsl:if test="@evicted"> (evicted)</xsl:if>
            </xsl:for-each>
   	     <xsl:text>"];
</xsl:text>
      </xsl:for-each>
      <xsl:for-each select="dependencies/module/revision[not(@evicted)]/caller">
   	      <xsl:text>"</xsl:text>
   	      		<xsl:value-of select="@organisation"/>-<xsl:value-of select="@name"/>
   	      		<xsl:text>" -> "</xsl:text>
   	      		<xsl:value-of select="../../@organisation"/>-<xsl:value-of select="../../@name"/>
   	      		<xsl:text>" [label="</xsl:text>
   	      		  <xsl:value-of select="@rev"/>
   	      		<xsl:text>"]</xsl:text>
   	      <xsl:text>;
</xsl:text>
      </xsl:for-each>
  <xsl:text>}</xsl:text>
</xsl:template>

</xsl:stylesheet>
