/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.url.CredentialsStore;
import fr.jayasoft.ivy.url.URLHandler;
import fr.jayasoft.ivy.url.URLHandlerDispatcher;
import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Property;

public class IvyConfigure
extends IvyTask {
    private File _file = null;
    private URL _url = null;
    private String _realm = null;
    private String _host = null;
    private String _userName = null;
    private String _passwd = null;
    static /* synthetic */ Class class$fr$jayasoft$ivy$Ivy;

    public File getFile() {
        return this._file;
    }

    public void setFile(File conf) {
        this._file = conf;
    }

    public URL getUrl() {
        return this._url;
    }

    public void setUrl(String url) throws MalformedURLException {
        this._url = new URL(url);
    }

    public String getPasswd() {
        return this._passwd;
    }

    public void setPasswd(String passwd) {
        this._passwd = passwd;
    }

    public String getRealm() {
        return this._realm;
    }

    public void setRealm(String realm) {
        this._realm = IvyConfigure.format(realm);
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = IvyConfigure.format(host);
    }

    public String getUsername() {
        return this._userName;
    }

    public void setUsername(String userName) {
        this._userName = IvyConfigure.format(userName);
    }

    private static String format(String str) {
        return str == null ? str : (str.trim().length() == 0 ? null : str.trim());
    }

    public void addConfiguredCredentials(Credentials c) {
        CredentialsStore.INSTANCE.addCredentials(c.getRealm(), c.getHost(), c.getUsername(), c.getPasswd());
    }

    public void execute() throws BuildException {
        try {
            this.loadDefaultProperties();
        }
        catch (Exception ex) {
            throw new BuildException("impossible to load ivy default properties file: " + ex, (Throwable)ex);
        }
        this.ensureMessageInitialised();
        Ivy ivy = new Ivy();
        try {
            this.configureURLHandler();
            ivy.addAllVariables(this.getProject().getProperties());
            if (this._file == null && this._url == null) {
                this._file = new File(this.getProject().getBaseDir(), this.getProject().getProperty("ivy.conf.file"));
                Message.verbose("searching ivyconf file: trying " + this._file);
                if (!this._file.exists()) {
                    this._file = new File(this.getProject().getProperty("ivy.conf.file"));
                    Message.verbose("searching ivyconf file: trying " + this._file);
                    if (!this._file.exists()) {
                        Message.info("no configuration file found, using default...");
                        this._file = null;
                        this._url = Ivy.getDefaultConfigurationURL();
                    }
                }
            }
            if (this._file != null) {
                if (!this._file.exists()) {
                    throw new BuildException("configuration file does not exist: " + this._file);
                }
                ivy.configure(this._file);
            } else {
                ivy.configure(this._url);
            }
            this.setIvyInstance(ivy);
        }
        catch (Exception ex) {
            throw new BuildException("impossible to configure ivy with given " + (this._file != null ? "file: " + this._file : "url :" + this._url) + " :" + ex, (Throwable)ex);
        }
    }

    private void loadDefaultProperties() {
        Property prop = new Property(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws BuildException {
                URL url = (class$fr$jayasoft$ivy$Ivy == null ? (class$fr$jayasoft$ivy$Ivy = IvyConfigure.class$("fr.jayasoft.ivy.Ivy")) : class$fr$jayasoft$ivy$Ivy).getResource("ivy.properties");
                Properties props = new Properties();
                Message.verbose("Loading " + url);
                try {
                    InputStream is = url.openStream();
                    try {
                        props.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    this.addProperties(props);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex, this.getLocation());
                }
            }
        };
        prop.setProject(this.getProject());
        prop.execute();
    }

    private void configureURLHandler() {
        CredentialsStore.INSTANCE.addCredentials(this.getRealm(), this.getHost(), this.getUsername(), this.getPasswd());
        URLHandlerDispatcher dispatcher = new URLHandlerDispatcher();
        URLHandler httpHandler = URLHandlerRegistry.getHttp();
        dispatcher.setDownloader("http", httpHandler);
        dispatcher.setDownloader("https", httpHandler);
        URLHandlerRegistry.setDefault(dispatcher);
    }

    public static class Credentials {
        private String _realm;
        private String _host;
        private String _username;
        private String _passwd;

        public String getPasswd() {
            return this._passwd;
        }

        public void setPasswd(String passwd) {
            this._passwd = passwd;
        }

        public String getRealm() {
            return this._realm;
        }

        public void setRealm(String realm) {
            this._realm = IvyConfigure.format(realm);
        }

        public String getHost() {
            return this._host;
        }

        public void setHost(String host) {
            this._host = IvyConfigure.format(host);
        }

        public String getUsername() {
            return this._username;
        }

        public void setUsername(String userName) {
            this._username = IvyConfigure.format(userName);
        }
    }
}

