/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.APersistentSet;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.PersistentTreeMap;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import java.util.Comparator;

public class PersistentTreeSet
extends APersistentSet
implements IObj,
Reversible,
Sorted {
    public static final PersistentTreeSet EMPTY = new PersistentTreeSet(null, PersistentTreeMap.EMPTY);
    final IPersistentMap _meta;

    public static PersistentTreeSet create(ISeq items) {
        PersistentTreeSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentTreeSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    public static PersistentTreeSet create(Comparator comp2, ISeq items) {
        PersistentTreeSet ret = new PersistentTreeSet(null, new PersistentTreeMap(null, comp2));
        while (items != null) {
            ret = (PersistentTreeSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    PersistentTreeSet(IPersistentMap meta2, IPersistentMap impl) {
        super(impl);
        this._meta = meta2;
    }

    public IPersistentSet disjoin(Object key2) throws Exception {
        if (this.contains(key2)) {
            return new PersistentTreeSet(this.meta(), this.impl.without(key2));
        }
        return this;
    }

    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentTreeSet(this.meta(), this.impl.assoc(o, o));
    }

    public IPersistentCollection empty() {
        return new PersistentTreeSet(this.meta(), (PersistentTreeMap)this.impl.empty());
    }

    public ISeq rseq() throws Exception {
        return APersistentMap.KeySeq.create(((Reversible)((Object)this.impl)).rseq());
    }

    public PersistentTreeSet withMeta(IPersistentMap meta2) {
        return new PersistentTreeSet(meta2, this.impl);
    }

    public Comparator comparator() {
        return ((Sorted)((Object)this.impl)).comparator();
    }

    public Object entryKey(Object entry) {
        return entry;
    }

    public ISeq seq(boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seq(ascending));
    }

    public ISeq seqFrom(Object key2, boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seqFrom(key2, ascending));
    }

    public IPersistentMap meta() {
        return this._meta;
    }
}

