/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Ratio;
import clojure.lang.Var;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class Numbers {
    static final IntegerOps INTEGER_OPS = new IntegerOps();
    static final LongOps LONG_OPS = new LongOps();
    static final FloatOps FLOAT_OPS = new FloatOps();
    static final DoubleOps DOUBLE_OPS = new DoubleOps();
    static final RatioOps RATIO_OPS = new RatioOps();
    static final BigIntegerOps BIGINTEGER_OPS = new BigIntegerOps();
    static final BigDecimalOps BIGDECIMAL_OPS = new BigDecimalOps();
    static final IntegerBitOps INTEGER_BITOPS = new IntegerBitOps();
    static final LongBitOps LONG_BITOPS = new LongBitOps();
    static final BigIntegerBitOps BIGINTEGER_BITOPS = new BigIntegerBitOps();

    public static boolean isZero(Object x) {
        return Numbers.ops(x).isZero((Number)x);
    }

    public static boolean isPos(Object x) {
        return Numbers.ops(x).isPos((Number)x);
    }

    public static boolean isNeg(Object x) {
        return Numbers.ops(x).isNeg((Number)x);
    }

    public static Number minus(Object x) {
        return Numbers.ops(x).negate((Number)x);
    }

    public static Number inc(Object x) {
        return Numbers.ops(x).inc((Number)x);
    }

    public static Number dec(Object x) {
        return Numbers.ops(x).dec((Number)x);
    }

    public static Number add(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).add((Number)x, (Number)y);
    }

    public static Number minus(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        return Numbers.ops(x).combine(yops).add((Number)x, yops.negate((Number)y));
    }

    public static Number multiply(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).multiply((Number)x, (Number)y);
    }

    public static Number divide(Object x, Object y) {
        Ops yops = Numbers.ops(y);
        if (yops.isZero((Number)y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.ops(x).combine(yops).divide((Number)x, (Number)y);
    }

    public static Number quotient(Number x, Number y) {
        Ops yops = Numbers.ops(y);
        if (yops.isZero(y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.reduce(Numbers.ops(x).combine(yops).quotient(x, y));
    }

    public static Number remainder(Number x, Number y) {
        Ops yops = Numbers.ops(y);
        if (yops.isZero(y)) {
            throw new ArithmeticException("Divide by zero");
        }
        return Numbers.reduce(Numbers.ops(x).combine(yops).remainder(x, y));
    }

    static Number quotient(double n, double d) {
        double q = n / d;
        if (q <= 2.147483647E9 && q >= -2.147483648E9) {
            return (int)q;
        }
        return Numbers.reduce(new BigDecimal(q).toBigInteger());
    }

    static Number remainder(double n, double d) {
        double q = n / d;
        if (q <= 2.147483647E9 && q >= -2.147483648E9) {
            return n - (double)((int)q) * d;
        }
        Number bq = Numbers.reduce(new BigDecimal(q).toBigInteger());
        return n - bq.doubleValue() * d;
    }

    public static boolean equiv(Object x, Object y) {
        return Numbers.equiv((Number)x, (Number)y);
    }

    public static boolean equiv(Number x, Number y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).equiv(x, y);
    }

    public static boolean lt(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)x, (Number)y);
    }

    public static boolean lte(Object x, Object y) {
        return !Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)y, (Number)x);
    }

    public static boolean gt(Object x, Object y) {
        return Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)y, (Number)x);
    }

    public static boolean gte(Object x, Object y) {
        return !Numbers.ops(x).combine(Numbers.ops(y)).lt((Number)x, (Number)y);
    }

    public static int compare(Number x, Number y) {
        Ops ops = Numbers.ops(x).combine(Numbers.ops(y));
        if (ops.lt(x, y)) {
            return -1;
        }
        if (ops.lt(y, x)) {
            return 1;
        }
        return 0;
    }

    static BigInteger toBigInteger(Object x) {
        if (x instanceof BigInteger) {
            return (BigInteger)x;
        }
        return BigInteger.valueOf(((Number)x).longValue());
    }

    static BigDecimal toBigDecimal(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof BigInteger) {
            return new BigDecimal((BigInteger)x);
        }
        return BigDecimal.valueOf(((Number)x).longValue());
    }

    static Ratio toRatio(Object x) {
        if (x instanceof Ratio) {
            return (Ratio)x;
        }
        if (x instanceof BigDecimal) {
            BigDecimal bx = (BigDecimal)x;
            BigInteger bv = bx.unscaledValue();
            int scale = bx.scale();
            if (scale < 0) {
                return new Ratio(bv.multiply(BigInteger.TEN.pow(-scale)), BigInteger.ONE);
            }
            return new Ratio(bv, BigInteger.TEN.pow(scale));
        }
        return new Ratio(Numbers.toBigInteger(x), BigInteger.ONE);
    }

    public static Number rationalize(Number x) {
        if (x instanceof Float || x instanceof Double) {
            return Numbers.rationalize(BigDecimal.valueOf(x.doubleValue()));
        }
        if (x instanceof BigDecimal) {
            BigDecimal bx = (BigDecimal)x;
            BigInteger bv = bx.unscaledValue();
            int scale = bx.scale();
            if (scale < 0) {
                return bv.multiply(BigInteger.TEN.pow(-scale));
            }
            return Numbers.divide(bv, BigInteger.TEN.pow(scale));
        }
        return x;
    }

    public static Number reduce(Number val2) {
        if (val2 instanceof Long) {
            return Numbers.reduce(val2.longValue());
        }
        if (val2 instanceof BigInteger) {
            return Numbers.reduce((BigInteger)val2);
        }
        return val2;
    }

    public static Number reduce(BigInteger val2) {
        int bitLength = val2.bitLength();
        if (bitLength < 32) {
            return val2.intValue();
        }
        if (bitLength < 64) {
            return val2.longValue();
        }
        return val2;
    }

    public static Number reduce(long val2) {
        if (val2 >= Integer.MIN_VALUE && val2 <= Integer.MAX_VALUE) {
            return (int)val2;
        }
        return val2;
    }

    public static Number divide(BigInteger n, BigInteger d) {
        if (d.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger gcd = n.gcd(d);
        if (gcd.equals(BigInteger.ZERO)) {
            return 0;
        }
        n = n.divide(gcd);
        if ((d = d.divide(gcd)).equals(BigInteger.ONE)) {
            return Numbers.reduce(n);
        }
        if (d.equals(BigInteger.ONE.negate())) {
            return Numbers.reduce(n.negate());
        }
        return new Ratio(d.signum() < 0 ? n.negate() : n, d.signum() < 0 ? d.negate() : d);
    }

    public static Number not(Object x) {
        return Numbers.bitOps(x).not((Number)x);
    }

    public static Number and(Object x, Object y) {
        return Numbers.bitOps(x).combine(Numbers.bitOps(y)).and((Number)x, (Number)y);
    }

    public static Number or(Object x, Object y) {
        return Numbers.bitOps(x).combine(Numbers.bitOps(y)).or((Number)x, (Number)y);
    }

    public static Number xor(Object x, Object y) {
        return Numbers.bitOps(x).combine(Numbers.bitOps(y)).xor((Number)x, (Number)y);
    }

    public static Number andNot(Number x, Number y) {
        return Numbers.bitOps(x).combine(Numbers.bitOps(y)).andNot(x, y);
    }

    public static Number clearBit(Number x, int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit index");
        }
        return Numbers.bitOps(x).clearBit(x, n);
    }

    public static Number setBit(Number x, int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit index");
        }
        return Numbers.bitOps(x).setBit(x, n);
    }

    public static Number flipBit(Number x, int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit index");
        }
        return Numbers.bitOps(x).flipBit(x, n);
    }

    public static boolean testBit(Number x, int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit index");
        }
        return Numbers.bitOps(x).testBit(x, n);
    }

    public static Number shiftLeft(Object x, Object n) {
        return Numbers.bitOps(x).shiftLeft((Number)x, ((Number)n).intValue());
    }

    public static int shiftLeft(int x, int n) {
        return x << n;
    }

    public static Number shiftRight(Object x, Object n) {
        return Numbers.bitOps(x).shiftRight((Number)x, ((Number)n).intValue());
    }

    public static int shiftRight(int x, int n) {
        return x >> n;
    }

    static Ops ops(Object x) {
        Class<?> xc = x.getClass();
        if (xc == Integer.class) {
            return INTEGER_OPS;
        }
        if (xc == Double.class) {
            return DOUBLE_OPS;
        }
        if (xc == Float.class) {
            return FLOAT_OPS;
        }
        if (xc == BigInteger.class) {
            return BIGINTEGER_OPS;
        }
        if (xc == Long.class) {
            return LONG_OPS;
        }
        if (xc == Ratio.class) {
            return RATIO_OPS;
        }
        if (xc == BigDecimal.class) {
            return BIGDECIMAL_OPS;
        }
        return INTEGER_OPS;
    }

    static BitOps bitOps(Object x) {
        Class<?> xc = x.getClass();
        if (xc == Integer.class) {
            return INTEGER_BITOPS;
        }
        if (xc == Long.class) {
            return LONG_BITOPS;
        }
        if (xc == BigInteger.class) {
            return BIGINTEGER_BITOPS;
        }
        if (xc == Double.class || xc == Float.class || xc == BigDecimalOps.class || xc == Ratio.class) {
            throw new ArithmeticException("bit operation on non integer type: " + xc);
        }
        return INTEGER_BITOPS;
    }

    public static float[] float_array(int size, Object init) {
        float[] ret = new float[size];
        if (init instanceof Number) {
            float f = ((Number)init).floatValue();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = f;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = ((Number)s.first()).floatValue();
            }
        }
        return ret;
    }

    public static float[] float_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new float[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        float[] ret = new float[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = ((Number)s.first()).floatValue();
        }
        return ret;
    }

    public static double[] double_array(int size, Object init) {
        double[] ret = new double[size];
        if (init instanceof Number) {
            double f = ((Number)init).doubleValue();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = f;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = ((Number)s.first()).doubleValue();
            }
        }
        return ret;
    }

    public static double[] double_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new double[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        double[] ret = new double[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = ((Number)s.first()).doubleValue();
        }
        return ret;
    }

    public static int[] int_array(int size, Object init) {
        int[] ret = new int[size];
        if (init instanceof Number) {
            int f = ((Number)init).intValue();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = f;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = ((Number)s.first()).intValue();
            }
        }
        return ret;
    }

    public static int[] int_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new int[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        int[] ret = new int[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = ((Number)s.first()).intValue();
        }
        return ret;
    }

    public static long[] long_array(int size, Object init) {
        long[] ret = new long[size];
        if (init instanceof Number) {
            long f = ((Number)init).longValue();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = f;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = ((Number)s.first()).longValue();
            }
        }
        return ret;
    }

    public static long[] long_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new long[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        long[] ret = new long[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = ((Number)s.first()).longValue();
        }
        return ret;
    }

    public static short[] short_array(int size, Object init) {
        short[] ret = new short[size];
        if (init instanceof Short) {
            short s = (Short)init;
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = s;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = (Short)s.first();
            }
        }
        return ret;
    }

    public static short[] short_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new short[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        short[] ret = new short[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = (Short)s.first();
        }
        return ret;
    }

    public static char[] char_array(int size, Object init) {
        char[] ret = new char[size];
        if (init instanceof Character) {
            char c = ((Character)init).charValue();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = c;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = ((Character)s.first()).charValue();
            }
        }
        return ret;
    }

    public static char[] char_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new char[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        char[] ret = new char[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = ((Character)s.first()).charValue();
        }
        return ret;
    }

    public static byte[] byte_array(int size, Object init) {
        byte[] ret = new byte[size];
        if (init instanceof Byte) {
            byte b = (Byte)init;
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = b;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = (Byte)s.first();
            }
        }
        return ret;
    }

    public static byte[] byte_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new byte[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        byte[] ret = new byte[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = (Byte)s.first();
        }
        return ret;
    }

    public static boolean[] boolean_array(int size, Object init) {
        boolean[] ret = new boolean[size];
        if (init instanceof Boolean) {
            boolean b = (Boolean)init;
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = b;
            }
        } else {
            ISeq s = RT.seq(init);
            for (int i = 0; i < size && s != null; ++i, s = s.next()) {
                ret[i] = (Boolean)s.first();
            }
        }
        return ret;
    }

    public static boolean[] boolean_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new boolean[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        boolean[] ret = new boolean[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = (Boolean)s.first();
        }
        return ret;
    }

    public static boolean[] booleans(Object array2) {
        return (boolean[])array2;
    }

    public static byte[] bytes(Object array2) {
        return (byte[])array2;
    }

    public static char[] chars(Object array2) {
        return (char[])array2;
    }

    public static short[] shorts(Object array2) {
        return (short[])array2;
    }

    public static float[] floats(Object array2) {
        return (float[])array2;
    }

    public static double[] doubles(Object array2) {
        return (double[])array2;
    }

    public static int[] ints(Object array2) {
        return (int[])array2;
    }

    public static long[] longs(Object array2) {
        return (long[])array2;
    }

    public static Number num(Object x) {
        return (Number)x;
    }

    public static Number num(float x) {
        return Float.valueOf(x);
    }

    public static float add(float x, float y) {
        return x + y;
    }

    public static float minus(float x, float y) {
        return x - y;
    }

    public static float minus(float x) {
        return -x;
    }

    public static float inc(float x) {
        return x + 1.0f;
    }

    public static float dec(float x) {
        return x - 1.0f;
    }

    public static float multiply(float x, float y) {
        return x * y;
    }

    public static float divide(float x, float y) {
        return x / y;
    }

    public static boolean equiv(float x, float y) {
        return x == y;
    }

    public static boolean lt(float x, float y) {
        return x < y;
    }

    public static boolean lte(float x, float y) {
        return x <= y;
    }

    public static boolean gt(float x, float y) {
        return x > y;
    }

    public static boolean gte(float x, float y) {
        return x >= y;
    }

    public static boolean isPos(float x) {
        return x > 0.0f;
    }

    public static boolean isNeg(float x) {
        return x < 0.0f;
    }

    public static boolean isZero(float x) {
        return x == 0.0f;
    }

    public static Number num(double x) {
        return x;
    }

    public static double add(double x, double y) {
        return x + y;
    }

    public static double minus(double x, double y) {
        return x - y;
    }

    public static double minus(double x) {
        return -x;
    }

    public static double inc(double x) {
        return x + 1.0;
    }

    public static double dec(double x) {
        return x - 1.0;
    }

    public static double multiply(double x, double y) {
        return x * y;
    }

    public static double divide(double x, double y) {
        return x / y;
    }

    public static boolean equiv(double x, double y) {
        return x == y;
    }

    public static boolean lt(double x, double y) {
        return x < y;
    }

    public static boolean lte(double x, double y) {
        return x <= y;
    }

    public static boolean gt(double x, double y) {
        return x > y;
    }

    public static boolean gte(double x, double y) {
        return x >= y;
    }

    public static boolean isPos(double x) {
        return x > 0.0;
    }

    public static boolean isNeg(double x) {
        return x < 0.0;
    }

    public static boolean isZero(double x) {
        return x == 0.0;
    }

    static int throwIntOverflow() {
        throw new ArithmeticException("integer overflow");
    }

    public static Number num(int x) {
        return x;
    }

    public static int unchecked_add(int x, int y) {
        return x + y;
    }

    public static int unchecked_subtract(int x, int y) {
        return x - y;
    }

    public static int unchecked_negate(int x) {
        return -x;
    }

    public static int unchecked_inc(int x) {
        return x + 1;
    }

    public static int unchecked_dec(int x) {
        return x - 1;
    }

    public static int unchecked_multiply(int x, int y) {
        return x * y;
    }

    public static int add(int x, int y) {
        int ret = x + y;
        if ((ret ^ x) < 0 && (ret ^ y) < 0) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static int not(int x) {
        return ~x;
    }

    public static int and(int x, int y) {
        return x & y;
    }

    public static int or(int x, int y) {
        return x | y;
    }

    public static int xor(int x, int y) {
        return x ^ y;
    }

    public static int minus(int x, int y) {
        int ret = x - y;
        if ((ret ^ x) < 0 && (ret ^ ~y) < 0) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static int minus(int x) {
        if (x == Integer.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return -x;
    }

    public static int inc(int x) {
        if (x == Integer.MAX_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x + 1;
    }

    public static int dec(int x) {
        if (x == Integer.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x - 1;
    }

    public static int multiply(int x, int y) {
        int ret = x * y;
        if (y != 0 && ret / y != x) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static int unchecked_divide(int x, int y) {
        return x / y;
    }

    public static int unchecked_remainder(int x, int y) {
        return x % y;
    }

    public static boolean equiv(int x, int y) {
        return x == y;
    }

    public static boolean lt(int x, int y) {
        return x < y;
    }

    public static boolean lte(int x, int y) {
        return x <= y;
    }

    public static boolean gt(int x, int y) {
        return x > y;
    }

    public static boolean gte(int x, int y) {
        return x >= y;
    }

    public static boolean isPos(int x) {
        return x > 0;
    }

    public static boolean isNeg(int x) {
        return x < 0;
    }

    public static boolean isZero(int x) {
        return x == 0;
    }

    public static Number num(long x) {
        return x;
    }

    public static long unchecked_add(long x, long y) {
        return x + y;
    }

    public static long unchecked_subtract(long x, long y) {
        return x - y;
    }

    public static long unchecked_negate(long x) {
        return -x;
    }

    public static long unchecked_inc(long x) {
        return x + 1L;
    }

    public static long unchecked_dec(long x) {
        return x - 1L;
    }

    public static long unchecked_multiply(long x, long y) {
        return x * y;
    }

    public static long add(long x, long y) {
        long ret = x + y;
        if ((ret ^ x) < 0L && (ret ^ y) < 0L) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static long minus(long x, long y) {
        long ret = x - y;
        if ((ret ^ x) < 0L && (ret ^ (y ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static long minus(long x) {
        if (x == Long.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return -x;
    }

    public static long inc(long x) {
        if (x == Long.MAX_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x + 1L;
    }

    public static long dec(long x) {
        if (x == Long.MIN_VALUE) {
            return Numbers.throwIntOverflow();
        }
        return x - 1L;
    }

    public static long multiply(long x, long y) {
        long ret = x * y;
        if (y != 0L && ret / y != x) {
            return Numbers.throwIntOverflow();
        }
        return ret;
    }

    public static long unchecked_divide(long x, long y) {
        return x / y;
    }

    public static long unchecked_remainder(long x, long y) {
        return x % y;
    }

    public static boolean equiv(long x, long y) {
        return x == y;
    }

    public static boolean lt(long x, long y) {
        return x < y;
    }

    public static boolean lte(long x, long y) {
        return x <= y;
    }

    public static boolean gt(long x, long y) {
        return x > y;
    }

    public static boolean gte(long x, long y) {
        return x >= y;
    }

    public static boolean isPos(long x) {
        return x > 0L;
    }

    public static boolean isNeg(long x) {
        return x < 0L;
    }

    public static boolean isZero(long x) {
        return x == 0L;
    }

    public static Number add(int x, Object y) {
        return Numbers.add((Object)x, y);
    }

    public static Number add(Object x, int y) {
        return Numbers.add(x, (Object)y);
    }

    public static Number and(int x, Object y) {
        return Numbers.and((Object)x, y);
    }

    public static Number and(Object x, int y) {
        return Numbers.and(x, (Object)y);
    }

    public static Number or(int x, Object y) {
        return Numbers.or((Object)x, y);
    }

    public static Number or(Object x, int y) {
        return Numbers.or(x, (Object)y);
    }

    public static Number xor(int x, Object y) {
        return Numbers.xor((Object)x, y);
    }

    public static Number xor(Object x, int y) {
        return Numbers.xor(x, (Object)y);
    }

    public static Number add(float x, Object y) {
        return Numbers.add((Object)Float.valueOf(x), y);
    }

    public static Number add(Object x, float y) {
        return Numbers.add(x, (Object)Float.valueOf(y));
    }

    public static Number add(long x, Object y) {
        return Numbers.add((Object)x, y);
    }

    public static Number add(Object x, long y) {
        return Numbers.add(x, (Object)y);
    }

    public static Number add(double x, Object y) {
        return Numbers.add((Object)x, y);
    }

    public static Number add(Object x, double y) {
        return Numbers.add(x, (Object)y);
    }

    public static Number minus(int x, Object y) {
        return Numbers.minus((Object)x, y);
    }

    public static Number minus(Object x, int y) {
        return Numbers.minus(x, (Object)y);
    }

    public static Number minus(float x, Object y) {
        return Numbers.minus((Object)Float.valueOf(x), y);
    }

    public static Number minus(Object x, float y) {
        return Numbers.minus(x, (Object)Float.valueOf(y));
    }

    public static Number minus(long x, Object y) {
        return Numbers.minus((Object)x, y);
    }

    public static Number minus(Object x, long y) {
        return Numbers.minus(x, (Object)y);
    }

    public static Number minus(double x, Object y) {
        return Numbers.minus((Object)x, y);
    }

    public static Number minus(Object x, double y) {
        return Numbers.minus(x, (Object)y);
    }

    public static Number multiply(int x, Object y) {
        return Numbers.multiply((Object)x, y);
    }

    public static Number multiply(Object x, int y) {
        return Numbers.multiply(x, (Object)y);
    }

    public static Number multiply(float x, Object y) {
        return Numbers.multiply((Object)Float.valueOf(x), y);
    }

    public static Number multiply(Object x, float y) {
        return Numbers.multiply(x, (Object)Float.valueOf(y));
    }

    public static Number multiply(long x, Object y) {
        return Numbers.multiply((Object)x, y);
    }

    public static Number multiply(Object x, long y) {
        return Numbers.multiply(x, (Object)y);
    }

    public static Number multiply(double x, Object y) {
        return Numbers.multiply((Object)x, y);
    }

    public static Number multiply(Object x, double y) {
        return Numbers.multiply(x, (Object)y);
    }

    public static Number divide(int x, Object y) {
        return Numbers.divide((Object)x, y);
    }

    public static Number divide(Object x, int y) {
        return Numbers.divide(x, (Object)y);
    }

    public static Number divide(float x, Object y) {
        return Numbers.divide((Object)Float.valueOf(x), y);
    }

    public static Number divide(Object x, float y) {
        return Numbers.divide(x, (Object)Float.valueOf(y));
    }

    public static Number divide(long x, Object y) {
        return Numbers.divide((Object)x, y);
    }

    public static Number divide(Object x, long y) {
        return Numbers.divide(x, (Object)y);
    }

    public static Number divide(double x, Object y) {
        return Numbers.divide((Object)x, y);
    }

    public static Number divide(Object x, double y) {
        return Numbers.divide(x, (Object)y);
    }

    public static boolean lt(int x, Object y) {
        return Numbers.lt((Object)x, y);
    }

    public static boolean lt(Object x, int y) {
        return Numbers.lt(x, (Object)y);
    }

    public static boolean lt(float x, Object y) {
        return Numbers.lt((Object)Float.valueOf(x), y);
    }

    public static boolean lt(Object x, float y) {
        return Numbers.lt(x, (Object)Float.valueOf(y));
    }

    public static boolean lt(long x, Object y) {
        return Numbers.lt((Object)x, y);
    }

    public static boolean lt(Object x, long y) {
        return Numbers.lt(x, (Object)y);
    }

    public static boolean lt(double x, Object y) {
        return Numbers.lt((Object)x, y);
    }

    public static boolean lt(Object x, double y) {
        return Numbers.lt(x, (Object)y);
    }

    public static boolean lte(int x, Object y) {
        return Numbers.lte((Object)x, y);
    }

    public static boolean lte(Object x, int y) {
        return Numbers.lte(x, (Object)y);
    }

    public static boolean lte(float x, Object y) {
        return Numbers.lte((Object)Float.valueOf(x), y);
    }

    public static boolean lte(Object x, float y) {
        return Numbers.lte(x, (Object)Float.valueOf(y));
    }

    public static boolean lte(long x, Object y) {
        return Numbers.lte((Object)x, y);
    }

    public static boolean lte(Object x, long y) {
        return Numbers.lte(x, (Object)y);
    }

    public static boolean lte(double x, Object y) {
        return Numbers.lte((Object)x, y);
    }

    public static boolean lte(Object x, double y) {
        return Numbers.lte(x, (Object)y);
    }

    public static boolean gt(int x, Object y) {
        return Numbers.gt((Object)x, y);
    }

    public static boolean gt(Object x, int y) {
        return Numbers.gt(x, (Object)y);
    }

    public static boolean gt(float x, Object y) {
        return Numbers.gt((Object)Float.valueOf(x), y);
    }

    public static boolean gt(Object x, float y) {
        return Numbers.gt(x, (Object)Float.valueOf(y));
    }

    public static boolean gt(long x, Object y) {
        return Numbers.gt((Object)x, y);
    }

    public static boolean gt(Object x, long y) {
        return Numbers.gt(x, (Object)y);
    }

    public static boolean gt(double x, Object y) {
        return Numbers.gt((Object)x, y);
    }

    public static boolean gt(Object x, double y) {
        return Numbers.gt(x, (Object)y);
    }

    public static boolean gte(int x, Object y) {
        return Numbers.gte((Object)x, y);
    }

    public static boolean gte(Object x, int y) {
        return Numbers.gte(x, (Object)y);
    }

    public static boolean gte(float x, Object y) {
        return Numbers.gte((Object)Float.valueOf(x), y);
    }

    public static boolean gte(Object x, float y) {
        return Numbers.gte(x, (Object)Float.valueOf(y));
    }

    public static boolean gte(long x, Object y) {
        return Numbers.gte((Object)x, y);
    }

    public static boolean gte(Object x, long y) {
        return Numbers.gte(x, (Object)y);
    }

    public static boolean gte(double x, Object y) {
        return Numbers.gte((Object)x, y);
    }

    public static boolean gte(Object x, double y) {
        return Numbers.gte(x, (Object)y);
    }

    public static boolean equiv(int x, Object y) {
        return Numbers.equiv((Object)x, y);
    }

    public static boolean equiv(Object x, int y) {
        return Numbers.equiv(x, (Object)y);
    }

    public static boolean equiv(float x, Object y) {
        return Numbers.equiv((Object)Float.valueOf(x), y);
    }

    public static boolean equiv(Object x, float y) {
        return Numbers.equiv(x, (Object)Float.valueOf(y));
    }

    public static boolean equiv(long x, Object y) {
        return Numbers.equiv((Object)x, y);
    }

    public static boolean equiv(Object x, long y) {
        return Numbers.equiv(x, (Object)y);
    }

    public static boolean equiv(double x, Object y) {
        return Numbers.equiv((Object)x, y);
    }

    public static boolean equiv(Object x, double y) {
        return Numbers.equiv(x, (Object)y);
    }

    public static float add(int x, float y) {
        return Numbers.add((float)x, y);
    }

    public static float add(float x, int y) {
        return Numbers.add(x, (float)y);
    }

    public static double add(int x, double y) {
        return Numbers.add((double)x, y);
    }

    public static double add(double x, int y) {
        return Numbers.add(x, (double)y);
    }

    public static long add(int x, long y) {
        return Numbers.add((long)x, y);
    }

    public static long add(long x, int y) {
        return Numbers.add(x, (long)y);
    }

    public static float add(long x, float y) {
        return Numbers.add((float)x, y);
    }

    public static float add(float x, long y) {
        return Numbers.add(x, (float)y);
    }

    public static double add(long x, double y) {
        return Numbers.add((double)x, y);
    }

    public static double add(double x, long y) {
        return Numbers.add(x, (double)y);
    }

    public static double add(float x, double y) {
        return Numbers.add((double)x, y);
    }

    public static double add(double x, float y) {
        return Numbers.add(x, (double)y);
    }

    public static float minus(int x, float y) {
        return Numbers.minus((float)x, y);
    }

    public static float minus(float x, int y) {
        return Numbers.minus(x, (float)y);
    }

    public static double minus(int x, double y) {
        return Numbers.minus((double)x, y);
    }

    public static double minus(double x, int y) {
        return Numbers.minus(x, (double)y);
    }

    public static long minus(int x, long y) {
        return Numbers.minus((long)x, y);
    }

    public static long minus(long x, int y) {
        return Numbers.minus(x, (long)y);
    }

    public static float minus(long x, float y) {
        return Numbers.minus((float)x, y);
    }

    public static float minus(float x, long y) {
        return Numbers.minus(x, (float)y);
    }

    public static double minus(long x, double y) {
        return Numbers.minus((double)x, y);
    }

    public static double minus(double x, long y) {
        return Numbers.minus(x, (double)y);
    }

    public static double minus(float x, double y) {
        return Numbers.minus((double)x, y);
    }

    public static double minus(double x, float y) {
        return Numbers.minus(x, (double)y);
    }

    public static float multiply(int x, float y) {
        return Numbers.multiply((float)x, y);
    }

    public static float multiply(float x, int y) {
        return Numbers.multiply(x, (float)y);
    }

    public static double multiply(int x, double y) {
        return Numbers.multiply((double)x, y);
    }

    public static double multiply(double x, int y) {
        return Numbers.multiply(x, (double)y);
    }

    public static long multiply(int x, long y) {
        return Numbers.multiply((long)x, y);
    }

    public static long multiply(long x, int y) {
        return Numbers.multiply(x, (long)y);
    }

    public static float multiply(long x, float y) {
        return Numbers.multiply((float)x, y);
    }

    public static float multiply(float x, long y) {
        return Numbers.multiply(x, (float)y);
    }

    public static double multiply(long x, double y) {
        return Numbers.multiply((double)x, y);
    }

    public static double multiply(double x, long y) {
        return Numbers.multiply(x, (double)y);
    }

    public static double multiply(float x, double y) {
        return Numbers.multiply((double)x, y);
    }

    public static double multiply(double x, float y) {
        return Numbers.multiply(x, (double)y);
    }

    public static float divide(int x, float y) {
        return Numbers.divide((float)x, y);
    }

    public static float divide(float x, int y) {
        return Numbers.divide(x, (float)y);
    }

    public static double divide(int x, double y) {
        return Numbers.divide((double)x, y);
    }

    public static double divide(double x, int y) {
        return Numbers.divide(x, (double)y);
    }

    public static float divide(long x, float y) {
        return Numbers.divide((float)x, y);
    }

    public static float divide(float x, long y) {
        return Numbers.divide(x, (float)y);
    }

    public static double divide(long x, double y) {
        return Numbers.divide((double)x, y);
    }

    public static double divide(double x, long y) {
        return Numbers.divide(x, (double)y);
    }

    public static double divide(float x, double y) {
        return Numbers.divide((double)x, y);
    }

    public static double divide(double x, float y) {
        return Numbers.divide(x, (double)y);
    }

    public static boolean lt(int x, float y) {
        return Numbers.lt((float)x, y);
    }

    public static boolean lt(float x, int y) {
        return Numbers.lt(x, (float)y);
    }

    public static boolean lt(int x, double y) {
        return Numbers.lt((double)x, y);
    }

    public static boolean lt(double x, int y) {
        return Numbers.lt(x, (double)y);
    }

    public static boolean lt(int x, long y) {
        return Numbers.lt((long)x, y);
    }

    public static boolean lt(long x, int y) {
        return Numbers.lt(x, (long)y);
    }

    public static boolean lt(long x, float y) {
        return Numbers.lt((float)x, y);
    }

    public static boolean lt(float x, long y) {
        return Numbers.lt(x, (float)y);
    }

    public static boolean lt(long x, double y) {
        return Numbers.lt((double)x, y);
    }

    public static boolean lt(double x, long y) {
        return Numbers.lt(x, (double)y);
    }

    public static boolean lt(float x, double y) {
        return Numbers.lt((double)x, y);
    }

    public static boolean lt(double x, float y) {
        return Numbers.lt(x, (double)y);
    }

    public static boolean lte(int x, float y) {
        return Numbers.lte((float)x, y);
    }

    public static boolean lte(float x, int y) {
        return Numbers.lte(x, (float)y);
    }

    public static boolean lte(int x, double y) {
        return Numbers.lte((double)x, y);
    }

    public static boolean lte(double x, int y) {
        return Numbers.lte(x, (double)y);
    }

    public static boolean lte(int x, long y) {
        return Numbers.lte((long)x, y);
    }

    public static boolean lte(long x, int y) {
        return Numbers.lte(x, (long)y);
    }

    public static boolean lte(long x, float y) {
        return Numbers.lte((float)x, y);
    }

    public static boolean lte(float x, long y) {
        return Numbers.lte(x, (float)y);
    }

    public static boolean lte(long x, double y) {
        return Numbers.lte((double)x, y);
    }

    public static boolean lte(double x, long y) {
        return Numbers.lte(x, (double)y);
    }

    public static boolean lte(float x, double y) {
        return Numbers.lte((double)x, y);
    }

    public static boolean lte(double x, float y) {
        return Numbers.lte(x, (double)y);
    }

    public static boolean gt(int x, float y) {
        return Numbers.gt((float)x, y);
    }

    public static boolean gt(float x, int y) {
        return Numbers.gt(x, (float)y);
    }

    public static boolean gt(int x, double y) {
        return Numbers.gt((double)x, y);
    }

    public static boolean gt(double x, int y) {
        return Numbers.gt(x, (double)y);
    }

    public static boolean gt(int x, long y) {
        return Numbers.gt((long)x, y);
    }

    public static boolean gt(long x, int y) {
        return Numbers.gt(x, (long)y);
    }

    public static boolean gt(long x, float y) {
        return Numbers.gt((float)x, y);
    }

    public static boolean gt(float x, long y) {
        return Numbers.gt(x, (float)y);
    }

    public static boolean gt(long x, double y) {
        return Numbers.gt((double)x, y);
    }

    public static boolean gt(double x, long y) {
        return Numbers.gt(x, (double)y);
    }

    public static boolean gt(float x, double y) {
        return Numbers.gt((double)x, y);
    }

    public static boolean gt(double x, float y) {
        return Numbers.gt(x, (double)y);
    }

    public static boolean gte(int x, float y) {
        return Numbers.gte((float)x, y);
    }

    public static boolean gte(float x, int y) {
        return Numbers.gte(x, (float)y);
    }

    public static boolean gte(int x, double y) {
        return Numbers.gte((double)x, y);
    }

    public static boolean gte(double x, int y) {
        return Numbers.gte(x, (double)y);
    }

    public static boolean gte(int x, long y) {
        return Numbers.gte((long)x, y);
    }

    public static boolean gte(long x, int y) {
        return Numbers.gte(x, (long)y);
    }

    public static boolean gte(long x, float y) {
        return Numbers.gte((float)x, y);
    }

    public static boolean gte(float x, long y) {
        return Numbers.gte(x, (float)y);
    }

    public static boolean gte(long x, double y) {
        return Numbers.gte((double)x, y);
    }

    public static boolean gte(double x, long y) {
        return Numbers.gte(x, (double)y);
    }

    public static boolean gte(float x, double y) {
        return Numbers.gte((double)x, y);
    }

    public static boolean gte(double x, float y) {
        return Numbers.gte(x, (double)y);
    }

    public static boolean equiv(int x, float y) {
        return Numbers.equiv((float)x, y);
    }

    public static boolean equiv(float x, int y) {
        return Numbers.equiv(x, (float)y);
    }

    public static boolean equiv(int x, double y) {
        return Numbers.equiv((double)x, y);
    }

    public static boolean equiv(double x, int y) {
        return Numbers.equiv(x, (double)y);
    }

    public static boolean equiv(int x, long y) {
        return Numbers.equiv((long)x, y);
    }

    public static boolean equiv(long x, int y) {
        return Numbers.equiv(x, (long)y);
    }

    public static boolean equiv(long x, float y) {
        return Numbers.equiv((float)x, y);
    }

    public static boolean equiv(float x, long y) {
        return Numbers.equiv(x, (float)y);
    }

    public static boolean equiv(long x, double y) {
        return Numbers.equiv((double)x, y);
    }

    public static boolean equiv(double x, long y) {
        return Numbers.equiv(x, (double)y);
    }

    public static boolean equiv(float x, double y) {
        return Numbers.equiv((double)x, y);
    }

    public static boolean equiv(double x, float y) {
        return Numbers.equiv(x, (double)y);
    }

    static final class BigIntegerBitOps
    implements BitOps {
        BigIntegerBitOps() {
        }

        public BitOps combine(BitOps y) {
            return y.bitOpsWith(this);
        }

        public final BitOps bitOpsWith(IntegerBitOps x) {
            return this;
        }

        public final BitOps bitOpsWith(LongBitOps x) {
            return this;
        }

        public final BitOps bitOpsWith(BigIntegerBitOps x) {
            return this;
        }

        public Number not(Number x) {
            return Numbers.toBigInteger(x).not();
        }

        public Number and(Number x, Number y) {
            return Numbers.toBigInteger(x).and(Numbers.toBigInteger(y));
        }

        public Number or(Number x, Number y) {
            return Numbers.toBigInteger(x).or(Numbers.toBigInteger(y));
        }

        public Number xor(Number x, Number y) {
            return Numbers.toBigInteger(x).xor(Numbers.toBigInteger(y));
        }

        public Number andNot(Number x, Number y) {
            return Numbers.toBigInteger(x).andNot(Numbers.toBigInteger(y));
        }

        public Number clearBit(Number x, int n) {
            return Numbers.toBigInteger(x).clearBit(n);
        }

        public Number setBit(Number x, int n) {
            return Numbers.toBigInteger(x).setBit(n);
        }

        public Number flipBit(Number x, int n) {
            return Numbers.toBigInteger(x).flipBit(n);
        }

        public boolean testBit(Number x, int n) {
            return Numbers.toBigInteger(x).testBit(n);
        }

        public Number shiftLeft(Number x, int n) {
            return Numbers.toBigInteger(x).shiftLeft(n);
        }

        public Number shiftRight(Number x, int n) {
            return Numbers.toBigInteger(x).shiftRight(n);
        }
    }

    static final class LongBitOps
    implements BitOps {
        LongBitOps() {
        }

        public BitOps combine(BitOps y) {
            return y.bitOpsWith(this);
        }

        public final BitOps bitOpsWith(IntegerBitOps x) {
            return this;
        }

        public final BitOps bitOpsWith(LongBitOps x) {
            return this;
        }

        public final BitOps bitOpsWith(BigIntegerBitOps x) {
            return BIGINTEGER_BITOPS;
        }

        public Number not(Number x) {
            return x.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public Number and(Number x, Number y) {
            return x.longValue() & y.longValue();
        }

        public Number or(Number x, Number y) {
            return x.longValue() | y.longValue();
        }

        public Number xor(Number x, Number y) {
            return x.longValue() ^ y.longValue();
        }

        public Number andNot(Number x, Number y) {
            return x.longValue() & (y.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public Number clearBit(Number x, int n) {
            if (n < 63) {
                return x.longValue() & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return Numbers.toBigInteger(x).clearBit(n);
        }

        public Number setBit(Number x, int n) {
            if (n < 63) {
                return x.longValue() | 1L << n;
            }
            return Numbers.toBigInteger(x).setBit(n);
        }

        public Number flipBit(Number x, int n) {
            if (n < 63) {
                return x.longValue() ^ 1L << n;
            }
            return Numbers.toBigInteger(x).flipBit(n);
        }

        public boolean testBit(Number x, int n) {
            if (n < 64) {
                return (x.longValue() & 1L << n) != 0L;
            }
            return Numbers.toBigInteger(x).testBit(n);
        }

        public Number shiftLeft(Number x, int n) {
            if (n < 0) {
                return this.shiftRight(x, -n);
            }
            return Numbers.reduce(Numbers.toBigInteger(x).shiftLeft(n));
        }

        public Number shiftRight(Number x, int n) {
            if (n < 0) {
                return this.shiftLeft(x, -n);
            }
            return x.longValue() >> n;
        }
    }

    static final class IntegerBitOps
    implements BitOps {
        IntegerBitOps() {
        }

        public BitOps combine(BitOps y) {
            return y.bitOpsWith(this);
        }

        public final BitOps bitOpsWith(IntegerBitOps x) {
            return this;
        }

        public final BitOps bitOpsWith(LongBitOps x) {
            return LONG_BITOPS;
        }

        public final BitOps bitOpsWith(BigIntegerBitOps x) {
            return BIGINTEGER_BITOPS;
        }

        public Number not(Number x) {
            return ~x.intValue();
        }

        public Number and(Number x, Number y) {
            return x.intValue() & y.intValue();
        }

        public Number or(Number x, Number y) {
            return x.intValue() | y.intValue();
        }

        public Number xor(Number x, Number y) {
            return x.intValue() ^ y.intValue();
        }

        public Number andNot(Number x, Number y) {
            return x.intValue() & ~y.intValue();
        }

        public Number clearBit(Number x, int n) {
            if (n < 31) {
                return x.intValue() & ~(1 << n);
            }
            if (n < 63) {
                return x.longValue() & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return Numbers.toBigInteger(x).clearBit(n);
        }

        public Number setBit(Number x, int n) {
            if (n < 31) {
                return x.intValue() | 1 << n;
            }
            if (n < 63) {
                return x.longValue() | 1L << n;
            }
            return Numbers.toBigInteger(x).setBit(n);
        }

        public Number flipBit(Number x, int n) {
            if (n < 31) {
                return x.intValue() ^ 1 << n;
            }
            if (n < 63) {
                return x.longValue() ^ 1L << n;
            }
            return Numbers.toBigInteger(x).flipBit(n);
        }

        public boolean testBit(Number x, int n) {
            if (n < 32) {
                return (x.intValue() & 1 << n) != 0;
            }
            if (n < 64) {
                return (x.longValue() & 1L << n) != 0L;
            }
            return Numbers.toBigInteger(x).testBit(n);
        }

        public Number shiftLeft(Number x, int n) {
            if (n < 32) {
                if (n < 0) {
                    return this.shiftRight(x, -n);
                }
                return Numbers.reduce(x.longValue() << n);
            }
            return Numbers.reduce(Numbers.toBigInteger(x).shiftLeft(n));
        }

        public Number shiftRight(Number x, int n) {
            if (n < 0) {
                return this.shiftLeft(x, -n);
            }
            return x.intValue() >> n;
        }
    }

    static final class BigDecimalOps
    implements Ops {
        static final Var MATH_CONTEXT = RT.MATH_CONTEXT;

        BigDecimalOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return RATIO_OPS;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        public boolean isZero(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() == 0;
        }

        public boolean isPos(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() > 0;
        }

        public boolean isNeg(Number x) {
            BigDecimal bx = (BigDecimal)x;
            return bx.signum() < 0;
        }

        public final Number add(Number x, Number y) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? Numbers.toBigDecimal(x).add(Numbers.toBigDecimal(y)) : Numbers.toBigDecimal(x).add(Numbers.toBigDecimal(y), mc);
        }

        public final Number multiply(Number x, Number y) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? Numbers.toBigDecimal(x).multiply(Numbers.toBigDecimal(y)) : Numbers.toBigDecimal(x).multiply(Numbers.toBigDecimal(y), mc);
        }

        public Number divide(Number x, Number y) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? Numbers.toBigDecimal(x).divide(Numbers.toBigDecimal(y)) : Numbers.toBigDecimal(x).divide(Numbers.toBigDecimal(y), mc);
        }

        public Number quotient(Number x, Number y) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? Numbers.toBigDecimal(x).divideToIntegralValue(Numbers.toBigDecimal(y)) : Numbers.toBigDecimal(x).divideToIntegralValue(Numbers.toBigDecimal(y), mc);
        }

        public Number remainder(Number x, Number y) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? Numbers.toBigDecimal(x).remainder(Numbers.toBigDecimal(y)) : Numbers.toBigDecimal(x).remainder(Numbers.toBigDecimal(y), mc);
        }

        public boolean equiv(Number x, Number y) {
            return Numbers.toBigDecimal(x).equals(Numbers.toBigDecimal(y));
        }

        public boolean lt(Number x, Number y) {
            return Numbers.toBigDecimal(x).compareTo(Numbers.toBigDecimal(y)) < 0;
        }

        public final Number negate(Number x) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            return mc == null ? ((BigDecimal)x).negate() : ((BigDecimal)x).negate(mc);
        }

        public Number inc(Number x) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            BigDecimal bx = (BigDecimal)x;
            return mc == null ? bx.add(BigDecimal.ONE) : bx.add(BigDecimal.ONE, mc);
        }

        public Number dec(Number x) {
            MathContext mc = (MathContext)MATH_CONTEXT.deref();
            BigDecimal bx = (BigDecimal)x;
            return mc == null ? bx.subtract(BigDecimal.ONE) : bx.subtract(BigDecimal.ONE, mc);
        }
    }

    static final class BigIntegerOps
    implements Ops {
        BigIntegerOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return RATIO_OPS;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        public boolean isZero(Number x) {
            BigInteger bx = Numbers.toBigInteger(x);
            return bx.signum() == 0;
        }

        public boolean isPos(Number x) {
            BigInteger bx = Numbers.toBigInteger(x);
            return bx.signum() > 0;
        }

        public boolean isNeg(Number x) {
            BigInteger bx = Numbers.toBigInteger(x);
            return bx.signum() < 0;
        }

        public final Number add(Number x, Number y) {
            return Numbers.reduce(Numbers.toBigInteger(x).add(Numbers.toBigInteger(y)));
        }

        public final Number multiply(Number x, Number y) {
            return Numbers.reduce(Numbers.toBigInteger(x).multiply(Numbers.toBigInteger(y)));
        }

        public Number divide(Number x, Number y) {
            return Numbers.divide(Numbers.toBigInteger(x), Numbers.toBigInteger(y));
        }

        public Number quotient(Number x, Number y) {
            return Numbers.toBigInteger(x).divide(Numbers.toBigInteger(y));
        }

        public Number remainder(Number x, Number y) {
            return Numbers.toBigInteger(x).remainder(Numbers.toBigInteger(y));
        }

        public boolean equiv(Number x, Number y) {
            return Numbers.toBigInteger(x).equals(Numbers.toBigInteger(y));
        }

        public boolean lt(Number x, Number y) {
            return Numbers.toBigInteger(x).compareTo(Numbers.toBigInteger(y)) < 0;
        }

        public final Number negate(Number x) {
            return Numbers.toBigInteger(x).negate();
        }

        public Number inc(Number x) {
            BigInteger bx = Numbers.toBigInteger(x);
            return Numbers.reduce(bx.add(BigInteger.ONE));
        }

        public Number dec(Number x) {
            BigInteger bx = Numbers.toBigInteger(x);
            return Numbers.reduce(bx.subtract(BigInteger.ONE));
        }
    }

    static final class RatioOps
    implements Ops {
        RatioOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return this;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        public boolean isZero(Number x) {
            Ratio r2 = (Ratio)x;
            return r2.numerator.signum() == 0;
        }

        public boolean isPos(Number x) {
            Ratio r2 = (Ratio)x;
            return r2.numerator.signum() > 0;
        }

        public boolean isNeg(Number x) {
            Ratio r2 = (Ratio)x;
            return r2.numerator.signum() < 0;
        }

        public final Number add(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            return this.divide(ry.numerator.multiply(rx.denominator).add(rx.numerator.multiply(ry.denominator)), ry.denominator.multiply(rx.denominator));
        }

        public final Number multiply(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            return Numbers.divide(ry.numerator.multiply(rx.numerator), ry.denominator.multiply(rx.denominator));
        }

        public Number divide(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            return Numbers.divide(ry.denominator.multiply(rx.numerator), ry.numerator.multiply(rx.denominator));
        }

        public Number quotient(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            BigInteger q = rx.numerator.multiply(ry.denominator).divide(rx.denominator.multiply(ry.numerator));
            return Numbers.reduce(q);
        }

        public Number remainder(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            BigInteger q = rx.numerator.multiply(ry.denominator).divide(rx.denominator.multiply(ry.numerator));
            return Numbers.minus((Object)x, (Object)Numbers.multiply((Object)q, (Object)y));
        }

        public boolean equiv(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            return rx.numerator.equals(ry.numerator) && rx.denominator.equals(ry.denominator);
        }

        public boolean lt(Number x, Number y) {
            Ratio rx = Numbers.toRatio(x);
            Ratio ry = Numbers.toRatio(y);
            return Numbers.lt((Object)rx.numerator.multiply(ry.denominator), (Object)ry.numerator.multiply(rx.denominator));
        }

        public final Number negate(Number x) {
            Ratio r2 = (Ratio)x;
            return new Ratio(r2.numerator.negate(), r2.denominator);
        }

        public Number inc(Number x) {
            return Numbers.add((Object)x, 1);
        }

        public Number dec(Number x) {
            return Numbers.add((Object)x, -1);
        }
    }

    static final class DoubleOps
    implements Ops {
        DoubleOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return this;
        }

        public final Ops opsWith(DoubleOps x) {
            return this;
        }

        public final Ops opsWith(RatioOps x) {
            return this;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        public boolean isZero(Number x) {
            return x.doubleValue() == 0.0;
        }

        public boolean isPos(Number x) {
            return x.doubleValue() > 0.0;
        }

        public boolean isNeg(Number x) {
            return x.doubleValue() < 0.0;
        }

        public final Number add(Number x, Number y) {
            return x.doubleValue() + y.doubleValue();
        }

        public final Number multiply(Number x, Number y) {
            return x.doubleValue() * y.doubleValue();
        }

        public Number divide(Number x, Number y) {
            return x.doubleValue() / y.doubleValue();
        }

        public Number quotient(Number x, Number y) {
            return Numbers.quotient(x.doubleValue(), y.doubleValue());
        }

        public Number remainder(Number x, Number y) {
            return Numbers.remainder(x.doubleValue(), y.doubleValue());
        }

        public boolean equiv(Number x, Number y) {
            return x.doubleValue() == y.doubleValue();
        }

        public boolean lt(Number x, Number y) {
            return x.doubleValue() < y.doubleValue();
        }

        public final Number negate(Number x) {
            return -x.doubleValue();
        }

        public Number inc(Number x) {
            return x.doubleValue() + 1.0;
        }

        public Number dec(Number x) {
            return x.doubleValue() - 1.0;
        }
    }

    static final class FloatOps
    implements Ops {
        FloatOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return this;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return this;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return this;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return this;
        }

        public boolean isZero(Number x) {
            return x.floatValue() == 0.0f;
        }

        public boolean isPos(Number x) {
            return x.floatValue() > 0.0f;
        }

        public boolean isNeg(Number x) {
            return x.floatValue() < 0.0f;
        }

        public final Number add(Number x, Number y) {
            return Float.valueOf(x.floatValue() + y.floatValue());
        }

        public final Number multiply(Number x, Number y) {
            return Float.valueOf(x.floatValue() * y.floatValue());
        }

        public Number divide(Number x, Number y) {
            return Float.valueOf(x.floatValue() / y.floatValue());
        }

        public Number quotient(Number x, Number y) {
            return Numbers.quotient(x.doubleValue(), y.doubleValue());
        }

        public Number remainder(Number x, Number y) {
            return Numbers.remainder(x.doubleValue(), y.doubleValue());
        }

        public boolean equiv(Number x, Number y) {
            return x.floatValue() == y.floatValue();
        }

        public boolean lt(Number x, Number y) {
            return x.floatValue() < y.floatValue();
        }

        public final Number negate(Number x) {
            return Float.valueOf(-x.floatValue());
        }

        public Number inc(Number x) {
            return Float.valueOf(x.floatValue() + 1.0f);
        }

        public Number dec(Number x) {
            return Float.valueOf(x.floatValue() - 1.0f);
        }
    }

    static final class LongOps
    implements Ops {
        LongOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return this;
        }

        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return RATIO_OPS;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return BIGINTEGER_OPS;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        public boolean isZero(Number x) {
            return x.longValue() == 0L;
        }

        public boolean isPos(Number x) {
            return x.longValue() > 0L;
        }

        public boolean isNeg(Number x) {
            return x.longValue() < 0L;
        }

        public final Number add(Number x, Number y) {
            long ly;
            long lx = x.longValue();
            long ret = lx + (ly = y.longValue());
            if ((ret ^ lx) < 0L && (ret ^ ly) < 0L) {
                return BIGINTEGER_OPS.add(x, y);
            }
            return ret;
        }

        public final Number multiply(Number x, Number y) {
            long lx = x.longValue();
            long ly = y.longValue();
            long ret = lx * ly;
            if (ly != 0L && ret / ly != lx) {
                return BIGINTEGER_OPS.multiply(x, y);
            }
            return ret;
        }

        static long gcd(long u, long v) {
            while (v != 0L) {
                long r2 = u % v;
                u = v;
                v = r2;
            }
            return u;
        }

        public Number divide(Number x, Number y) {
            long val2;
            long n = x.longValue();
            long gcd = LongOps.gcd(n, val2 = y.longValue());
            if (gcd == 0L) {
                return 0;
            }
            n /= gcd;
            long d = val2 / gcd;
            if (d == 1L) {
                return n;
            }
            if (d < 0L) {
                n = -n;
                d = -d;
            }
            return new Ratio(BigInteger.valueOf(n), BigInteger.valueOf(d));
        }

        public Number quotient(Number x, Number y) {
            return x.longValue() / y.longValue();
        }

        public Number remainder(Number x, Number y) {
            return x.longValue() % y.longValue();
        }

        public boolean equiv(Number x, Number y) {
            return x.longValue() == y.longValue();
        }

        public boolean lt(Number x, Number y) {
            return x.longValue() < y.longValue();
        }

        public final Number negate(Number x) {
            long val2 = x.longValue();
            if (val2 > Long.MIN_VALUE) {
                return -val2;
            }
            return BigInteger.valueOf(val2).negate();
        }

        public Number inc(Number x) {
            long val2 = x.longValue();
            if (val2 < Long.MAX_VALUE) {
                return val2 + 1L;
            }
            return BIGINTEGER_OPS.inc(x);
        }

        public Number dec(Number x) {
            long val2 = x.longValue();
            if (val2 > Long.MIN_VALUE) {
                return val2 - 1L;
            }
            return BIGINTEGER_OPS.dec(x);
        }
    }

    static final class IntegerOps
    implements Ops {
        IntegerOps() {
        }

        public Ops combine(Ops y) {
            return y.opsWith(this);
        }

        public final Ops opsWith(IntegerOps x) {
            return this;
        }

        public final Ops opsWith(LongOps x) {
            return LONG_OPS;
        }

        public final Ops opsWith(FloatOps x) {
            return FLOAT_OPS;
        }

        public final Ops opsWith(DoubleOps x) {
            return DOUBLE_OPS;
        }

        public final Ops opsWith(RatioOps x) {
            return RATIO_OPS;
        }

        public final Ops opsWith(BigIntegerOps x) {
            return BIGINTEGER_OPS;
        }

        public final Ops opsWith(BigDecimalOps x) {
            return BIGDECIMAL_OPS;
        }

        public boolean isZero(Number x) {
            return x.intValue() == 0;
        }

        public boolean isPos(Number x) {
            return x.intValue() > 0;
        }

        public boolean isNeg(Number x) {
            return x.intValue() < 0;
        }

        public final Number add(Number x, Number y) {
            long ret = x.longValue() + y.longValue();
            if (ret <= Integer.MAX_VALUE && ret >= Integer.MIN_VALUE) {
                return (int)ret;
            }
            return ret;
        }

        public final Number multiply(Number x, Number y) {
            long ret = x.longValue() * y.longValue();
            if (ret <= Integer.MAX_VALUE && ret >= Integer.MIN_VALUE) {
                return (int)ret;
            }
            return ret;
        }

        static int gcd(int u, int v) {
            while (v != 0) {
                int r2 = u % v;
                u = v;
                v = r2;
            }
            return u;
        }

        public Number divide(Number x, Number y) {
            int val2;
            int n = x.intValue();
            int gcd = IntegerOps.gcd(n, val2 = y.intValue());
            if (gcd == 0) {
                return 0;
            }
            n /= gcd;
            int d = val2 / gcd;
            if (d == 1) {
                return n;
            }
            if (d < 0) {
                n = -n;
                d = -d;
            }
            return new Ratio(BigInteger.valueOf(n), BigInteger.valueOf(d));
        }

        public Number quotient(Number x, Number y) {
            return x.intValue() / y.intValue();
        }

        public Number remainder(Number x, Number y) {
            return x.intValue() % y.intValue();
        }

        public boolean equiv(Number x, Number y) {
            return x.intValue() == y.intValue();
        }

        public boolean lt(Number x, Number y) {
            return x.intValue() < y.intValue();
        }

        public final Number negate(Number x) {
            int val2 = x.intValue();
            if (val2 > Integer.MIN_VALUE) {
                return -val2;
            }
            return -((long)val2);
        }

        public Number inc(Number x) {
            int val2 = x.intValue();
            if (val2 < Integer.MAX_VALUE) {
                return val2 + 1;
            }
            return (long)val2 + 1L;
        }

        public Number dec(Number x) {
            int val2 = x.intValue();
            if (val2 > Integer.MIN_VALUE) {
                return val2 - 1;
            }
            return (long)val2 - 1L;
        }
    }

    static interface BitOps {
        public BitOps combine(BitOps var1);

        public BitOps bitOpsWith(IntegerBitOps var1);

        public BitOps bitOpsWith(LongBitOps var1);

        public BitOps bitOpsWith(BigIntegerBitOps var1);

        public Number not(Number var1);

        public Number and(Number var1, Number var2);

        public Number or(Number var1, Number var2);

        public Number xor(Number var1, Number var2);

        public Number andNot(Number var1, Number var2);

        public Number clearBit(Number var1, int var2);

        public Number setBit(Number var1, int var2);

        public Number flipBit(Number var1, int var2);

        public boolean testBit(Number var1, int var2);

        public Number shiftLeft(Number var1, int var2);

        public Number shiftRight(Number var1, int var2);
    }

    static interface Ops {
        public Ops combine(Ops var1);

        public Ops opsWith(IntegerOps var1);

        public Ops opsWith(LongOps var1);

        public Ops opsWith(FloatOps var1);

        public Ops opsWith(DoubleOps var1);

        public Ops opsWith(RatioOps var1);

        public Ops opsWith(BigIntegerOps var1);

        public Ops opsWith(BigDecimalOps var1);

        public boolean isZero(Number var1);

        public boolean isPos(Number var1);

        public boolean isNeg(Number var1);

        public Number add(Number var1, Number var2);

        public Number multiply(Number var1, Number var2);

        public Number divide(Number var1, Number var2);

        public Number quotient(Number var1, Number var2);

        public Number remainder(Number var1, Number var2);

        public boolean equiv(Number var1, Number var2);

        public boolean lt(Number var1, Number var2);

        public Number negate(Number var1);

        public Number inc(Number var1);

        public Number dec(Number var1);
    }
}

