/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnFilter;
import ca.sqlpower.sql.ColumnNotDisplayableException;
import ca.sqlpower.sql.NoRowidException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class WebResultSet
implements Cloneable {
    private static final Logger logger = Logger.getLogger(WebResultSet.class);
    protected ResultSet rs;
    protected String sqlQuery;
    protected ColumnFilter[] columnFilter;
    protected List[] columnChoices;
    protected List[] columnMutexList;
    protected String[] columnLabel;
    protected String[] columnChoicesName;
    protected String[] columnDefaultChoice;
    protected String[] columnDefaultValue;
    protected boolean[] columnHasAny;
    protected boolean[] columnHasAll;
    protected int[] columnType;
    protected List[] columnHyperlinks;
    protected String[] columnHyperlinkStyle;
    protected int rowidColNo;
    public String tableTitle;
    public String emptyMessage;
    protected Integer independentColumn;
    protected boolean isAfterLast;

    public WebResultSet(ResultSet results, String query) throws SQLException {
        this.sqlQuery = query;
        this.applyResultSet(results);
        this.initMembers(this.rs.getMetaData().getColumnCount());
    }

    protected WebResultSet() {
    }

    protected void applyResultSet(ResultSet results) throws SQLException {
        this.applyResultSet(results, true);
    }

    protected void applyResultSet(ResultSet results, boolean closeOldRS) throws SQLException {
        if (closeOldRS && this.rs != null) {
            this.rs.close();
        }
        this.rs = results;
    }

    protected void initMembers(int cols) {
        this.columnFilter = new ColumnFilter[cols];
        this.columnChoices = new List[cols];
        this.columnMutexList = new List[cols];
        this.columnLabel = new String[cols];
        this.columnChoicesName = new String[cols];
        this.columnDefaultChoice = new String[cols];
        this.columnDefaultValue = new String[cols];
        this.columnHasAny = new boolean[cols];
        this.columnHasAll = new boolean[cols];
        this.columnType = new int[cols];
        this.columnHyperlinks = new List[cols];
        this.columnHyperlinkStyle = new String[cols];
        this.rowidColNo = 0;
        this.tableTitle = "";
        this.emptyMessage = "";
        this.independentColumn = null;
        this.isAfterLast = false;
    }

    public void setColumnHasAnyAll(int colNo, boolean has) {
        this.columnHasAny[colNo - 1] = has;
        this.columnHasAll[colNo - 1] = has;
    }

    public boolean getColumnHasAnyAll(int colNo) {
        return this.columnHasAny[colNo - 1] && this.columnHasAll[colNo - 1];
    }

    public void setColumnHasAny(int colNo, boolean has) {
        this.columnHasAny[colNo - 1] = has;
    }

    public boolean getColumnHasAny(int colNo) {
        return this.columnHasAny[colNo - 1];
    }

    public void setColumnHasAll(int colNo, boolean has) {
        this.columnHasAll[colNo - 1] = has;
    }

    public boolean getColumnHasAll(int colNo) {
        return this.columnHasAll[colNo - 1];
    }

    public void setColumnFilter(int colNo, ColumnFilter filter) {
        this.columnFilter[colNo - 1] = filter;
    }

    public ColumnFilter getColumnFilter(int colNo) {
        return this.columnFilter[colNo - 1];
    }

    public void setColumnChoicesList(int colNo, List choicesList) {
        this.columnChoices[colNo - 1] = choicesList;
    }

    public List getColumnChoicesList(int colNo) {
        return this.columnChoices[colNo - 1];
    }

    public void setColumnMutexList(int colNo, List mutexList) {
        this.columnMutexList[colNo - 1] = mutexList;
    }

    public List getColumnMutexList(int colNo) {
        return this.columnMutexList[colNo - 1];
    }

    public void setColumnLabel(int colNo, String label) {
        this.columnLabel[colNo - 1] = label;
    }

    public void setColumnChoicesName(int colNo, String choicesName) {
        this.columnChoicesName[colNo - 1] = choicesName;
    }

    public String getColumnChoicesName(int colNo) throws ColumnNotDisplayableException {
        if (colNo == this.rowidColNo) {
            throw new ColumnNotDisplayableException();
        }
        return this.columnChoicesName[colNo - 1];
    }

    public void setColumnDefaultChoice(int colNo, String defaultChoice) {
        this.columnDefaultChoice[colNo - 1] = defaultChoice;
    }

    public String getColumnDefaultChoice(int colNo) throws ColumnNotDisplayableException {
        if (colNo == this.rowidColNo) {
            throw new ColumnNotDisplayableException();
        }
        return this.columnDefaultChoice[colNo - 1];
    }

    public void setColumnDefaultValue(int colNo, String defaultValue) {
        this.columnDefaultValue[colNo - 1] = defaultValue;
    }

    public String getColumnDefaultValue(int colNo) {
        return this.columnDefaultValue[colNo - 1];
    }

    public void setShowFirstColumn(boolean flag) {
        if (flag) {
            this.setColumnType(1, 10);
        } else {
            this.setColumnType(1, 9);
            this.rowidColNo = 0;
        }
    }

    public boolean getShowFirstColumn() {
        return this.getColumnType(1) != 10;
    }

    public int getColumnType(int colNo) {
        return this.columnType[colNo - 1];
    }

    public void setColumnType(int colNo, int v) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting column " + colNo + " to type " + v));
        }
        if (v == 10) {
            if (this.rowidColNo > 0) {
                throw new IllegalStateException("A resultset can have only one ROWID column");
            }
            this.rowidColNo = colNo;
        }
        this.columnType[colNo - 1] = v;
    }

    public List getColumnHyperlinks(int colNo) {
        return this.columnHyperlinks[colNo - 1];
    }

    public void setColumnHyperlinks(int colNo, List links) {
        this.columnHyperlinks[colNo - 1] = links;
    }

    public void setColumnHyperlinkStyle(int colNo, String style) {
        this.columnHyperlinkStyle[colNo - 1] = style;
    }

    public String getColumnHyperlinkStyle(int colNo) {
        return this.columnHyperlinkStyle[colNo - 1];
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public String getColumnLabel(int colNo) throws SQLException, ColumnNotDisplayableException {
        if (colNo == this.rowidColNo) {
            throw new ColumnNotDisplayableException();
        }
        if (this.columnLabel[colNo - 1] != null) {
            return this.columnLabel[colNo - 1];
        }
        return this.rs.getMetaData().getColumnLabel(colNo);
    }

    public String getColumnName(int colNo) throws SQLException {
        return this.rs.getMetaData().getColumnLabel(colNo);
    }

    public String getRowid() throws SQLException, NoRowidException {
        if (this.rowidColNo > 0) {
            return this.rs.getString(this.rowidColNo);
        }
        throw new NoRowidException();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        int numCols = 0;
        try {
            numCols = this.getColumnCount();
        }
        catch (SQLException e) {
            sb.append("SQL Exception while getting column count!");
        }
        for (int i = 1; i <= numCols; ++i) {
            try {
                sb.append("Column ").append(i).append(": type ").append(this.getColumnType(i)).append(", label \"").append(this.getColumnLabel(i)).append("\"\n");
                continue;
            }
            catch (SQLException e) {
                sb.append("SQLException processing column!");
                continue;
            }
            catch (ColumnNotDisplayableException e) {
                sb.append("Column not displayable!");
            }
        }
        return sb.toString();
    }

    public String getTableTitle() {
        return this.tableTitle;
    }

    public void setTableTitle(String title) {
        this.tableTitle = title;
    }

    public String getEmptyMessage() {
        return this.emptyMessage;
    }

    public void setEmptyMessage(String message) {
        this.emptyMessage = message;
    }

    public int getIndependentColNo() {
        if (this.independentColumn == null) {
            throw new IllegalStateException("no independent column was specified.");
        }
        return this.independentColumn;
    }

    public void setIndependentColNo(int argIndependentColumn) {
        this.independentColumn = new Integer(argIndependentColumn);
    }

    public String getIndependentField() throws SQLException, IllegalStateException {
        return this.getString(this.getIndependentColNo());
    }

    public boolean next() throws SQLException {
        boolean hasMoreRows = this.rs.next();
        if (!hasMoreRows) {
            this.isAfterLast = true;
        }
        return hasMoreRows;
    }

    public String getString(String colName) throws SQLException {
        return this.rs.getString(colName);
    }

    public String getString(int colNo) throws SQLException {
        if (this.columnFilter[colNo - 1] != null) {
            return this.columnFilter[colNo - 1].filter(this.rs.getString(colNo));
        }
        return this.rs.getString(colNo);
    }

    public Object getObject(int colNo) throws SQLException {
        return this.rs.getObject(colNo);
    }

    public Object getObject(String colName) throws SQLException {
        return this.rs.getObject(colName);
    }

    public Double getDouble(String colName) throws SQLException {
        double val = this.rs.getDouble(colName);
        if (this.rs.wasNull()) {
            return null;
        }
        return new Double(val);
    }

    public Double getDouble(int colNo) throws SQLException {
        double val = this.rs.getDouble(colNo);
        if (this.rs.wasNull()) {
            return null;
        }
        return new Double(val);
    }

    public java.sql.Date getDate(int colNo) throws SQLException {
        String dateStr = this.rs.getString(colNo);
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateStr.substring(0, 10));
        }
        catch (ParseException e) {
            throw new SQLException("invalid date format in column " + colNo);
        }
        return new java.sql.Date(date.getTime());
    }

    public Timestamp getTimestamp(int colNo) throws SQLException {
        return this.rs.getTimestamp(colNo);
    }

    public float getFloat(int colNo) throws SQLException {
        return this.rs.getFloat(colNo);
    }

    public int getInt(int colNo) throws SQLException {
        return this.rs.getInt(colNo);
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    public void close() throws SQLException {
        this.rs.getStatement().close();
    }

    public ResultSetMetaData getRsmd() throws SQLException {
        return this.rs.getMetaData();
    }
}

