/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.PostgreSQLTypeConverter;
import ca.sqlpower.sql.SQLServerTypeConverter;
import java.sql.Connection;

public abstract class SqlTypeConverter {
    public static SqlTypeConverter getInstance(Connection con) {
        if (con.getClass().getName().indexOf("postgresql") >= 0) {
            return new PostgreSQLTypeConverter();
        }
        if (con.getClass().getName().indexOf("SQLServer") >= 0) {
            return new SQLServerTypeConverter();
        }
        throw new UnsupportedOperationException("Unknown database type for driver " + con.getClass().getName());
    }

    public String convertType(int sqlType, int precision, int scale) {
        switch (sqlType) {
            case 1: {
                return "CHARACTER(" + precision + ")";
            }
            case 91: {
                return "DATE";
            }
            case -6: 
            case 3: 
            case 4: 
            case 5: {
                return "DECIMAL(" + precision + ")";
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return "NUMBER(" + precision + "," + scale + ")";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 12: {
                return "VARCHAR(" + precision + ")";
            }
        }
        throw new UnsupportedOperationException("SQL Type " + sqlType + " is not implemented for this database.");
    }
}

