/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.action.ProgressAction;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilePanelAction
extends ProgressAction {
    private static final Logger logger = Logger.getLogger(ProfilePanelAction.class);
    protected DBTree dbTree;
    protected TableProfileManager profileManager;
    private JDialog dialog;

    public ProfilePanelAction() {
        super("Profile...", ASUtils.createJLFIcon("general/Information", "Information", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Profile Tables");
    }

    private void profileItemsFromDBTree(ProgressAction.ActionMonitor monitor) {
        if (this.dbTree == null) {
            logger.debug((Object)"dbtree was null when actionPerformed called");
            return;
        }
        if (this.dbTree.getSelectionPaths() == null) {
            JOptionPane.showMessageDialog(this.dialog, "Please select table(s) in the Database Tree to profile them", "No selection", 1);
            return;
        }
        TreePath targetDBPath = this.dbTree.getPathForRow(0);
        for (TreePath path : this.dbTree.getSelectionPaths()) {
            if (monitor.isCancelled()) {
                logger.debug((Object)"Profile load canceled");
                return;
            }
            if (!path.isDescendant(targetDBPath)) continue;
            int answer = JOptionPane.showConfirmDialog(this.dialog, "Cannot perform profiling on the project database.\nDo you want to continue profiling?", "Continue Profiling", 2);
            if (answer != 2) break;
            return;
        }
        logger.debug((Object)("dbTree.getSelectionPaths() # = " + this.dbTree.getSelectionPaths().length));
        try {
            HashSet<SQLObject> sqlObject = new HashSet<SQLObject>();
            for (TreePath tp : this.dbTree.getSelectionPaths()) {
                SQLDatabase db;
                SQLCatalog cat;
                SQLSchema sch;
                SQLTable tab;
                if (monitor.isCancelled()) {
                    logger.debug((Object)"Profile load canceled");
                    return;
                }
                logger.debug((Object)("Top of first loop, treepath=" + tp));
                if (tp.isDescendant(targetDBPath)) continue;
                if (tp.getLastPathComponent() instanceof SQLDatabase) {
                    sqlObject.add((SQLDatabase)tp.getLastPathComponent());
                    continue;
                }
                if (tp.getLastPathComponent() instanceof SQLCatalog) {
                    SQLCatalog cat2 = (SQLCatalog)tp.getLastPathComponent();
                    sqlObject.add(cat2);
                    SQLDatabase db2 = ArchitectUtils.getAncestor(cat2, SQLDatabase.class);
                    if (db2 == null || !sqlObject.contains(db2)) continue;
                    sqlObject.remove(db2);
                    continue;
                }
                if (tp.getLastPathComponent() instanceof SQLSchema) {
                    SQLDatabase db3;
                    SQLSchema sch2 = (SQLSchema)tp.getLastPathComponent();
                    sqlObject.add(sch2);
                    SQLCatalog cat3 = ArchitectUtils.getAncestor(sch2, SQLCatalog.class);
                    if (cat3 != null && sqlObject.contains(cat3)) {
                        sqlObject.remove(cat3);
                    }
                    if ((db3 = ArchitectUtils.getAncestor(sch2, SQLDatabase.class)) == null || !sqlObject.contains(db3)) continue;
                    sqlObject.remove(db3);
                    continue;
                }
                if (tp.getLastPathComponent() instanceof SQLTable) {
                    tab = (SQLTable)tp.getLastPathComponent();
                    sqlObject.add(tab);
                    sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                    if (sch != null && sqlObject.contains(sch)) {
                        sqlObject.remove(sch);
                    }
                    if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                        sqlObject.remove(cat);
                    }
                    if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) == null || !sqlObject.contains(db)) continue;
                    sqlObject.remove(db);
                    continue;
                }
                if (tp.getLastPathComponent() instanceof SQLTable.Folder) {
                    tab = ArchitectUtils.getAncestor((SQLTable.Folder)tp.getLastPathComponent(), SQLTable.class);
                    sqlObject.add(tab);
                    sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                    if (sch != null && sqlObject.contains(sch)) {
                        sqlObject.remove(sch);
                    }
                    if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                        sqlObject.remove(cat);
                    }
                    if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) == null || !sqlObject.contains(db)) continue;
                    sqlObject.remove(db);
                    continue;
                }
                if (!(tp.getLastPathComponent() instanceof SQLColumn)) continue;
                tab = ((SQLColumn)tp.getLastPathComponent()).getParentTable();
                sqlObject.add((SQLColumn)tp.getLastPathComponent());
                sch = ArchitectUtils.getAncestor(tab, SQLSchema.class);
                if (sch != null && sqlObject.contains(sch)) {
                    sqlObject.remove(sch);
                }
                if ((cat = ArchitectUtils.getAncestor(sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                    sqlObject.remove(cat);
                }
                if ((db = ArchitectUtils.getAncestor(sch, SQLDatabase.class)) == null || !sqlObject.contains(db)) continue;
                sqlObject.remove(db);
            }
            monitor.setJobSize(sqlObject.size());
            HashSet<SQLTable> tables = new HashSet<SQLTable>();
            for (SQLObject o : sqlObject) {
                if (monitor.isCancelled()) {
                    logger.debug((Object)"Profile load canceled");
                    return;
                }
                if (o instanceof SQLColumn) {
                    tables.add(((SQLColumn)o).getParentTable());
                } else {
                    tables.addAll(ArchitectUtils.tablesUnder(o));
                }
                monitor.setProgress(monitor.getProgress() + 1);
            }
            logger.debug((Object)"Calling profileManager.asynchCreateProfiles(tables)");
            this.profileManager.asynchCreateProfiles(tables);
            JDialog profileDialog = ArchitectFrame.getMainInstance().getProject().getProfileDialog();
            profileDialog.pack();
            profileDialog.setVisible(true);
        }
        catch (Exception ex) {
            logger.error((Object)"Error in Profile Action ", (Throwable)ex);
            ASUtils.showExceptionDialog(this.dbTree, "Error during profile run", ex, new ArchitectExceptionReportFactory());
        }
    }

    public void setDBTree(DBTree dbTree) {
        this.dbTree = dbTree;
    }

    public TableProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void setProfileManager(TableProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public String getDialogMessage() {
        return "Preparing Profiles:";
    }

    @Override
    public void cleanUp(ProgressAction.ActionMonitor monitor) {
    }

    @Override
    public void doStuff(ProgressAction.ActionMonitor monitor, Map<String, Object> properties) {
        monitor.setStarted(true);
        this.profileItemsFromDBTree(monitor);
        monitor.setFinished(true);
    }

    @Override
    public void setup(ProgressAction.ActionMonitor monitor, Map<String, Object> properties) {
    }

    @Override
    public String getButtonText() {
        return "Cancel";
    }
}

