/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DBTreeNode
implements MutableTreeNode {
    private static final Logger logger = Logger.getLogger(DBTreeNode.class);
    protected static Map userObjectToTreeNodeMap = new HashMap();
    public SQLObject userObject;
    protected TreeNode parent;

    public DBTreeNode(SQLObject userObject) {
        DBTreeNode parent = (DBTreeNode)userObjectToTreeNodeMap.get(userObject.getParent());
        this.setup(userObject, parent);
    }

    public DBTreeNode(SQLObject userObject, TreeNode parent) {
        if (parent instanceof SQLObject) {
            throw new IllegalArgumentException("Don't use DBTreeNode(SQLObject,Object) to add a node with a SQLObject as its parent; use DBTreeNode(SQLObject) instead.");
        }
        this.setup(userObject, parent);
    }

    protected void setup(SQLObject userObject, TreeNode parent) {
        this.userObject = userObject;
        userObjectToTreeNodeMap.put(userObject, this);
        this.parent = parent;
    }

    public boolean getAllowsChildren() {
        return this.userObject.allowsChildren();
    }

    public TreeNode getChildAt(int i) {
        try {
            DBTreeNode child = (DBTreeNode)userObjectToTreeNodeMap.get(this.userObject.getChild(i));
            if (child == null) {
                child = new DBTreeNode(this.userObject.getChild(i));
            }
            return child;
        }
        catch (ArchitectException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getChildCount() {
        try {
            int count = this.userObject.getChildren().size();
            return count;
        }
        catch (ArchitectException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getIndex(TreeNode node) {
        try {
            return this.userObject.getChildren().indexOf(((DBTreeNode)node).userObject);
        }
        catch (ArchitectException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return !this.userObject.allowsChildren();
    }

    public String toString() {
        return this.userObject.getShortDisplayName();
    }

    public Enumeration children() {
        return new TreeNodeEnumeration(this.userObject);
    }

    public SQLObject getSQLObject() {
        return this.userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void insert(MutableTreeNode child, int index) {
        if (child instanceof DBTreeNode) {
            try {
                this.userObject.addChild(index, ((DBTreeNode)child).getSQLObject());
            }
            catch (ArchitectException e) {
                logger.error((Object)("Couldn't add \"" + child.toString() + "\" to tree:"), (Throwable)e);
                JOptionPane.showMessageDialog(null, "Failed to add child:\n" + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("You can't add a non-DBTreeNode to a DBTreeNode");
        }
        child.setParent(this);
    }

    public void remove(int index) {
        SQLObject gone = this.userObject.removeChild(index);
        userObjectToTreeNodeMap.remove(gone);
    }

    public void remove(MutableTreeNode node) {
        SQLObject gone = ((DBTreeNode)node).userObject;
        this.userObject.removeChild(gone);
        userObjectToTreeNodeMap.remove(gone);
    }

    public void removeFromParent() throws UnsupportedOperationException {
        if (this.parent == null) {
            return;
        }
        if (!(this.parent instanceof MutableTreeNode)) {
            throw new UnsupportedOperationException("Can't remove this node from immuable TreeNode parent.");
        }
        ((MutableTreeNode)this.parent).remove(this);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    public void setUserObject(Object newSQLObject) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public class TreeNodeEnumeration
    implements Enumeration {
        protected Iterator children;

        public TreeNodeEnumeration(SQLObject parent) {
            try {
                this.children = parent.getChildren().iterator();
            }
            catch (ArchitectException e) {
                e.printStackTrace();
                this.children = Collections.EMPTY_LIST.iterator();
            }
        }

        public boolean hasMoreElements() {
            return this.children.hasNext();
        }

        public Object nextElement() {
            Object next = userObjectToTreeNodeMap.get(this.children.next());
            if (next == null) {
                throw new NullPointerException("Woops, null tree node");
            }
            return next;
        }
    }
}

