plot.ts                package:stats                R Documentation

_P_l_o_t_t_i_n_g _T_i_m_e-_S_e_r_i_e_s _O_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plotting method for objects inheriting from class '"ts"'.

_U_s_a_g_e:

     ## S3 method for class 'ts':
     plot(x, y = NULL, plot.type = c("multiple", "single"),
             xy.labels, xy.lines, panel = lines, nc, yax.flip = FALSE,
             mar.multi = c(0, 5.1, 0, if(yax.flip) 5.1 else 2.1),
             oma.multi = c(6, 0, 5, 0), axes = TRUE, ...)

     ## S3 method for class 'ts':
     lines(x, ...)

_A_r_g_u_m_e_n_t_s:

    x, y: time series objects, usually inheriting from class '"ts"'.

plot.type: for multivariate time series, should the series by plotted
          separately (with a common time axis) or on a single plot?

xy.labels: logical, indicating if 'text()' labels should be used for an
          x-y plot, _or_ character, supplying a vector of labels to be
          used.  The default is to label for up to 150 points, and not
          for more.

xy.lines: logical, indicating if 'lines' should be drawn for an x-y
          plot.  Defaults to the value of 'xy.labels' if that is
          logical, otherwise to 'TRUE'.

   panel: a 'function(x, col, bg, pch, type, ...)' which gives the
          action to be carried out in each panel of the display for
          'plot.type="multiple"'.  The default is 'lines'.

      nc: the number of columns to use when 'type="multiple"'. Defaults
          to 1 for up to 4 series, otherwise to 2.

yax.flip: logical indicating if the y-axis (ticks and numbering) should
          flip from side 2 (left) to 4 (right) from series to series
          when 'type="multiple"'.

mar.multi, oma.multi: the (default) 'par' settings for
          'plot.type="multiple"'.  Modify with care!

    axes: logical indicating if x- and y- axes should be drawn.

     ...: additional graphical arguments, see 'plot', 'plot.default'
          and 'par'.

_D_e_t_a_i_l_s:

     If 'y' is missing, this function creates a time series plot, for
     multivariate series of one of two kinds depending on 'plot.type'.

     If 'y' is present, both 'x' and 'y' must be univariate, and a
     scatter plot 'y ~ x' will be drawn, enhanced by using 'text' if
     'xy.labels' is 'TRUE' or 'character', and 'lines' if 'xy.lines' is
     'TRUE'.

_S_e_e _A_l_s_o:

     'ts' for basic time series construction and access functionality.

_E_x_a_m_p_l_e_s:

     require(graphics)

     ## Multivariate
     z <- ts(matrix(rt(200 * 8, df = 3), 200, 8),
             start = c(1961, 1), frequency = 12)
     plot(z, yax.flip = TRUE)
     plot(z, axes = FALSE, ann = FALSE, frame.plot = TRUE,
          mar.multi = c(0,0,0,0), oma.multi = c(1,1,5,1))
     title("plot(ts(..), axes=FALSE, ann=FALSE, frame.plot=TRUE, mar..., oma...)")

     z <- window(z[,1:3], end = c(1969,12))
     plot(z, type = "b")    # multiple
     plot(z, plot.type="single", lty=1:3, col=4:2)

     ## A phase plot:
     plot(nhtemp, c(nhtemp[-1], NA), cex = .8, col="blue",
          main = "Lag plot of New Haven temperatures")
     ## a clearer way to do this would be
     ## Not run: 
     plot(nhtemp, lag(nhtemp, 1), cex = .8, col="blue",
          main = "Lag plot of New Haven temperatures")
     ## End(Not run)

     ## xy.lines and xy.labels are FALSE for large series:
     plot(lag(sunspots, 1), sunspots, pch = ".")

     SMI <- EuStockMarkets[, "SMI"]
     plot(lag(SMI,  1), SMI, pch = ".")
     plot(lag(SMI, 20), SMI, pch = ".", log = "xy",
          main = "4 weeks lagged SMI stocks -- log scale", xy.lines= TRUE)

