#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.06';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkII_2',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::LensInfo',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::UnknownInfo',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 75 => 0x69 },
	'about' => { 281 => 'about' },
	'abspeakaudiofilepath' => { 287 => 'absPeakAudioFilePath' },
	'accessorytype' => { 213 => 0x53 },
	'actionadvised' => { 86 => 0x2a },
	'activearea' => { 80 => 0xc68d },
	'actived-lighting' => { 153 => 0x22, 179 => 0x24 },
	'actived-lightingmode' => { 179 => 0x25 },
	'addaspectratioinfo' => { 56 => 0x80e },
	'additionalmodelinformation' => { 274 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 56 => 0x80f, 57 => 0x11, 58 => 0x13, 61 => 0x14 },
	'address' => { 112 => 'Address' },
	'adjustmentmode' => { 253 => 0x15 },
	'adultcontentwarning' => { 277 => 'AdultContentWarning', 280 => 'adultContentWarning' },
	'advancedraw' => { 181 => 0x76a43203 },
	'advancedscenemode' => { 213 => 0x3d },
	'advisory' => { 285 => 'Advisory' },
	'ae_iso' => { 216 => 0x2 },
	'aeaperture' => { 216 => 0x1 },
	'aebautocancel' => { 56 => 0x104 },
	'aebbracketvalue' => { 51 => 0x11 },
	'aebsequence' => { 56 => 0x105 },
	'aebsequenceautocancel' => { 54 => 0x9, 55 => 0x9, 57 => 0x8, 58 => 0x9, 61 => 0x9, 62 => 0x7 },
	'aebshotcount' => { 56 => 0x106 },
	'aebxv' => { 216 => 0x4 },
	'aeexposuretime' => { 216 => 0x0 },
	'aeextra' => { 216 => 0x7 },
	'aelbutton' => { 128 => 0x45 },
	'aelexposureindicator' => { 128 => 0x51 },
	'aelock' => { 128 => 0x5b, 189 => '4.2', 191 => '4.2', 193 => 0x201, 234 => 0x48 },
	'aelockbutton' => { 188 => '16.1', 189 => '4.1', 190 => '15.1', 191 => '4.1', 192 => '17.1' },
	'aelockbuttonplusdials' => { 188 => '16.2' },
	'aelockformb-d80' => { 192 => '3.1' },
	'aemaxaperture' => { 216 => 0x9 },
	'aemaxaperture2' => { 216 => 0xa },
	'aemeteringmode' => { 216 => 0xc },
	'aemeteringsegments' => { 234 => 0x209 },
	'aemicroadjustment' => { 56 => 0x111 },
	'aeminaperture' => { 216 => 0xb },
	'aeminexposuretime' => { 216 => 0x5 },
	'aeprogrammode' => { 216 => 0x6 },
	'aesetting' => { 24 => 0x21 },
	'aexv' => { 216 => 0x3 },
	'af-cpriorityselection' => { 188 => '1.1' },
	'af-onformb-d10' => { 188 => '3.3' },
	'af-spriorityselection' => { 188 => '1.2' },
	'afactivation' => { 188 => '2.1' },
	'afadjustment' => { 234 => 0x72 },
	'afandmeteringbuttons' => { 56 => 0x701 },
	'afaperture' => { 151 => 0x5, 152 => 0x5 },
	'afareaheight' => { 135 => 0x1a },
	'afareaillumination' => { 128 => 0x4b, 191 => '15.3' },
	'afareamode' => { 128 => 0xe, 134 => 0x0, 135 => 0x5, 213 => 0xf, 254 => 0x11, 255 => 0x11 },
	'afareamodesetting' => { 189 => '11.1', 190 => '0.1', 191 => '16.1', 192 => '2.1' },
	'afareas' => { 193 => 0x304 },
	'afareawidth' => { 135 => 0x18 },
	'afareaxposition' => { 135 => 0x14 },
	'afareayposition' => { 135 => 0x16 },
	'afassist' => { 54 => 0x5, 62 => 0x5, 128 => 0x48, 188 => '2.5', 189 => '0.2', 190 => '0.2', 191 => '0.2', 192 => '2.3' },
	'afassistbeam' => { 56 => 0x50e, 57 => 0x4, 58 => 0x5, 59 => 0x4, 60 => 0x4, 61 => 0x5 },
	'afassistlamp' => { 213 => 0x31 },
	'afdefocus' => { 217 => 0x6 },
	'afduringliveview' => { 56 => 0x511 },
	'affinetune' => { 136 => 0x0 },
	'affinetuneadj' => { 136 => 0x2, 161 => 0x2d1, 162 => 0x2dc, 193 => 0x307 },
	'affinetuneindex' => { 136 => 0x1 },
	'afilluminator' => { 254 => 0x29, 257 => 0xb044 },
	'afimageheight' => { 135 => 0x12 },
	'afimagewidth' => { 135 => 0x10 },
	'afintegrationtime' => { 217 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 56 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 77 => 0x3009, 253 => 0x5, 257 => 0xb043 },
	'afonaelockbuttonswitch' => { 56 => 0x702 },
	'afonbutton' => { 188 => '3.1' },
	'afpoint' => { 24 => 0x13, 76 => 0x18, 134 => 0x1, 196 => 0x308, 253 => 0x1f },
	'afpointactivationarea' => { 55 => 0x11, 61 => 0x11 },
	'afpointareaexpansion' => { 56 => 0x508 },
	'afpointautoselection' => { 56 => 0x50b },
	'afpointbrightness' => { 56 => 0x50d, 188 => '2.4' },
	'afpointdisplayduringfocus' => { 56 => 0x50c },
	'afpointillumination' => { 55 => 0xa, 188 => '2.3', 192 => '2.4' },
	'afpointmode' => { 221 => 0x3 },
	'afpointposition' => { 77 => 0x2021, 213 => 0x4d },
	'afpointregistration' => { 54 => 0x7 },
	'afpoints' => { 127 => 0x10 },
	'afpointselected' => { 193 => 0x305, 234 => 0xe },
	'afpointselected2' => { 221 => 0x4 },
	'afpointselection' => { 55 => 0xb, 188 => '1.3' },
	'afpointselectionmethod' => { 56 => 0x50f, 57 => 0xc, 58 => 0xd, 61 => 0xd },
	'afpointsinfocus' => { 51 => 0xe, 134 => 0x2, 217 => 0xb, 234 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 15 => 0x38 },
	'afpointspotmetering' => { 55 => 0xd },
	'afpointsunknown1' => { 217 => 0x0 },
	'afpointsunknown2' => { 217 => 0x2 },
	'afpointsused' => { 135 => 0x8 },
	'afpredictor' => { 217 => 0x4 },
	'afresponse' => { 153 => 0xad },
	'afresult' => { 198 => 0x1038 },
	'afsearch' => { 193 => 0x303 },
	'afwithshutter' => { 254 => 0x2a },
	'aggregationtype' => { 278 => 'aggregationType' },
	'agreement' => { 280 => 'agreement' },
	'aiservocontinuousshooting' => { 55 => 0x15 },
	'aiservoimagepriority' => { 56 => 0x503 },
	'aiservotrackingmethod' => { 56 => 0x504 },
	'aiservotrackingsensitivity' => { 55 => 0x14, 56 => 0x502 },
	'album' => { 287 => 'album' },
	'alreadyapplied' => { 268 => 'AlreadyApplied' },
	'alternatetitle' => { 278 => 'alternateTitle' },
	'alttapename' => { 287 => 'altTapeName' },
	'alttimecodetimeformat' => { 287 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 287 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 287 => 'altTimecodeValue' },
	'ambienceselection' => { 2 => 0x1 },
	'analogbalance' => { 80 => 0xc627 },
	'angleadj' => { 75 => 0x8b },
	'anti-blur' => { 257 => 0xb04b },
	'antialiasstrength' => { 80 => 0xc632 },
	'aperturerange' => { 56 => 0x10d },
	'apertureringuse' => { 221 => '1.4' },
	'aperturevalue' => { 65 => 0x2, 80 => 0x9202, 198 => 0x1002, 272 => 'ApertureValue' },
	'applekeywords' => { 202 => 'AAPL:Keywords' },
	'applicationnotes' => { 80 => 0x2bc, 215 => 0x2bc },
	'applicationrecordversion' => { 86 => 0x0 },
	'applyshootingmeteringmode' => { 56 => 0x10e },
	'approximatefnumber' => { 208 => 0x313, 214 => 0x3406 },
	'armidentifier' => { 87 => 0x78 },
	'armversion' => { 87 => 0x7a },
	'artfilter' => { 193 => 0x529 },
	'artist' => { 80 => 0x13b, 204 => 'Artist', 234 => 0x22e, 283 => 'Artist', 287 => 'artist' },
	'artworkcopyrightnotice' => { 274 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 274 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 274 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 274 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 274 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 274 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 197 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 197 => 0x1112, 254 => 0x55 },
	'asshoticcprofile' => { 80 => 0xc68f },
	'asshotneutral' => { 80 => 0xc628 },
	'asshotpreprofilematrix' => { 80 => 0xc690 },
	'asshotprofilename' => { 80 => 0xc6f6 },
	'asshotwhitexy' => { 80 => 0xc629 },
	'assignbktbutton' => { 188 => '4.2' },
	'assignfuncbutton' => { 56 => 0x70b },
	'assistbuttonfunction' => { 54 => 0xd },
	'attributionname' => { 267 => 'attributionName' },
	'attributionurl' => { 267 => 'attributionURL' },
	'audio' => { 213 => 0x20 },
	'audiobitrate' => { 43 => 0x6c },
	'audiochannels' => { 43 => 0x70 },
	'audiochanneltype' => { 287 => 'audioChannelType' },
	'audiocompression' => { 106 => 'Compression' },
	'audiocompressor' => { 287 => 'audioCompressor' },
	'audioduration' => { 86 => 0x99 },
	'audiomoddate' => { 287 => 'audioModDate' },
	'audiooutcue' => { 86 => 0x9a },
	'audiosamplerate' => { 43 => 0x6e, 287 => 'audioSampleRate' },
	'audiosampletype' => { 287 => 'audioSampleType' },
	'audiosamplingrate' => { 86 => 0x97 },
	'audiosamplingresolution' => { 86 => 0x98 },
	'audiotype' => { 86 => 0x96 },
	'author' => { 108 => 'Author', 202 => 'Author', 204 => 'Author', 245 => 'Author', 265 => 'author', 275 => 'Author' },
	'authorsposition' => { 276 => 'AuthorsPosition' },
	'autoaperture' => { 228 => '0.1' },
	'autobracket' => { 253 => 0x19 },
	'autobracketing' => { 84 => 0x1100, 234 => 0x18 },
	'autobracketmodem' => { 188 => '21.2' },
	'autobracketorder' => { 128 => 0x43, 188 => '21.3', 191 => '2.2', 192 => '13.2' },
	'autobracketset' => { 188 => '21.1', 190 => '11.1', 191 => '2.1', 192 => '13.1' },
	'autobrightness' => { 268 => 'AutoBrightness' },
	'autocontrast' => { 268 => 'AutoContrast' },
	'autodistortioncontrol' => { 143 => 0x4 },
	'autodynamicrange' => { 84 => 0x140b },
	'autoexposure' => { 268 => 'AutoExposure' },
	'autoexposurebracketing' => { 51 => 0x10 },
	'autofocus' => { 196 => 0x209 },
	'autofp' => { 191 => '7.3', 192 => '31.4' },
	'autoiso' => { 51 => 0x1, 77 => 0x3008, 189 => '1.1', 191 => '1.1' },
	'autoisomax' => { 189 => '1.2', 191 => '1.2' },
	'autoisominshutterspeed' => { 189 => '1.3', 191 => '1.3' },
	'autolightingoptimizer' => { 12 => 0xbe, 13 => 0xbf, 16 => 0xbf, 39 => 0x2, 56 => 0x204, 75 => 0x6f },
	'autolightingoptimizeron' => { 75 => 0x6e },
	'autoredeye' => { 181 => 0xfe28a44f },
	'autorotate' => { 51 => 0x1b },
	'autoshadows' => { 268 => 'AutoShadows' },
	'auxiliarylens' => { 153 => 0x82 },
	'avaperturesetting' => { 221 => 0x13 },
	'avsettingwithoutlens' => { 56 => 0x707 },
	'azimuth' => { 116 => 'Azimuth' },
	'babyage' => { 213 => [0x8010,0x33] },
	'babyname' => { 213 => 0x66 },
	'backgroundalpha' => { 282 => 'bgalpha' },
	'baseexposurecompensation' => { 221 => 0x15 },
	'baseiso' => { 51 => 0x2, 69 => 0x101c, 214 => 0x312a },
	'baselineexposure' => { 80 => 0xc62a },
	'baselinenoise' => { 80 => 0xc62b },
	'baselinesharpness' => { 80 => 0xc62c },
	'baseurl' => { 285 => 'BaseURL' },
	'batterylevel' => { 128 => 0x60 },
	'batteryorder' => { 188 => '12.5' },
	'bayergreensplit' => { 80 => 0xc62d },
	'bayerpattern' => { 90 => 0xf902, 131 => 0x17 },
	'beatspliceparamsriseindecibel' => { 287 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 287 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 287 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 287 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 188 => '13.1', 189 => '0.1', 190 => '2.1', 191 => '0.1', 192 => '4.1' },
	'bestqualityscale' => { 80 => 0xc65c },
	'bestshotmode' => { 77 => 0x3007 },
	'bitdepth' => { 113 => 'BitDepth', 131 => 0x11, 158 => 0x41 },
	'bitspercomponent' => { 88 => 0x87 },
	'bitspersample' => { 80 => 0x102, 283 => 'BitsPerSample' },
	'blacklevel' => { 80 => 0xc61a, 198 => 0x1012 },
	'blacklevel2' => { 197 => 0x600, 201 => 0x600 },
	'blacklevelrepeatdim' => { 80 => 0xc619 },
	'blackpoint' => { 234 => 0x200 },
	'bleachbypasstoning' => { 234 => 0x7f },
	'bluebalance' => { 142 => 0x271, 198 => 0x1018, 215 => 0x12, 234 => 0x1b },
	'bluecurvelimits' => { 74 => 0x1fe },
	'bluecurvepoints' => { 74 => 0x1d4 },
	'bluehue' => { 268 => 'BlueHue' },
	'bluesaturation' => { 268 => 'BlueSaturation' },
	'blurwarning' => { 84 => 0x1300 },
	'bodybatteryadload' => { 219 => 0x3 },
	'bodybatteryadnoload' => { 219 => 0x2 },
	'bodybatterystate' => { 219 => '1.1' },
	'bodybatteryvoltage1' => { 219 => 0x2 },
	'bodybatteryvoltage2' => { 219 => 0x4 },
	'bodybatteryvoltage3' => { 219 => 0x6 },
	'bodybatteryvoltage4' => { 219 => 0x8 },
	'bodyfirmware' => { 248 => 0x0 },
	'bodyfirmwareversion' => { 194 => 0x104, 195 => 0x100, 198 => 0x104 },
	'bodyserialnumber' => { 248 => 0x10 },
	'bracketmode' => { 35 => 0x3 },
	'bracketsequence' => { 77 => 0x301d },
	'bracketshotnumber' => { 35 => 0x5, 221 => 0x9 },
	'bracketstep' => { 125 => 0xe },
	'bracketvalue' => { 35 => 0x4 },
	'brightness' => { 80 => 0xfe53, 107 => 'Brightness', 125 => 0x2c, 155 => 0x34, 254 => 0x22, 268 => 'Brightness' },
	'brightnessadj' => { 74 => 0x114, 174 => 0x0, 184 => 0x2d, 260 => 0x8018 },
	'brightnessvalue' => { 80 => 0x9203, 198 => 0x1003, 272 => 'BrightnessValue' },
	'bulbduration' => { 51 => 0x18 },
	'burstmode' => { 93 => 0xa, 213 => 0x2a },
	'burstmode2' => { 93 => 0x18 },
	'burstshot' => { 253 => 0x34 },
	'buttonfunctioncontroloff' => { 56 => 0x70a },
	'bwfilter' => { 125 => 0x2a, 132 => 0x39 },
	'bwmode' => { 198 => 0x203 },
	'by-line' => { 86 => 0x50 },
	'by-linetitle' => { 86 => 0x55 },
	'bytecount' => { 278 => 'byteCount' },
	'calibration' => { 253 => 0x24 },
	'calibrationilluminant1' => { 80 => 0xc65a },
	'calibrationilluminant2' => { 80 => 0xc65b },
	'cameraangle' => { 287 => 'cameraAngle' },
	'cameracalibration1' => { 80 => 0xc623 },
	'cameracalibration2' => { 80 => 0xc624 },
	'cameracalibrationsig' => { 80 => 0xc6f3 },
	'cameracolorcalibration01' => { 26 => 0x4b, 27 => 0xa4, 28 => 0x85, 29 => 0xa8, 30 => 0xba },
	'cameracolorcalibration02' => { 26 => 0x4f, 27 => 0xa8, 28 => 0x89, 29 => 0xac, 30 => 0xbf },
	'cameracolorcalibration03' => { 26 => 0x53, 27 => 0xac, 28 => 0x8d, 29 => 0xb0, 30 => 0xc4 },
	'cameracolorcalibration04' => { 26 => 0x57, 27 => 0xb0, 28 => 0x91, 29 => 0xb4, 30 => 0xc9 },
	'cameracolorcalibration05' => { 26 => 0x5b, 27 => 0xb4, 28 => 0x95, 29 => 0xb8, 30 => 0xce },
	'cameracolorcalibration06' => { 26 => 0x5f, 27 => 0xb8, 28 => 0x99, 29 => 0xbc, 30 => 0xd3 },
	'cameracolorcalibration07' => { 26 => 0x63, 27 => 0xbc, 28 => 0x9d, 29 => 0xc0, 30 => 0xd8 },
	'cameracolorcalibration08' => { 26 => 0x67, 27 => 0xc0, 28 => 0xa1, 29 => 0xc4, 30 => 0xdd },
	'cameracolorcalibration09' => { 26 => 0x6b, 27 => 0xc4, 28 => 0xa5, 29 => 0xc8, 30 => 0xe2 },
	'cameracolorcalibration10' => { 26 => 0x6f, 27 => 0xc8, 28 => 0xa9, 29 => 0xcc, 30 => 0xe7 },
	'cameracolorcalibration11' => { 26 => 0x73, 27 => 0xcc, 28 => 0xad, 29 => 0xd0, 30 => 0xec },
	'cameracolorcalibration12' => { 26 => 0x77, 27 => 0xd0, 28 => 0xb1, 29 => 0xd4, 30 => 0xf1 },
	'cameracolorcalibration13' => { 26 => 0x7b, 27 => 0xd4, 28 => 0xb5, 29 => 0xd8, 30 => 0xf6 },
	'cameracolorcalibration14' => { 26 => 0x7f, 27 => 0xd8, 28 => 0xb9, 29 => 0xdc, 30 => 0xfb },
	'cameracolorcalibration15' => { 26 => 0x83, 27 => 0xdc, 28 => 0xbd, 29 => 0xe0, 30 => 0x100 },
	'cameraid' => { 198 => 0x209, 252 => 0x209 },
	'cameraiso' => { 24 => 0x10 },
	'cameralabel' => { 287 => 'cameraLabel' },
	'cameramodel' => { 287 => 'cameraModel' },
	'cameramove' => { 287 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 7 => 0x30, 9 => 0x35, 10 => 0x30, 11 => 0x30, 12 => 0x31, 13 => 0x31, 14 => 0x35, 15 => 0x27, 16 => 0x31, 18 => 0x36, 20 => 0x11, 236 => 0x1 },
	'cameraowner' => { 94 => 0xc353 },
	'cameraparameters' => { 198 => 0x2050 },
	'cameraprofile' => { 268 => 'CameraProfile' },
	'cameraprofiledigest' => { 268 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 80 => 0xc62f, 124 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 193 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 7 => 0x18, 9 => 0x19, 10 => 0x18, 11 => 0x18, 12 => 0x19, 13 => 0x19, 14 => 0x19, 15 => 0x17, 16 => 0x19, 18 => 0x19, 19 => 0x19, 21 => [0x87,0x91], 22 => [0x99,0x9f,0xa4,0xa8,0x105], 23 => [0x64,0x47,0x53,0x5b,0x5c], 51 => 0xc, 208 => 0x320, 214 => 0x3402, 234 => 0x47, 251 => 0x43 },
	'cameratemperature2' => { 239 => 0xc },
	'cameratemperature3' => { 239 => 0xe },
	'cameratype' => { 51 => 0x1a, 198 => 0x207 },
	'cameratype2' => { 194 => 0x100 },
	'canonexposuremode' => { 24 => 0x14 },
	'canonfiledescription' => { 69 => 0x805 },
	'canonfilelength' => { 40 => 0xe },
	'canonfirmwareversion' => { 40 => 0x7, 69 => 0x80b },
	'canonflashinfo' => { 69 => 0x1028 },
	'canonflashmode' => { 24 => 0x4 },
	'canonimagesize' => { 6 => 0x39, 24 => 0xa },
	'canonimagetype' => { 40 => 0x6, 69 => 0x815 },
	'canonmodelid' => { 40 => 0x10, 69 => 0x1834 },
	'canonvrd' => { 81 => 'CanonVRD' },
	'caption' => { 265 => 'caption' },
	'caption-abstract' => { 86 => 0x78 },
	'captionsauthornames' => { 271 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 271 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 276 => 'CaptionWriter' },
	'captureframerate' => { 77 => 0x4001 },
	'cardshutterlock' => { 128 => 0x49 },
	'casioimagesize' => { 77 => 0x9 },
	'catalogsets' => { 86 => 0xff, 264 => 'CatalogSets' },
	'categories' => { 40 => 0x23, 265 => 'categories' },
	'category' => { 86 => 0xf, 276 => 'Category' },
	'ccdboardversion' => { 208 => 0x331 },
	'ccdscanmode' => { 198 => 0x1039 },
	'ccdsensitivity' => { 171 => 0x6 },
	'ccdversion' => { 208 => 0x330 },
	'celllength' => { 80 => 0x109 },
	'cellwidth' => { 80 => 0x108 },
	'centerafarea' => { 191 => '15.1' },
	'centerfocuspoint' => { 192 => '2.2' },
	'centerweightedareasize' => { 188 => '7.1', 191 => '6.3', 192 => '8.1' },
	'certificate' => { 291 => 'Certificate' },
	'cfapattern' => { 80 => 0xa302 },
	'cfapatterncolumns' => { 272 => 'CFAPatternColumns' },
	'cfapatternrows' => { 272 => 'CFAPatternRows' },
	'cfapatternvalues' => { 272 => 'CFAPatternValues' },
	'channel' => { 278 => 'channel' },
	'channels' => { 106 => 'Channels' },
	'checkmark' => { 74 => 0x26a },
	'checkmark2' => { 75 => 0x8e },
	'childfontfiles' => { 292 => 'FontsChildFontFiles' },
	'chmodeshootingspeed' => { 188 => '10.3' },
	'chromablurradius' => { 80 => 0xc631 },
	'chromaticaberration' => { 75 => 0x66 },
	'chromaticaberrationb' => { 268 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 75 => 0x6b },
	'chromaticaberrationcorrection' => { 227 => 0x1 },
	'chromaticaberrationon' => { 75 => 0x62 },
	'chromaticaberrationr' => { 268 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 75 => 0x6a },
	'chrominancenoisereduction' => { 75 => 0x5e, 253 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 75 => 0x60 },
	'city' => { 86 => 0x5a, 112 => 'City', 213 => 0x6d, 276 => 'City' },
	'clarity' => { 268 => 'Clarity' },
	'classifystate' => { 86 => 0xe1 },
	'client' => { 287 => 'client' },
	'clmodeshootingspeed' => { 188 => '10.2', 192 => '11.1' },
	'cmcontrast' => { 201 => 0x2022 },
	'cmexposurecompensation' => { 201 => 0x2000 },
	'cmhue' => { 201 => 0x2021 },
	'cmsaturation' => { 201 => 0x2020 },
	'cmsharpness' => { 201 => 0x2023 },
	'cmwhitebalance' => { 201 => 0x2001 },
	'cmwhitebalancecomp' => { 201 => 0x2002 },
	'cmwhitebalancegraypoint' => { 201 => 0x2010 },
	'codec' => { 120 => 'Codec' },
	'codedcharacterset' => { 87 => 0x5a },
	'coloraberrationcontrol' => { 181 => 0xc89224b },
	'coloradjustment' => { 253 => 0x14 },
	'coloradjustmentmode' => { 252 => 0x210 },
	'coloranta' => { 292 => 'ColorantsA' },
	'colorantb' => { 292 => 'ColorantsB' },
	'colorantblack' => { 292 => 'ColorantsBlack' },
	'colorantblue' => { 292 => 'ColorantsBlue' },
	'colorantcyan' => { 292 => 'ColorantsCyan' },
	'colorantgreen' => { 292 => 'ColorantsGreen' },
	'colorantl' => { 292 => 'ColorantsL' },
	'colorantmagenta' => { 292 => 'ColorantsMagenta' },
	'colorantmode' => { 292 => 'ColorantsMode' },
	'colorantred' => { 292 => 'ColorantsRed' },
	'colorantswatchname' => { 292 => 'ColorantsSwatchName' },
	'coloranttype' => { 292 => 'ColorantsType' },
	'colorantyellow' => { 292 => 'ColorantsYellow' },
	'colorbalance' => { 107 => 'ColorBalance' },
	'colorbalanceadj' => { 181 => 0x76a43202 },
	'colorbalanceblue' => { 125 => 0x1e },
	'colorbalancegreen' => { 125 => 0x1d },
	'colorbalancered' => { 125 => 0x1c },
	'colorblur' => { 75 => 0x65 },
	'colorbooster' => { 181 => 0x5f0e7d23 },
	'colorboostlevel' => { 175 => 0x1 },
	'colorboosttype' => { 175 => 0x0 },
	'colorclass' => { 240 => 0xde },
	'colorcompensationfilter' => { 128 => [0x3a,0x5f], 129 => 0x111, 257 => 0xb022 },
	'colorcontrol' => { 198 => 0x102b },
	'colorcorrection' => { 260 => 0x8015 },
	'colordataversion' => { 28 => 0x0, 29 => 0x0 },
	'coloreffect' => { 213 => 0x28 },
	'colorfilter' => { 76 => 0x17, 77 => 0x3017, 125 => 0x29, 132 => [0x38,0x4d,0x4f], 238 => 0x17 },
	'colorgain' => { 158 => 0x51 },
	'colorhue' => { 153 => 0x8d },
	'colorimetricreference' => { 80 => 0xc6bf },
	'colormatrix' => { 197 => 0x200, 198 => 0x1011 },
	'colormatrix1' => { 80 => 0xc621 },
	'colormatrix2' => { 80 => 0xc622, 201 => 0x200 },
	'colormatrixa' => { 234 => 0x203 },
	'colormatrixb' => { 234 => 0x204 },
	'colormatrixnumber' => { 198 => 0x1019 },
	'colormode' => { 77 => 0x3015, 84 => 0x1210, 93 => 0x66, 125 => 0x28, 128 => 0x16, 129 => 0x101, 132 => 0x7, 153 => 0x3, 171 => 0x4, 213 => 0x32, 253 => 0x2c, 257 => 0xb029, 276 => 'ColorMode' },
	'colormoirereduction' => { 182 => 0x15 },
	'colormoirereductionmode' => { 182 => 0x5 },
	'colornoisereduction' => { 260 => 0x8029, 268 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 182 => 0x18 },
	'colornoisereductionsharpness' => { 182 => 0x1c },
	'colorplanes' => { 83 => 0x2 },
	'colorprofile' => { 125 => 0x33 },
	'colorrepresentation' => { 88 => 0x3c },
	'colorreproduction' => { 257 => 0xb020 },
	'colorsequence' => { 88 => 0x41 },
	'colorspace' => { 31 => 0x3, 40 => 0xb4, 69 => 0x10b4, 80 => 0xa001, 113 => 'ColorSpace', 126 => 0x2f, 127 => 0x25, 128 => 0x17, 153 => 0x1e, 193 => 0x507, 234 => 0x37, 253 => 0xb, 272 => 'ColorSpace' },
	'colortempasshot' => { 26 => 0x1d, 27 => 0x26, 28 => 0x43, 29 => 0x43, 30 => 0x4b },
	'colortempauto' => { 26 => 0x22, 27 => 0x1c, 28 => 0x48, 29 => 0x48, 30 => 0x50 },
	'colortempcloudy' => { 26 => 0x31, 27 => 0x35, 28 => 0x5c, 29 => 0x61, 30 => 0x69 },
	'colortempcustom' => { 28 => 0x84 },
	'colortempcustom1' => { 26 => 0x45 },
	'colortempcustom2' => { 26 => 0x4a },
	'colortempdaylight' => { 26 => 0x27, 27 => 0x2b, 28 => 0x52, 29 => 0x57, 30 => 0x5f },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0x37, 7 => 0x62, 8 => 0x37, 9 => [0x7b,0x7c], 10 => 0x73, 11 => 0x73, 12 => 0x77, 13 => 0x73, 14 => 0x7c, 15 => 0x58, 16 => 0x73, 18 => 0x7d, 20 => 0x57, 40 => 0xae, 49 => 0x9, 69 => 0x10ae, 84 => 0x1005, 91 => 0x846, 107 => 'ColorTemperature', 126 => [0x6e,0x49], 127 => 0x3f, 128 => [0x39,0x5e], 129 => 0x10b, 132 => [0x3c,0x4c,0x4e], 208 => 0x321, 234 => 0x50, 257 => 0xb021 },
	'colortemperatureadj' => { 260 => 0x8013 },
	'colortemperaturebg' => { 198 => 0x1013 },
	'colortemperaturerg' => { 198 => 0x1014 },
	'colortemperaturesetting' => { 128 => 0x25 },
	'colortempflash' => { 26 => 0x40, 27 => 0x49, 28 => 0x70, 29 => 0x75, 30 => 0x7d },
	'colortempflashdata' => { 28 => 0x24a },
	'colortempfluorescent' => { 26 => 0x3b, 27 => 0x3f, 28 => 0x66, 29 => 0x6b, 30 => 0x73 },
	'colortempkelvin' => { 27 => 0x44, 28 => 0x6b, 29 => 0x70, 30 => 0x78 },
	'colortempmeasured' => { 28 => 0x4d, 29 => 0x4d, 30 => 0x55 },
	'colortemppc1' => { 27 => 0x94, 28 => 0x75 },
	'colortemppc2' => { 27 => 0x99, 28 => 0x7a },
	'colortemppc3' => { 27 => 0x9e, 28 => 0x7f },
	'colortempshade' => { 26 => 0x2c, 27 => 0x30, 28 => 0x57, 29 => 0x5c, 30 => 0x64 },
	'colortemptungsten' => { 26 => 0x36, 27 => 0x3a, 28 => 0x61, 29 => 0x66, 30 => 0x6e },
	'colortempunknown' => { 27 => 0x21, 29 => 0x52, 30 => 0x5a },
	'colortempunknown10' => { 27 => 0x76, 29 => 0xa2, 30 => 0xaa },
	'colortempunknown11' => { 27 => 0x7b, 29 => 0xa7, 30 => 0xaf },
	'colortempunknown12' => { 27 => 0x80, 30 => 0xb4 },
	'colortempunknown13' => { 27 => 0x85, 30 => 0xb9 },
	'colortempunknown14' => { 27 => 0x8a },
	'colortempunknown15' => { 27 => 0x8f },
	'colortempunknown16' => { 27 => 0xa3 },
	'colortempunknown2' => { 27 => 0x4e, 29 => 0x7a, 30 => 0x82 },
	'colortempunknown3' => { 27 => 0x53, 29 => 0x7f, 30 => 0x87 },
	'colortempunknown4' => { 27 => 0x58, 29 => 0x84, 30 => 0x8c },
	'colortempunknown5' => { 27 => 0x5d, 29 => 0x89, 30 => 0x91 },
	'colortempunknown6' => { 27 => 0x62, 29 => 0x8e, 30 => 0x96 },
	'colortempunknown7' => { 27 => 0x67, 29 => 0x93, 30 => 0x9b },
	'colortempunknown8' => { 27 => 0x6c, 29 => 0x98, 30 => 0xa0 },
	'colortempunknown9' => { 27 => 0x71, 29 => 0x9d, 30 => 0xa5 },
	'colortone' => { 6 => 0x6f, 8 => 0x77, 24 => 0x2a, 31 => 0x2 },
	'colortoneadj' => { 74 => 0x11e },
	'colortonefaithful' => { 15 => 0x107, 45 => 0x6c, 46 => 0x6c },
	'colortonelandscape' => { 15 => 0x105, 45 => 0x3c, 46 => 0x3c },
	'colortonemonochrome' => { 45 => 0x84, 46 => 0x84 },
	'colortoneneutral' => { 15 => 0x106, 45 => 0x54, 46 => 0x54 },
	'colortoneportrait' => { 15 => 0x104, 45 => 0x24, 46 => 0x24 },
	'colortonestandard' => { 15 => 0x103, 45 => 0xc, 46 => 0xc },
	'colortoneunknown' => { 46 => 0x9c },
	'colortoneuserdef1' => { 15 => 0x109, 45 => 0x9c, 46 => 0xb4 },
	'colortoneuserdef2' => { 15 => 0x10a, 45 => 0xb4, 46 => 0xcc },
	'colortoneuserdef3' => { 15 => 0x10b, 45 => 0xcc, 46 => 0xe4 },
	'commanddials' => { 191 => '5.1' },
	'commanddialsaperturesetting' => { 188 => '17.3' },
	'commanddialschangemainsub' => { 188 => '17.2' },
	'commanddialsmenuandplayback' => { 188 => '17.4' },
	'commanddialsreverserotation' => { 188 => '17.1', 190 => '16.2', 192 => '18.1' },
	'commanderchannel' => { 191 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 191 => '13.1' },
	'commandergroupa_ttlcomp' => { 192 => '32.1' },
	'commandergroupamanualoutput' => { 191 => '13.2' },
	'commandergroupamode' => { 191 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 191 => '14.1' },
	'commandergroupb_ttlcomp' => { 192 => '33.1' },
	'commandergroupbmanualoutput' => { 191 => '14.2' },
	'commandergroupbmode' => { 191 => '11.3' },
	'commanderinternalflash' => { 191 => '11.1' },
	'commanderinternalmanualoutput' => { 191 => '12.2' },
	'commanderinternalttlcomp' => { 191 => '12.1', 192 => '31.2' },
	'comment' => { 0 => 0x2, 81 => 'Comment', 108 => 'Comment', 204 => 'Comment' },
	'complianceprofile' => { 278 => 'complianceProfile' },
	'componentsconfiguration' => { 80 => 0x9101, 113 => 'Components', 272 => 'ComponentsConfiguration' },
	'componentversion' => { 69 => 0x80c },
	'composer' => { 287 => 'composer' },
	'compressedbitsperpixel' => { 80 => 0x9102, 272 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 129 => 0x40, 198 => 0x40 },
	'compression' => { 80 => 0x103, 283 => 'Compression' },
	'compressionfactor' => { 193 => 0x50d },
	'compressionratio' => { 113 => 'Compression', 198 => 0x1034 },
	'constrainedcropheight' => { 74 => 0x266, 240 => 0xd6 },
	'constrainedcropwidth' => { 74 => 0x262, 240 => 0xd5 },
	'contact' => { 86 => 0x76 },
	'contentlocationcode' => { 86 => 0x1a },
	'contentlocationname' => { 86 => 0x1b },
	'continuousbracketing' => { 128 => 0x20 },
	'continuousdrive' => { 24 => 0x5 },
	'continuousshootingspeed' => { 56 => 0x610 },
	'continuousshotlimit' => { 56 => 0x611 },
	'contrast' => { 6 => 0x73, 8 => 0x75, 24 => 0xd, 76 => 0xc, 77 => [0x3012,0x20], 80 => [0xa408,0xfe54], 84 => [0x1004,0x1006], 107 => 'Contrast', 125 => 0x20, 126 => 0x31, 127 => 0x27, 128 => 0x19, 132 => 0x2, 155 => 0x33, 198 => 0x1029, 213 => 0x39, 214 => 0x300a, 234 => 0x20, 238 => 0xc, 253 => 0xd, 254 => 0x1d, 255 => 0x1a, 257 => 0x2004, 268 => 'Contrast', 272 => 'Contrast' },
	'contrastadj' => { 74 => 0x115, 184 => 0x2c, 260 => 0x8017 },
	'contrastdetectaf' => { 135 => 0x4 },
	'contrastdetectafarea' => { 234 => 0x231 },
	'contrastdetectafinfocus' => { 135 => 0x1c },
	'contrastfaithful' => { 15 => 0xec, 45 => 0x60, 46 => 0x60 },
	'contrasthighlight' => { 234 => 0x6d },
	'contrasthighlightshadowadj' => { 234 => 0x6f },
	'contrastlandscape' => { 15 => 0xea, 45 => 0x30, 46 => 0x30 },
	'contrastmode' => { 213 => 0x2c },
	'contrastmonochrome' => { 15 => 0xed, 45 => 0x78, 46 => 0x78 },
	'contrastneutral' => { 15 => 0xeb, 45 => 0x48, 46 => 0x48 },
	'contrastportrait' => { 15 => 0xe9, 45 => 0x18, 46 => 0x18 },
	'contrastsetting' => { 193 => 0x505, 201 => 0x1012 },
	'contrastshadow' => { 234 => 0x6e },
	'contraststandard' => { 15 => 0xe8, 45 => 0x0, 46 => 0x0 },
	'contrastunknown' => { 46 => 0x90 },
	'contrastuserdef1' => { 15 => 0xee, 45 => 0x90, 46 => 0xa8 },
	'contrastuserdef2' => { 15 => 0xef, 45 => 0xa8, 46 => 0xc0 },
	'contrastuserdef3' => { 15 => 0xf0, 45 => 0xc0, 46 => 0xd8 },
	'contributedmediadurationscale' => { 287 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 287 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 287 => 'contributedMediaManaged' },
	'contributedmediapath' => { 287 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 287 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 287 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 287 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 287 => 'contributedMediaWebStatement' },
	'contributor' => { 269 => 'contributor' },
	'contributors' => { 108 => 'Contributors' },
	'controldialset' => { 128 => 0x46 },
	'controlledvocabularyterm' => { 274 => 'CVterm' },
	'controllerboardversion' => { 208 => 0x332 },
	'controlmode' => { 51 => 0x12 },
	'conversionlens' => { 213 => 0x35 },
	'converter' => { 80 => 0xfe4d, 171 => 0xb, 268 => 'Converter' },
	'converttograyscale' => { 268 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 80 => 0x8298, 108 => 'Copyright', 204 => 'Copyright', 234 => 0x22f, 245 => 'Copyright', 275 => 'Copyright', 278 => 'copyright', 280 => 'copyright', 283 => 'Copyright', 287 => 'copyright' },
	'copyrightflag' => { 243 => 0x40a },
	'copyrightnotice' => { 86 => 0x74 },
	'copyrightownerid' => { 277 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 277 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 277 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 277 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 277 => 'CopyrightStatus' },
	'coringfilter' => { 197 => 0x310, 198 => 0x102d, 201 => 0x310 },
	'coringvalues' => { 197 => 0x311, 201 => 0x311 },
	'corporateentity' => { 278 => 'corporateEntity' },
	'country' => { 112 => 'Country', 213 => 0x69, 276 => 'Country' },
	'country-primarylocationcode' => { 86 => 0x64 },
	'country-primarylocationname' => { 86 => 0x65 },
	'countrycode' => { 241 => 'CountryCode', 273 => 'CountryCode' },
	'coverage' => { 269 => 'coverage' },
	'coverdate' => { 278 => 'coverDate' },
	'coverdisplaydate' => { 278 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 234 => 0x28 },
	'crc32' => { 270 => 'crc32' },
	'createdate' => { 80 => 0x9004, 108 => 'CreateDate', 202 => 'CreationDate', 204 => 'create-date', 245 => 'CreationDate', 285 => 'CreateDate' },
	'creationdate' => { 275 => 'CreationDate', 278 => 'creationDate' },
	'creationtime' => { 204 => 'Creation Time' },
	'creativestyle' => { 254 => 0x1a, 255 => 0x18 },
	'creativestylewaschanged' => { 260 => 0x8001 },
	'creator' => { 202 => 'Creator', 245 => 'Creator', 269 => 'creator', 275 => 'Creator' },
	'creatoraddress' => { 273 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 273 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 273 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 273 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 273 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 285 => 'CreatorTool' },
	'creatorworkemail' => { 273 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 273 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 273 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 86 => 0x6e, 276 => 'Credit' },
	'creditline' => { 280 => 'creditLine' },
	'creditlinereq' => { 290 => 'CreditLineReq' },
	'creditlinerequired' => { 277 => 'CreditLineRequired' },
	'cropactive' => { 74 => 0x244 },
	'cropangle' => { 268 => 'CropAngle' },
	'cropaspectratio' => { 74 => 0x260 },
	'cropbottom' => { 83 => 0x9, 176 => 0x36, 240 => 0xdc, 268 => 'CropBottom' },
	'cropbottommargin' => { 32 => 0x3 },
	'cropheight' => { 74 => 0x24c, 197 => 0x615, 201 => 0x615, 268 => 'CropHeight' },
	'crophispeed' => { 153 => 0x1b },
	'cropleft' => { 74 => 0x246, 83 => 0x6, 176 => 0x1e, 197 => 0x612, 201 => 0x612, 240 => 0xd9, 268 => 'CropLeft' },
	'cropleftmargin' => { 32 => 0x0 },
	'cropoutputheight' => { 176 => 0xce },
	'cropoutputheightinches' => { 176 => 0x96 },
	'cropoutputpixels' => { 176 => 0xd6 },
	'cropoutputresolution' => { 176 => 0xb6 },
	'cropoutputscale' => { 176 => 0xbe },
	'cropoutputwidth' => { 176 => 0xc6 },
	'cropoutputwidthinches' => { 176 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 83 => 0x8, 176 => 0x2e, 240 => 0xdb, 268 => 'CropRight' },
	'croprightmargin' => { 32 => 0x1 },
	'croprotation' => { 83 => 0xb },
	'cropscaledresolution' => { 176 => 0x9e },
	'cropsourceresolution' => { 176 => 0xae },
	'croptop' => { 74 => 0x248, 83 => 0x7, 176 => 0x26, 197 => 0x613, 201 => 0x613, 240 => 0xda, 268 => 'CropTop' },
	'croptopmargin' => { 32 => 0x2 },
	'cropunit' => { 268 => 'CropUnit' },
	'cropunits' => { 268 => 'CropUnits' },
	'cropwidth' => { 74 => 0x24a, 197 => 0x614, 201 => 0x614, 268 => 'CropWidth' },
	'crossprocess' => { 234 => 0x7b },
	'crossprocessparams' => { 234 => 0x235 },
	'currenticcprofile' => { 80 => 0xc691 },
	'currentpreprofilematrix' => { 80 => 0xc692 },
	'currentversion' => { 260 => 0xd000 },
	'curves' => { 181 => 0x76a43201 },
	'custom1' => { 277 => 'Custom1' },
	'custom10' => { 277 => 'Custom10' },
	'custom2' => { 277 => 'Custom2' },
	'custom3' => { 277 => 'Custom3' },
	'custom4' => { 277 => 'Custom4' },
	'custom5' => { 277 => 'Custom5' },
	'custom6' => { 277 => 'Custom6' },
	'custom7' => { 277 => 'Custom7' },
	'custom8' => { 277 => 'Custom8' },
	'custom9' => { 277 => 'Custom9' },
	'customcontrast' => { 75 => 0x4e },
	'customcontrols' => { 56 => 0x70c },
	'customlinear' => { 75 => 0x4f },
	'customoutputhighlightpoint' => { 75 => 0x53 },
	'customoutputshadowpoint' => { 75 => 0x54 },
	'custompicturestylefilename' => { 40 => 0x4010 },
	'customrawhighlight' => { 75 => 0x7c },
	'customrawhighlightpoint' => { 75 => 0x51 },
	'customrawshadow' => { 75 => 0x85 },
	'customrawshadowpoint' => { 75 => 0x52 },
	'customrendered' => { 80 => 0xa401, 272 => 'CustomRendered' },
	'customsaturation' => { 193 => 0x503 },
	'customsettingsalldefault' => { 188 => '0.2' },
	'customsettingsbank' => { 188 => '0.1' },
	'customsharpness' => { 75 => 0x50 },
	'customwbbluelevel' => { 128 => 0x36 },
	'customwberror' => { 128 => 0x37 },
	'customwbgreenlevel' => { 128 => 0x35 },
	'customwbredlevel' => { 128 => 0x34 },
	'customwbsetting' => { 128 => 0x26 },
	'd-lightinghq' => { 181 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 177 => 0x2 },
	'd-lightinghqhighlight' => { 177 => 0x1 },
	'd-lightinghqselected' => { 181 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 177 => 0x0 },
	'd-lightinghs' => { 181 => 0xce5554aa },
	'd-lightinghsadjustment' => { 178 => 0x0 },
	'd-lightinghscolorboost' => { 178 => 0x1 },
	'd-rangeoptimizerhighlight' => { 260 => 0x8024 },
	'd-rangeoptimizermode' => { 260 => 0x8022 },
	'd-rangeoptimizershadow' => { 260 => 0x802d },
	'd-rangeoptimizervalue' => { 260 => 0x8023 },
	'datacompressionmethod' => { 88 => 0x6e },
	'dataimprint' => { 125 => 0x34 },
	'date' => { 234 => 0x6, 269 => 'date' },
	'dateacquired' => { 124 => 'DateAcquired' },
	'datecreated' => { 86 => 0x37, 276 => 'DateCreated' },
	'datedisplayformat' => { 173 => 0x3 },
	'dateimprint' => { 190 => '4.2' },
	'daterecieved' => { 278 => 'dateRecieved' },
	'datesent' => { 87 => 0x46 },
	'datestampmode' => { 40 => 0x1c },
	'datetime' => { 265 => 'datetime', 283 => 'DateTime' },
	'datetimedigitized' => { 272 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 72 => 0x0, 80 => 0x9003, 105 => 0x14, 108 => 'OriginalDate', 272 => 'DateTimeOriginal' },
	'datetimestamp' => { 93 => 0x64 },
	'daylightsavings' => { 173 => 0x2 },
	'declination' => { 116 => 'Declination' },
	'decposition' => { 125 => 0x32 },
	'defaultcroporigin' => { 80 => 0xc61f },
	'defaultcropsize' => { 80 => 0xc620 },
	'defaultscale' => { 80 => 0xc61e },
	'defringe' => { 268 => 'Defringe' },
	'deletedimagecount' => { 153 => 0xa6, 159 => 0x6e },
	'derivedfromalternatepaths' => { 288 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 288 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 288 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 288 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 288 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 288 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 288 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 288 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 288 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 288 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 288 => 'DerivedFromMaskMarkers' },
	'derivedfromoriginaldocumentid' => { 288 => 'DerivedFromOriginalDocumentID' },
	'derivedfrompartmapping' => { 288 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 288 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 288 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 288 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 288 => 'DerivedFromVersionID' },
	'description' => { 204 => 'Description', 269 => 'description' },
	'destination' => { 87 => 0x5 },
	'destinationcity' => { 234 => 0x24, 237 => 0x3 },
	'destinationcitycode' => { 238 => 0x1001 },
	'destinationdst' => { 234 => 0x26, 237 => '0.3' },
	'developmentdynamicrange' => { 84 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 272 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 272 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 272 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 56 => 0x706 },
	'digitalcreationdate' => { 86 => 0x3e },
	'digitalcreationtime' => { 86 => 0x3f },
	'digitaldeehighlightadj' => { 158 => 0x202 },
	'digitaldeeshadowadj' => { 158 => 0x200 },
	'digitaldeethreshold' => { 158 => 0x201 },
	'digitalfilter01' => { 225 => 0x5 },
	'digitalfilter02' => { 225 => 0x16 },
	'digitalfilter03' => { 225 => 0x27 },
	'digitalfilter04' => { 225 => 0x38 },
	'digitalfilter05' => { 225 => 0x49 },
	'digitalfilter06' => { 225 => 0x5a },
	'digitalfilter07' => { 225 => 0x6b },
	'digitalfilter08' => { 225 => 0x7c },
	'digitalfilter09' => { 225 => 0x8d },
	'digitalfilter10' => { 225 => 0x9e },
	'digitalfilter11' => { 225 => 0xaf },
	'digitalfilter12' => { 225 => 0xc0 },
	'digitalfilter13' => { 225 => 0xd1 },
	'digitalfilter14' => { 225 => 0xe2 },
	'digitalfilter15' => { 225 => 0xf3 },
	'digitalfilter16' => { 225 => 0x104 },
	'digitalfilter17' => { 225 => 0x115 },
	'digitalfilter18' => { 225 => 0x126 },
	'digitalfilter19' => { 225 => 0x137 },
	'digitalfilter20' => { 225 => 0x148 },
	'digitalgain' => { 49 => 0xb },
	'digitalgem' => { 148 => 0x0 },
	'digitalice' => { 158 => 0x100 },
	'digitalimageguid' => { 274 => 'DigImageGUID' },
	'digitalroc' => { 157 => 0x0 },
	'digitalsourcefiletype' => { 274 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 274 => 'DigitalSourceType' },
	'digitalzoom' => { 24 => 0xc, 76 => 0xa, 93 => 0x68, 107 => 'DigitalZoom', 125 => 0xc, 153 => 0x86, 171 => 0xa, 198 => 0x204, 234 => 0x1e, 238 => 0xa, 252 => 0x204 },
	'digitalzoomon' => { 252 => 0x21b },
	'digitalzoomratio' => { 80 => 0xa404, 272 => 'DigitalZoomRatio' },
	'director' => { 287 => 'director' },
	'directorphotography' => { 287 => 'directorPhotography' },
	'directory' => { 81 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 7 => 0x17e, 9 => [0x233,0x238], 10 => 0x13f, 11 => 0x133, 12 => 0x1df, 13 => [0x1a3,0x1a7], 14 => 0x1f0, 17 => 0x49, 18 => 0x1e5, 20 => 0x1d3 },
	'directorynumber' => { 144 => 0x6 },
	'disclaimer' => { 204 => 'Disclaimer' },
	'displayallafpoints' => { 56 => 0x514 },
	'displayaperture' => { 24 => 0x23 },
	'displayedunitsx' => { 244 => 0x2 },
	'displayedunitsy' => { 244 => 0x6 },
	'distance1' => { 93 => 0x28 },
	'distance2' => { 93 => 0x2c },
	'distance3' => { 93 => 0x30 },
	'distance4' => { 93 => 0x34 },
	'distortioncontrol' => { 159 => 0x10 },
	'distortioncorrection' => { 75 => 0x67, 193 => 0x50b, 227 => 0x0 },
	'distortioncorrection2' => { 197 => 0x1011 },
	'distortioncorrectionon' => { 75 => 0x63 },
	'distributor' => { 278 => 'distributor' },
	'dmcomment' => { 287 => 'comment' },
	'dngbackwardversion' => { 80 => 0xc613 },
	'dnglensinfo' => { 80 => 0xc630 },
	'dngversion' => { 80 => 0xc612 },
	'document' => { 204 => 'Document' },
	'documentancestorid' => { 276 => 'DocumentAncestorsAncestorID' },
	'documenthistory' => { 86 => 0xe7 },
	'documentid' => { 288 => 'DocumentID' },
	'documentname' => { 80 => 0x10d },
	'documentnotes' => { 86 => 0xe6 },
	'doi' => { 278 => 'doi' },
	'dotrange' => { 80 => 0x150 },
	'drivemode' => { 77 => 0x3103, 125 => 0x6, 128 => 0x1e, 193 => 0x600, 234 => 0x34, 253 => 0x3, 254 => 0x4 },
	'drivemode2' => { 128 => 0xa, 221 => 0x7 },
	'dspfirmwareversion' => { 234 => 0x27 },
	'duration' => { 43 => 0x6a, 106 => 'Duration', 120 => 'Duration' },
	'durationscale' => { 287 => 'durationScale' },
	'durationvalue' => { 287 => 'durationValue' },
	'dustremovaldata' => { 40 => 0x97 },
	'dynamicafarea' => { 188 => '1.4' },
	'dynamicrange' => { 84 => 0x1400 },
	'dynamicrangeexpansion' => { 234 => 0x69 },
	'dynamicrangemax' => { 74 => 0x7c },
	'dynamicrangemin' => { 74 => 0x7a },
	'dynamicrangeoptimizer' => { 128 => 0x15, 257 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 254 => 0x19, 255 => 0x17 },
	'dynamicrangeoptimizermode' => { 254 => 0x18, 255 => 0x16 },
	'dynamicrangeoptimizersetting' => { 128 => 0x27 },
	'dynamicrangesetting' => { 84 => 0x1402 },
	'e-dialinprogram' => { 221 => '1.3' },
	'easyexposurecomp' => { 192 => '6.1' },
	'easyexposurecompensation' => { 188 => '6.4' },
	'easymode' => { 24 => 0xb },
	'edgenoisereduction' => { 182 => 0x4, 260 => 0x8028 },
	'edition' => { 278 => 'edition' },
	'editorialupdate' => { 86 => 0x8 },
	'editstatus' => { 86 => 0x7, 241 => 'EditStatus' },
	'effectivelv' => { 234 => 0x2d },
	'effectivemaxaperture' => { 151 => 0x12, 152 => 0x13 },
	'eissn' => { 278 => 'eIssn' },
	'elevation' => { 116 => 'Elevation' },
	'email' => { 108 => 'EMail' },
	'embargodate' => { 278 => 'embargoDate', 280 => 'embargoDate' },
	'endingpage' => { 278 => 'endingPage' },
	'enduserid' => { 277 => 'EndUserEndUserID' },
	'endusername' => { 277 => 'EndUserEndUserName' },
	'engineer' => { 287 => 'engineer' },
	'enhancedarktones' => { 174 => 0x8 },
	'enhancement' => { 76 => 0x16, 77 => 0x3016 },
	'enhancer' => { 197 => 0x300 },
	'enhancervalues' => { 197 => 0x301 },
	'envelopenumber' => { 87 => 0x28 },
	'envelopepriority' => { 87 => 0x3c },
	'enveloperecordversion' => { 87 => 0x0 },
	'epsonimageheight' => { 198 => 0x20c },
	'epsonimagewidth' => { 198 => 0x20b },
	'epsonsoftware' => { 198 => 0x20d },
	'equipmentinstitution' => { 262 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 262 => 'EquipmentManufacturer' },
	'equipmentversion' => { 194 => 0x0 },
	'ettlii' => { 56 => 0x304, 57 => 0xd, 58 => 0xe, 59 => 0x7, 60 => 0x7, 61 => 0xe },
	'event' => { 264 => 'Event', 274 => 'Event', 278 => 'event' },
	'evsteps' => { 221 => '1.2', 223 => 0x0 },
	'evstepsize' => { 190 => '5.1', 191 => '0.7' },
	'exclusivityenddate' => { 280 => 'exclusivityEndDate' },
	'excursiontolerance' => { 88 => 0x82 },
	'exif' => { 81 => 'EXIF' },
	'exifbyteorder' => { 81 => 'ExifByteOrder' },
	'exifcamerainfo' => { 86 => 0xe8 },
	'exifimageheight' => { 80 => 0xa003, 272 => 'PixelYDimension' },
	'exifimagewidth' => { 80 => 0xa002, 272 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 81 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 80 => 0x9000, 272 => 'ExifVersion' },
	'exitpupilposition' => { 151 => 0x4, 152 => 0x4 },
	'expirationdate' => { 86 => 0x25, 278 => 'expirationDate', 280 => 'expirationDate' },
	'expirationtime' => { 86 => 0x26 },
	'exposure' => { 80 => 0xfe51, 268 => 'Exposure' },
	'exposureadj' => { 179 => 0x0 },
	'exposureadj2' => { 179 => 0x12 },
	'exposureadjust' => { 253 => 0xc },
	'exposurebracketingindicatorlast' => { 128 => 0x52 },
	'exposurebracketstepsize' => { 221 => 0x8 },
	'exposurebracketvalue' => { 153 => 0x19 },
	'exposurecompensation' => { 51 => 0x6, 65 => 0x0, 80 => 0x9204, 93 => 0x24, 107 => 'ExposureComp', 125 => 0xd, 126 => 0x53, 127 => 0x1e, 198 => 0x1006, 234 => 0x16, 251 => 0xa013, 253 => [0xc,0x35], 272 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 128 => 0x47 },
	'exposurecompensationsetting' => { 128 => 0x1 },
	'exposurecompstepsize' => { 188 => '6.3' },
	'exposurecontrolstepsize' => { 188 => '6.2', 192 => '7.1' },
	'exposuredelaymode' => { 188 => '10.1', 190 => '9.1', 191 => '6.4', 192 => '11.2' },
	'exposuredifference' => { 153 => 0xe },
	'exposureindex' => { 80 => 0xa215, 272 => 'ExposureIndex' },
	'exposureindicator' => { 128 => 0x50 },
	'exposurelevelincrements' => { 54 => 0x6, 55 => 0x6, 56 => 0x101, 57 => 0x5, 58 => 0x6, 59 => 0x5, 60 => 0x5, 61 => 0x6, 62 => 0x4, 254 => 0x58 },
	'exposuremode' => { 80 => 0xa402, 107 => 'ExposureMode', 125 => 0x1, 126 => 0xa, 127 => 0x0, 128 => 0x0, 193 => 0x200, 210 => 0x40d, 253 => 0x8, 257 => 0xb041, 272 => 'ExposureMode' },
	'exposuremodeinmanual' => { 56 => 0x10b },
	'exposureprogram' => { 80 => 0x8822, 254 => 0x3c, 255 => 0x3c, 272 => 'ExposureProgram' },
	'exposureshift' => { 193 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 18 => 0x4, 19 => 0x4, 21 => 0x6, 22 => 0x7, 51 => 0x16, 80 => 0x829a, 90 => 0xfd05, 93 => 0x20, 95 => 0xfa24, 97 => 0xf104, 100 => 0x12, 102 => 0x38, 105 => 0x10, 107 => 'ExposureTime', 125 => 0x9, 126 => 0x35, 127 => 0x48, 128 => 0x8, 234 => 0x12, 251 => 0xa018, 253 => 0x32, 272 => 'ExposureTime' },
	'exposuretime2' => { 253 => 0x33 },
	'exposuretuning' => { 153 => 0x1c },
	'exposurevalue' => { 91 => 0x3 },
	'exposurewarning' => { 84 => 0x1302 },
	'exrauto' => { 84 => 0x1033 },
	'exrmode' => { 84 => 0x1034 },
	'extendedwbdetect' => { 193 => 0x902 },
	'extender' => { 194 => 0x301 },
	'extenderfirmwareversion' => { 194 => 0x304 },
	'extendermagnification' => { 109 => 'Magnification' },
	'extendermake' => { 109 => 'Make' },
	'extendermodel' => { 109 => 'Model', 194 => 0x303 },
	'extenderserialnumber' => { 109 => 'SerialNumber', 194 => 0x302 },
	'externalflash' => { 196 => 0x1201 },
	'externalflashae1' => { 198 => 0x101f },
	'externalflashae1_0' => { 198 => 0x101b },
	'externalflashae2' => { 198 => 0x1020 },
	'externalflashae2_0' => { 198 => 0x101c },
	'externalflashbounce' => { 196 => 0x1204, 198 => 0x1026, 226 => 0x1a },
	'externalflashexposurecomp' => { 153 => 0x17, 226 => 0x19 },
	'externalflashfirmware' => { 145 => 0x6, 146 => 0x6, 147 => 0x6 },
	'externalflashflags' => { 145 => 0x8, 146 => 0x8, 147 => 0x8 },
	'externalflashguidenumber' => { 196 => 0x1203, 226 => '24.1' },
	'externalflashgvalue' => { 198 => 0x1025 },
	'externalflashmode' => { 198 => 0x1028, 226 => 0x2 },
	'externalflashzoom' => { 196 => 0x1205, 198 => 0x1027 },
	'externalsensorbrightnessvalue' => { 208 => 0x311, 214 => 0x3408 },
	'eyestartaf' => { 128 => 0x40 },
	'face0position' => { 33 => 0x8 },
	'face1position' => { 33 => 0xa, 206 => 0x1 },
	'face2position' => { 33 => 0xc, 206 => 0x5 },
	'face3position' => { 33 => 0xe, 206 => 0x9 },
	'face4position' => { 33 => 0x10, 206 => 0xd },
	'face5position' => { 33 => 0x12, 206 => 0x11 },
	'face6position' => { 33 => 0x14 },
	'face7position' => { 33 => 0x16 },
	'face8position' => { 33 => 0x18 },
	'facedetect' => { 197 => 0x1200, 234 => 0x76 },
	'facedetectarea' => { 197 => 0x1201 },
	'facedetectframeheight' => { 33 => 0x4 },
	'facedetectframesize' => { 234 => 0x77 },
	'facedetectframewidth' => { 33 => 0x3 },
	'faceposition' => { 224 => 0x2 },
	'facepositions' => { 84 => 0x4103 },
	'facesdetected' => { 33 => 0x2, 34 => 0x2, 84 => 0x4100, 213 => 0x3f, 224 => 0x0 },
	'facesrecognized' => { 207 => 0x0 },
	'faithfuloutputhighlightpoint' => { 75 => 0x38 },
	'faithfuloutputshadowpoint' => { 75 => 0x39 },
	'faithfulrawcolortone' => { 75 => 0x31 },
	'faithfulrawcontrast' => { 75 => 0x33 },
	'faithfulrawhighlight' => { 75 => 0x79 },
	'faithfulrawhighlightpoint' => { 75 => 0x36 },
	'faithfulrawlinear' => { 75 => 0x34 },
	'faithfulrawsaturation' => { 75 => 0x32 },
	'faithfulrawshadow' => { 75 => 0x82 },
	'faithfulrawshadowpoint' => { 75 => 0x37 },
	'faithfulrawsharpness' => { 75 => 0x35 },
	'femicroadjustment' => { 56 => 0x110 },
	'ffid' => { 270 => 'ffid' },
	'fieldcount' => { 198 => 0x103f },
	'filedatarate' => { 287 => 'fileDataRate' },
	'fileformat' => { 67 => 0x0, 87 => 0x14, 253 => 0x22, 257 => 0xb000 },
	'fileindex' => { 4 => 0x143, 7 => 0x172, 9 => [0x227,0x22c], 10 => 0x133, 11 => 0x13f, 12 => 0x1d3, 13 => [0x197,0x19b], 14 => 0x1e4, 17 => 0x3d, 18 => 0x1d9, 20 => 0x1c7 },
	'filemodifydate' => { 81 => 'FileModifyDate' },
	'filename' => { 81 => 'FileName' },
	'filenameasdelivered' => { 277 => 'FileNameAsDelivered' },
	'filenumber' => { 35 => 0x1, 40 => 0x8, 69 => 0x1817, 78 => 'FileNumber', 144 => 0x8 },
	'filenumbermemory' => { 125 => 0x1a },
	'filenumbersequence' => { 188 => '12.2', 190 => '3.1', 192 => '5.2' },
	'filesource' => { 80 => 0xa300, 84 => 0x8000, 272 => 'FileSource' },
	'fileversion' => { 87 => 0x16 },
	'fillflashautoreduction' => { 54 => 0xe, 55 => 0xe, 62 => 0xa },
	'filllight' => { 268 => 'FillLight' },
	'fillorder' => { 80 => 0x10a },
	'filmmode' => { 84 => 0x1401, 210 => 0x412, 213 => 0x42 },
	'filmtype' => { 158 => 0x2 },
	'filtereffect' => { 35 => 0xe, 155 => 0x37 },
	'filtereffectfaithful' => { 45 => 0x70, 46 => 0x70 },
	'filtereffectlandscape' => { 45 => 0x40, 46 => 0x40 },
	'filtereffectmonochrome' => { 15 => 0xff, 45 => 0x88, 46 => 0x88 },
	'filtereffectneutral' => { 45 => 0x58, 46 => 0x58 },
	'filtereffectportrait' => { 45 => 0x28, 46 => 0x28 },
	'filtereffectstandard' => { 45 => 0x10, 46 => 0x10 },
	'filtereffectunknown' => { 46 => 0xa0 },
	'filtereffectuserdef1' => { 45 => 0xa0, 46 => 0xb8 },
	'filtereffectuserdef2' => { 45 => 0xb8, 46 => 0xd0 },
	'filtereffectuserdef3' => { 45 => 0xd0, 46 => 0xe8 },
	'finderdisplayduringexposure' => { 55 => 0x1 },
	'finesharpness' => { 234 => 0x70 },
	'finetuneoptcenterweighted' => { 188 => '7.2', 192 => '9.1' },
	'finetuneoptmatrixmetering' => { 188 => '8.1', 192 => '8.2' },
	'finetuneoptspotmetering' => { 188 => '8.2', 192 => '9.2' },
	'firmware' => { 198 => 0x405, 253 => [0x17,0x3b], 266 => 'Firmware' },
	'firmwaredate' => { 76 => 0x15, 77 => 0x2001 },
	'firmwareid' => { 131 => 0x0 },
	'firmwarename' => { 251 => 0xa001 },
	'firmwarerevision' => { 15 => 0xa4, 40 => 0x1e },
	'firmwareversion' => { 4 => 0x10b, 7 => 0x136, 10 => 0xff, 11 => 0x107, 91 => 0xce5, 105 => 0x57, 107 => 'FirmwareVersion', 213 => 0x2, 214 => 0x3109, 234 => 0x230, 247 => 0x2 },
	'firstpublicationdate' => { 277 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 86 => 0x16 },
	'flash' => { 80 => 0x9209, 126 => 0x1f, 127 => 0x15 },
	'flashactivity' => { 24 => 0x1c },
	'flashbatterylevel' => { 28 => 0x249 },
	'flashbias' => { 213 => 0x24 },
	'flashbits' => { 24 => 0x1d },
	'flashchargelevel' => { 198 => 0x1010 },
	'flashcolorfilter' => { 147 => 0x10 },
	'flashcommandermode' => { 145 => '9.1', 146 => '9.1', 147 => '9.1' },
	'flashcompensation' => { 145 => 0xa, 146 => 0xa, 147 => 0xa, 266 => 'FlashCompensation' },
	'flashcontrolmode' => { 145 => '9.2', 146 => '9.2', 147 => '9.2', 193 => 0x404 },
	'flashdefault' => { 128 => 0x42 },
	'flashdevice' => { 198 => 0x1005 },
	'flashdistance' => { 77 => 0x2034 },
	'flashenergy' => { 80 => 0xa20b, 272 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 153 => 0x18 },
	'flashexposurecomp' => { 51 => 0xf, 84 => 0x1011, 110 => 'ExposureComp', 125 => 0x23, 129 => 0x104, 153 => 0x12, 193 => 0x401, 198 => 0x1023, 234 => 0x4d, 253 => 0x3a, 257 => 0x104 },
	'flashexposurecompset' => { 216 => 0xe },
	'flashexposurecompsetting' => { 128 => 0x10 },
	'flashexposureindicator' => { 128 => 0x54 },
	'flashexposureindicatorlast' => { 128 => 0x56 },
	'flashexposureindicatornext' => { 128 => 0x55 },
	'flashexposurelock' => { 35 => 0x19 },
	'flashfired' => { 93 => 0x5d, 110 => 'Fired', 125 => 0x14, 169 => '590.3', 213 => 0x8007, 272 => 'FlashFired' },
	'flashfiring' => { 56 => 0x306, 57 => 0x6, 58 => 0x7, 61 => 0x7 },
	'flashfirmwareversion' => { 194 => 0x1002 },
	'flashfocallength' => { 145 => 0xb, 146 => 0xc, 147 => 0xc },
	'flashfunction' => { 272 => 'FlashFunction' },
	'flashgndistance' => { 145 => 0xe, 146 => 0xf, 147 => 0xf },
	'flashgroupacompensation' => { 145 => 0x11, 146 => 0x12, 147 => 0x13 },
	'flashgroupacontrolmode' => { 145 => 0xf, 146 => '16.1', 147 => '17.1' },
	'flashgroupaoutput' => { 145 => 0x11, 146 => 0x12, 147 => 0x13 },
	'flashgroupbcompensation' => { 145 => 0x12, 146 => 0x13, 147 => 0x14 },
	'flashgroupbcontrolmode' => { 145 => 0x10, 146 => '17.1', 147 => '18.1' },
	'flashgroupboutput' => { 145 => 0x12, 146 => 0x13, 147 => 0x14 },
	'flashgroupccompensation' => { 146 => 0x14, 147 => 0x15 },
	'flashgroupccontrolmode' => { 146 => '17.2', 147 => '18.2' },
	'flashgroupcoutput' => { 146 => 0x14, 147 => 0x15 },
	'flashguidenumber' => { 51 => 0xd, 66 => 0x0, 110 => 'GuideNumber' },
	'flashintensity' => { 76 => [0x19,0x5], 193 => 0x405 },
	'flashlevel' => { 189 => 0x9, 257 => 0xb048 },
	'flashmake' => { 110 => 'Make' },
	'flashmanufacturer' => { 124 => 'FlashManufacturer' },
	'flashmetering' => { 125 => 0x3f, 128 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 16 => 0x15, 19 => 0x15 },
	'flashmeteringsegments' => { 234 => 0x20a },
	'flashmode' => { 76 => 0x4, 93 => 0x5c, 110 => 'Mode', 125 => 0x2, 126 => 0x20, 127 => 0x16, 128 => 0xf, 153 => 0x87, 193 => 0x400, 198 => 0x1004, 234 => 0xc, 238 => 0x4, 246 => 0x20, 252 => 0x225, 254 => 0x23, 255 => 0x23, 272 => 'FlashMode' },
	'flashmodel' => { 110 => 'Model', 124 => 'FlashModel', 194 => 0x1001 },
	'flashoptions' => { 221 => 0x2 },
	'flashoptions2' => { 221 => 0x10 },
	'flashoutput' => { 28 => 0x248, 51 => 0x21, 145 => 0xa, 146 => 0xa, 147 => 0xa },
	'flashpixversion' => { 80 => 0xa000, 272 => 'FlashpixVersion' },
	'flashredeyemode' => { 272 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 193 => 0x403 },
	'flashreturn' => { 272 => 'FlashReturn' },
	'flashserialnumber' => { 110 => 'SerialNumber', 194 => 0x1003 },
	'flashsetting' => { 153 => 0x8 },
	'flashshutterspeed' => { 188 => '20.2', 191 => '7.2', 192 => '23.1' },
	'flashsource' => { 145 => 0x4, 146 => 0x4, 147 => 0x4 },
	'flashstatus' => { 226 => 0x0 },
	'flashsyncspeed' => { 188 => '20.1' },
	'flashsyncspeedav' => { 54 => 0x3, 56 => 0x10f, 57 => 0x2, 58 => 0x3, 59 => 0x2, 60 => 0x2, 61 => 0x3, 62 => 0x6 },
	'flashthreshold' => { 66 => 0x1 },
	'flashtype' => { 110 => 'Type', 128 => 0x59, 153 => 0x9, 194 => 0x1000 },
	'flashwarning' => { 191 => '7.1', 192 => '31.1', 213 => 0x62 },
	'flickerreduce' => { 252 => 0x218 },
	'fliphorizontal' => { 181 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 7 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 18 => 0x3, 19 => 0x3, 21 => 0x5, 22 => 0x6, 51 => 0x15, 80 => 0x829d, 90 => 0xfd04, 93 => 0x1e, 95 => 0xfa23, 97 => 0xf103, 100 => 0x13, 102 => 0x3c, 105 => 0xc, 114 => 'FNumber', 125 => 0xa, 126 => 0x36, 127 => 0x47, 128 => 0x9, 234 => 0x13, 251 => 0xa019, 253 => 0x31, 272 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x9, 7 => 0x1d, 8 => 0x9, 9 => 0x1e, 10 => 0x1d, 11 => 0x1d, 12 => 0x1e, 13 => 0x1e, 14 => 0x1e, 15 => 0x28, 16 => 0x1e, 18 => 0x1e, 19 => 0x1e, 37 => 0x1, 77 => 0x1d, 80 => 0x920a, 100 => 0x1d, 114 => 'FocalLength', 125 => 0x12, 151 => 0xa, 152 => 0xb, 228 => 0x9, 234 => 0x1d, 272 => 'FocalLength' },
	'focallengthin35mmformat' => { 80 => 0xa405, 251 => 0xa01a, 272 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 194 => 0x103, 198 => 0x205 },
	'focalplaneresolutionunit' => { 80 => 0xa210, 272 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 80 => 0xa20e, 272 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 37 => 0x2 },
	'focalplanexunknown' => { 37 => 0x2 },
	'focalplaneyresolution' => { 80 => 0xa20f, 272 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 37 => 0x3 },
	'focalplaneyunknown' => { 37 => 0x3 },
	'focaltype' => { 6 => 0x2d, 37 => 0x0 },
	'focalunits' => { 24 => 0x19 },
	'focus' => { 171 => 0x8 },
	'focusarea' => { 125 => 0x31 },
	'focusareaselection' => { 191 => '15.2' },
	'focuscontinuous' => { 24 => 0x20 },
	'focusdisplayaiservoandmf' => { 56 => 0x515 },
	'focusdistance' => { 114 => 'FocusDistance', 125 => 0x13, 151 => 0x9, 152 => 0xa, 196 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 7 => 0x45, 9 => 0x56, 10 => 0x45, 11 => 0x45, 12 => 0x52, 13 => 0x52, 14 => 0x56, 16 => 0x52, 18 => 0x57, 20 => 0x32, 51 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 7 => 0x43, 9 => 0x54, 10 => 0x43, 11 => 0x43, 12 => 0x50, 13 => 0x50, 14 => 0x54, 16 => 0x50, 18 => 0x55, 20 => 0x30, 51 => 0x13 },
	'focusholdbutton' => { 128 => 0x44 },
	'focusinfoversion' => { 196 => 0x0 },
	'focusingscreen' => { 55 => 0x0, 56 => 0x80b, 61 => 0x0 },
	'focusmode' => { 24 => 0x7, 76 => 0x3, 77 => [0x3003,0xd], 84 => 0x1021, 93 => 0x38, 107 => 'FocusMode', 125 => 0x30, 127 => 0xe, 128 => 0xc, 153 => 0x7, 193 => 0x301, 198 => 0x100b, 213 => 0x7, 234 => 0xd, 238 => 0x3, 254 => 0x10, 255 => 0x10, 257 => 0xb042 },
	'focusmode2' => { 221 => '3.1' },
	'focusmodesetting' => { 189 => '10.1' },
	'focusmodeswitch' => { 128 => 0x58 },
	'focuspixel' => { 84 => 0x1023 },
	'focuspointwrap' => { 188 => '2.2', 192 => '2.5' },
	'focusposition' => { 151 => 0x8, 152 => 0x8, 234 => 0x10 },
	'focusprocess' => { 193 => 0x302 },
	'focusrange' => { 24 => 0x12, 198 => 0x100a },
	'focussetting' => { 253 => 0x6 },
	'focusstepcount' => { 196 => 0x301, 198 => 0x100e },
	'focusstepinfinity' => { 196 => 0x303, 198 => 0x103b },
	'focusstepnear' => { 196 => 0x304, 198 => 0x103c },
	'focustrackinglockon' => { 188 => ['1.5','4.1'] },
	'focuswarning' => { 84 => 0x1301 },
	'foldername' => { 125 => 0x27 },
	'fontcomposite' => { 292 => 'FontsComposite' },
	'fontface' => { 292 => 'FontsFontFace' },
	'fontfamily' => { 292 => 'FontsFontFamily' },
	'fontfilename' => { 292 => 'FontsFontFileName' },
	'fontname' => { 292 => 'FontsFontName' },
	'fonttype' => { 292 => 'FontsFontType' },
	'fontversion' => { 292 => 'FontsVersionString' },
	'for' => { 245 => 'For' },
	'format' => { 269 => 'format' },
	'forwardlock' => { 282 => 'forwardlock' },
	'forwardmatrix1' => { 80 => 0xc714 },
	'forwardmatrix2' => { 80 => 0xc715 },
	'framecount' => { 43 => [0x2,0x4] },
	'framenum' => { 240 => 0xd7 },
	'framenumber' => { 84 => 0x8003, 234 => 0x29 },
	'framerate' => { 43 => [0x1,0x6] },
	'frameselector' => { 212 => '0.1' },
	'freebytes' => { 69 => 0x1 },
	'freememorycardimages' => { 126 => [0x37,0x54], 127 => [0x2d,0x4a], 128 => 0x32 },
	'fujiflashmode' => { 84 => 0x1010 },
	'fullimagesize' => { 257 => 0xb02b },
	'fullsizeimage' => { 113 => 'data' },
	'fullsizeimagename' => { 113 => '1Name' },
	'fullsizeimagetype' => { 113 => '0Type' },
	'funcbutton' => { 188 => ['14.1','15.1'], 192 => '14.1' },
	'funcbuttonplusdials' => { 188 => ['14.2','15.2'] },
	'functionbutton' => { 191 => '5.2' },
	'gainbase' => { 197 => 0x610 },
	'gaincontrol' => { 80 => 0xa407, 272 => 'GainControl' },
	'gamma' => { 80 => 0xa500 },
	'gammacompensatedvalue' => { 88 => 0x91 },
	'genre' => { 278 => 'genre', 287 => 'genre' },
	'geography' => { 279 => 'geography' },
	'geosync' => { 81 => 'Geosync' },
	'geotag' => { 81 => 'Geotag' },
	'geotime' => { 81 => 'Geotime' },
	'globalaltitude' => { 243 => 0x419 },
	'globalangle' => { 243 => 0x40d },
	'good' => { 287 => 'good' },
	'gpsaltitude' => { 85 => 0x6, 111 => 'Altitude', 272 => 'GPSAltitude' },
	'gpsaltituderef' => { 85 => 0x5, 272 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 85 => 0x1c, 272 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 85 => 0x1d },
	'gpsdatetime' => { 111 => 'DateTime', 272 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 85 => 0x18, 111 => 'Bearing', 272 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 85 => 0x17, 272 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 85 => 0x1a, 111 => 'Distance', 272 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 85 => 0x19, 272 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 85 => 0x14, 272 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 85 => 0x13 },
	'gpsdestlongitude' => { 85 => 0x16, 272 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 85 => 0x15 },
	'gpsdifferential' => { 85 => 0x1e, 111 => 'Differential', 272 => 'GPSDifferential' },
	'gpsdop' => { 85 => 0xb, 272 => 'GPSDOP' },
	'gpshpositioningerror' => { 85 => 0x1f },
	'gpsimgdirection' => { 85 => 0x11, 272 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 85 => 0x10, 272 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 85 => 0x2, 111 => 'Latitude', 272 => 'GPSLatitude' },
	'gpslatituderef' => { 85 => 0x1 },
	'gpslongitude' => { 85 => 0x4, 111 => 'Longitude', 272 => 'GPSLongitude' },
	'gpslongituderef' => { 85 => 0x3 },
	'gpsmapdatum' => { 85 => 0x12, 111 => 'Datum', 272 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 85 => 0xa, 111 => 'MeasureMode', 272 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 85 => 0x1b, 272 => 'GPSProcessingMethod' },
	'gpssatellites' => { 85 => 0x8, 111 => 'Satellites', 272 => 'GPSSatellites' },
	'gpsspeed' => { 85 => 0xd, 111 => 'Speed', 272 => 'GPSSpeed' },
	'gpsspeedref' => { 85 => 0xc, 272 => 'GPSSpeedRef' },
	'gpsstatus' => { 85 => 0x9, 272 => 'GPSStatus' },
	'gpstimestamp' => { 85 => 0x7 },
	'gpstrack' => { 85 => 0xf, 111 => 'Heading', 272 => 'GPSTrack' },
	'gpstrackref' => { 85 => 0xe, 272 => 'GPSTrackRef' },
	'gpsversionid' => { 85 => 0x0, 272 => 'GPSVersionID' },
	'gradation' => { 193 => 0x50f },
	'graymixeraqua' => { 268 => 'GrayMixerAqua' },
	'graymixerblue' => { 268 => 'GrayMixerBlue' },
	'graymixergreen' => { 268 => 'GrayMixerGreen' },
	'graymixermagenta' => { 268 => 'GrayMixerMagenta' },
	'graymixerorange' => { 268 => 'GrayMixerOrange' },
	'graymixerpurple' => { 268 => 'GrayMixerPurple' },
	'graymixerred' => { 268 => 'GrayMixerRed' },
	'graymixeryellow' => { 268 => 'GrayMixerYellow' },
	'graypoint' => { 260 => 0x8021 },
	'grayresponseunit' => { 80 => 0x122 },
	'greencurvelimits' => { 74 => 0x1c4 },
	'greencurvepoints' => { 74 => 0x19a },
	'greenhue' => { 268 => 'GreenHue' },
	'greensaturation' => { 268 => 'GreenSaturation' },
	'griddisplay' => { 188 => '13.3', 190 => '2.2', 191 => '6.1', 192 => '4.2' },
	'gripbatteryadload' => { 219 => 0x5 },
	'gripbatteryadnoload' => { 219 => 0x4 },
	'gripbatterystate' => { 219 => '1.2' },
	'halftonehints' => { 80 => 0x141 },
	'hasalternative' => { 278 => 'hasAlternative' },
	'hascorrection' => { 278 => 'hasCorrection' },
	'hascrop' => { 268 => 'HasCrop' },
	'hasextendedxmp' => { 289 => 'HasExtendedXMP' },
	'haspreviousversion' => { 278 => 'hasPreviousVersion' },
	'hassettings' => { 268 => 'HasSettings' },
	'hastranslation' => { 278 => 'hasTranslation' },
	'hdr' => { 257 => 0x200a },
	'headline' => { 86 => 0x69, 276 => 'Headline' },
	'hierarchicalsubject' => { 263 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 12 => 0xbc, 13 => 0xbd, 16 => 0xbd, 20 => 0xa5, 56 => 0x202, 153 => 0xb1, 234 => 0x71, 254 => 0x2c },
	'highlight' => { 253 => 0xf },
	'highlightcolordistortreduct' => { 260 => 0x8026 },
	'highlightprotection' => { 180 => 0x6 },
	'highlightrecovery' => { 268 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 12 => 0x7, 13 => 0x7, 14 => 0x7, 16 => 0x7, 19 => 0x7, 56 => 0x203 },
	'highlowkeyadj' => { 234 => 0x6c },
	'highspeedsync' => { 128 => 0x5 },
	'history' => { 276 => 'History' },
	'historyaction' => { 288 => 'HistoryAction' },
	'historychanged' => { 288 => 'HistoryChanged' },
	'historyinstanceid' => { 288 => 'HistoryInstanceID' },
	'historyparameters' => { 288 => 'HistoryParameters' },
	'historysoftwareagent' => { 288 => 'HistorySoftwareAgent' },
	'historywhen' => { 288 => 'HistoryWhen' },
	'hometowncity' => { 77 => 0x3006, 234 => 0x23, 237 => 0x2 },
	'hometowncitycode' => { 238 => 0x1000 },
	'hometowndst' => { 234 => 0x25, 237 => '0.2' },
	'hostcomputer' => { 80 => 0x13c },
	'hue' => { 132 => 0x3b, 234 => 0x67 },
	'hueadj' => { 184 => 0x2f, 260 => 0x8019 },
	'hueadjustment' => { 126 => 0x4a, 127 => 0x40, 153 => 0x92, 155 => 0x36 },
	'hueadjustmentaqua' => { 268 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 268 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 268 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 268 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 268 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 268 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 268 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 268 => 'HueAdjustmentYellow' },
	'huesetting' => { 201 => 0x1011 },
	'icc_profile' => { 81 => 'ICC_Profile' },
	'iccprofilename' => { 276 => 'ICCProfile' },
	'idccreativestyle' => { 260 => 0x8000 },
	'idcpreviewlength' => { 260 => 0x202 },
	'idcpreviewstart' => { 260 => 0x201 },
	'identifier' => { 269 => 'identifier', 285 => 'Identifier' },
	'illumination' => { 191 => '0.5' },
	'imageadjustment' => { 153 => 0x80, 171 => 0x5 },
	'imagealterationconstraints' => { 277 => 'ImageAlterationConstraints' },
	'imagearea' => { 163 => 0x10, 166 => 0x10 },
	'imageareaoffset' => { 234 => 0x38 },
	'imageauthentication' => { 153 => 0x20 },
	'imageboundary' => { 153 => 0x16 },
	'imagecount' => { 153 => 0xa5 },
	'imagecreatorid' => { 277 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 277 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 277 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 153 => 0xa2 },
	'imagedescription' => { 80 => 0x10e, 283 => 'ImageDescription' },
	'imageduplicationconstraints' => { 277 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 181 => 0xfe443a45 },
	'imageeditcount' => { 234 => 0x41 },
	'imageediting' => { 234 => 0x32 },
	'imagefileconstraints' => { 277 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 277 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 277 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 80 => 0x101, 131 => 0xc, 283 => 'ImageLength' },
	'imagehistory' => { 80 => 0x9213 },
	'imageidnumber' => { 208 => 0x340 },
	'imagenumber' => { 15 => 0xd0, 80 => 0x9211, 107 => 'ImageNumber', 126 => 0xae, 127 => 0x5e, 266 => 'ImageNumber' },
	'imagenumber2' => { 127 => 0x62 },
	'imageoptimization' => { 153 => 0xa9 },
	'imageorientation' => { 86 => 0x83 },
	'imageprocessing' => { 153 => 0x1a },
	'imageprocessingversion' => { 197 => 0x0 },
	'imagequality' => { 107 => 'ImageQuality', 165 => '723.2', 166 => '732.2', 169 => '708.1', 213 => 0x1 },
	'imagequality2' => { 193 => 0x603 },
	'imagereview' => { 189 => '0.4', 191 => '0.4' },
	'imagereviewtime' => { 189 => '2.1', 190 => '19.1', 192 => '21.2' },
	'imagesize' => { 113 => 'ImageSize' },
	'imagesizerestriction' => { 280 => 'imageSizeRestriction' },
	'imagesourcedata' => { 80 => 0x935c },
	'imagestabilization' => { 24 => 0x22, 77 => 0x3020, 107 => 'ImageStabilization', 126 => 0xbd, 127 => 0x71, 128 => 0x57, 129 => [0x18,0x107,0x113], 153 => 0xac, 193 => 0x604, 196 => 0x1600, 213 => 0x1a, 254 => 0x3d, 257 => 0xb026 },
	'imagestyle' => { 254 => 0x2d },
	'imagesupplierid' => { 277 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 277 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 277 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 234 => 0x4f },
	'imagetype' => { 86 => 0x82, 277 => 'ImageType' },
	'imageuniqueid' => { 40 => 0x28, 80 => 0xa420, 272 => 'ImageUniqueID' },
	'imagewidth' => { 80 => 0x100, 131 => 0xe, 283 => 'ImageWidth' },
	'incrementaltemperature' => { 268 => 'IncrementalTemperature' },
	'incrementaltint' => { 268 => 'IncrementalTint' },
	'industry' => { 278 => 'industry', 279 => 'industry' },
	'infobuttonwhenshooting' => { 56 => 0x409 },
	'ingredientsalternatepaths' => { 288 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 288 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 288 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 288 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 288 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 288 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 288 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 288 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 288 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 288 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 288 => 'IngredientsMaskMarkers' },
	'ingredientsoriginaldocumentid' => { 288 => 'IngredientsOriginalDocumentID' },
	'ingredientspartmapping' => { 288 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 288 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 288 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 288 => 'IngredientsToPart' },
	'ingredientsversionid' => { 288 => 'IngredientsVersionID' },
	'initialzoomliveview' => { 188 => '4.4' },
	'initialzoomsetting' => { 188 => '9.3' },
	'inkset' => { 80 => 0x14c },
	'instanceid' => { 288 => 'InstanceID' },
	'instantplaybacksetup' => { 128 => 0x3e },
	'instantplaybacktime' => { 128 => 0x3d },
	'instructions' => { 276 => 'Instructions' },
	'instrument' => { 287 => 'instrument' },
	'intellectualgenre' => { 273 => 'IntellectualGenre' },
	'intelligentauto' => { 257 => 0xb052 },
	'intelligentd-range' => { 213 => 0x79 },
	'intelligentexposure' => { 213 => 0x5d },
	'intelligentresolution' => { 213 => 0x70 },
	'interchangecolorspace' => { 88 => 0x40 },
	'internalflash' => { 125 => 0x2b, 188 => '23.1', 189 => '8.1', 190 => '22.1', 191 => '8.1', 192 => '24.1', 196 => 0x1208 },
	'internalflashae1' => { 198 => 0x1021 },
	'internalflashae1_0' => { 198 => 0x101d },
	'internalflashae2' => { 198 => 0x1022 },
	'internalflashae2_0' => { 198 => 0x101e },
	'internalflashmode' => { 226 => 0x1 },
	'internalflashstrength' => { 226 => 0x3 },
	'internalflashtable' => { 198 => 0x1024 },
	'internalserialnumber' => { 40 => 0x96, 50 => 0x9, 84 => 0x10, 130 => 0x49dc, 194 => 0x102, 213 => 0x25, 220 => 0x4, 247 => 0x5 },
	'interopindex' => { 80 => 0x1 },
	'interopversion' => { 80 => 0x2 },
	'intervallength' => { 125 => 0x10 },
	'intervalmode' => { 125 => 0x26 },
	'intervalnumber' => { 125 => 0x11 },
	'introtimescale' => { 287 => 'introTimeScale' },
	'introtimevalue' => { 287 => 'introTimeValue' },
	'iptc-naa' => { 80 => 0x83bb, 215 => 0x83bb },
	'iptcbitspersample' => { 88 => 0x56 },
	'iptcdigest' => { 243 => 0x425 },
	'iptcimageheight' => { 88 => 0x1e },
	'iptcimagerotation' => { 88 => 0x66 },
	'iptcimagewidth' => { 88 => 0x14 },
	'iptclastedited' => { 274 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 88 => 0xa },
	'iptcpixelheight' => { 88 => 0x32 },
	'iptcpixelwidth' => { 88 => 0x28 },
	'isbn' => { 278 => 'isbn' },
	'iscorrectionof' => { 278 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 75 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x75, 7 => 0x6, 8 => 0x79, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 18 => 0x6, 19 => 0x6, 21 => 0x0, 22 => 0x1, 76 => 0x14, 77 => [0x3014,0x14], 80 => 0x8827, 90 => 0xfd06, 91 => 0x1784, 93 => 0x60, 95 => [0xfa2e,0xfa46], 96 => [0x27,0x28], 97 => 0xf105, 100 => 0x14, 102 => 0x4e, 105 => 0x34, 107 => 'ISO', 125 => 0x8, 149 => 0x0, 153 => 0x2, 215 => 0x17, 234 => 0x14, 238 => 0x14, 251 => 0xa014, 272 => 'ISOSpeedRatings' },
	'iso2' => { 149 => 0x6, 160 => 0x265, 161 => 0x25c, 162 => 0x265, 163 => 0x221, 164 => 0x25d, 165 => 0x256, 166 => 0x25d, 168 => 0x2b5, 170 => 0x2b5 },
	'isoauto' => { 221 => '14.4' },
	'isoautoparameters' => { 234 => 0x7a },
	'isodisplay' => { 190 => '2.3', 192 => '4.3' },
	'isoexpansion' => { 56 => 0x103, 57 => 0x7, 58 => 0x8, 61 => 0x8, 149 => 0x4 },
	'isoexpansion2' => { 149 => 0xa },
	'isofloor' => { 221 => 0x6 },
	'isoselection' => { 153 => 0xf },
	'isosetting' => { 93 => 0x5e, 107 => 'ISOSetting', 125 => 0x24, 126 => 0x26, 127 => 0x1c, 128 => 0x13, 132 => 0x6, 153 => 0x13, 221 => '17.3', 246 => 0x27, 254 => 0x16, 255 => 0x14 },
	'isospeed' => { 80 => 0x8833 },
	'isospeedexpansion' => { 55 => 0x3 },
	'isospeedincrements' => { 56 => 0x102 },
	'isospeedlatitudeyyy' => { 80 => 0x8834 },
	'isospeedlatitudezzz' => { 80 => 0x8835 },
	'isospeedrange' => { 56 => 0x103 },
	'isostepsize' => { 188 => '6.1' },
	'isovalue' => { 198 => 0x1001 },
	'issn' => { 278 => 'issn' },
	'issueidentifier' => { 278 => 'issueIdentifier' },
	'issuename' => { 278 => 'issueName' },
	'istranslationof' => { 278 => 'isTranslationOf' },
	'jobid' => { 86 => 0xb8 },
	'jobrefid' => { 286 => 'JobRefId' },
	'jobrefname' => { 286 => 'JobRefName' },
	'jobrefurl' => { 286 => 'JobRefUrl' },
	'jpegquality' => { 6 => 0x66, 214 => 0x3034 },
	'jpegsize' => { 214 => 0x303a },
	'jpgfromraw' => { 69 => 0x2007, 78 => 'JpgFromRaw', 215 => 0x2e },
	'jpgfromrawlength' => { 80 => [0x117,0x202] },
	'jpgfromrawstart' => { 80 => [0x111,0x201] },
	'jpgrecordedpixels' => { 221 => '14.1' },
	'key' => { 287 => 'key' },
	'keyword' => { 278 => 'keyword' },
	'keywords' => { 86 => 0x19, 108 => 'Keywords', 202 => 'Keywords', 245 => 'Keywords', 265 => 'keywords', 275 => 'Keywords' },
	'killdate' => { 278 => 'killDate' },
	'kodakimageheight' => { 90 => 0xf908, 93 => 0xe, 95 => [0xfa1e,0xfa52], 101 => 0x70 },
	'kodakimagewidth' => { 90 => 0xf907, 93 => 0xc, 95 => [0xfa1d,0xfa51], 101 => 0x6c },
	'kodakinfotype' => { 90 => 0xfa00 },
	'kodakmaker' => { 101 => 0x8 },
	'kodakmodel' => { 93 => 0x0, 101 => 0x28 },
	'label' => { 204 => 'Label', 285 => 'Label' },
	'landmark' => { 213 => 0x6f },
	'landscapeoutputhighlightpoint' => { 75 => 0x26 },
	'landscapeoutputshadowpoint' => { 75 => 0x27 },
	'landscaperawcolortone' => { 75 => 0x1f },
	'landscaperawcontrast' => { 75 => 0x21 },
	'landscaperawhighlight' => { 75 => 0x77 },
	'landscaperawhighlightpoint' => { 75 => 0x24 },
	'landscaperawlinear' => { 75 => 0x22 },
	'landscaperawsaturation' => { 75 => 0x20 },
	'landscaperawshadow' => { 75 => 0x80 },
	'landscaperawshadowpoint' => { 75 => 0x25 },
	'landscaperawsharpness' => { 75 => 0x23 },
	'language' => { 269 => 'language' },
	'languageidentifier' => { 86 => 0x87 },
	'lastfilenumber' => { 125 => 0x1b },
	'lastkeywordiptc' => { 124 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 124 => 'LastKeywordXMP' },
	'lasturl' => { 288 => 'LastURL' },
	'lc1' => { 228 => 0x2 },
	'lc10' => { 228 => 0xb },
	'lc11' => { 228 => 0xc },
	'lc12' => { 228 => 0xd },
	'lc14' => { 228 => 0xf },
	'lc15' => { 228 => 0x10 },
	'lc2' => { 228 => 0x3 },
	'lc3' => { 228 => 0x4 },
	'lc4' => { 228 => 0x5 },
	'lc5' => { 228 => 0x6 },
	'lc6' => { 228 => 0x7 },
	'lc7' => { 228 => 0x8 },
	'lcddisplayatpoweron' => { 56 => 0x811, 60 => 0xa },
	'lcddisplayreturntoshoot' => { 61 => 0x12 },
	'lcdillumination' => { 188 => '17.5', 192 => '5.4' },
	'lcdilluminationduringbulb' => { 56 => 0x408 },
	'lcdpanels' => { 55 => 0x8 },
	'lcheditor' => { 181 => 0x8ae85e },
	'legacyiptcdigest' => { 276 => 'LegacyIPTCDigest' },
	'lens' => { 80 => 0xfdea, 153 => 0x84, 266 => 'Lens' },
	'lensafstopbutton' => { 54 => 0x11, 55 => 0x13, 56 => 0x506, 57 => 0x10, 58 => 0x12, 61 => 0x13, 62 => 0x9 },
	'lensaperturerange' => { 253 => 0x30 },
	'lensdistortionparams' => { 198 => 0x206 },
	'lensdrivenoaf' => { 56 => 0x505 },
	'lensfirmware' => { 248 => 0x20 },
	'lensfirmwareversion' => { 194 => 0x204 },
	'lensfocalrange' => { 253 => 0xa },
	'lensfstops' => { 150 => 0x7, 151 => 0xc, 152 => 0xd, 153 => 0x8b, 228 => '0.3' },
	'lensid' => { 266 => 'LensID' },
	'lensidnumber' => { 150 => 0x6, 151 => 0xb, 152 => 0xc },
	'lensinfo' => { 80 => 0xa432, 266 => 'LensInfo' },
	'lenskind' => { 228 => 0x1 },
	'lensmake' => { 80 => 0xa433, 114 => 'Make' },
	'lensmanufacturer' => { 124 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 10 => 0x92b, 11 => 0x933, 40 => 0x95, 80 => 0xa434, 114 => 'Model', 124 => 'LensModel', 194 => 0x203 },
	'lensproperties' => { 194 => 0x20b },
	'lensserialnumber' => { 38 => 0x0, 80 => 0xa435, 114 => 'SerialNumber', 194 => 0x202, 213 => 0x52, 248 => 0x30 },
	'lensshutterlock' => { 128 => 0x4a },
	'lenstemperature' => { 198 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0xc, 7 => 0x111, 8 => 0xc, 9 => [0x14e,0x14f], 10 => 0xd6, 11 => 0xde, 12 => 0xf6, 13 => 0xea, 14 => 0xff, 15 => [0xc,0x97], 16 => 0xe6, 18 => 0xe8, 20 => 0xee, 24 => 0x16, 129 => 0x10c, 153 => 0x83, 194 => 0x201, 205 => 0x16, 211 => 0x303, 212 => 0x0, 213 => 0x51, 214 => 0x3405, 229 => 0x0, 230 => 0x0, 231 => 0x1, 232 => 0x1, 234 => 0x3f, 251 => 0xa003, 257 => 0xb027 },
	'levelgaugepitch' => { 193 => 0x904 },
	'levelgaugeroll' => { 193 => 0x903 },
	'levelorientation' => { 233 => 0x0 },
	'license' => { 267 => 'license' },
	'licenseeid' => { 277 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 277 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 277 => 'LicenseeImageNotes' },
	'licenseename' => { 277 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 277 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 277 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 277 => 'LicenseeTransactionID' },
	'licenseid' => { 277 => 'LicenseID' },
	'licensestartdate' => { 277 => 'LicenseStartDate' },
	'licensetransactiondate' => { 277 => 'LicenseTransactionDate' },
	'licensetype' => { 270 => 'licensetype' },
	'licensorcity' => { 277 => 'LicensorLicensorCity' },
	'licensorcountry' => { 277 => 'LicensorLicensorCountry' },
	'licensoremail' => { 277 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 277 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 277 => 'LicensorLicensorID' },
	'licensorimageid' => { 277 => 'LicensorImageID' },
	'licensorname' => { 277 => 'LicensorLicensorName' },
	'licensornotes' => { 277 => 'LicensorNotes' },
	'licensorpostalcode' => { 277 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 277 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 277 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 277 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 277 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 277 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 277 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 277 => 'LicensorTransactionID' },
	'licensorurl' => { 277 => 'LicensorLicensorURL' },
	'lightcondition' => { 198 => 0x1009 },
	'lightingmode' => { 77 => 0x302a },
	'lightreading' => { 234 => 0x15 },
	'lightsource' => { 80 => 0x9208, 153 => 0x90, 201 => 0x1000, 272 => 'LightSource' },
	'lightsourcespecial' => { 252 => 0x21d },
	'lightswitch' => { 192 => '0.1' },
	'lightvaluecenter' => { 198 => 0x103d },
	'lightvalueperiphery' => { 198 => 0x103e },
	'linearresponselimit' => { 80 => 0xc62e },
	'linkaetoafpoint' => { 221 => '14.2' },
	'liveviewaf' => { 190 => '32.1', 192 => '34.1' },
	'liveviewexposuresimulation' => { 56 => 0x810 },
	'liveviewshooting' => { 35 => 0x13 },
	'localafareapoint' => { 128 => 0xd, 254 => 0x12, 255 => 0x12 },
	'localcaption' => { 86 => 0x79 },
	'localizedcameramodel' => { 80 => 0xc615 },
	'location' => { 213 => 0x67, 264 => 'Location', 273 => 'Location', 278 => 'location' },
	'locationcreatedcity' => { 274 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 274 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 274 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 274 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 274 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 274 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 274 => 'LocationShownCity' },
	'locationshowncountrycode' => { 274 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 274 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 274 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 274 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 274 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 56 => 0x709 },
	'logcomment' => { 287 => 'logComment' },
	'longexposurenoisereduction' => { 56 => 0x201, 57 => 0x1, 58 => 0x2, 59 => 0x1, 60 => 0x1, 61 => 0x2, 62 => 0x1, 254 => 0x2b, 257 => 0xb04e },
	'longexposurenoisereduction2' => { 35 => 0x8 },
	'longfocal' => { 5 => 0x10, 6 => 0x13, 7 => 0x115, 8 => 0x13, 9 => [0x152,0x153], 10 => 0xda, 12 => 0xfa, 13 => 0xee, 14 => 0x103, 15 => 0x95, 16 => 0xea, 18 => 0xec, 20 => 0xf2, 24 => 0x17 },
	'loop' => { 287 => 'loop' },
	'luminanceadjustmentaqua' => { 268 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 268 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 268 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 268 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 268 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 268 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 268 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 268 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 74 => 0x150 },
	'luminancecurvepoints' => { 74 => 0x126 },
	'luminancenoisereduction' => { 75 => 0x5f, 253 => 0x1b },
	'luminancenr_tiff_jpeg' => { 75 => 0x6d },
	'luminancesmoothing' => { 268 => 'LuminanceSmoothing' },
	'm16cversion' => { 208 => 0x333 },
	'macro' => { 84 => 0x1020, 198 => 0x202, 246 => 0x21, 252 => 0x202, 257 => 0xb040 },
	'macromagnification' => { 4 => 0x1b, 7 => 0x1b, 10 => 0x1b, 11 => 0x1b, 15 => 0x1b, 16 => 0x1b, 35 => 0x10 },
	'macromode' => { 24 => 0x1, 125 => 0xb, 193 => 0x300, 213 => 0x1c },
	'magicfilter' => { 193 => 0x52c },
	'magnifiedview' => { 58 => 0x11, 60 => 0x9 },
	'maindialexposurecomp' => { 191 => '0.6' },
	'make' => { 70 => 0x0, 80 => 0x10f, 107 => 'Make', 204 => 'Make', 215 => 0x10f, 283 => 'Make' },
	'makernote' => { 272 => 'MakerNote' },
	'makernotecanon' => { 79 => 'MakN', 80 => 0x927c },
	'makernotecasio' => { 79 => 'MakN', 80 => 0x927c },
	'makernotecasio2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotefujifilm' => { 79 => 'MakN', 80 => 0x927c },
	'makernotehp' => { 79 => 'MakN', 80 => 0x927c },
	'makernotehp2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotehp4' => { 79 => 'MakN', 80 => 0x927c },
	'makernotehp6' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteisl' => { 79 => 'MakN', 80 => 0x927c },
	'makernotejvc' => { 79 => 'MakN', 80 => 0x927c },
	'makernotejvctext' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak10' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak1a' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak1b' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak3' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak4' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak5' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak6a' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak6b' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak7' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak8a' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak8b' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodak9' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekodakunknown' => { 79 => 'MakN', 80 => 0x927c },
	'makernotekyocera' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica2' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica3' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica4' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica5' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteleica6' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteminolta' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteminolta2' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteminolta3' => { 79 => 'MakN', 80 => 0x927c },
	'makernotenikon' => { 79 => 'MakN', 80 => 0x927c },
	'makernotenikon2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotenikon3' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteoffset' => { 252 => 0xff },
	'makernoteolympus' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteolympus2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepanasonic' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepanasonic2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepentax' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepentax2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepentax3' => { 79 => 'MakN', 80 => 0x927c },
	'makernotepentax4' => { 79 => 'MakN', 80 => 0x927c },
	'makernotericoh' => { 79 => 'MakN', 80 => 0x927c },
	'makernotericohtext' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesafety' => { 80 => 0xc635 },
	'makernotesamsung1a' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesamsung1b' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesamsung2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesanyo' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesanyoc4' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesanyopatch' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesigma' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesony' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesony2' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesony3' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesony4' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesonyericsson' => { 79 => 'MakN', 80 => 0x927c },
	'makernotesonysrf' => { 79 => 'MakN', 80 => 0x927c },
	'makernotetype' => { 247 => 0x1 },
	'makernoteunknown' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteunknowntext' => { 79 => 'MakN', 80 => 0x927c },
	'makernoteversion' => { 129 => 0x0, 153 => 0x1, 198 => 0x0, 213 => 0x8000, 250 => 0x0, 251 => 0x1, 253 => 0x1d, 256 => 0x2000 },
	'managedfromalternatepaths' => { 288 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 288 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 288 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 288 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 288 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 288 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 288 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 288 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 288 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 288 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 288 => 'ManagedFromMaskMarkers' },
	'managedfromoriginaldocumentid' => { 288 => 'ManagedFromOriginalDocumentID' },
	'managedfrompartmapping' => { 288 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 288 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 288 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 288 => 'ManagedFromToPart' },
	'managedfromversionid' => { 288 => 'ManagedFromVersionID' },
	'manager' => { 288 => 'Manager' },
	'managervariant' => { 288 => 'ManagerVariant' },
	'manageto' => { 288 => 'ManageTo' },
	'manageui' => { 288 => 'ManageUI' },
	'manometerpressure' => { 193 => 0x900 },
	'manometerreading' => { 193 => 0x901 },
	'manualafpointselectpattern' => { 56 => 0x513 },
	'manualexposuretime' => { 128 => 0x6 },
	'manualflash' => { 196 => 0x1209 },
	'manualflashoutput' => { 24 => 0x29, 189 => '8.2', 190 => '22.2', 191 => '8.2', 192 => '24.2' },
	'manualflashstrength' => { 193 => 0x406 },
	'manualfnumber' => { 128 => 0x7 },
	'manualfocusdistance' => { 153 => 0x85, 198 => 0x100c, 252 => 0x223 },
	'manualtv' => { 55 => 0x5, 56 => 0x705 },
	'manufacturedate' => { 220 => 0x1 },
	'manufacturedate1' => { 249 => 0x4 },
	'manufacturedate2' => { 249 => 0x5 },
	'marked' => { 275 => 'Marked', 291 => 'Marked' },
	'markerscomment' => { 287 => 'markersComment' },
	'markerscuepointparamskey' => { 287 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 287 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 287 => 'markersCuePointType' },
	'markersduration' => { 287 => 'markersDuration' },
	'markerslocation' => { 287 => 'markersLocation' },
	'markersname' => { 287 => 'markersName' },
	'markersprobability' => { 287 => 'markersProbability' },
	'markersspeaker' => { 287 => 'markersSpeaker' },
	'markersstarttime' => { 287 => 'markersStartTime' },
	'markerstarget' => { 287 => 'markersTarget' },
	'markerstype' => { 287 => 'markersType' },
	'maskedareas' => { 80 => 0xc68e },
	'masterdocumentid' => { 86 => 0xb9 },
	'mastergain' => { 158 => 0x50 },
	'maxaperture' => { 24 => 0x1a, 97 => 0x6103, 114 => 'MaxAperture', 125 => 0x17, 228 => '14.1' },
	'maxapertureatcurrentfocal' => { 194 => 0x20a },
	'maxapertureatmaxfocal' => { 84 => 0x1407, 114 => 'MaxApertureAtMaxFocal', 150 => 0xb, 151 => 0x10, 152 => 0x11, 194 => 0x206 },
	'maxapertureatminfocal' => { 84 => 0x1406, 150 => 0xa, 151 => 0xf, 152 => 0x10, 194 => 0x205 },
	'maxaperturevalue' => { 80 => 0x9205, 272 => 'MaxApertureValue' },
	'maxavailheight' => { 274 => 'MaxAvailHeight' },
	'maxavailwidth' => { 274 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 188 => 0xb },
	'maxfocallength' => { 84 => 0x1405, 114 => 'MaxFocalLength', 150 => 0x9, 151 => 0xe, 152 => 0xf, 194 => 0x208 },
	'maximumdensityrange' => { 88 => 0x8c },
	'maxpagesizeh' => { 292 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 292 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 292 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 80 => 0x119 },
	'maxstorage' => { 282 => 'maxstorage' },
	'mb-d10batteries' => { 188 => '12.6' },
	'mb-d80batteries' => { 191 => '6.5' },
	'mb-d80batterytype' => { 192 => '3.2' },
	'mcuversion' => { 150 => 0xc, 151 => 0x11, 152 => 0x12 },
	'md5digest' => { 115 => 'zmd5' },
	'measuredev' => { 19 => 0x9, 51 => 0x3, 69 => 0x1814, 107 => 'MeasuredEV' },
	'measuredev2' => { 9 => 0x8, 19 => 0x8, 51 => 0x17 },
	'measuredev3' => { 9 => 0x9 },
	'measuredlv' => { 208 => 0x312, 214 => 0x3407 },
	'measuredrggb' => { 41 => 0x1 },
	'measuredrggbdata' => { 28 => 0x287 },
	'mediaconstraints' => { 277 => 'MediaConstraints' },
	'mediasummarycode' => { 277 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 54 => 0xb, 57 => 0xa, 58 => 0xb, 61 => 0xb },
	'menubuttonreturn' => { 62 => 0xb },
	'menumonitorofftime' => { 192 => '22.1' },
	'metadatadate' => { 285 => 'MetadataDate' },
	'metadatamoddate' => { 287 => 'metadataModDate' },
	'metering' => { 189 => '6.1' },
	'meteringmode' => { 24 => 0x11, 80 => 0x9207, 93 => 0x1c, 125 => 0x7, 126 => 0x25, 128 => 0x12, 193 => 0x202, 234 => 0x17, 253 => 0x9, 254 => 0x15, 255 => 0x13, 272 => 'MeteringMode' },
	'meteringmode2' => { 221 => '2.1' },
	'meteringmode3' => { 221 => '16.1' },
	'meteringoffscaleindicator' => { 128 => 0x53 },
	'meteringtime' => { 188 => '22.2', 189 => '3.2', 190 => '17.1', 191 => '3.2', 192 => '19.1' },
	'mieversion' => { 115 => '0Vers' },
	'minaperture' => { 24 => 0x1b, 114 => 'MinAperture', 228 => '0.2' },
	'minfocallength' => { 84 => 0x1404, 114 => 'MinFocalLength', 150 => 0x8, 151 => 0xd, 152 => 0xe, 194 => 0x207 },
	'minoltadate' => { 125 => 0x15 },
	'minoltaimagesize' => { 125 => 0x4, 126 => 0xc, 127 => 0x2, 129 => 0x103 },
	'minoltamodelid' => { 125 => 0x25 },
	'minoltaquality' => { 125 => 0x5, 126 => 0xd, 127 => 0x3, 129 => [0x102,0x103] },
	'minoltatime' => { 125 => 0x16 },
	'minormodelagedisclosure' => { 277 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 80 => 0x118 },
	'mirrorlockup' => { 54 => 0xc, 55 => 0xc, 56 => 0x60f, 57 => 0xb, 58 => 0xc, 59 => 0x6, 60 => 0x6, 61 => 0xc, 62 => 0x3 },
	'moddate' => { 204 => 'modify-date', 275 => 'ModDate' },
	'model' => { 70 => 0x6, 80 => 0x110, 107 => 'Model', 204 => 'Model', 215 => 0x110, 283 => 'Model' },
	'modelage' => { 274 => 'ModelAge' },
	'modelingflash' => { 188 => '21.4', 191 => '7.4', 192 => '31.3' },
	'modelreleaseid' => { 277 => 'ModelReleaseID' },
	'modelreleasestatus' => { 277 => 'ModelReleaseStatus' },
	'modificationdate' => { 278 => 'modificationDate' },
	'modifiedcolortemp' => { 42 => 0x9 },
	'modifieddigitalgain' => { 42 => 0xb },
	'modifiedparamflag' => { 36 => 0x1 },
	'modifiedpicturestyle' => { 42 => 0xa },
	'modifiedsaturation' => { 193 => 0x504 },
	'modifiedsensorbluelevel' => { 42 => 0x5 },
	'modifiedsensorredlevel' => { 42 => 0x4 },
	'modifiedsharpness' => { 42 => 0x2 },
	'modifiedsharpnessfreq' => { 42 => 0x3 },
	'modifiedtonecurve' => { 42 => 0x1 },
	'modifiedwhitebalance' => { 42 => 0x8 },
	'modifiedwhitebalanceblue' => { 42 => 0x7 },
	'modifiedwhitebalancered' => { 42 => 0x6 },
	'modifydate' => { 80 => 0x132, 108 => 'ModifyDate', 202 => 'ModDate', 203 => 'tIME', 245 => 'ModDate', 285 => 'ModifyDate' },
	'moirefilter' => { 80 => 0xfe58, 268 => 'MoireFilter' },
	'monitordisplayoff' => { 128 => 0x4c },
	'monitorofftime' => { 188 => '18.2', 189 => '3.1', 191 => '3.1' },
	'monochromecontrast' => { 75 => 0x3c },
	'monochromefiltereffect' => { 75 => 0x3a, 234 => 0x73 },
	'monochromelinear' => { 75 => 0x3d },
	'monochromeoutputhighlightpoint' => { 75 => 0x41 },
	'monochromeoutputshadowpoint' => { 75 => 0x42 },
	'monochromerawhighlight' => { 75 => 0x7a },
	'monochromerawhighlightpoint' => { 75 => 0x3f },
	'monochromerawshadow' => { 75 => 0x83 },
	'monochromerawshadowpoint' => { 75 => 0x40 },
	'monochromesharpness' => { 75 => 0x3e },
	'monochrometoning' => { 234 => 0x74 },
	'monochrometoningeffect' => { 75 => 0x3b },
	'monthdaycreated' => { 93 => 0x12, 102 => 0xe },
	'morepermissions' => { 267 => 'morePermissions' },
	'multiburstimageheight' => { 257 => 0x1002 },
	'multiburstimagewidth' => { 257 => 0x1001 },
	'multiburstmode' => { 257 => 0x1000 },
	'multicontrollerwhilemetering' => { 56 => 0x517 },
	'multiexposureautogain' => { 154 => 0x3 },
	'multiexposuremode' => { 154 => 0x1 },
	'multiexposureshots' => { 154 => 0x2 },
	'multipleexposuremode' => { 197 => 0x101c },
	'multipleexposureset' => { 221 => '10.1' },
	'multisample' => { 158 => 0x40 },
	'multiselector' => { 188 => '9.4' },
	'multiselectorliveview' => { 188 => '4.3' },
	'multiselectorplaybackmode' => { 188 => ['13.5','9.2'] },
	'multiselectorshootmode' => { 188 => '9.1' },
	'mycolormode' => { 44 => 0x2 },
	'nativedigest' => { 272 => 'NativeDigest', 283 => 'NativeDigest' },
	'ncdfileinfo' => { 91 => 0x414 },
	'ndfilter' => { 51 => 0x1c },
	'nefbitdepth' => { 153 => 0xe22 },
	'nefcompression' => { 153 => 0x93 },
	'neutraloutputhighlightpoint' => { 75 => 0x2f },
	'neutraloutputshadowpoint' => { 75 => 0x30 },
	'neutralrawcolortone' => { 75 => 0x28 },
	'neutralrawcontrast' => { 75 => 0x2a },
	'neutralrawhighlight' => { 75 => 0x78 },
	'neutralrawhighlightpoint' => { 75 => 0x2d },
	'neutralrawlinear' => { 75 => 0x2b },
	'neutralrawsaturation' => { 75 => 0x29 },
	'neutralrawshadow' => { 75 => 0x81 },
	'neutralrawshadowpoint' => { 75 => 0x2e },
	'neutralrawsharpness' => { 75 => 0x2c },
	'newsphotoversion' => { 88 => 0x0 },
	'nickname' => { 285 => 'Nickname' },
	'nikoncapturedata' => { 153 => 0xe01 },
	'nikoncapturehistory' => { 153 => 0xe13 },
	'nikoncaptureoutput' => { 153 => 0xe1e },
	'nikoncaptureversion' => { 153 => 0xe09 },
	'nikoniccprofile' => { 153 => 0xe1d },
	'nikonimagesize' => { 165 => '723.1', 166 => '732.1', 169 => 0x2c4 },
	'noisefilter' => { 193 => 0x527 },
	'noisereduction' => { 84 => 0x100b, 126 => 0xb0, 127 => 0x60, 128 => 0x3f, 153 => 0x95, 181 => 0x753dcbc0, 182 => 0x17, 193 => 0x50a, 198 => 0x103a, 213 => 0x2d, 234 => 0x49 },
	'noisereduction2' => { 197 => 0x1010 },
	'noisereductionapplied' => { 80 => 0xc6f7 },
	'noisereductionintensity' => { 182 => 0x9 },
	'noisereductionmethod' => { 182 => 0x11 },
	'noisereductionmode' => { 260 => 0x801e },
	'noisereductionsharpness' => { 182 => 0xd },
	'noisereductionvalue' => { 260 => 0x8027 },
	'nomemorycard' => { 188 => '22.1', 189 => '0.3', 190 => '2.4', 191 => '0.3', 192 => '4.5' },
	'nominalmaxaperture' => { 228 => 0xa },
	'nominalminaperture' => { 228 => '10.1' },
	'notes' => { 261 => 'Notes', 265 => 'notes' },
	'npages' => { 292 => 'NPages' },
	'nullrecord' => { 69 => 0x0 },
	'number' => { 278 => 'number' },
	'numberofbeats' => { 287 => 'numberOfBeats' },
	'numfacepositions' => { 206 => 0x0 },
	'numindexentries' => { 88 => 0x54 },
	'object' => { 278 => 'object' },
	'objectattributereference' => { 86 => 0x4 },
	'objectcycle' => { 86 => 0x4b },
	'objectdistance' => { 76 => 0x6, 77 => 0x2022 },
	'objectname' => { 86 => 0x5 },
	'objectpreviewdata' => { 86 => 0xca },
	'objectpreviewfileformat' => { 86 => 0xc8 },
	'objectpreviewfileversion' => { 86 => 0xc9 },
	'objecttypereference' => { 86 => 0x3 },
	'oecfcolumns' => { 272 => 'OECFColumns' },
	'oecfnames' => { 272 => 'OECFNames' },
	'oecfrows' => { 272 => 'OECFRows' },
	'oecfvalues' => { 272 => 'OECFValues' },
	'offsetschema' => { 80 => 0xea1d },
	'okbutton' => { 192 => '16.1' },
	'oldsubfiletype' => { 80 => 0xff },
	'olympusimageheight' => { 198 => 0x102f },
	'olympusimagewidth' => { 198 => 0x102e },
	'onetouchwb' => { 198 => 0x302 },
	'opticalzoom' => { 95 => 0xfa3d, 97 => [0x6006,0xf006], 98 => 0x1000, 99 => 0xf, 102 => 0x1e, 114 => 'OpticalZoom' },
	'opticalzoomcode' => { 51 => 0xa },
	'opticalzoommode' => { 213 => 0x34 },
	'opticalzoomon' => { 252 => 0x219 },
	'optionenddate' => { 280 => 'optionEndDate' },
	'ordernumber' => { 84 => 0x8002 },
	'organisationinimagecode' => { 274 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 274 => 'OrganisationInImageName' },
	'organization' => { 278 => 'organization' },
	'orientation' => { 80 => 0x112, 215 => 0x112, 283 => 'Orientation' },
	'orientationlinkedafpoint' => { 56 => 0x516 },
	'originaldecisiondata' => { 78 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 40 => 0x83 },
	'originaldirectory' => { 210 => 0x408 },
	'originaldocumentid' => { 288 => 'OriginalDocumentID' },
	'originalfilename' => { 69 => 0x816, 91 => 0x3e9, 103 => 0x20, 210 => 0x407 },
	'originalimageheight' => { 52 => 0xc, 83 => 0x1 },
	'originalimagewidth' => { 52 => 0xb, 83 => 0x0 },
	'originalrawfiledata' => { 80 => 0xc68c },
	'originalrawfiledigest' => { 80 => 0xc71d },
	'originalrawfilename' => { 80 => 0xc68b },
	'originaltransmissionreference' => { 86 => 0x67 },
	'originatingprogram' => { 86 => 0x41 },
	'originplatform' => { 278 => 'originPlatform' },
	'os' => { 270 => 'os' },
	'otherconditions' => { 277 => 'OtherConditions' },
	'otherconstraints' => { 277 => 'OtherConstraints' },
	'otherimageinfo' => { 277 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 277 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 277 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 277 => 'OtherLicenseRequirements' },
	'outcuescale' => { 287 => 'outCueScale' },
	'outcuevalue' => { 287 => 'outCueValue' },
	'outputimageheight' => { 137 => 0x3 },
	'outputimagewidth' => { 137 => 0x2 },
	'outputresolution' => { 137 => 0x4 },
	'owner' => { 291 => 'Owner' },
	'ownerid' => { 86 => 0xbc },
	'ownername' => { 11 => 0x10f, 40 => 0x9, 69 => 0x810, 80 => [0xa430,0xfde8], 107 => 'OwnerName', 266 => 'OwnerName' },
	'padding' => { 80 => 0xea1c },
	'pageimage' => { 285 => 'PageInfoImage' },
	'pageimageformat' => { 285 => 'PageInfoFormat' },
	'pageimageheight' => { 285 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 285 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 285 => 'PageInfoWidth' },
	'pagename' => { 80 => 0x11d },
	'pagenumber' => { 80 => 0x129 },
	'pagerange' => { 278 => 'pageRange' },
	'panasonicexifversion' => { 213 => 0x26 },
	'panasonicimageheight' => { 213 => 0x4c },
	'panasonicimagewidth' => { 213 => 0x4b },
	'panasonicrawversion' => { 215 => 0x1 },
	'panasonictitle' => { 80 => 0xc6d2 },
	'panasonictitle2' => { 80 => 0xc6d3 },
	'panoramacropbottom' => { 258 => 0x7 },
	'panoramacropleft' => { 258 => 0x4 },
	'panoramacropright' => { 258 => 0x6 },
	'panoramacroptop' => { 258 => 0x5 },
	'panoramadirection' => { 47 => 0x5, 258 => 0x3 },
	'panoramaframeheight' => { 258 => 0x9 },
	'panoramaframenumber' => { 47 => 0x2 },
	'panoramaframewidth' => { 258 => 0x8 },
	'panoramafullheight' => { 258 => 0x2 },
	'panoramafullwidth' => { 258 => 0x1 },
	'panoramamode' => { 93 => 0x3c, 193 => 0x601 },
	'panoramasourceheight' => { 258 => 0xb },
	'panoramasourcewidth' => { 258 => 0xa },
	'panoramicstitchcameramotion' => { 122 => 'PanoramicStitchCameraMotion', 123 => 0x1 },
	'panoramicstitchmaptype' => { 122 => 'PanoramicStitchMapType', 123 => 0x2 },
	'panoramicstitchphi0' => { 122 => 'PanoramicStitchPhi0', 123 => 0x5 },
	'panoramicstitchphi1' => { 122 => 'PanoramicStitchPhi1', 123 => 0x6 },
	'panoramicstitchtheta0' => { 122 => 'PanoramicStitchTheta0', 123 => 0x3 },
	'panoramicstitchtheta1' => { 122 => 'PanoramicStitchTheta1', 123 => 0x4 },
	'panoramicstitchversion' => { 123 => 0x0 },
	'parallax' => { 84 => 0xb211 },
	'parametricdarks' => { 268 => 'ParametricDarks' },
	'parametrichighlights' => { 268 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 268 => 'ParametricHighlightSplit' },
	'parametriclights' => { 268 => 'ParametricLights' },
	'parametricmidtonesplit' => { 268 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 268 => 'ParametricShadows' },
	'parametricshadowsplit' => { 268 => 'ParametricShadowSplit' },
	'patientbirthdate' => { 262 => 'PatientDOB' },
	'patientid' => { 262 => 'PatientID' },
	'patientname' => { 262 => 'PatientName' },
	'patientsex' => { 262 => 'PatientSex' },
	'pdfversion' => { 275 => 'PDFVersion' },
	'pentaximagesize' => { 234 => 0x9 },
	'pentaxmodelid' => { 220 => 0x0, 234 => 0x5 },
	'pentaxmodeltype' => { 234 => 0x1 },
	'pentaxversion' => { 234 => 0x0 },
	'people' => { 264 => 'People' },
	'peripheralillumcentralradius' => { 260 => 0x8030 },
	'peripheralillumcentralvalue' => { 260 => 0x8031 },
	'peripheralillumination' => { 75 => 0x68 },
	'peripheralilluminationon' => { 75 => 0x64 },
	'peripheralillumperiphvalue' => { 260 => 0x8032 },
	'peripherallighting' => { 52 => 0x2 },
	'peripherallightingsetting' => { 53 => 0x5 },
	'peripherallightingvalue' => { 52 => 0x6 },
	'permissions' => { 280 => 'permissions' },
	'person' => { 278 => 'person' },
	'personinimage' => { 274 => 'PersonInImage' },
	'pf0customfuncregistration' => { 64 => 0x1 },
	'pf10retainprogramshift' => { 64 => 0xb },
	'pf13drivepriority' => { 64 => 0xe },
	'pf14disablefocussearch' => { 64 => 0xf },
	'pf15disableafassistbeam' => { 64 => 0x10 },
	'pf16autofocuspointshoot' => { 64 => 0x11 },
	'pf17disableafpointsel' => { 64 => 0x12 },
	'pf18enableautoafpointsel' => { 64 => 0x13 },
	'pf19continuousshootspeed' => { 64 => 0x14 },
	'pf19shootingspeedhigh' => { 63 => 0xa },
	'pf19shootingspeedlow' => { 63 => 0x9 },
	'pf1disableshootingmodes' => { 64 => 0x2 },
	'pf1value' => { 63 => 0x1 },
	'pf20limitcontinousshots' => { 64 => 0x15 },
	'pf20maxcontinousshots' => { 63 => 0xb },
	'pf21enablequietoperation' => { 64 => 0x16 },
	'pf23felocktime' => { 63 => 0xd },
	'pf23postreleasetime' => { 63 => 0xe },
	'pf23settimerlengths' => { 64 => 0x18 },
	'pf23shutterbuttontime' => { 63 => 0xc },
	'pf24lightlcdduringbulb' => { 64 => 0x19 },
	'pf25aemode' => { 63 => 0xf },
	'pf25afmode' => { 63 => 0x12 },
	'pf25afpointsel' => { 63 => 0x13 },
	'pf25colormatrix' => { 63 => 0x17 },
	'pf25defaultclearsettings' => { 64 => 0x1a },
	'pf25drivemode' => { 63 => 0x11 },
	'pf25imagesize' => { 63 => 0x14 },
	'pf25meteringmode' => { 63 => 0x10 },
	'pf25parameters' => { 63 => 0x16 },
	'pf25wbmode' => { 63 => 0x15 },
	'pf26shortenreleaselag' => { 64 => 0x1b },
	'pf27reversedialrotation' => { 64 => 0x1c },
	'pf27value' => { 63 => 0x18 },
	'pf28noquickdialexpcomp' => { 64 => 0x1d },
	'pf29quickdialswitchoff' => { 64 => 0x1e },
	'pf2disablemeteringmodes' => { 64 => 0x3 },
	'pf2value' => { 63 => 0x2 },
	'pf30enlargementmode' => { 64 => 0x1f },
	'pf31originaldecisiondata' => { 64 => 0x20 },
	'pf3manualexposuremetering' => { 64 => 0x4 },
	'pf3value' => { 63 => 0x3 },
	'pf4exposuretimelimits' => { 64 => 0x5 },
	'pf4exposuretimemax' => { 63 => 0x5 },
	'pf4exposuretimemin' => { 63 => 0x4 },
	'pf5aperturelimits' => { 64 => 0x6 },
	'pf5aperturemax' => { 63 => 0x7 },
	'pf5aperturemin' => { 63 => 0x6 },
	'pf6presetshootingmodes' => { 64 => 0x7 },
	'pf7bracketcontinuousshoot' => { 64 => 0x8 },
	'pf8bracketshots' => { 63 => 0x8 },
	'pf8setbracketshots' => { 64 => 0x9 },
	'pf9changebracketsequence' => { 64 => 0xa },
	'phasedetectaf' => { 135 => 0x6 },
	'phonenumber' => { 108 => 'Phone' },
	'photoeffect' => { 24 => 0x28 },
	'photoeffects' => { 181 => 0xab5eca5e },
	'photoeffectsblue' => { 183 => 0x8 },
	'photoeffectsgreen' => { 183 => 0x6 },
	'photoeffectsred' => { 183 => 0x4 },
	'photoeffectstype' => { 183 => 0x0 },
	'photoinfoplayback' => { 188 => '17.6' },
	'photometricinterpretation' => { 80 => 0x106, 283 => 'PhotometricInterpretation' },
	'photoshopquality' => { 242 => 0x0 },
	'pictinfo' => { 252 => 0x208 },
	'picturecontrol' => { 181 => 0xe2173c47 },
	'picturecontrolactive' => { 184 => 0x0 },
	'picturecontroladjust' => { 155 => 0x30 },
	'picturecontrolbase' => { 155 => 0x18 },
	'picturecontroldata' => { 153 => [0xbd,0x23] },
	'picturecontrolmode' => { 184 => 0x13 },
	'picturecontrolname' => { 155 => 0x4 },
	'picturecontrolquickadjust' => { 155 => 0x31 },
	'picturefinish' => { 126 => 0x71 },
	'picturemode' => { 84 => 0x1031, 193 => 0x520, 234 => [0xb,0x33], 253 => 0x3d },
	'picturemode2' => { 221 => 0x0 },
	'picturemodebwfilter' => { 193 => 0x525 },
	'picturemodecontrast' => { 193 => 0x523 },
	'picturemodehue' => { 193 => 0x522 },
	'picturemodesaturation' => { 193 => 0x521 },
	'picturemodesharpness' => { 193 => 0x524 },
	'picturemodetone' => { 193 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0x6c, 7 => 0x86, 8 => 0x73, 12 => 0xab, 13 => 0xa7, 14 => 0xb0, 15 => 0x6c, 16 => 0xa7, 49 => 0xa, 75 => 0x2 },
	'picturewizard' => { 251 => 0x21 },
	'pitchangle' => { 233 => 0x2 },
	'planarconfiguration' => { 80 => 0x11c, 283 => 'PlanarConfiguration' },
	'platenames' => { 292 => 'PlateNames' },
	'playbackmenustime' => { 190 => '20.1' },
	'playbackmonitorofftime' => { 192 => '21.1' },
	'playdisplay' => { 128 => 0x4e },
	'plusversion' => { 277 => 'Version' },
	'pngwarning' => { 204 => 'Warning' },
	'portraitoutputhighlightpoint' => { 75 => 0x1d },
	'portraitoutputshadowpoint' => { 75 => 0x1e },
	'portraitrawcolortone' => { 75 => 0x16 },
	'portraitrawcontrast' => { 75 => 0x18 },
	'portraitrawhighlight' => { 75 => 0x76 },
	'portraitrawhighlightpoint' => { 75 => 0x1b },
	'portraitrawlinear' => { 75 => 0x19 },
	'portraitrawsaturation' => { 75 => 0x17 },
	'portraitrawshadow' => { 75 => 0x7f },
	'portraitrawshadowpoint' => { 75 => 0x1c },
	'portraitrawsharpness' => { 75 => 0x1a },
	'portraitrefiner' => { 77 => 0x302b },
	'postalcode' => { 112 => 'PostalCode' },
	'postcropvignetteamount' => { 268 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 268 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 268 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 268 => 'PostCropVignetteRoundness' },
	'powersource' => { 219 => '0.1' },
	'poweruptime' => { 153 => 0xb6 },
	'precaptureframes' => { 198 => 0x300 },
	'predictor' => { 80 => 0x13d },
	'preflashreturnstrength' => { 166 => 0x28a },
	'prefs' => { 86 => 0xdd, 241 => 'Prefs' },
	'preservedfilename' => { 288 => 'PreservedFileName' },
	'presetwhitebalance' => { 128 => 0x24, 260 => 0x8002 },
	'presetwhitebalanceadj' => { 260 => 0x8014 },
	'previewapplicationname' => { 80 => 0xc716 },
	'previewapplicationversion' => { 80 => 0xc717 },
	'previewbutton' => { 188 => ['14.1','15.1'] },
	'previewbuttonplusdials' => { 188 => ['14.2','15.2'] },
	'previewcolorspace' => { 80 => 0xc71a },
	'previewcropbottom' => { 240 => 0xef },
	'previewcropleft' => { 240 => 0xec },
	'previewcropright' => { 240 => 0xee },
	'previewcroptop' => { 240 => 0xed },
	'previewdatetime' => { 80 => 0xc71b },
	'previewheight' => { 95 => 0xfa58 },
	'previewimage' => { 77 => 0x2000, 78 => 'PreviewImage', 81 => 'PreviewImage', 82 => 0x4, 117 => 'data', 129 => 0x81, 198 => 0x280, 211 => 0x300, 257 => 0x2001 },
	'previewimageborders' => { 234 => 0x3e },
	'previewimageheight' => { 48 => 0x4 },
	'previewimagelength' => { 48 => 0x2, 77 => 0x3, 80 => [0x117,0x202], 129 => 0x89, 156 => 0x202, 193 => 0x102, 198 => 0x1037, 234 => 0x3, 246 => 0x1e, 250 => 0x3, 253 => 0x1b, 256 => 0x202 },
	'previewimagename' => { 117 => '1Name' },
	'previewimagesize' => { 77 => 0x2, 100 => 0x2, 117 => 'ImageSize', 234 => 0x2, 253 => 0x1c, 257 => 0xb02c },
	'previewimagestart' => { 48 => 0x5, 77 => 0x4, 80 => [0x111,0x201], 129 => 0x88, 156 => 0x201, 193 => 0x101, 198 => 0x1036, 234 => 0x4, 246 => 0x1c, 250 => 0x2, 253 => 0x1a, 256 => 0x201 },
	'previewimagetype' => { 117 => '0Type' },
	'previewimagevalid' => { 193 => 0x100, 198 => 0x1035 },
	'previewimagewidth' => { 48 => 0x3 },
	'previewquality' => { 48 => 0x1 },
	'previewsettingsdigest' => { 80 => 0xc719 },
	'previewsettingsname' => { 80 => 0xc718 },
	'previewwidth' => { 95 => 0xfa57 },
	'primaryafpoint' => { 135 => 0x7 },
	'primarychromaticities' => { 80 => 0x13f, 283 => 'PrimaryChromaticities' },
	'printim' => { 80 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 128 => 0x1d, 254 => 0x28 },
	'privatertkinfo' => { 263 => 'privateRTKInfo' },
	'processingsoftware' => { 80 => 0xb },
	'producer' => { 202 => 'Producer', 275 => 'Producer' },
	'productid' => { 87 => 0x32 },
	'productioncode' => { 220 => 0x2 },
	'productorserviceconstraints' => { 277 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 80 => 0xc6f4 },
	'profilecopyright' => { 80 => 0xc6fe },
	'profileembedpolicy' => { 80 => 0xc6fd },
	'profilehuesatmapdata1' => { 80 => 0xc6fa },
	'profilehuesatmapdata2' => { 80 => 0xc6fb },
	'profilehuesatmapdims' => { 80 => 0xc6f9 },
	'profilelooktabledata' => { 80 => 0xc726 },
	'profilelooktabledims' => { 80 => 0xc725 },
	'profilename' => { 80 => 0xc6f8 },
	'profiletonecurve' => { 80 => 0xc6fc },
	'programiso' => { 213 => 0x3c },
	'programline' => { 221 => '1.1' },
	'programmode' => { 132 => 0x5 },
	'programshift' => { 153 => 0xd },
	'programversion' => { 86 => 0x46 },
	'projectname' => { 287 => 'projectName' },
	'projectrefpath' => { 287 => 'projectRefPath' },
	'projectreftype' => { 287 => 'projectRefType' },
	'propertyreleaseid' => { 277 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 277 => 'PropertyReleaseStatus' },
	'province-state' => { 86 => 0x5f },
	'publicationdate' => { 278 => 'publicationDate' },
	'publicationname' => { 278 => 'publicationName' },
	'publisher' => { 269 => 'publisher' },
	'pulldown' => { 287 => 'pullDown' },
	'quality' => { 0 => 0x1, 24 => 0x3, 76 => 0x2, 77 => 0x3002, 84 => 0x1000, 93 => 0x9, 153 => 0x4, 171 => 0x3, 198 => 0x201, 208 => 0x300, 234 => 0x8, 238 => 0x2, 253 => 0x16, 254 => 0x56, 257 => [0x102,0xb047] },
	'qualitymode' => { 77 => 0x8 },
	'quantizationmethod' => { 88 => 0x78 },
	'quickadjust' => { 184 => 0x2a },
	'quickcontroldialinmeter' => { 56 => 0x703 },
	'quickshot' => { 252 => 0x213 },
	'rangefinder' => { 190 => '4.1' },
	'rasterizedcaption' => { 86 => 0x7d },
	'rating' => { 80 => 0x4746, 240 => 0xdf, 265 => 'rating', 270 => 'rating', 285 => 'Rating' },
	'ratingpercent' => { 80 => 0x4749, 124 => 'Rating' },
	'rawandjpgrecording' => { 54 => 0x8, 129 => 0x109, 221 => 0xd },
	'rawbrightnessadj' => { 74 => 0x38 },
	'rawcoloradj' => { 74 => 0x2e },
	'rawcropbottom' => { 240 => 0xd4 },
	'rawcropleft' => { 240 => 0xd1 },
	'rawcropright' => { 240 => 0xd3 },
	'rawcroptop' => { 240 => 0xd2 },
	'rawcustomsaturation' => { 74 => 0x30 },
	'rawcustomtone' => { 74 => 0x34 },
	'rawdatauniqueid' => { 80 => 0xc65d },
	'rawdepth' => { 131 => 0x10 },
	'rawdevautogradation' => { 200 => 0x119 },
	'rawdevcolorspace' => { 199 => 0x108, 200 => 0x109 },
	'rawdevcontrastvalue' => { 199 => 0x106, 200 => 0x105 },
	'rawdeveditstatus' => { 199 => 0x10b },
	'rawdevengine' => { 199 => 0x109, 200 => 0x10b },
	'rawdevexposurebiasvalue' => { 199 => 0x100, 200 => 0x100 },
	'rawdevgradation' => { 200 => 0x112 },
	'rawdevgraypoint' => { 199 => 0x103, 200 => 0x104 },
	'rawdevmemorycoloremphasis' => { 199 => 0x105, 200 => 0x108 },
	'rawdevnoisereduction' => { 199 => 0x10a, 200 => 0x10a },
	'rawdevpicturemode' => { 200 => 0x10c },
	'rawdevpm_bwfilter' => { 200 => 0x110 },
	'rawdevpmcontrast' => { 200 => 0x10e },
	'rawdevpmnoisefilter' => { 200 => 0x120 },
	'rawdevpmpicturetone' => { 200 => 0x111 },
	'rawdevpmsaturation' => { 200 => 0x10d },
	'rawdevpmsharpness' => { 200 => 0x10f },
	'rawdevsaturation3' => { 200 => 0x113 },
	'rawdevsaturationemphasis' => { 199 => 0x104, 200 => 0x107 },
	'rawdevsettings' => { 199 => 0x10c },
	'rawdevsharpnessvalue' => { 199 => 0x107, 200 => 0x106 },
	'rawdevversion' => { 199 => 0x0, 200 => 0x0 },
	'rawdevwbfineadjustment' => { 199 => 0x102, 200 => 0x103 },
	'rawdevwhitebalance' => { 200 => 0x101 },
	'rawdevwhitebalancevalue' => { 199 => 0x101, 200 => 0x102 },
	'rawfile' => { 80 => 0xfe4c },
	'rawfilename' => { 268 => 'RawFileName' },
	'rawimagecenter' => { 153 => 0x99 },
	'rawimagedigest' => { 80 => 0xc71c },
	'rawimagesize' => { 234 => 0x39 },
	'rawinfoversion' => { 201 => 0x0 },
	'rawjpgheight' => { 71 => 0x4 },
	'rawjpgquality' => { 35 => 0x6, 71 => 0x1 },
	'rawjpgsize' => { 35 => 0x7, 71 => 0x2 },
	'rawjpgwidth' => { 71 => 0x3 },
	'rawmeasuredrggb' => { 27 => 0x26a, 29 => 0x280 },
	'reardisplay' => { 188 => '12.3' },
	'recognizedface1age' => { 207 => 0x20 },
	'recognizedface1name' => { 207 => 0x4 },
	'recognizedface1position' => { 207 => 0x18 },
	'recognizedface2age' => { 207 => 0x50 },
	'recognizedface2name' => { 207 => 0x34 },
	'recognizedface2position' => { 207 => 0x48 },
	'recognizedface3age' => { 207 => 0x80 },
	'recognizedface3name' => { 207 => 0x64 },
	'recognizedface3position' => { 207 => 0x78 },
	'recognizedfaceflags' => { 213 => 0x63 },
	'recommendedexposureindex' => { 80 => 0x8832 },
	'recorddisplay' => { 128 => 0x4d },
	'recordid' => { 69 => 0x1804 },
	'recordingmode' => { 76 => 0x1, 238 => 0x1 },
	'recordmode' => { 24 => 0x9, 77 => 0x3000 },
	'recordshutterrelease' => { 252 => 0x217 },
	'redbalance' => { 142 => 0x270, 198 => 0x1017, 215 => 0x11, 234 => 0x1c },
	'redcurvelimits' => { 74 => 0x18a },
	'redcurvepoints' => { 74 => 0x160 },
	'redeyecorrection' => { 185 => 0x0 },
	'redeyeinfo' => { 268 => 'RedEyeInfo' },
	'redeyereduction' => { 128 => 0x41 },
	'redhue' => { 268 => 'RedHue' },
	'redsaturation' => { 268 => 'RedSaturation' },
	'reductionmatrix1' => { 80 => 0xc625 },
	'reductionmatrix2' => { 80 => 0xc626 },
	'referenceblackwhite' => { 80 => 0x214, 283 => 'ReferenceBlackWhite' },
	'referencedate' => { 86 => 0x2f },
	'referencenumber' => { 86 => 0x32 },
	'references' => { 108 => 'References' },
	'referenceservice' => { 86 => 0x2d },
	'regionconstraints' => { 277 => 'RegionConstraints' },
	'regionpersondisplayname' => { 121 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 121 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 274 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 274 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 106 => 'data' },
	'relatedaudiofilename' => { 106 => '1Name' },
	'relatedaudiofiletype' => { 106 => '0Type' },
	'relatedimagefileformat' => { 80 => 0x1000 },
	'relatedimageheight' => { 80 => 0x1002 },
	'relatedimagewidth' => { 80 => 0x1001 },
	'relatedsoundfile' => { 80 => 0xa004, 272 => 'RelatedSoundFile' },
	'relatedvideofile' => { 120 => 'data' },
	'relatedvideofilename' => { 120 => '1Name' },
	'relatedvideofiletype' => { 120 => '0Type' },
	'relation' => { 269 => 'relation' },
	'relativepeakaudiofilepath' => { 287 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 287 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 287 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 188 => '17.8' },
	'releasedate' => { 86 => 0x1e, 287 => 'releaseDate' },
	'releasemode' => { 77 => 0x3001, 257 => 0xb049 },
	'releasesetting' => { 69 => 0x1016 },
	'releasetime' => { 86 => 0x23 },
	'remoteonduration' => { 189 => '3.4', 190 => '17.2', 191 => '4.3', 192 => '19.2' },
	'renditionclass' => { 288 => 'RenditionClass' },
	'renditionofalternatepaths' => { 288 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 288 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 288 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 288 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 288 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 288 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 288 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 288 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 288 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 288 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 288 => 'RenditionOfMaskMarkers' },
	'renditionoforiginaldocumentid' => { 288 => 'RenditionOfOriginalDocumentID' },
	'renditionofpartmapping' => { 288 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 288 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 288 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 288 => 'RenditionOfToPart' },
	'renditionofversionid' => { 288 => 'RenditionOfVersionID' },
	'renditionparams' => { 288 => 'RenditionParams' },
	'repeatingflashcount' => { 145 => 0xd, 146 => 0xe, 147 => 0xe, 191 => '9.2', 192 => '25.2' },
	'repeatingflashoutput' => { 191 => '9.1', 192 => '25.1' },
	'repeatingflashrate' => { 145 => 0xc, 146 => 0xd, 147 => 0xd, 191 => '10.1', 192 => '26.1' },
	'resampleparamsquality' => { 287 => 'resampleParamsQuality' },
	'resaved' => { 252 => 0x21e },
	'resolution' => { 113 => 'Resolution' },
	'resolutionmode' => { 253 => 0x4 },
	'resolutionunit' => { 80 => 0x128, 89 => 0x2, 283 => 'ResolutionUnit' },
	'restrictions' => { 280 => 'restrictions' },
	'retouchhistory' => { 153 => 0x9e },
	'retouchinfo' => { 268 => 'RetouchInfo' },
	'reuse' => { 277 => 'Reuse' },
	'reuseallowed' => { 290 => 'ReuseAllowed' },
	'reuseprohibited' => { 280 => 'reuseProhibited' },
	'reverseindicators' => { 188 => '12.1', 190 => '4.3', 192 => '6.2' },
	'revision' => { 270 => 'revision' },
	'rgbcurvelimits' => { 74 => 0x238 },
	'rgbcurvepoints' => { 74 => 0x20e },
	'ricohdate' => { 246 => 0x6 },
	'ricohimageheight' => { 246 => 0x2 },
	'ricohimagewidth' => { 246 => 0x0 },
	'rightascension' => { 116 => 'RightAscension' },
	'rights' => { 269 => 'rights' },
	'rightsagent' => { 278 => 'rightsAgent', 280 => 'rightsAgent' },
	'rightsowner' => { 280 => 'rightsOwner' },
	'rollangle' => { 233 => 0x1 },
	'romoperationmode' => { 69 => 0x80d },
	'rotation' => { 21 => 0x17, 22 => 0x18, 68 => 0x3, 74 => 0x26e, 83 => 0x4, 116 => 'Rotation', 126 => [0x65,0x50], 127 => 0x46, 128 => 0x5a, 169 => '590.1', 181 => 0x76a43207, 213 => 0x30, 221 => '17.2', 240 => 0xd8, 254 => 0x3f, 255 => 0x3f },
	'routing' => { 245 => 'Routing' },
	'rowsperstrip' => { 80 => 0x116 },
	'rpp' => { 265 => 'rpp' },
	'safetyshift' => { 56 => 0x108 },
	'safetyshiftinavortv' => { 54 => 0x10, 55 => 0x10, 57 => 0xf, 58 => 0x10, 61 => 0x10 },
	'samplebits' => { 106 => 'SampleBits' },
	'samplerate' => { 106 => 'SampleRate' },
	'samplesperpixel' => { 80 => 0x115, 283 => 'SamplesPerPixel' },
	'samplestructure' => { 88 => 0x5a },
	'sanyoquality' => { 252 => 0x201 },
	'sanyothumbnail' => { 252 => 0x100 },
	'saturation' => { 6 => 0x6e, 8 => 0x76, 24 => 0xe, 31 => 0x1, 76 => 0xd, 77 => [0x3013,0x1f], 80 => [0xa409,0xfe55], 84 => 0x1003, 107 => 'Saturation', 125 => 0x1f, 126 => 0x32, 127 => 0x28, 128 => 0x1a, 132 => 0x1, 153 => [0x94,0xaa], 155 => 0x35, 213 => 0x40, 214 => 0x300d, 234 => 0x1f, 238 => 0xd, 246 => 0x28, 253 => 0x10, 254 => 0x1e, 255 => 0x1b, 257 => 0x2005, 268 => 'Saturation', 272 => 'Saturation' },
	'saturationadj' => { 74 => 0x116, 180 => 0x1, 184 => 0x2e, 260 => 0x8016 },
	'saturationadjustmentaqua' => { 268 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 268 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 268 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 268 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 268 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 268 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 268 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 268 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 15 => 0xfe, 45 => 0x68, 46 => 0x68 },
	'saturationlandscape' => { 15 => 0xfc, 45 => 0x38, 46 => 0x38 },
	'saturationmonochrome' => { 45 => 0x80, 46 => 0x80 },
	'saturationneutral' => { 15 => 0xfd, 45 => 0x50, 46 => 0x50 },
	'saturationportrait' => { 15 => 0xfb, 45 => 0x20, 46 => 0x20 },
	'saturationsetting' => { 201 => 0x1010 },
	'saturationstandard' => { 15 => 0xfa, 45 => 0x8, 46 => 0x8 },
	'saturationunknown' => { 46 => 0x98 },
	'saturationuserdef1' => { 15 => 0x100, 45 => 0x98, 46 => 0xb0 },
	'saturationuserdef2' => { 15 => 0x101, 45 => 0xb0, 46 => 0xc8 },
	'saturationuserdef3' => { 15 => 0x102, 45 => 0xc8, 46 => 0xe0 },
	'saveid' => { 288 => 'SaveID' },
	'scaletype' => { 287 => 'scaleType' },
	'scanimageenhancer' => { 158 => 0x60 },
	'scanningdirection' => { 88 => 0x64 },
	'scene' => { 273 => 'Scene', 287 => 'scene' },
	'scenearea' => { 196 => 0x211, 198 => 0x1031 },
	'sceneassist' => { 153 => 0x9c },
	'scenecapturetype' => { 80 => 0xa406, 272 => 'SceneCaptureType' },
	'scenedetect' => { 196 => 0x210, 198 => 0x1030 },
	'scenedetectdata' => { 196 => 0x212, 198 => 0x1033 },
	'scenemode' => { 95 => 0xfa02, 129 => 0x100, 153 => 0x8f, 193 => 0x509, 198 => 0x403, 213 => 0x8001, 257 => 0xb023 },
	'scenemodeused' => { 97 => [0x6002,0xf002] },
	'sceneselect' => { 252 => 0x21f },
	'scenetype' => { 80 => 0xa301, 272 => 'SceneType' },
	'screentips' => { 188 => '12.7', 192 => '5.1' },
	'section' => { 278 => 'section' },
	'securityclassification' => { 80 => 0x9212 },
	'selectableafpoint' => { 56 => 0x509 },
	'selectafareaselectmode' => { 56 => 0x512 },
	'selftimer' => { 24 => 0x2, 213 => 0x2e, 252 => 0x214 },
	'selftimer2' => { 51 => 0x1d },
	'selftimermode' => { 80 => 0x882b },
	'selftimershotcount' => { 190 => '18.2', 192 => '20.2' },
	'selftimertime' => { 69 => 0x1806, 128 => 0x1f, 188 => '18.1', 189 => '3.3', 190 => '18.1', 191 => '3.3', 192 => '20.1' },
	'seminfo' => { 80 => 0x8546 },
	'sensingmethod' => { 80 => 0xa217, 272 => 'SensingMethod' },
	'sensitivityadjust' => { 234 => 0x40 },
	'sensitivitysteps' => { 221 => ['14.3','17.4'], 223 => 0x1 },
	'sensitivitytype' => { 80 => 0x8830 },
	'sensorareas' => { 251 => 0xa010 },
	'sensorbitdepth' => { 214 => 0x312d },
	'sensorbluelevel' => { 49 => 0x5 },
	'sensorcleaning' => { 62 => 0xd },
	'sensorfullheight' => { 90 => 0xf904 },
	'sensorfullwidth' => { 90 => 0xf903 },
	'sensorheight' => { 90 => 0xf901, 95 => 0xfa21, 131 => 0x8, 214 => 0x312c },
	'sensorpixelsize' => { 153 => 0x9a },
	'sensorredlevel' => { 49 => 0x4 },
	'sensorsize' => { 107 => 'SensorSize', 234 => 0x35 },
	'sensortemperature' => { 196 => 0x1500, 198 => 0x1007, 253 => 0x39 },
	'sensorwidth' => { 90 => 0xf900, 95 => 0xfa20, 131 => 0xa, 214 => 0x312b },
	'sequencenumber' => { 51 => 0x9, 77 => 0x301c, 84 => 0x1101, 93 => 0x1d, 213 => 0x2b, 257 => 0xb04a },
	'sequenceshotinterval' => { 252 => 0x224 },
	'sequentialshot' => { 252 => 0x20e },
	'serialnumber' => { 40 => 0xc, 69 => 0x180b, 80 => [0xa431,0xfde9], 90 => 0xfa04, 92 => 0xfa00, 94 => 0xc354, 95 => 0xfa19, 104 => 0x0, 105 => 0xa8, 107 => 'SerialNumber', 153 => [0xa0,0x1d], 194 => 0x101, 198 => [0x404,0x101a], 208 => 0x303, 214 => 0x3103, 234 => 0x229, 247 => 0x5, 253 => 0x2, 266 => 'SerialNumber' },
	'serialnumberformat' => { 40 => 0x15, 69 => 0x183b },
	'seriesdatetime' => { 262 => 'SeriesDateTime' },
	'seriesdescription' => { 262 => 'SeriesDescription' },
	'seriesmodality' => { 262 => 'SeriesModality' },
	'seriesnumber' => { 262 => 'SeriesNumber' },
	'serviceidentifier' => { 87 => 0x1e },
	'setbuttoncrosskeysfunc' => { 59 => 0x0, 60 => 0x0 },
	'setbuttonwhenshooting' => { 54 => 0x1, 56 => 0x704, 62 => 0xc },
	'setfunctionwhenshooting' => { 57 => 0x0, 58 => 0x1, 61 => 0x1 },
	'shadingcompensation' => { 193 => 0x50c },
	'shadingcompensation2' => { 197 => 0x1012 },
	'shadow' => { 253 => 0xe },
	'shadowcompensation' => { 234 => 0x79 },
	'shadowprotection' => { 180 => 0x0 },
	'shadows' => { 80 => 0xfe52, 268 => 'Shadows' },
	'shadowscale' => { 80 => 0xc633 },
	'shadowtint' => { 268 => 'ShadowTint' },
	'shakereduction' => { 235 => 0x1 },
	'sharpendetail' => { 268 => 'SharpenDetail' },
	'sharpenedgemasking' => { 268 => 'SharpenEdgeMasking' },
	'sharpening' => { 214 => 0x300b },
	'sharpeningadj' => { 184 => 0x2b },
	'sharpenradius' => { 268 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 6 => 0x72, 8 => 0x74, 24 => 0xf, 49 => 0x2, 76 => 0xb, 77 => [0x3011,0x21], 80 => [0xa40a,0xfe56], 84 => 0x1001, 93 => 0x6b, 102 => 0x37, 107 => 'Sharpness', 125 => 0x21, 126 => 0x30, 127 => 0x26, 128 => 0x18, 132 => 0x3, 153 => 0x6, 155 => 0x32, 198 => 0x100f, 213 => 0x41, 234 => 0x21, 238 => 0xb, 246 => 0x22, 247 => 0x1003, 253 => 0x11, 254 => 0x1c, 255 => 0x19, 268 => 'Sharpness', 272 => 'Sharpness' },
	'sharpnessadj' => { 74 => 0x25a, 260 => 0x801a },
	'sharpnessfactor' => { 198 => 0x102a },
	'sharpnessfaithful' => { 15 => 0xf5, 45 => 0x64, 46 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 49 => 0x3 },
	'sharpnesslandscape' => { 15 => 0xf3, 45 => 0x34, 46 => 0x34 },
	'sharpnessmonochrome' => { 15 => 0xf6, 45 => 0x7c, 46 => 0x7c },
	'sharpnessneutral' => { 15 => 0xf4, 45 => 0x4c, 46 => 0x4c },
	'sharpnessovershoot' => { 260 => 0x801b },
	'sharpnessportrait' => { 15 => 0xf2, 45 => 0x1c, 46 => 0x1c },
	'sharpnesssetting' => { 193 => 0x506, 201 => 0x1013 },
	'sharpnessstandard' => { 15 => 0xf1, 45 => 0x4, 46 => 0x4 },
	'sharpnessthreshold' => { 260 => 0x801d },
	'sharpnessundershoot' => { 260 => 0x801c },
	'sharpnessunknown' => { 46 => 0x94 },
	'sharpnessuserdef1' => { 15 => 0xf7, 45 => 0x94, 46 => 0xac },
	'sharpnessuserdef2' => { 15 => 0xf8, 45 => 0xac, 46 => 0xc4 },
	'sharpnessuserdef3' => { 15 => 0xf9, 45 => 0xc4, 46 => 0xdc },
	'shootinginfodisplay' => { 188 => '13.2', 192 => '5.3' },
	'shootinginfomonitorofftime' => { 192 => '22.2' },
	'shootingmode' => { 107 => 'ShootingMode', 153 => 0x89, 213 => 0x1f },
	'shootingmodesetting' => { 189 => '5.1' },
	'shortdescription' => { 270 => 'shortdescription' },
	'shortdocumentid' => { 86 => 0xba },
	'shortfocal' => { 5 => 0xe, 6 => 0x11, 7 => 0x113, 8 => 0x11, 9 => [0x150,0x151], 10 => 0xd8, 12 => 0xf8, 13 => 0xec, 14 => 0x101, 15 => 0x93, 16 => 0xe8, 18 => 0xea, 20 => 0xf0, 24 => 0x18 },
	'shortownername' => { 15 => 0xac },
	'shortreleasetimelag' => { 56 => 0x80d },
	'shotdate' => { 287 => 'shotDate' },
	'shotday' => { 287 => 'shotDay' },
	'shotlocation' => { 287 => 'shotLocation' },
	'shotname' => { 287 => 'shotName' },
	'shotnumber' => { 287 => 'shotNumber' },
	'shotsize' => { 287 => 'shotSize' },
	'shutter-aelock' => { 54 => 0x4, 56 => 0x701, 57 => 0x3, 58 => 0x4, 59 => 0x3, 60 => 0x3, 61 => 0x4, 62 => 0x2 },
	'shutteraelbutton' => { 55 => 0x4 },
	'shutterbuttonafonbutton' => { 56 => 0x701 },
	'shuttercount' => { 7 => 0x176, 35 => 0x1, 153 => 0xa7, 159 => [0x6a,0x157,0x24d], 160 => 0x286, 161 => 0x279, 162 => 0x284, 163 => 0x242, 164 => 0x280, 165 => 0x276, 166 => [0x27d,0x27f], 167 => 0x246, 168 => 0x2d6, 169 => 0x24a, 170 => 0x2d5, 234 => 0x5d },
	'shuttercurtainsync' => { 54 => 0xf, 55 => 0xf, 56 => 0x305, 57 => 0xe, 58 => 0xf, 59 => 0x8, 60 => 0x8, 61 => 0xf, 62 => 0x8 },
	'shuttermode' => { 93 => 0x1b },
	'shutterreleasebuttonae-l' => { 188 => '17.7', 190 => '16.1', 192 => '18.2' },
	'shutterreleasemethod' => { 69 => 0x1010 },
	'shutterreleasenocfcard' => { 54 => 0x2, 55 => 0x2, 62 => 0xf },
	'shutterreleasetiming' => { 69 => 0x1011 },
	'shutterspeedrange' => { 56 => 0x10c },
	'shutterspeedvalue' => { 65 => 0x1, 80 => 0x9201, 198 => 0x1000, 272 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 276 => 'SidecarForExtension' },
	'similarityindex' => { 86 => 0xe4 },
	'singleframebracketing' => { 128 => 0x21 },
	'slaveflashmeteringsegments' => { 234 => 0x20b },
	'slowshutter' => { 51 => 0x8 },
	'slowsync' => { 84 => 0x1030 },
	'smoothness' => { 80 => 0xfe57, 268 => 'Smoothness' },
	'software' => { 80 => 0x131, 108 => 'Software', 204 => 'Software', 253 => 0x18, 283 => 'Software' },
	'softwareversion' => { 252 => 0x207 },
	'sonydatetime' => { 259 => 0x6 },
	'sonyimagesize' => { 128 => 0x3b, 254 => 0x54, 255 => 0x54 },
	'sonymodelid' => { 257 => 0xb001 },
	'sonyquality' => { 128 => 0x3c },
	'source' => { 86 => 0x73, 204 => 'Source', 269 => 'source', 270 => 'source', 276 => 'Source' },
	'sourcedirectoryindex' => { 225 => 0x0 },
	'sourcefileindex' => { 225 => 0x2 },
	'spatialfrequencyresponsecolumns' => { 272 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 272 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 272 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 272 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 287 => 'speakerPlacement' },
	'specialeffectlevel' => { 77 => 0x3030 },
	'specialeffectmode' => { 77 => 0x2076 },
	'specialeffectsetting' => { 77 => 0x3031 },
	'specialinstructions' => { 86 => 0x28 },
	'specialmode' => { 198 => 0x200, 252 => 0x200 },
	'spectralsensitivity' => { 80 => 0x8824, 272 => 'SpectralSensitivity' },
	'splittoningbalance' => { 268 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 268 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 268 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 268 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 268 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 125 => 0x2d },
	'spotfocuspointy' => { 125 => 0x2e },
	'spotmeteringmode' => { 24 => 0x27 },
	'spotmeterlinktoafpoint' => { 56 => 0x107 },
	'sractive' => { 221 => '17.1' },
	'srawquality' => { 24 => 0x2e },
	'srfocallength' => { 235 => 0x3 },
	'srhalfpresstime' => { 235 => 0x2 },
	'srresult' => { 235 => 0x0 },
	'standardoutputhighlightpoint' => { 75 => 0x14 },
	'standardoutputsensitivity' => { 80 => 0x8831 },
	'standardoutputshadowpoint' => { 75 => 0x15 },
	'standardrawcolortone' => { 75 => 0xd },
	'standardrawcontrast' => { 75 => 0xf },
	'standardrawhighlight' => { 75 => 0x75 },
	'standardrawhighlightpoint' => { 75 => 0x12 },
	'standardrawlinear' => { 75 => 0x10 },
	'standardrawsaturation' => { 75 => 0xe },
	'standardrawshadow' => { 75 => 0x7e },
	'standardrawshadowpoint' => { 75 => 0x13 },
	'standardrawsharpness' => { 75 => 0x11 },
	'startingpage' => { 278 => 'startingPage' },
	'startmovieshooting' => { 56 => 0x70d },
	'starttimecodetimeformat' => { 287 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 287 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 287 => 'startTimecodeValue' },
	'state' => { 112 => 'State', 213 => 0x6b, 276 => 'State' },
	'status' => { 264 => 'Status' },
	'storagemethod' => { 131 => 0x12 },
	'straightenangle' => { 181 => 0x2fc08431 },
	'stretchmode' => { 287 => 'stretchMode' },
	'studydatetime' => { 262 => 'StudyDateTime' },
	'studydescription' => { 262 => 'StudyDescription' },
	'studyid' => { 262 => 'StudyID' },
	'studyphysician' => { 262 => 'StudyPhysician' },
	'sub-location' => { 86 => 0x5c },
	'subfiledata' => { 115 => 'data' },
	'subfiledirectory' => { 115 => '1Directory' },
	'subfilemimetype' => { 115 => '2MIME' },
	'subfilename' => { 115 => '1Name' },
	'subfileresource' => { 115 => 'rsrc' },
	'subfiletype' => { 80 => 0xfe, 115 => '0Type' },
	'subject' => { 202 => 'Subject', 245 => 'Subject', 269 => 'subject', 275 => 'Subject' },
	'subjectarea' => { 80 => 0x9214, 272 => 'SubjectArea' },
	'subjectcode' => { 273 => 'SubjectCode' },
	'subjectdistance' => { 80 => 0x9206, 93 => 0x3e, 272 => 'SubjectDistance' },
	'subjectdistancerange' => { 80 => 0xa40c, 272 => 'SubjectDistanceRange' },
	'subjectlocation' => { 80 => 0xa214, 272 => 'SubjectLocation' },
	'subjectprogram' => { 125 => 0x22 },
	'subjectreference' => { 86 => 0xc },
	'subsectime' => { 80 => 0x9290 },
	'subsectimedigitized' => { 80 => 0x9292 },
	'subsectimeoriginal' => { 80 => 0x9291 },
	'subsection1' => { 278 => 'subsection1' },
	'subsection2' => { 278 => 'subsection2' },
	'subsection3' => { 278 => 'subsection3' },
	'subsection4' => { 278 => 'subsection4' },
	'superimposeddisplay' => { 54 => 0xa, 56 => 0x510, 57 => 0x9, 58 => 0xa, 61 => 0xa, 62 => 0xe },
	'supermacro' => { 40 => 0x1a },
	'supplementalcategories' => { 86 => 0x14, 276 => 'SupplementalCategories' },
	'supplementaltype' => { 88 => 0x37 },
	'svisosetting' => { 221 => 0x14 },
	'switchtoregisteredafpoint' => { 55 => 0x12, 56 => 0x50a },
	'tagged' => { 240 => 0xdd, 265 => 'tagged' },
	'tagslist' => { 271 => 'TagsList' },
	'takenumber' => { 287 => 'takeNumber' },
	'tapename' => { 287 => 'tapeName' },
	'targetaperture' => { 51 => 0x4 },
	'targetcompressionratio' => { 67 => 0x1 },
	'targetdistancesetting' => { 69 => 0x1807 },
	'targetexposuretime' => { 51 => 0x5 },
	'targetimagetype' => { 69 => 0x100a },
	'teaser' => { 278 => 'teaser' },
	'teleconverter' => { 129 => 0x105, 257 => 0x105 },
	'temperature' => { 268 => 'Temperature' },
	'tempo' => { 287 => 'tempo' },
	'termsandconditionstext' => { 277 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 277 => 'TermsAndConditionsURL' },
	'textlayername' => { 276 => 'TextLayersLayerName' },
	'textlayertext' => { 276 => 'TextLayersLayerText' },
	'textstamp' => { 213 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 80 => 0x107 },
	'thumbnailfilename' => { 69 => 0x817 },
	'thumbnailformat' => { 285 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 95 => 0xfa55, 285 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 69 => 0x2008, 78 => 'ThumbnailImage', 82 => 0x3, 118 => 'data', 198 => 0x100, 285 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 118 => '1Name' },
	'thumbnailimagesize' => { 118 => 'ImageSize' },
	'thumbnailimagetype' => { 118 => '0Type' },
	'thumbnailimagevalidarea' => { 40 => 0x13 },
	'thumbnaillength' => { 80 => 0x202 },
	'thumbnailoffset' => { 80 => 0x201 },
	'thumbnailwidth' => { 95 => 0xfa54, 285 => 'ThumbnailsWidth' },
	'ticker' => { 278 => 'ticker' },
	'tilelength' => { 80 => 0x143 },
	'tilewidth' => { 80 => 0x142 },
	'time' => { 91 => 0x401, 234 => 0x7 },
	'timecreated' => { 86 => 0x3c, 93 => 0x14, 102 => 0x10, 241 => 'TimeCreated' },
	'timeperiod' => { 278 => 'timePeriod' },
	'timerfunctionbutton' => { 189 => '5.2', 190 => '12.1' },
	'timerlength' => { 56 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 287 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 287 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 287 => 'timeScaleParamsQuality' },
	'timesent' => { 87 => 0x50 },
	'timesignature' => { 287 => 'timeSignature' },
	'timesincepoweron' => { 213 => 0x29 },
	'timestamp' => { 7 => 0x45e, 15 => 0x11c, 204 => 'TimeStamp' },
	'timestamp1' => { 7 => 0x45a },
	'timezone' => { 173 => 0x0 },
	'timezonecode' => { 72 => 0x1 },
	'timezoneinfo' => { 72 => 0x2 },
	'timezoneoffset' => { 80 => 0x882a },
	'tint' => { 268 => 'Tint' },
	'title' => { 108 => 'Title', 202 => 'Title', 204 => 'Title', 213 => 0x65, 245 => 'Title', 269 => 'title', 275 => 'Title' },
	'tonecomp' => { 153 => 0x81 },
	'tonecurve' => { 49 => 0x1, 234 => 0x402, 268 => 'ToneCurve' },
	'tonecurveactive' => { 74 => 0x110 },
	'tonecurvebluex' => { 260 => 0x9003 },
	'tonecurvebluey' => { 260 => 0x9007 },
	'tonecurvebrightnessx' => { 260 => 0x9000 },
	'tonecurvebrightnessy' => { 260 => 0x9004 },
	'tonecurvefilename' => { 91 => 0x1391 },
	'tonecurvegreenx' => { 260 => 0x9002 },
	'tonecurvegreeny' => { 260 => 0x9006 },
	'tonecurveinterpolation' => { 74 => 0x159 },
	'tonecurvemode' => { 74 => 0x113 },
	'tonecurvename' => { 268 => 'ToneCurveName' },
	'tonecurveproperty' => { 74 => 0x3c },
	'tonecurveredx' => { 260 => 0x9001 },
	'tonecurveredy' => { 260 => 0x9005 },
	'tonecurves' => { 234 => 0x403 },
	'toningeffect' => { 35 => 0xf, 153 => 0xb3, 155 => 0x38 },
	'toningeffectfaithful' => { 45 => 0x74, 46 => 0x74 },
	'toningeffectlandscape' => { 45 => 0x44, 46 => 0x44 },
	'toningeffectmonochrome' => { 15 => 0x108, 45 => 0x8c, 46 => 0x8c },
	'toningeffectneutral' => { 45 => 0x5c, 46 => 0x5c },
	'toningeffectportrait' => { 45 => 0x2c, 46 => 0x2c },
	'toningeffectstandard' => { 45 => 0x14, 46 => 0x14 },
	'toningeffectunknown' => { 46 => 0xa4 },
	'toningeffectuserdef1' => { 45 => 0xa4, 46 => 0xbc },
	'toningeffectuserdef2' => { 45 => 0xbc, 46 => 0xd4 },
	'toningeffectuserdef3' => { 45 => 0xd4, 46 => 0xec },
	'toningsaturation' => { 155 => 0x39 },
	'totalzoom' => { 93 => 0x62 },
	'tracknumber' => { 287 => 'trackNumber' },
	'tracksframerate' => { 287 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 287 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 287 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 287 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 287 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 287 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 287 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 287 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 287 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 287 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 287 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 287 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 287 => 'TracksMarkersType' },
	'trackstrackname' => { 287 => 'TracksTrackName' },
	'trackstracktype' => { 287 => 'TracksTrackType' },
	'trailersignature' => { 115 => 'zmie' },
	'transferfunction' => { 80 => 0x12d, 283 => 'TransferFunction' },
	'transform' => { 213 => [0x8012,0x59] },
	'transmissionreference' => { 276 => 'TransmissionReference' },
	'trapped' => { 202 => 'Trapped', 275 => 'Trapped' },
	'travelday' => { 213 => 0x36 },
	'ttl_da_adown' => { 226 => 0x5 },
	'ttl_da_aup' => { 226 => 0x4 },
	'ttl_da_bdown' => { 226 => 0x7 },
	'ttl_da_bup' => { 226 => 0x6 },
	'tungstenawb' => { 218 => 0x1 },
	'tvexposuretimesetting' => { 221 => 0x12 },
	'type' => { 269 => 'type', 282 => 'type' },
	'uniquecameramodel' => { 80 => 0xc614 },
	'uniquedocumentid' => { 86 => 0xbb },
	'uniqueobjectname' => { 87 => 0x64 },
	'unknownblock' => { 197 => 0x1103 },
	'unknowncontrast' => { 75 => 0x45 },
	'unknownev' => { 91 => 0x1 },
	'unknownlinear' => { 75 => 0x46 },
	'unknownmode' => { 77 => 0x301b },
	'unknownnumber' => { 69 => 0x180b },
	'unknownoutputhighlightpoint' => { 75 => 0x4a },
	'unknownoutputshadowpoint' => { 75 => 0x4b },
	'unknownrawhighlight' => { 75 => 0x7b },
	'unknownrawhighlightpoint' => { 75 => 0x48 },
	'unknownrawshadow' => { 75 => 0x84 },
	'unknownrawshadowpoint' => { 75 => 0x49 },
	'unknownsharpness' => { 75 => 0x47 },
	'unsharp1color' => { 186 => 0x13 },
	'unsharp1halowidth' => { 186 => 0x19 },
	'unsharp1intensity' => { 186 => 0x17 },
	'unsharp1threshold' => { 186 => 0x1b },
	'unsharp2color' => { 186 => 0x2e },
	'unsharp2halowidth' => { 186 => 0x34 },
	'unsharp2intensity' => { 186 => 0x32 },
	'unsharp2threshold' => { 186 => 0x36 },
	'unsharp3color' => { 186 => 0x49 },
	'unsharp3halowidth' => { 186 => 0x4f },
	'unsharp3intensity' => { 186 => 0x4d },
	'unsharp3threshold' => { 186 => 0x51 },
	'unsharp4color' => { 186 => 0x64 },
	'unsharp4halowidth' => { 186 => 0x6a },
	'unsharp4intensity' => { 186 => 0x68 },
	'unsharp4threshold' => { 186 => 0x6c },
	'unsharpcount' => { 186 => 0x0 },
	'unsharpmask' => { 75 => 0x90, 181 => 0x76a43200 },
	'unsharpmaskfineness' => { 75 => 0x94 },
	'unsharpmaskstrength' => { 75 => 0x92 },
	'unsharpmaskthreshold' => { 75 => 0x96 },
	'urgency' => { 86 => 0xa, 276 => 'Urgency' },
	'url' => { 108 => 'URL', 204 => 'URL', 243 => 0x40b, 278 => 'url' },
	'usablemeteringmodes' => { 56 => 0x10a },
	'usableshootingmodes' => { 56 => 0x109 },
	'usage' => { 279 => 'usage' },
	'usagefee' => { 280 => 'usageFee' },
	'usageterms' => { 291 => 'UsageTerms' },
	'usercomment' => { 69 => 0x805, 80 => 0x9286, 272 => 'UserComment' },
	'userdef1picturestyle' => { 15 => 0x10c, 45 => 0xd8, 46 => 0xf0 },
	'userdef2picturestyle' => { 15 => 0x10e, 45 => 0xda, 46 => 0xf2 },
	'userdef3picturestyle' => { 15 => 0x110, 45 => 0xdc, 46 => 0xf4 },
	'userfields' => { 264 => 'UserFields' },
	'userprofile' => { 208 => 0x302, 214 => 0x3038 },
	'usmlenselectronicmf' => { 55 => 0x7, 56 => 0x501 },
	'utmeasting' => { 119 => 'Easting' },
	'utmmapdatum' => { 119 => 'Datum' },
	'utmnorthing' => { 119 => 'Northing' },
	'utmzone' => { 119 => 'Zone' },
	'uv-irfiltercorrection' => { 208 => 0x325 },
	'validbits' => { 197 => 0x611, 198 => 0x102c },
	'validpixeldepth' => { 201 => 0x611 },
	'variousmodes' => { 93 => 0x26 },
	'variousmodes2' => { 93 => 0x3a },
	'variprogram' => { 153 => 0xab },
	'version' => { 84 => 0x0, 245 => 'Version', 268 => 'Version' },
	'versioncreatedate' => { 260 => 0xd100 },
	'versionid' => { 288 => 'VersionID' },
	'versionidentifier' => { 278 => 'versionIdentifier' },
	'versionmodifydate' => { 260 => 0xd101 },
	'versionscomments' => { 288 => 'VersionsComments' },
	'versionseventaction' => { 288 => 'VersionsEventAction' },
	'versionseventchanged' => { 288 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 288 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 288 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 288 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 288 => 'VersionsEventWhen' },
	'versionsmodifier' => { 288 => 'VersionsModifier' },
	'versionsmodifydate' => { 288 => 'VersionsModifyDate' },
	'versionsversion' => { 288 => 'VersionsVersion' },
	'verticalafonbutton' => { 188 => '3.2' },
	'vfdisplayillumination' => { 56 => 0x510 },
	'vibrance' => { 268 => 'Vibrance' },
	'vibrationreduction' => { 159 => [0x75,0x82,0x1ae], 167 => '586.1', 169 => '590.2', 172 => 0x4 },
	'videoalphamode' => { 287 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 287 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 287 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 287 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 287 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 287 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 287 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 287 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 287 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 287 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 287 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 287 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 287 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 287 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 287 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 43 => 0x74 },
	'videocolorspace' => { 287 => 'videoColorSpace' },
	'videocompressor' => { 287 => 'videoCompressor' },
	'videofieldorder' => { 287 => 'videoFieldOrder' },
	'videoframerate' => { 287 => 'videoFrameRate' },
	'videoframesizeh' => { 287 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 287 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 287 => 'videoFrameSizeW' },
	'videomoddate' => { 287 => 'videoModDate' },
	'videopixelaspectratio' => { 287 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 287 => 'videoPixelDepth' },
	'videoquality' => { 77 => 0x4003 },
	'viewfinderdisplay' => { 188 => '12.4' },
	'viewfinderwarning' => { 188 => '13.4', 191 => '6.2', 192 => '4.4' },
	'viewinfoduringexposure' => { 56 => 0x407 },
	'vignetteamount' => { 268 => 'VignetteAmount' },
	'vignettecontrol' => { 153 => 0x2a, 181 => 0x76a43205 },
	'vignettecontrolintensity' => { 181 => 0xac6bd5c0 },
	'vignettemidpoint' => { 268 => 'VignetteMidpoint' },
	'voicememo' => { 252 => 0x216 },
	'volume' => { 278 => 'volume' },
	'vr_0x66' => { 159 => 0x66 },
	'vrdoffset' => { 40 => 0xd0 },
	'wb_bluepresetsfluorescent' => { 130 => 0x40a },
	'wb_gbrglevels' => { 130 => 0xae, 133 => 0x4 },
	'wb_glevel' => { 197 => 0x11f },
	'wb_glevel3000k' => { 197 => 0x113 },
	'wb_glevel3300k' => { 197 => 0x114 },
	'wb_glevel3600k' => { 197 => 0x115 },
	'wb_glevel3900k' => { 197 => 0x116 },
	'wb_glevel4000k' => { 197 => 0x117 },
	'wb_glevel4300k' => { 197 => 0x118 },
	'wb_glevel4500k' => { 197 => 0x119 },
	'wb_glevel4800k' => { 197 => 0x11a },
	'wb_glevel5300k' => { 197 => 0x11b },
	'wb_glevel6000k' => { 197 => 0x11c },
	'wb_glevel6600k' => { 197 => 0x11d },
	'wb_glevel7500k' => { 197 => 0x11e },
	'wb_grbglevels' => { 141 => 0x0 },
	'wb_rbgglevels' => { 138 => 0x0 },
	'wb_rblevels' => { 153 => 0xc, 197 => 0x100 },
	'wb_rblevels3000k' => { 197 => 0x102 },
	'wb_rblevels3300k' => { 197 => 0x103 },
	'wb_rblevels3600k' => { 197 => 0x104 },
	'wb_rblevels3900k' => { 197 => 0x105 },
	'wb_rblevels4000k' => { 197 => 0x106 },
	'wb_rblevels4300k' => { 197 => 0x107 },
	'wb_rblevels4500k' => { 197 => 0x108 },
	'wb_rblevels4800k' => { 197 => 0x109 },
	'wb_rblevels5300k' => { 197 => 0x10a },
	'wb_rblevels6000k' => { 197 => 0x10b },
	'wb_rblevels6600k' => { 197 => 0x10c },
	'wb_rblevels7500k' => { 197 => 0x10d },
	'wb_rblevelsauto' => { 201 => 0x110 },
	'wb_rblevelscloudy' => { 132 => 0x10, 201 => 0x121 },
	'wb_rblevelscoolwhitef' => { 132 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 201 => 0x132 },
	'wb_rblevelscwb1' => { 197 => 0x10e },
	'wb_rblevelscwb2' => { 197 => 0x10f },
	'wb_rblevelscwb3' => { 197 => 0x110 },
	'wb_rblevelscwb4' => { 197 => 0x111 },
	'wb_rblevelsdaylight' => { 132 => 0xc },
	'wb_rblevelsdaylightf' => { 132 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 201 => 0x130 },
	'wb_rblevelsdaywhitef' => { 132 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 201 => 0x131 },
	'wb_rblevelseveningsunlight' => { 201 => 0x124 },
	'wb_rblevelsfineweather' => { 201 => 0x122 },
	'wb_rblevelsflash' => { 132 => 0x18 },
	'wb_rblevelsshade' => { 132 => 0x20, 201 => 0x120 },
	'wb_rblevelstungsten' => { 132 => 0x8, 201 => 0x123 },
	'wb_rblevelsunknown' => { 132 => 0x1c },
	'wb_rblevelsused' => { 201 => 0x100 },
	'wb_rblevelswhitef' => { 132 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 201 => 0x133 },
	'wb_rbpresetcloudy' => { 130 => 0x3f0 },
	'wb_rbpresetcoolwhitef' => { 130 => 0x308 },
	'wb_rbpresetcustom' => { 130 => 0x424 },
	'wb_rbpresetdaylight' => { 130 => 0x3ec },
	'wb_rbpresetflash' => { 130 => [0x3f4,0x304] },
	'wb_rbpresetshade' => { 130 => 0x418 },
	'wb_rbpresettungsten' => { 130 => 0x3e8 },
	'wb_redpresetsfluorescent' => { 130 => 0x3fc },
	'wb_rgbglevels' => { 140 => 0x0 },
	'wb_rgblevels' => { 130 => 0x96, 209 => 0xd, 210 => 0x413, 214 => 0x3036 },
	'wb_rggblevels' => { 133 => 0x4, 139 => 0x0, 251 => 0xa021 },
	'wb_rggblevelsasshot' => { 26 => 0x19, 27 => 0x22, 28 => 0x3f, 29 => 0x3f, 30 => 0x47 },
	'wb_rggblevelsauto' => { 25 => 0x0, 26 => 0x1e, 27 => 0x18, 28 => 0x44, 29 => 0x44, 30 => 0x4c },
	'wb_rggblevelscloudy' => { 25 => 0xc, 26 => 0x2d, 27 => 0x31, 28 => 0x58, 29 => 0x5d, 30 => 0x65, 234 => 0x20f },
	'wb_rggblevelscustom' => { 25 => 0x1c, 28 => 0x80 },
	'wb_rggblevelscustom1' => { 26 => 0x41 },
	'wb_rggblevelscustom2' => { 26 => 0x46 },
	'wb_rggblevelsdaylight' => { 25 => 0x4, 26 => 0x23, 27 => 0x27, 28 => 0x4e, 29 => 0x53, 30 => 0x5b, 234 => 0x20d },
	'wb_rggblevelsflash' => { 25 => 0x18, 26 => 0x3c, 27 => 0x45, 28 => 0x6c, 29 => 0x71, 30 => 0x79, 234 => 0x214 },
	'wb_rggblevelsfluorescent' => { 25 => 0x14, 26 => 0x37, 27 => 0x3b, 28 => 0x62, 29 => 0x67, 30 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 234 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 234 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 234 => 0x213 },
	'wb_rggblevelskelvin' => { 25 => 0x20, 27 => 0x40, 28 => 0x67, 29 => 0x6c, 30 => 0x74 },
	'wb_rggblevelsmeasured' => { 28 => 0x49, 29 => 0x49, 30 => 0x51 },
	'wb_rggblevelspc1' => { 27 => 0x90, 28 => 0x71 },
	'wb_rggblevelspc2' => { 27 => 0x95, 28 => 0x76 },
	'wb_rggblevelspc3' => { 27 => 0x9a, 28 => 0x7b },
	'wb_rggblevelsshade' => { 25 => 0x8, 26 => 0x28, 27 => 0x2c, 28 => 0x53, 29 => 0x58, 30 => 0x60, 234 => 0x20e },
	'wb_rggblevelstungsten' => { 25 => 0x10, 26 => 0x32, 27 => 0x36, 28 => 0x5d, 29 => 0x62, 30 => 0x6a, 234 => 0x210 },
	'wb_rggblevelsunknown' => { 27 => 0x1d, 29 => 0x4e, 30 => 0x56 },
	'wb_rggblevelsunknown10' => { 27 => 0x72, 29 => 0x9e, 30 => 0xa6 },
	'wb_rggblevelsunknown11' => { 27 => 0x77, 29 => 0xa3, 30 => 0xab },
	'wb_rggblevelsunknown12' => { 27 => 0x7c, 30 => 0xb0 },
	'wb_rggblevelsunknown13' => { 27 => 0x81, 30 => 0xb5 },
	'wb_rggblevelsunknown14' => { 27 => 0x86 },
	'wb_rggblevelsunknown15' => { 27 => 0x8b },
	'wb_rggblevelsunknown16' => { 27 => 0x9f },
	'wb_rggblevelsunknown2' => { 27 => 0x4a, 29 => 0x76, 30 => 0x7e },
	'wb_rggblevelsunknown3' => { 27 => 0x4f, 29 => 0x7b, 30 => 0x83 },
	'wb_rggblevelsunknown4' => { 27 => 0x54, 29 => 0x80, 30 => 0x88 },
	'wb_rggblevelsunknown5' => { 27 => 0x59, 29 => 0x85, 30 => 0x8d },
	'wb_rggblevelsunknown6' => { 27 => 0x5e, 29 => 0x8a, 30 => 0x92 },
	'wb_rggblevelsunknown7' => { 27 => 0x63, 29 => 0x8f, 30 => 0x97 },
	'wb_rggblevelsunknown8' => { 27 => 0x68, 29 => 0x94, 30 => 0x9c },
	'wb_rggblevelsunknown9' => { 27 => 0x6d, 29 => 0x99, 30 => 0xa1 },
	'wbadjbluebalance' => { 187 => 0x8 },
	'wbadjcolortemp' => { 74 => 0x1a },
	'wbadjlighting' => { 187 => 0x15 },
	'wbadjlightingsubtype' => { 187 => 0x14 },
	'wbadjmode' => { 187 => 0x10 },
	'wbadjredbalance' => { 187 => 0x0 },
	'wbadjrgblevels' => { 74 => 0x8 },
	'wbadjtemperature' => { 187 => 0x18 },
	'wbadjtint' => { 187 => 0x25 },
	'wbadjustab' => { 213 => 0x46 },
	'wbadjustgm' => { 213 => 0x47 },
	'wbbluelevel' => { 208 => 0x324, 213 => 0x8006, 215 => 0x26 },
	'wbbracketmode' => { 35 => 0x9 },
	'wbbracketvalueab' => { 35 => 0xc },
	'wbbracketvaluegm' => { 35 => 0xd },
	'wbfinetuneactive' => { 74 => 0x24 },
	'wbfinetunesaturation' => { 74 => 0x28 },
	'wbfinetunetone' => { 74 => 0x2c },
	'wbgreenlevel' => { 208 => 0x323, 213 => 0x8005, 215 => 0x25 },
	'wbmediaimagesizesetting' => { 56 => 0x708 },
	'wbmode' => { 132 => 0x4, 198 => 0x1015 },
	'wbredlevel' => { 208 => 0x322, 213 => 0x8004, 215 => 0x24 },
	'wbscale' => { 133 => 0x0 },
	'wbshiftab' => { 49 => 0xc, 222 => 0x10 },
	'wbshiftgm' => { 49 => 0xd },
	'wbshiftmg' => { 222 => 0x11 },
	'webstatement' => { 291 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0x36, 7 => 0x5e, 8 => 0x36, 9 => [0x77,0x78], 10 => 0x6f, 11 => 0x6f, 12 => 0x73, 13 => 0x6f, 14 => 0x78, 15 => 0x54, 16 => 0x6f, 20 => 0x53, 49 => 0x8, 51 => 0x7, 76 => 0x7, 77 => [0x19,0x2012], 80 => [0xa403,0xfe4e], 84 => 0x1002, 91 => 0x3fc, 92 => 0xfa0d, 93 => 0x40, 125 => 0x3, 126 => 0xe, 127 => 0x4, 128 => 0xb, 129 => 0x115, 153 => 0x5, 171 => 0x7, 208 => 0x304, 213 => 0x3, 214 => 0x3033, 234 => 0x19, 238 => 0x7, 246 => 0x26, 253 => [0x3c,0x7], 257 => [0x115,0xb054], 268 => 'WhiteBalance', 272 => 'WhiteBalance' },
	'whitebalance2' => { 193 => 0x500 },
	'whitebalanceadj' => { 74 => 0x18, 181 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 218 => 0x0 },
	'whitebalancebias' => { 77 => 0x2011, 198 => 0x304, 213 => 0x23 },
	'whitebalanceblue' => { 49 => 0x7 },
	'whitebalancebracket' => { 193 => 0x502, 198 => 0x303 },
	'whitebalancebracketing' => { 128 => 0x22 },
	'whitebalancecomp' => { 201 => 0x1001 },
	'whitebalancefinetune' => { 84 => 0x100a, 128 => 0x38, 129 => 0x112, 153 => 0xb, 254 => 0x6, 257 => 0x112 },
	'whitebalancemode' => { 234 => 0x1a },
	'whitebalancered' => { 49 => 0x6 },
	'whitebalanceset' => { 221 => 0xa },
	'whitebalancesetting' => { 128 => 0x23 },
	'whitebalancetemperature' => { 193 => 0x501 },
	'whiteboard' => { 198 => 0x301 },
	'whitelevel' => { 80 => 0xc61d },
	'whitepoint' => { 80 => 0x13e, 234 => 0x201, 283 => 'WhitePoint' },
	'widefocuszone' => { 125 => 0x2f },
	'widerange' => { 252 => 0x20f },
	'wordcount' => { 278 => 'wordCount' },
	'workcolorspace' => { 74 => 0x270 },
	'worldtimelocation' => { 213 => 0x3a, 234 => 0x22, 237 => '0.1' },
	'writer-editor' => { 86 => 0x7a },
	'x3filllight' => { 253 => 0x12 },
	'xmp' => { 73 => 0xffff00f6, 81 => 'XMP' },
	'xmptoolkit' => { 284 => 'xmptk' },
	'xpauthor' => { 80 => 0x9c9d },
	'xpcomment' => { 80 => 0x9c9c },
	'xpkeywords' => { 80 => 0x9c9e },
	'xposition' => { 80 => 0x11e },
	'xpsubject' => { 80 => 0x9c9f },
	'xptitle' => { 80 => 0x9c9b },
	'xresolution' => { 80 => 0x11a, 89 => 0x3, 244 => 0x0, 283 => 'XResolution' },
	'xyresolution' => { 83 => 0x3 },
	'ycbcrcoefficients' => { 80 => 0x211, 283 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 80 => 0x213, 283 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 80 => 0x212, 283 => 'YCbCrSubSampling' },
	'yearcreated' => { 93 => 0x10, 102 => 0xc },
	'yposition' => { 80 => 0x11f },
	'yresolution' => { 80 => 0x11b, 89 => 0x5, 244 => 0x4, 283 => 'YResolution' },
	'zonematching' => { 129 => 0x10a, 132 => [0x3a,0x4a], 257 => 0xb024 },
	'zonematchingmode' => { 128 => 0x14 },
	'zonematchingon' => { 127 => 0x75 },
	'zonematchingvalue' => { 254 => 0x1f },
	'zoomedpreviewlength' => { 198 => 0xf05 },
	'zoomedpreviewsize' => { 198 => 0xf06 },
	'zoomedpreviewstart' => { 198 => 0xf04 },
	'zoomsourcewidth' => { 24 => 0x24 },
	'zoomstepcount' => { 196 => 0x300, 198 => 0x100d },
	'zoomtargetwidth' => { 24 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationextension' => 1,
	'animationiterations' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplebits' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo5dmkii_2a' => 1,
	'camerainfo5dmkii_2b' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datecompleted' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framewidth' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isbasefont' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isoinfo' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'linearized' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationname' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxtags' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primaryitemreference' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyimageheight' => 1,
	'sonyimagewidth' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'starttimecode' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'synchronizedlyrictext' => 1,
	'syncsampletable' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracks' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpextension' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) source hash of tag definitions, 1) destination table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagsHash, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagsHash)) {
            my $newInfo = $$tagsHash{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagsHash{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagsHash = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2010, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
