require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_DEV_MIDIVAR_H_)) {
    eval 'sub _SYS_DEV_MIDIVAR_H_ () {1;}' unless defined(&_SYS_DEV_MIDIVAR_H_);
    require 'dev/midi_if.ph';
    require 'sys/device.ph';
    require 'sys/selinfo.ph';
    require 'sys/proc.ph';
    require 'sys/timeout.ph';
    eval 'sub MIDI_MAXWRITE () {32;}' unless defined(&MIDI_MAXWRITE);
    eval 'sub MIDI_RATE () {3125;}' unless defined(&MIDI_RATE);
    eval 'sub MIDI_UNIT {
        my($a) = @_;
	    eval q((($a) & 0xff));
    }' unless defined(&MIDI_UNIT);
    eval 'sub MIDI_DEV2SC {
        my($a) = @_;
	    eval q(( ($midi_cd->{cd_devs[MIDI_UNIT($a)]})));
    }' unless defined(&MIDI_DEV2SC);
    require './dev/sequencer.ph';
    if((defined(&NSEQUENCER) ? &NSEQUENCER : undef) > 0) {
    }
    eval 'sub MIDIBUF_SIZE () {(1<< 10);}' unless defined(&MIDIBUF_SIZE);
    eval 'sub MIDIBUF_MASK () {( &MIDIBUF_SIZE - 1);}' unless defined(&MIDIBUF_MASK);
    eval 'sub MIDIBUF_START {
        my($buf) = @_;
	    eval q((($buf)-> &start));
    }' unless defined(&MIDIBUF_START);
    eval 'sub MIDIBUF_END {
        my($buf) = @_;
	    eval q(((($buf)-> &start + ($buf)-> &used) &  &MIDIBUF_MASK));
    }' unless defined(&MIDIBUF_END);
    eval 'sub MIDIBUF_USED {
        my($buf) = @_;
	    eval q((($buf)-> &used));
    }' unless defined(&MIDIBUF_USED);
    eval 'sub MIDIBUF_AVAIL {
        my($buf) = @_;
	    eval q(( &MIDIBUF_SIZE - ($buf)-> &used));
    }' unless defined(&MIDIBUF_AVAIL);
    eval 'sub MIDIBUF_ISFULL {
        my($buf) = @_;
	    eval q((($buf)-> &used >=  &MIDIBUF_SIZE));
    }' unless defined(&MIDIBUF_ISFULL);
    eval 'sub MIDIBUF_ISEMPTY {
        my($buf) = @_;
	    eval q((($buf)-> &used == 0));
    }' unless defined(&MIDIBUF_ISEMPTY);
    eval 'sub MIDIBUF_WRITE {
        my($buf, $byte) = @_;
	    eval q( &do { ($buf)-> $data[ &MIDIBUF_END($buf)] = ($byte); ($buf)-> &used++; }  &while(0));
    }' unless defined(&MIDIBUF_WRITE);
    eval 'sub MIDIBUF_READ {
        my($buf, $byte) = @_;
	    eval q( &do { ($byte) = ($buf)-> $data[($buf)-> &start++]; ($buf)-> &start &=  &MIDIBUF_MASK; ($buf)-> &used--; }  &while(0));
    }' unless defined(&MIDIBUF_READ);
    eval 'sub MIDIBUF_REMOVE {
        my($buf, $count) = @_;
	    eval q( &do { ($buf)-> &start += ($count); ($buf)-> &start &=  &MIDIBUF_MASK; ($buf)-> &used -= ($count); }  &while(0));
    }' unless defined(&MIDIBUF_REMOVE);
    eval 'sub MIDIBUF_INIT {
        my($buf) = @_;
	    eval q( &do { ($buf)-> &start = ($buf)-> &used = 0; }  &while(0));
    }' unless defined(&MIDIBUF_INIT);
    if((defined(&NSEQUENCER) ? &NSEQUENCER : undef) > 0) {
    }
}
1;
