require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&R92C_MAX_CHAINS)) {
    sub R92C_MAX_CHAINS () {	2;}
}
unless(defined(&R92C_MAX_EPOUT)) {
    sub R92C_MAX_EPOUT () {	3;}
}
unless(defined(&R92C_MAX_TX_PWR)) {
    sub R92C_MAX_TX_PWR () {	0x3f;}
}
unless(defined(&R92C_PUBQ_NPAGES)) {
    sub R92C_PUBQ_NPAGES () {	231;}
}
unless(defined(&R92C_TXPKTBUF_COUNT)) {
    sub R92C_TXPKTBUF_COUNT () {	256;}
}
unless(defined(&R92C_TX_PAGE_COUNT)) {
    sub R92C_TX_PAGE_COUNT () {	248;}
}
unless(defined(&R92C_TX_PAGE_BOUNDARY)) {
    sub R92C_TX_PAGE_BOUNDARY () {	( &R92C_TX_PAGE_COUNT + 1);}
}
unless(defined(&R92C_H2C_NBOX)) {
    sub R92C_H2C_NBOX () {	4;}
}
unless(defined(&R92C_REQ_REGS)) {
    sub R92C_REQ_REGS () {	0x5;}
}
unless(defined(&R92C_SYS_ISO_CTRL)) {
    sub R92C_SYS_ISO_CTRL () {	0x;}
}
unless(defined(&R92C_SYS_FUNC_EN)) {
    sub R92C_SYS_FUNC_EN () {	0x2;}
}
unless(defined(&R92C_APS_FSMCO)) {
    sub R92C_APS_FSMCO () {	0x4;}
}
unless(defined(&R92C_SYS_CLKR)) {
    sub R92C_SYS_CLKR () {	0x8;}
}
unless(defined(&R92C_AFE_MISC)) {
    sub R92C_AFE_MISC () {	0x10;}
}
unless(defined(&R92C_SPS0_CTRL)) {
    sub R92C_SPS0_CTRL () {	0x11;}
}
unless(defined(&R92C_SPS_OCP_CFG)) {
    sub R92C_SPS_OCP_CFG () {	0x18;}
}
unless(defined(&R92C_RSV_CTRL)) {
    sub R92C_RSV_CTRL () {	0x1c;}
}
unless(defined(&R92C_RF_CTRL)) {
    sub R92C_RF_CTRL () {	0x1f;}
}
unless(defined(&R92C_LDOA15_CTRL)) {
    sub R92C_LDOA15_CTRL () {	0x20;}
}
unless(defined(&R92C_LDOV12D_CTRL)) {
    sub R92C_LDOV12D_CTRL () {	0x21;}
}
unless(defined(&R92C_LDOHCI12_CTRL)) {
    sub R92C_LDOHCI12_CTRL () {	0x22;}
}
unless(defined(&R92C_LPLDO_CTRL)) {
    sub R92C_LPLDO_CTRL () {	0x23;}
}
unless(defined(&R92C_AFE_XTAL_CTRL)) {
    sub R92C_AFE_XTAL_CTRL () {	0x24;}
}
unless(defined(&R92C_AFE_PLL_CTRL)) {
    sub R92C_AFE_PLL_CTRL () {	0x28;}
}
unless(defined(&R92C_EFUSE_CTRL)) {
    sub R92C_EFUSE_CTRL () {	0x30;}
}
unless(defined(&R92C_EFUSE_TEST)) {
    sub R92C_EFUSE_TEST () {	0x34;}
}
unless(defined(&R92C_PWR_DATA)) {
    sub R92C_PWR_DATA () {	0x38;}
}
unless(defined(&R92C_CAL_TIMER)) {
    sub R92C_CAL_TIMER () {	0x3c;}
}
unless(defined(&R92C_ACLK_MON)) {
    sub R92C_ACLK_MON () {	0x3e;}
}
unless(defined(&R92C_GPIO_MUXCFG)) {
    sub R92C_GPIO_MUXCFG () {	0x40;}
}
unless(defined(&R92C_GPIO_IO_SEL)) {
    sub R92C_GPIO_IO_SEL () {	0x42;}
}
unless(defined(&R92C_MAC_PINMUX_CFG)) {
    sub R92C_MAC_PINMUX_CFG () {	0x43;}
}
unless(defined(&R92C_GPIO_PIN_CTRL)) {
    sub R92C_GPIO_PIN_CTRL () {	0x44;}
}
unless(defined(&R92C_GPIO_INTM)) {
    sub R92C_GPIO_INTM () {	0x48;}
}
unless(defined(&R92C_LEDCFG0)) {
    sub R92C_LEDCFG0 () {	0x4c;}
}
unless(defined(&R92C_LEDCFG1)) {
    sub R92C_LEDCFG1 () {	0x4d;}
}
unless(defined(&R92C_LEDCFG2)) {
    sub R92C_LEDCFG2 () {	0x4e;}
}
unless(defined(&R92C_LEDCFG3)) {
    sub R92C_LEDCFG3 () {	0x4f;}
}
unless(defined(&R92C_FSIMR)) {
    sub R92C_FSIMR () {	0x50;}
}
unless(defined(&R92C_FSISR)) {
    sub R92C_FSISR () {	0x54;}
}
unless(defined(&R92C_HSIMR)) {
    sub R92C_HSIMR () {	0x58;}
}
unless(defined(&R92C_HSISR)) {
    sub R92C_HSISR () {	0x5c;}
}
unless(defined(&R92C_MCUFWDL)) {
    sub R92C_MCUFWDL () {	0x80;}
}
unless(defined(&R92C_HMEBOX_EXT)) {
    sub R92C_HMEBOX_EXT {
	my($idx) = @_;
	eval q((0x88 + ($idx) * 2));
    }
}
unless(defined(&R92C_BIST_SCAN)) {
    sub R92C_BIST_SCAN () {	0xd0;}
}
unless(defined(&R92C_BIST_RPT)) {
    sub R92C_BIST_RPT () {	0xd4;}
}
unless(defined(&R92C_BIST_ROM_RPT)) {
    sub R92C_BIST_ROM_RPT () {	0xd8;}
}
unless(defined(&R92C_USB_SIE_INTF)) {
    sub R92C_USB_SIE_INTF () {	0xe0;}
}
unless(defined(&R92C_PCIE_MIO_INTF)) {
    sub R92C_PCIE_MIO_INTF () {	0xe4;}
}
unless(defined(&R92C_PCIE_MIO_INTD)) {
    sub R92C_PCIE_MIO_INTD () {	0xe8;}
}
unless(defined(&R92C_HPON_FSM)) {
    sub R92C_HPON_FSM () {	0xec;}
}
unless(defined(&R92C_SYS_CFG)) {
    sub R92C_SYS_CFG () {	0xf0;}
}
unless(defined(&R92C_CR)) {
    sub R92C_CR () {	0x100;}
}
unless(defined(&R92C_PBP)) {
    sub R92C_PBP () {	0x104;}
}
unless(defined(&R92C_TRXDMA_CTRL)) {
    sub R92C_TRXDMA_CTRL () {	0x10c;}
}
unless(defined(&R92C_TRXFF_BNDY)) {
    sub R92C_TRXFF_BNDY () {	0x114;}
}
unless(defined(&R92C_TRXFF_STATUS)) {
    sub R92C_TRXFF_STATUS () {	0x118;}
}
unless(defined(&R92C_RXFF_PTR)) {
    sub R92C_RXFF_PTR () {	0x11c;}
}
unless(defined(&R92C_HIMR)) {
    sub R92C_HIMR () {	0x120;}
}
unless(defined(&R92C_HISR)) {
    sub R92C_HISR () {	0x124;}
}
unless(defined(&R92C_HIMRE)) {
    sub R92C_HIMRE () {	0x128;}
}
unless(defined(&R92C_HISRE)) {
    sub R92C_HISRE () {	0x12c;}
}
unless(defined(&R92C_CPWM)) {
    sub R92C_CPWM () {	0x12f;}
}
unless(defined(&R92C_FWIMR)) {
    sub R92C_FWIMR () {	0x130;}
}
unless(defined(&R92C_FWISR)) {
    sub R92C_FWISR () {	0x134;}
}
unless(defined(&R92C_PKTBUF_DBG_CTRL)) {
    sub R92C_PKTBUF_DBG_CTRL () {	0x140;}
}
unless(defined(&R92C_PKTBUF_DBG_DATA_L)) {
    sub R92C_PKTBUF_DBG_DATA_L () {	0x144;}
}
unless(defined(&R92C_PKTBUF_DBG_DATA_H)) {
    sub R92C_PKTBUF_DBG_DATA_H () {	0x148;}
}
unless(defined(&R92C_TC0_CTRL)) {
    sub R92C_TC0_CTRL {
	my($i) = @_;
	eval q((0x150 + ($i) * 4));
    }
}
unless(defined(&R92C_TCUNIT_BASE)) {
    sub R92C_TCUNIT_BASE () {	0x164;}
}
unless(defined(&R92C_MBIST_START)) {
    sub R92C_MBIST_START () {	0x174;}
}
unless(defined(&R92C_MBIST_DONE)) {
    sub R92C_MBIST_DONE () {	0x178;}
}
unless(defined(&R92C_MBIST_FAIL)) {
    sub R92C_MBIST_FAIL () {	0x17c;}
}
unless(defined(&R92C_C2HEVT_MSG_NORMAL)) {
    sub R92C_C2HEVT_MSG_NORMAL () {	0x1a0;}
}
unless(defined(&R92C_C2HEVT_MSG_TEST)) {
    sub R92C_C2HEVT_MSG_TEST () {	0x1b8;}
}
unless(defined(&R92C_C2HEVT_CLEAR)) {
    sub R92C_C2HEVT_CLEAR () {	0x1bf;}
}
unless(defined(&R92C_MCUTST_1)) {
    sub R92C_MCUTST_1 () {	0x1c0;}
}
unless(defined(&R92C_FMETHR)) {
    sub R92C_FMETHR () {	0x1c8;}
}
unless(defined(&R92C_HMETFR)) {
    sub R92C_HMETFR () {	0x1cc;}
}
unless(defined(&R92C_HMEBOX)) {
    sub R92C_HMEBOX {
	my($idx) = @_;
	eval q((0x1d0 + ($idx) * 4));
    }
}
unless(defined(&R92C_LLT_INIT)) {
    sub R92C_LLT_INIT () {	0x1e0;}
}
unless(defined(&R92C_BB_ACCESS_CTRL)) {
    sub R92C_BB_ACCESS_CTRL () {	0x1e8;}
}
unless(defined(&R92C_BB_ACCESS_DATA)) {
    sub R92C_BB_ACCESS_DATA () {	0x1ec;}
}
unless(defined(&R92C_RQPN)) {
    sub R92C_RQPN () {	0x200;}
}
unless(defined(&R92C_FIFOPAGE)) {
    sub R92C_FIFOPAGE () {	0x204;}
}
unless(defined(&R92C_TDECTRL)) {
    sub R92C_TDECTRL () {	0x208;}
}
unless(defined(&R92C_TXDMA_OFFSET_CHK)) {
    sub R92C_TXDMA_OFFSET_CHK () {	0x20c;}
}
unless(defined(&R92C_TXDMA_STATUS)) {
    sub R92C_TXDMA_STATUS () {	0x210;}
}
unless(defined(&R92C_RQPN_NPQ)) {
    sub R92C_RQPN_NPQ () {	0x214;}
}
unless(defined(&R92C_RXDMA_AGG_PG_TH)) {
    sub R92C_RXDMA_AGG_PG_TH () {	0x280;}
}
unless(defined(&R92C_RXPKT_NUM)) {
    sub R92C_RXPKT_NUM () {	0x284;}
}
unless(defined(&R92C_RXDMA_STATUS)) {
    sub R92C_RXDMA_STATUS () {	0x288;}
}
unless(defined(&R92C_FWHW_TXQ_CTRL)) {
    sub R92C_FWHW_TXQ_CTRL () {	0x420;}
}
unless(defined(&R92C_HWSEQ_CTRL)) {
    sub R92C_HWSEQ_CTRL () {	0x423;}
}
unless(defined(&R92C_TXPKTBUF_BCNQ_BDNY)) {
    sub R92C_TXPKTBUF_BCNQ_BDNY () {	0x424;}
}
unless(defined(&R92C_TXPKTBUF_MGQ_BDNY)) {
    sub R92C_TXPKTBUF_MGQ_BDNY () {	0x425;}
}
unless(defined(&R92C_SPEC_SIFS)) {
    sub R92C_SPEC_SIFS () {	0x428;}
}
unless(defined(&R92C_RL)) {
    sub R92C_RL () {	0x42a;}
}
unless(defined(&R92C_DARFRC)) {
    sub R92C_DARFRC () {	0x430;}
}
unless(defined(&R92C_RARFRC)) {
    sub R92C_RARFRC () {	0x438;}
}
unless(defined(&R92C_RRSR)) {
    sub R92C_RRSR () {	0x440;}
}
unless(defined(&R92C_ARFR)) {
    sub R92C_ARFR {
	my($i) = @_;
	eval q((0x444 + ($i) * 4));
    }
}
unless(defined(&R92C_AGGLEN_LMT)) {
    sub R92C_AGGLEN_LMT () {	0x458;}
}
unless(defined(&R92C_AMPDU_MIN_SPACE)) {
    sub R92C_AMPDU_MIN_SPACE () {	0x45c;}
}
unless(defined(&R92C_TXPKTBUF_WMAC_LBK_BF_HD)) {
    sub R92C_TXPKTBUF_WMAC_LBK_BF_HD () {	0x45d;}
}
unless(defined(&R92C_FAST_EDCA_CTRL)) {
    sub R92C_FAST_EDCA_CTRL () {	0x460;}
}
unless(defined(&R92C_RD_RESP_PKT_TH)) {
    sub R92C_RD_RESP_PKT_TH () {	0x463;}
}
unless(defined(&R92C_INIRTS_RATE_SEL)) {
    sub R92C_INIRTS_RATE_SEL () {	0x480;}
}
unless(defined(&R92C_INIDATA_RATE_SEL)) {
    sub R92C_INIDATA_RATE_SEL {
	my($macid) = @_;
	eval q((0x484 + ($macid)));
    }
}
unless(defined(&R92C_EDCA_VO_PARAM)) {
    sub R92C_EDCA_VO_PARAM () {	0x500;}
}
unless(defined(&R92C_EDCA_VI_PARAM)) {
    sub R92C_EDCA_VI_PARAM () {	0x504;}
}
unless(defined(&R92C_EDCA_BE_PARAM)) {
    sub R92C_EDCA_BE_PARAM () {	0x508;}
}
unless(defined(&R92C_EDCA_BK_PARAM)) {
    sub R92C_EDCA_BK_PARAM () {	0x50c;}
}
unless(defined(&R92C_BCNTCFG)) {
    sub R92C_BCNTCFG () {	0x510;}
}
unless(defined(&R92C_PIFS)) {
    sub R92C_PIFS () {	0x512;}
}
unless(defined(&R92C_RDG_PIFS)) {
    sub R92C_RDG_PIFS () {	0x513;}
}
unless(defined(&R92C_SIFS_CCK)) {
    sub R92C_SIFS_CCK () {	0x514;}
}
unless(defined(&R92C_SIFS_OFDM)) {
    sub R92C_SIFS_OFDM () {	0x516;}
}
unless(defined(&R92C_AGGR_BREAK_TIME)) {
    sub R92C_AGGR_BREAK_TIME () {	0x51a;}
}
unless(defined(&R92C_SLOT)) {
    sub R92C_SLOT () {	0x51b;}
}
unless(defined(&R92C_TX_PTCL_CTRL)) {
    sub R92C_TX_PTCL_CTRL () {	0x520;}
}
unless(defined(&R92C_TXPAUSE)) {
    sub R92C_TXPAUSE () {	0x522;}
}
unless(defined(&R92C_DIS_TXREQ_CLR)) {
    sub R92C_DIS_TXREQ_CLR () {	0x523;}
}
unless(defined(&R92C_RD_CTRL)) {
    sub R92C_RD_CTRL () {	0x524;}
}
unless(defined(&R92C_TBTT_PROHIBIT)) {
    sub R92C_TBTT_PROHIBIT () {	0x540;}
}
unless(defined(&R92C_RD_NAV_NXT)) {
    sub R92C_RD_NAV_NXT () {	0x544;}
}
unless(defined(&R92C_NAV_PROT_LEN)) {
    sub R92C_NAV_PROT_LEN () {	0x546;}
}
unless(defined(&R92C_BCN_CTRL)) {
    sub R92C_BCN_CTRL () {	0x550;}
}
unless(defined(&R92C_USTIME_TSF)) {
    sub R92C_USTIME_TSF () {	0x551;}
}
unless(defined(&R92C_MBID_NUM)) {
    sub R92C_MBID_NUM () {	0x552;}
}
unless(defined(&R92C_DUAL_TSF_RST)) {
    sub R92C_DUAL_TSF_RST () {	0x553;}
}
unless(defined(&R92C_BCN_INTERVAL)) {
    sub R92C_BCN_INTERVAL () {	0x554;}
}
unless(defined(&R92C_DRVERLYINT)) {
    sub R92C_DRVERLYINT () {	0x558;}
}
unless(defined(&R92C_BCNDMATIM)) {
    sub R92C_BCNDMATIM () {	0x559;}
}
unless(defined(&R92C_ATIMWND)) {
    sub R92C_ATIMWND () {	0x55a;}
}
unless(defined(&R92C_BCN_MAX_ERR)) {
    sub R92C_BCN_MAX_ERR () {	0x55d;}
}
unless(defined(&R92C_RXTSF_OFFSET_CCK)) {
    sub R92C_RXTSF_OFFSET_CCK () {	0x55e;}
}
unless(defined(&R92C_RXTSF_OFFSET_OFDM)) {
    sub R92C_RXTSF_OFFSET_OFDM () {	0x55f;}
}
unless(defined(&R92C_TSFTR)) {
    sub R92C_TSFTR () {	0x560;}
}
unless(defined(&R92C_INIT_TSFTR)) {
    sub R92C_INIT_TSFTR () {	0x564;}
}
unless(defined(&R92C_PSTIMER)) {
    sub R92C_PSTIMER () {	0x580;}
}
unless(defined(&R92C_TIMER0)) {
    sub R92C_TIMER0 () {	0x584;}
}
unless(defined(&R92C_TIMER1)) {
    sub R92C_TIMER1 () {	0x588;}
}
unless(defined(&R92C_ACMHWCTRL)) {
    sub R92C_ACMHWCTRL () {	0x5c0;}
}
unless(defined(&R92C_ACMRSTCTRL)) {
    sub R92C_ACMRSTCTRL () {	0x5c1;}
}
unless(defined(&R92C_ACMAVG)) {
    sub R92C_ACMAVG () {	0x5c2;}
}
unless(defined(&R92C_VO_ADMTIME)) {
    sub R92C_VO_ADMTIME () {	0x5c4;}
}
unless(defined(&R92C_VI_ADMTIME)) {
    sub R92C_VI_ADMTIME () {	0x5c6;}
}
unless(defined(&R92C_BE_ADMTIME)) {
    sub R92C_BE_ADMTIME () {	0x5c8;}
}
unless(defined(&R92C_EDCA_RANDOM_GEN)) {
    sub R92C_EDCA_RANDOM_GEN () {	0x5cc;}
}
unless(defined(&R92C_SCH_TXCMD)) {
    sub R92C_SCH_TXCMD () {	0x5d0;}
}
unless(defined(&R92C_APSD_CTRL)) {
    sub R92C_APSD_CTRL () {	0x600;}
}
unless(defined(&R92C_BWOPMODE)) {
    sub R92C_BWOPMODE () {	0x603;}
}
unless(defined(&R92C_RCR)) {
    sub R92C_RCR () {	0x608;}
}
unless(defined(&R92C_RX_DRVINFO_SZ)) {
    sub R92C_RX_DRVINFO_SZ () {	0x60f;}
}
unless(defined(&R92C_MACID)) {
    sub R92C_MACID () {	0x610;}
}
unless(defined(&R92C_BSSID)) {
    sub R92C_BSSID () {	0x618;}
}
unless(defined(&R92C_MAR)) {
    sub R92C_MAR () {	0x620;}
}
unless(defined(&R92C_MAC_SPEC_SIFS)) {
    sub R92C_MAC_SPEC_SIFS () {	0x63a;}
}
unless(defined(&R92C_R2T_SIFS)) {
    sub R92C_R2T_SIFS () {	0x63c;}
}
unless(defined(&R92C_T2T_SIFS)) {
    sub R92C_T2T_SIFS () {	0x63e;}
}
unless(defined(&R92C_ACKTO)) {
    sub R92C_ACKTO () {	0x640;}
}
unless(defined(&R92C_CAMCMD)) {
    sub R92C_CAMCMD () {	0x670;}
}
unless(defined(&R92C_CAMWRITE)) {
    sub R92C_CAMWRITE () {	0x674;}
}
unless(defined(&R92C_CAMREAD)) {
    sub R92C_CAMREAD () {	0x678;}
}
unless(defined(&R92C_CAMDBG)) {
    sub R92C_CAMDBG () {	0x67c;}
}
unless(defined(&R92C_SECCFG)) {
    sub R92C_SECCFG () {	0x680;}
}
unless(defined(&R92C_RXFLTMAP0)) {
    sub R92C_RXFLTMAP0 () {	0x6a0;}
}
unless(defined(&R92C_RXFLTMAP1)) {
    sub R92C_RXFLTMAP1 () {	0x6a2;}
}
unless(defined(&R92C_RXFLTMAP2)) {
    sub R92C_RXFLTMAP2 () {	0x6a4;}
}
unless(defined(&R92C_SYS_ISO_CTRL_MD2PP)) {
    sub R92C_SYS_ISO_CTRL_MD2PP () {	0x1;}
}
unless(defined(&R92C_SYS_ISO_CTRL_UA2USB)) {
    sub R92C_SYS_ISO_CTRL_UA2USB () {	0x2;}
}
unless(defined(&R92C_SYS_ISO_CTRL_UD2CORE)) {
    sub R92C_SYS_ISO_CTRL_UD2CORE () {	0x4;}
}
unless(defined(&R92C_SYS_ISO_CTRL_PA2PCIE)) {
    sub R92C_SYS_ISO_CTRL_PA2PCIE () {	0x8;}
}
unless(defined(&R92C_SYS_ISO_CTRL_PD2CORE)) {
    sub R92C_SYS_ISO_CTRL_PD2CORE () {	0x10;}
}
unless(defined(&R92C_SYS_ISO_CTRL_IP2MAC)) {
    sub R92C_SYS_ISO_CTRL_IP2MAC () {	0x20;}
}
unless(defined(&R92C_SYS_ISO_CTRL_DIOP)) {
    sub R92C_SYS_ISO_CTRL_DIOP () {	0x40;}
}
unless(defined(&R92C_SYS_ISO_CTRL_DIOE)) {
    sub R92C_SYS_ISO_CTRL_DIOE () {	0x80;}
}
unless(defined(&R92C_SYS_ISO_CTRL_EB2CORE)) {
    sub R92C_SYS_ISO_CTRL_EB2CORE () {	0x100;}
}
unless(defined(&R92C_SYS_ISO_CTRL_DIOR)) {
    sub R92C_SYS_ISO_CTRL_DIOR () {	0x200;}
}
unless(defined(&R92C_SYS_ISO_CTRL_PWC_EV25V)) {
    sub R92C_SYS_ISO_CTRL_PWC_EV25V () {	0x4000;}
}
unless(defined(&R92C_SYS_ISO_CTRL_PWC_EV12V)) {
    sub R92C_SYS_ISO_CTRL_PWC_EV12V () {	0x8000;}
}
unless(defined(&R92C_SYS_FUNC_EN_BBRSTB)) {
    sub R92C_SYS_FUNC_EN_BBRSTB () {	0x1;}
}
unless(defined(&R92C_SYS_FUNC_EN_BB_GLB_RST)) {
    sub R92C_SYS_FUNC_EN_BB_GLB_RST () {	0x2;}
}
unless(defined(&R92C_SYS_FUNC_EN_USBA)) {
    sub R92C_SYS_FUNC_EN_USBA () {	0x4;}
}
unless(defined(&R92C_SYS_FUNC_EN_UPLL)) {
    sub R92C_SYS_FUNC_EN_UPLL () {	0x8;}
}
unless(defined(&R92C_SYS_FUNC_EN_USBD)) {
    sub R92C_SYS_FUNC_EN_USBD () {	0x10;}
}
unless(defined(&R92C_SYS_FUNC_EN_DIO_PCIE)) {
    sub R92C_SYS_FUNC_EN_DIO_PCIE () {	0x20;}
}
unless(defined(&R92C_SYS_FUNC_EN_PCIEA)) {
    sub R92C_SYS_FUNC_EN_PCIEA () {	0x40;}
}
unless(defined(&R92C_SYS_FUNC_EN_PPLL)) {
    sub R92C_SYS_FUNC_EN_PPLL () {	0x80;}
}
unless(defined(&R92C_SYS_FUNC_EN_PCIED)) {
    sub R92C_SYS_FUNC_EN_PCIED () {	0x100;}
}
unless(defined(&R92C_SYS_FUNC_EN_DIOE)) {
    sub R92C_SYS_FUNC_EN_DIOE () {	0x200;}
}
unless(defined(&R92C_SYS_FUNC_EN_CPUEN)) {
    sub R92C_SYS_FUNC_EN_CPUEN () {	0x400;}
}
unless(defined(&R92C_SYS_FUNC_EN_DCORE)) {
    sub R92C_SYS_FUNC_EN_DCORE () {	0x800;}
}
unless(defined(&R92C_SYS_FUNC_EN_ELDR)) {
    sub R92C_SYS_FUNC_EN_ELDR () {	0x1000;}
}
unless(defined(&R92C_SYS_FUNC_EN_DIO_RF)) {
    sub R92C_SYS_FUNC_EN_DIO_RF () {	0x2000;}
}
unless(defined(&R92C_SYS_FUNC_EN_HWPDN)) {
    sub R92C_SYS_FUNC_EN_HWPDN () {	0x4000;}
}
unless(defined(&R92C_SYS_FUNC_EN_MREGEN)) {
    sub R92C_SYS_FUNC_EN_MREGEN () {	0x8000;}
}
unless(defined(&R92C_APS_FSMCO_PFM_LDALL)) {
    sub R92C_APS_FSMCO_PFM_LDALL () {	0x1;}
}
unless(defined(&R92C_APS_FSMCO_PFM_ALDN)) {
    sub R92C_APS_FSMCO_PFM_ALDN () {	0x2;}
}
unless(defined(&R92C_APS_FSMCO_PFM_LDKP)) {
    sub R92C_APS_FSMCO_PFM_LDKP () {	0x4;}
}
unless(defined(&R92C_APS_FSMCO_PFM_WOWL)) {
    sub R92C_APS_FSMCO_PFM_WOWL () {	0x8;}
}
unless(defined(&R92C_APS_FSMCO_PDN_EN)) {
    sub R92C_APS_FSMCO_PDN_EN () {	0x10;}
}
unless(defined(&R92C_APS_FSMCO_PDN_PL)) {
    sub R92C_APS_FSMCO_PDN_PL () {	0x20;}
}
unless(defined(&R92C_APS_FSMCO_APFM_ONMAC)) {
    sub R92C_APS_FSMCO_APFM_ONMAC () {	0x100;}
}
unless(defined(&R92C_APS_FSMCO_APFM_OFF)) {
    sub R92C_APS_FSMCO_APFM_OFF () {	0x200;}
}
unless(defined(&R92C_APS_FSMCO_APFM_RSM)) {
    sub R92C_APS_FSMCO_APFM_RSM () {	0x400;}
}
unless(defined(&R92C_APS_FSMCO_AFSM_HSUS)) {
    sub R92C_APS_FSMCO_AFSM_HSUS () {	0x800;}
}
unless(defined(&R92C_APS_FSMCO_AFSM_PCIE)) {
    sub R92C_APS_FSMCO_AFSM_PCIE () {	0x1000;}
}
unless(defined(&R92C_APS_FSMCO_APDM_MAC)) {
    sub R92C_APS_FSMCO_APDM_MAC () {	0x2000;}
}
unless(defined(&R92C_APS_FSMCO_APDM_HOST)) {
    sub R92C_APS_FSMCO_APDM_HOST () {	0x4000;}
}
unless(defined(&R92C_APS_FSMCO_APDM_HPDN)) {
    sub R92C_APS_FSMCO_APDM_HPDN () {	0x8000;}
}
unless(defined(&R92C_APS_FSMCO_RDY_MACON)) {
    sub R92C_APS_FSMCO_RDY_MACON () {	0x10000;}
}
unless(defined(&R92C_APS_FSMCO_SUS_HOST)) {
    sub R92C_APS_FSMCO_SUS_HOST () {	0x20000;}
}
unless(defined(&R92C_APS_FSMCO_ROP_ALD)) {
    sub R92C_APS_FSMCO_ROP_ALD () {	0x100000;}
}
unless(defined(&R92C_APS_FSMCO_ROP_PWR)) {
    sub R92C_APS_FSMCO_ROP_PWR () {	0x200000;}
}
unless(defined(&R92C_APS_FSMCO_ROP_SPS)) {
    sub R92C_APS_FSMCO_ROP_SPS () {	0x400000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_MRST)) {
    sub R92C_APS_FSMCO_SOP_MRST () {	0x2000000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_FUSE)) {
    sub R92C_APS_FSMCO_SOP_FUSE () {	0x4000000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_ABG)) {
    sub R92C_APS_FSMCO_SOP_ABG () {	0x8000000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_AMB)) {
    sub R92C_APS_FSMCO_SOP_AMB () {	0x10000000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_RCK)) {
    sub R92C_APS_FSMCO_SOP_RCK () {	0x20000000;}
}
unless(defined(&R92C_APS_FSMCO_SOP_A8M)) {
    sub R92C_APS_FSMCO_SOP_A8M () {	0x40000000;}
}
unless(defined(&R92C_APS_FSMCO_XOP_BTCK)) {
    sub R92C_APS_FSMCO_XOP_BTCK () {	0x80000000;}
}
unless(defined(&R92C_SYS_CLKR_ANAD16V_EN)) {
    sub R92C_SYS_CLKR_ANAD16V_EN () {	0x1;}
}
unless(defined(&R92C_SYS_CLKR_ANA8M)) {
    sub R92C_SYS_CLKR_ANA8M () {	0x2;}
}
unless(defined(&R92C_SYS_CLKR_MACSLP)) {
    sub R92C_SYS_CLKR_MACSLP () {	0x10;}
}
unless(defined(&R92C_SYS_CLKR_LOADER_EN)) {
    sub R92C_SYS_CLKR_LOADER_EN () {	0x20;}
}
unless(defined(&R92C_SYS_CLKR_80M_SSC_DIS)) {
    sub R92C_SYS_CLKR_80M_SSC_DIS () {	0x80;}
}
unless(defined(&R92C_SYS_CLKR_80M_SSC_EN_HO)) {
    sub R92C_SYS_CLKR_80M_SSC_EN_HO () {	0x100;}
}
unless(defined(&R92C_SYS_CLKR_PHY_SSC_RSTB)) {
    sub R92C_SYS_CLKR_PHY_SSC_RSTB () {	0x200;}
}
unless(defined(&R92C_SYS_CLKR_SEC_EN)) {
    sub R92C_SYS_CLKR_SEC_EN () {	0x400;}
}
unless(defined(&R92C_SYS_CLKR_MAC_EN)) {
    sub R92C_SYS_CLKR_MAC_EN () {	0x800;}
}
unless(defined(&R92C_SYS_CLKR_SYS_EN)) {
    sub R92C_SYS_CLKR_SYS_EN () {	0x1000;}
}
unless(defined(&R92C_SYS_CLKR_RING_EN)) {
    sub R92C_SYS_CLKR_RING_EN () {	0x2000;}
}
unless(defined(&R92C_RF_CTRL_EN)) {
    sub R92C_RF_CTRL_EN () {	0x1;}
}
unless(defined(&R92C_RF_CTRL_RSTB)) {
    sub R92C_RF_CTRL_RSTB () {	0x2;}
}
unless(defined(&R92C_RF_CTRL_SDMRSTB)) {
    sub R92C_RF_CTRL_SDMRSTB () {	0x4;}
}
unless(defined(&R92C_LDOV12D_CTRL_LDV12_EN)) {
    sub R92C_LDOV12D_CTRL_LDV12_EN () {	0x1;}
}
unless(defined(&R92C_EFUSE_CTRL_DATA_M)) {
    sub R92C_EFUSE_CTRL_DATA_M () {	0xff;}
}
unless(defined(&R92C_EFUSE_CTRL_DATA_S)) {
    sub R92C_EFUSE_CTRL_DATA_S () {	0;}
}
unless(defined(&R92C_EFUSE_CTRL_ADDR_M)) {
    sub R92C_EFUSE_CTRL_ADDR_M () {	0x3ff00;}
}
unless(defined(&R92C_EFUSE_CTRL_ADDR_S)) {
    sub R92C_EFUSE_CTRL_ADDR_S () {	8;}
}
unless(defined(&R92C_EFUSE_CTRL_VALID)) {
    sub R92C_EFUSE_CTRL_VALID () {	0x80000000;}
}
unless(defined(&R92C_GPIO_MUXCFG_ENBT)) {
    sub R92C_GPIO_MUXCFG_ENBT () {	0x20;}
}
unless(defined(&R92C_LEDCFG0_DIS)) {
    sub R92C_LEDCFG0_DIS () {	0x8;}
}
unless(defined(&R92C_MCUFWDL_EN)) {
    sub R92C_MCUFWDL_EN () {	0x1;}
}
unless(defined(&R92C_MCUFWDL_RDY)) {
    sub R92C_MCUFWDL_RDY () {	0x2;}
}
unless(defined(&R92C_MCUFWDL_CHKSUM_RPT)) {
    sub R92C_MCUFWDL_CHKSUM_RPT () {	0x4;}
}
unless(defined(&R92C_MCUFWDL_MACINI_RDY)) {
    sub R92C_MCUFWDL_MACINI_RDY () {	0x8;}
}
unless(defined(&R92C_MCUFWDL_BBINI_RDY)) {
    sub R92C_MCUFWDL_BBINI_RDY () {	0x10;}
}
unless(defined(&R92C_MCUFWDL_RFINI_RDY)) {
    sub R92C_MCUFWDL_RFINI_RDY () {	0x20;}
}
unless(defined(&R92C_MCUFWDL_WINTINI_RDY)) {
    sub R92C_MCUFWDL_WINTINI_RDY () {	0x40;}
}
unless(defined(&R92C_MCUFWDL_PAGE_M)) {
    sub R92C_MCUFWDL_PAGE_M () {	0x70000;}
}
unless(defined(&R92C_MCUFWDL_PAGE_S)) {
    sub R92C_MCUFWDL_PAGE_S () {	16;}
}
unless(defined(&R92C_MCUFWDL_CPRST)) {
    sub R92C_MCUFWDL_CPRST () {	0x800000;}
}
unless(defined(&R92C_HPON_FSM_CHIP_BONDING_ID_S)) {
    sub R92C_HPON_FSM_CHIP_BONDING_ID_S () {	22;}
}
unless(defined(&R92C_HPON_FSM_CHIP_BONDING_ID_M)) {
    sub R92C_HPON_FSM_CHIP_BONDING_ID_M () {	0xc00000;}
}
unless(defined(&R92C_HPON_FSM_CHIP_BONDING_ID_92C_1T2R)) {
    sub R92C_HPON_FSM_CHIP_BONDING_ID_92C_1T2R () {	1;}
}
unless(defined(&R92C_SYS_CFG_XCLK_VLD)) {
    sub R92C_SYS_CFG_XCLK_VLD () {	0x1;}
}
unless(defined(&R92C_SYS_CFG_ACLK_VLD)) {
    sub R92C_SYS_CFG_ACLK_VLD () {	0x2;}
}
unless(defined(&R92C_SYS_CFG_UCLK_VLD)) {
    sub R92C_SYS_CFG_UCLK_VLD () {	0x4;}
}
unless(defined(&R92C_SYS_CFG_PCLK_VLD)) {
    sub R92C_SYS_CFG_PCLK_VLD () {	0x8;}
}
unless(defined(&R92C_SYS_CFG_PCIRSTB)) {
    sub R92C_SYS_CFG_PCIRSTB () {	0x10;}
}
unless(defined(&R92C_SYS_CFG_V15_VLD)) {
    sub R92C_SYS_CFG_V15_VLD () {	0x20;}
}
unless(defined(&R92C_SYS_CFG_TRP_B15V_EN)) {
    sub R92C_SYS_CFG_TRP_B15V_EN () {	0x80;}
}
unless(defined(&R92C_SYS_CFG_SIC_IDLE)) {
    sub R92C_SYS_CFG_SIC_IDLE () {	0x100;}
}
unless(defined(&R92C_SYS_CFG_BD_MAC2)) {
    sub R92C_SYS_CFG_BD_MAC2 () {	0x200;}
}
unless(defined(&R92C_SYS_CFG_BD_MAC1)) {
    sub R92C_SYS_CFG_BD_MAC1 () {	0x400;}
}
unless(defined(&R92C_SYS_CFG_IC_MACPHY_MODE)) {
    sub R92C_SYS_CFG_IC_MACPHY_MODE () {	0x800;}
}
unless(defined(&R92C_SYS_CFG_CHIP_VER_RTL_M)) {
    sub R92C_SYS_CFG_CHIP_VER_RTL_M () {	0xf000;}
}
unless(defined(&R92C_SYS_CFG_CHIP_VER_RTL_S)) {
    sub R92C_SYS_CFG_CHIP_VER_RTL_S () {	12;}
}
unless(defined(&R92C_SYS_CFG_BT_FUNC)) {
    sub R92C_SYS_CFG_BT_FUNC () {	0x10000;}
}
unless(defined(&R92C_SYS_CFG_VENDOR_UMC)) {
    sub R92C_SYS_CFG_VENDOR_UMC () {	0x80000;}
}
unless(defined(&R92C_SYS_CFG_PAD_HWPD_IDN)) {
    sub R92C_SYS_CFG_PAD_HWPD_IDN () {	0x400000;}
}
unless(defined(&R92C_SYS_CFG_TRP_VAUX_EN)) {
    sub R92C_SYS_CFG_TRP_VAUX_EN () {	0x800000;}
}
unless(defined(&R92C_SYS_CFG_TRP_BT_EN)) {
    sub R92C_SYS_CFG_TRP_BT_EN () {	0x1000000;}
}
unless(defined(&R92C_SYS_CFG_BD_PKG_SEL)) {
    sub R92C_SYS_CFG_BD_PKG_SEL () {	0x2000000;}
}
unless(defined(&R92C_SYS_CFG_BD_HCI_SEL)) {
    sub R92C_SYS_CFG_BD_HCI_SEL () {	0x4000000;}
}
unless(defined(&R92C_SYS_CFG_TYPE_92C)) {
    sub R92C_SYS_CFG_TYPE_92C () {	0x8000000;}
}
unless(defined(&R92C_CR_HCI_TXDMA_EN)) {
    sub R92C_CR_HCI_TXDMA_EN () {	0x1;}
}
unless(defined(&R92C_CR_HCI_RXDMA_EN)) {
    sub R92C_CR_HCI_RXDMA_EN () {	0x2;}
}
unless(defined(&R92C_CR_TXDMA_EN)) {
    sub R92C_CR_TXDMA_EN () {	0x4;}
}
unless(defined(&R92C_CR_RXDMA_EN)) {
    sub R92C_CR_RXDMA_EN () {	0x8;}
}
unless(defined(&R92C_CR_PROTOCOL_EN)) {
    sub R92C_CR_PROTOCOL_EN () {	0x10;}
}
unless(defined(&R92C_CR_SCHEDULE_EN)) {
    sub R92C_CR_SCHEDULE_EN () {	0x20;}
}
unless(defined(&R92C_CR_MACTXEN)) {
    sub R92C_CR_MACTXEN () {	0x40;}
}
unless(defined(&R92C_CR_MACRXEN)) {
    sub R92C_CR_MACRXEN () {	0x80;}
}
unless(defined(&R92C_CR_ENSEC)) {
    sub R92C_CR_ENSEC () {	0x200;}
}
unless(defined(&R92C_CR_NETTYPE_S)) {
    sub R92C_CR_NETTYPE_S () {	16;}
}
unless(defined(&R92C_CR_NETTYPE_M)) {
    sub R92C_CR_NETTYPE_M () {	0x30000;}
}
unless(defined(&R92C_CR_NETTYPE_NOLINK)) {
    sub R92C_CR_NETTYPE_NOLINK () {	0;}
}
unless(defined(&R92C_CR_NETTYPE_ADHOC)) {
    sub R92C_CR_NETTYPE_ADHOC () {	1;}
}
unless(defined(&R92C_CR_NETTYPE_INFRA)) {
    sub R92C_CR_NETTYPE_INFRA () {	2;}
}
unless(defined(&R92C_CR_NETTYPE_AP)) {
    sub R92C_CR_NETTYPE_AP () {	3;}
}
unless(defined(&R92C_PBP_PSRX_M)) {
    sub R92C_PBP_PSRX_M () {	0xf;}
}
unless(defined(&R92C_PBP_PSRX_S)) {
    sub R92C_PBP_PSRX_S () {	0;}
}
unless(defined(&R92C_PBP_PSTX_M)) {
    sub R92C_PBP_PSTX_M () {	0xf0;}
}
unless(defined(&R92C_PBP_PSTX_S)) {
    sub R92C_PBP_PSTX_S () {	4;}
}
unless(defined(&R92C_PBP_64)) {
    sub R92C_PBP_64 () {	0;}
}
unless(defined(&R92C_PBP_128)) {
    sub R92C_PBP_128 () {	1;}
}
unless(defined(&R92C_PBP_256)) {
    sub R92C_PBP_256 () {	2;}
}
unless(defined(&R92C_PBP_512)) {
    sub R92C_PBP_512 () {	3;}
}
unless(defined(&R92C_PBP_1024)) {
    sub R92C_PBP_1024 () {	4;}
}
unless(defined(&R92C_TRXDMA_CTRL_RXDMA_AGG_EN)) {
    sub R92C_TRXDMA_CTRL_RXDMA_AGG_EN () {	0x4;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_VOQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_VOQ_MAP_M () {	0x30;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_VOQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_VOQ_MAP_S () {	4;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_VIQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_VIQ_MAP_M () {	0xc0;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_VIQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_VIQ_MAP_S () {	6;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_BEQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_BEQ_MAP_M () {	0x300;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_BEQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_BEQ_MAP_S () {	8;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_BKQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_BKQ_MAP_M () {	0xc00;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_BKQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_BKQ_MAP_S () {	10;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_MGQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_MGQ_MAP_M () {	0x3000;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_MGQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_MGQ_MAP_S () {	12;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_HIQ_MAP_M)) {
    sub R92C_TRXDMA_CTRL_TXDMA_HIQ_MAP_M () {	0xc000;}
}
unless(defined(&R92C_TRXDMA_CTRL_TXDMA_HIQ_MAP_S)) {
    sub R92C_TRXDMA_CTRL_TXDMA_HIQ_MAP_S () {	14;}
}
unless(defined(&R92C_TRXDMA_CTRL_QUEUE_LOW)) {
    sub R92C_TRXDMA_CTRL_QUEUE_LOW () {	1;}
}
unless(defined(&R92C_TRXDMA_CTRL_QUEUE_NORMAL)) {
    sub R92C_TRXDMA_CTRL_QUEUE_NORMAL () {	2;}
}
unless(defined(&R92C_TRXDMA_CTRL_QUEUE_HIGH)) {
    sub R92C_TRXDMA_CTRL_QUEUE_HIGH () {	3;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_M)) {
    sub R92C_TRXDMA_CTRL_QMAP_M () {	0xfff0;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_3EP)) {
    sub R92C_TRXDMA_CTRL_QMAP_3EP () {	0xf5b0;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_HQ_LQ)) {
    sub R92C_TRXDMA_CTRL_QMAP_HQ_LQ () {	0xf5f0;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_HQ_NQ)) {
    sub R92C_TRXDMA_CTRL_QMAP_HQ_NQ () {	0xfaf0;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_LQ)) {
    sub R92C_TRXDMA_CTRL_QMAP_LQ () {	0x5550;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_NQ)) {
    sub R92C_TRXDMA_CTRL_QMAP_NQ () {	0xaaa0;}
}
unless(defined(&R92C_TRXDMA_CTRL_QMAP_HQ)) {
    sub R92C_TRXDMA_CTRL_QMAP_HQ () {	0xfff0;}
}
unless(defined(&R92C_LLT_INIT_DATA_M)) {
    sub R92C_LLT_INIT_DATA_M () {	0xff;}
}
unless(defined(&R92C_LLT_INIT_DATA_S)) {
    sub R92C_LLT_INIT_DATA_S () {	0;}
}
unless(defined(&R92C_LLT_INIT_ADDR_M)) {
    sub R92C_LLT_INIT_ADDR_M () {	0xff00;}
}
unless(defined(&R92C_LLT_INIT_ADDR_S)) {
    sub R92C_LLT_INIT_ADDR_S () {	8;}
}
unless(defined(&R92C_LLT_INIT_OP_M)) {
    sub R92C_LLT_INIT_OP_M () {	0xc0000000;}
}
unless(defined(&R92C_LLT_INIT_OP_S)) {
    sub R92C_LLT_INIT_OP_S () {	30;}
}
unless(defined(&R92C_LLT_INIT_OP_NO_ACTIVE)) {
    sub R92C_LLT_INIT_OP_NO_ACTIVE () {	0;}
}
unless(defined(&R92C_LLT_INIT_OP_WRITE)) {
    sub R92C_LLT_INIT_OP_WRITE () {	1;}
}
unless(defined(&R92C_RQPN_HPQ_M)) {
    sub R92C_RQPN_HPQ_M () {	0xff;}
}
unless(defined(&R92C_RQPN_HPQ_S)) {
    sub R92C_RQPN_HPQ_S () {	0;}
}
unless(defined(&R92C_RQPN_LPQ_M)) {
    sub R92C_RQPN_LPQ_M () {	0xff00;}
}
unless(defined(&R92C_RQPN_LPQ_S)) {
    sub R92C_RQPN_LPQ_S () {	8;}
}
unless(defined(&R92C_RQPN_PUBQ_M)) {
    sub R92C_RQPN_PUBQ_M () {	0xff0000;}
}
unless(defined(&R92C_RQPN_PUBQ_S)) {
    sub R92C_RQPN_PUBQ_S () {	16;}
}
unless(defined(&R92C_RQPN_LD)) {
    sub R92C_RQPN_LD () {	0x80000000;}
}
unless(defined(&R92C_TDECTRL_BLK_DESC_NUM_M)) {
    sub R92C_TDECTRL_BLK_DESC_NUM_M () {	0xf;}
}
unless(defined(&R92C_TDECTRL_BLK_DESC_NUM_S)) {
    sub R92C_TDECTRL_BLK_DESC_NUM_S () {	4;}
}
unless(defined(&R92C_FWHW_TXQ_CTRL_AMPDU_RTY_NEW)) {
    sub R92C_FWHW_TXQ_CTRL_AMPDU_RTY_NEW () {	0x80;}
}
unless(defined(&R92C_SPEC_SIFS_CCK_M)) {
    sub R92C_SPEC_SIFS_CCK_M () {	0xff;}
}
unless(defined(&R92C_SPEC_SIFS_CCK_S)) {
    sub R92C_SPEC_SIFS_CCK_S () {	0;}
}
unless(defined(&R92C_SPEC_SIFS_OFDM_M)) {
    sub R92C_SPEC_SIFS_OFDM_M () {	0xff00;}
}
unless(defined(&R92C_SPEC_SIFS_OFDM_S)) {
    sub R92C_SPEC_SIFS_OFDM_S () {	8;}
}
unless(defined(&R92C_RL_LRL_M)) {
    sub R92C_RL_LRL_M () {	0x3f;}
}
unless(defined(&R92C_RL_LRL_S)) {
    sub R92C_RL_LRL_S () {	0;}
}
unless(defined(&R92C_RL_SRL_M)) {
    sub R92C_RL_SRL_M () {	0x3f00;}
}
unless(defined(&R92C_RL_SRL_S)) {
    sub R92C_RL_SRL_S () {	8;}
}
unless(defined(&R92C_RRSR_RATE_BITMAP_M)) {
    sub R92C_RRSR_RATE_BITMAP_M () {	0xfffff;}
}
unless(defined(&R92C_RRSR_RATE_BITMAP_S)) {
    sub R92C_RRSR_RATE_BITMAP_S () {	0;}
}
unless(defined(&R92C_RRSR_RATE_CCK_ONLY_1M)) {
    sub R92C_RRSR_RATE_CCK_ONLY_1M () {	0xffff1;}
}
unless(defined(&R92C_RRSR_RSC_LOWSUBCHNL)) {
    sub R92C_RRSR_RSC_LOWSUBCHNL () {	0x200000;}
}
unless(defined(&R92C_RRSR_RSC_UPSUBCHNL)) {
    sub R92C_RRSR_RSC_UPSUBCHNL () {	0x400000;}
}
unless(defined(&R92C_RRSR_SHORT)) {
    sub R92C_RRSR_SHORT () {	0x800000;}
}
unless(defined(&R92C_EDCA_PARAM_AIFS_M)) {
    sub R92C_EDCA_PARAM_AIFS_M () {	0xff;}
}
unless(defined(&R92C_EDCA_PARAM_AIFS_S)) {
    sub R92C_EDCA_PARAM_AIFS_S () {	0;}
}
unless(defined(&R92C_EDCA_PARAM_ECWMIN_M)) {
    sub R92C_EDCA_PARAM_ECWMIN_M () {	0xf00;}
}
unless(defined(&R92C_EDCA_PARAM_ECWMIN_S)) {
    sub R92C_EDCA_PARAM_ECWMIN_S () {	8;}
}
unless(defined(&R92C_EDCA_PARAM_ECWMAX_M)) {
    sub R92C_EDCA_PARAM_ECWMAX_M () {	0xf000;}
}
unless(defined(&R92C_EDCA_PARAM_ECWMAX_S)) {
    sub R92C_EDCA_PARAM_ECWMAX_S () {	12;}
}
unless(defined(&R92C_EDCA_PARAM_TXOP_M)) {
    sub R92C_EDCA_PARAM_TXOP_M () {	0xffff0000;}
}
unless(defined(&R92C_EDCA_PARAM_TXOP_S)) {
    sub R92C_EDCA_PARAM_TXOP_S () {	16;}
}
unless(defined(&R92C_BCN_CTRL_EN_MBSSID)) {
    sub R92C_BCN_CTRL_EN_MBSSID () {	0x2;}
}
unless(defined(&R92C_BCN_CTRL_TXBCN_RPT)) {
    sub R92C_BCN_CTRL_TXBCN_RPT () {	0x4;}
}
unless(defined(&R92C_BCN_CTRL_EN_BCN)) {
    sub R92C_BCN_CTRL_EN_BCN () {	0x8;}
}
unless(defined(&R92C_BCN_CTRL_DIS_TSF_UDT0)) {
    sub R92C_BCN_CTRL_DIS_TSF_UDT0 () {	0x10;}
}
unless(defined(&R92C_APSD_CTRL_OFF)) {
    sub R92C_APSD_CTRL_OFF () {	0x40;}
}
unless(defined(&R92C_APSD_CTRL_OFF_STATUS)) {
    sub R92C_APSD_CTRL_OFF_STATUS () {	0x80;}
}
unless(defined(&R92C_BWOPMODE_11J)) {
    sub R92C_BWOPMODE_11J () {	0x1;}
}
unless(defined(&R92C_BWOPMODE_5G)) {
    sub R92C_BWOPMODE_5G () {	0x2;}
}
unless(defined(&R92C_BWOPMODE_20MHZ)) {
    sub R92C_BWOPMODE_20MHZ () {	0x4;}
}
unless(defined(&R92C_RCR_AAP)) {
    sub R92C_RCR_AAP () {	0x1;}
}
unless(defined(&R92C_RCR_APM)) {
    sub R92C_RCR_APM () {	0x2;}
}
unless(defined(&R92C_RCR_AM)) {
    sub R92C_RCR_AM () {	0x4;}
}
unless(defined(&R92C_RCR_AB)) {
    sub R92C_RCR_AB () {	0x8;}
}
unless(defined(&R92C_RCR_ADD3)) {
    sub R92C_RCR_ADD3 () {	0x10;}
}
unless(defined(&R92C_RCR_APWRMGT)) {
    sub R92C_RCR_APWRMGT () {	0x20;}
}
unless(defined(&R92C_RCR_CBSSID_DATA)) {
    sub R92C_RCR_CBSSID_DATA () {	0x40;}
}
unless(defined(&R92C_RCR_CBSSID_BCN)) {
    sub R92C_RCR_CBSSID_BCN () {	0x80;}
}
unless(defined(&R92C_RCR_ACRC32)) {
    sub R92C_RCR_ACRC32 () {	0x100;}
}
unless(defined(&R92C_RCR_AICV)) {
    sub R92C_RCR_AICV () {	0x200;}
}
unless(defined(&R92C_RCR_ADF)) {
    sub R92C_RCR_ADF () {	0x800;}
}
unless(defined(&R92C_RCR_ACF)) {
    sub R92C_RCR_ACF () {	0x1000;}
}
unless(defined(&R92C_RCR_AMF)) {
    sub R92C_RCR_AMF () {	0x2000;}
}
unless(defined(&R92C_RCR_HTC_LOC_CTRL)) {
    sub R92C_RCR_HTC_LOC_CTRL () {	0x4000;}
}
unless(defined(&R92C_RCR_MFBEN)) {
    sub R92C_RCR_MFBEN () {	0x400000;}
}
unless(defined(&R92C_RCR_LSIGEN)) {
    sub R92C_RCR_LSIGEN () {	0x800000;}
}
unless(defined(&R92C_RCR_ENMBID)) {
    sub R92C_RCR_ENMBID () {	0x1000000;}
}
unless(defined(&R92C_RCR_APP_BA_SSN)) {
    sub R92C_RCR_APP_BA_SSN () {	0x8000000;}
}
unless(defined(&R92C_RCR_APP_PHYSTS)) {
    sub R92C_RCR_APP_PHYSTS () {	0x10000000;}
}
unless(defined(&R92C_RCR_APP_ICV)) {
    sub R92C_RCR_APP_ICV () {	0x20000000;}
}
unless(defined(&R92C_RCR_APP_MIC)) {
    sub R92C_RCR_APP_MIC () {	0x40000000;}
}
unless(defined(&R92C_RCR_APPFCS)) {
    sub R92C_RCR_APPFCS () {	0x80000000;}
}
unless(defined(&R92C_CAMCMD_ADDR_M)) {
    sub R92C_CAMCMD_ADDR_M () {	0xffff;}
}
unless(defined(&R92C_CAMCMD_ADDR_S)) {
    sub R92C_CAMCMD_ADDR_S () {	0;}
}
unless(defined(&R92C_CAMCMD_WRITE)) {
    sub R92C_CAMCMD_WRITE () {	0x10000;}
}
unless(defined(&R92C_CAMCMD_CLR)) {
    sub R92C_CAMCMD_CLR () {	0x40000000;}
}
unless(defined(&R92C_CAMCMD_POLLING)) {
    sub R92C_CAMCMD_POLLING () {	0x80000000;}
}
unless(defined(&R92C_FPGA0_RFMOD)) {
    sub R92C_FPGA0_RFMOD () {	0x800;}
}
unless(defined(&R92C_FPGA0_TXINFO)) {
    sub R92C_FPGA0_TXINFO () {	0x804;}
}
unless(defined(&R92C_HSSI_PARAM1)) {
    sub R92C_HSSI_PARAM1 {
	my($chain) = @_;
	eval q((0x820 + ($chain) * 8));
    }
}
unless(defined(&R92C_HSSI_PARAM2)) {
    sub R92C_HSSI_PARAM2 {
	my($chain) = @_;
	eval q((0x824 + ($chain) * 8));
    }
}
unless(defined(&R92C_TXAGC_RATE18_06)) {
    sub R92C_TXAGC_RATE18_06 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe00 : 0x830));
    }
}
unless(defined(&R92C_TXAGC_RATE54_24)) {
    sub R92C_TXAGC_RATE54_24 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe04 : 0x834));
    }
}
unless(defined(&R92C_TXAGC_A_CCK1_MCS32)) {
    sub R92C_TXAGC_A_CCK1_MCS32 () {	0xe08;}
}
unless(defined(&R92C_TXAGC_B_CCK1_55_MCS32)) {
    sub R92C_TXAGC_B_CCK1_55_MCS32 () {	0x838;}
}
unless(defined(&R92C_TXAGC_B_CCK11_A_CCK2_11)) {
    sub R92C_TXAGC_B_CCK11_A_CCK2_11 () {	0x86c;}
}
unless(defined(&R92C_TXAGC_MCS03_MCS00)) {
    sub R92C_TXAGC_MCS03_MCS00 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe10 : 0x83c));
    }
}
unless(defined(&R92C_TXAGC_MCS07_MCS04)) {
    sub R92C_TXAGC_MCS07_MCS04 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe14 : 0x848));
    }
}
unless(defined(&R92C_TXAGC_MCS11_MCS08)) {
    sub R92C_TXAGC_MCS11_MCS08 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe18 : 0x84c));
    }
}
unless(defined(&R92C_TXAGC_MCS15_MCS12)) {
    sub R92C_TXAGC_MCS15_MCS12 {
	my($i) = @_;
	eval q(((($i) == 0) ? 0xe1c : 0x868));
    }
}
unless(defined(&R92C_LSSI_PARAM)) {
    sub R92C_LSSI_PARAM {
	my($chain) = @_;
	eval q((0x840 + ($chain) * 4));
    }
}
unless(defined(&R92C_FPGA0_RFIFACEOE)) {
    sub R92C_FPGA0_RFIFACEOE {
	my($chain) = @_;
	eval q((0x860 + ($chain) * 4));
    }
}
unless(defined(&R92C_FPGA0_RFIFACESW)) {
    sub R92C_FPGA0_RFIFACESW {
	my($idx) = @_;
	eval q((0x870 + ($idx) * 4));
    }
}
unless(defined(&R92C_FPGA0_RFPARAM)) {
    sub R92C_FPGA0_RFPARAM {
	my($idx) = @_;
	eval q((0x878 + ($idx) * 4));
    }
}
unless(defined(&R92C_FPGA0_ANAPARAM2)) {
    sub R92C_FPGA0_ANAPARAM2 () {	0x884;}
}
unless(defined(&R92C_LSSI_READBACK)) {
    sub R92C_LSSI_READBACK {
	my($chain) = @_;
	eval q((0x8a0 + ($chain) * 4));
    }
}
unless(defined(&R92C_HSPI_READBACK)) {
    sub R92C_HSPI_READBACK {
	my($chain) = @_;
	eval q((0x8b8 + ($chain) * 4));
    }
}
unless(defined(&R92C_FPGA1_RFMOD)) {
    sub R92C_FPGA1_RFMOD () {	0x900;}
}
unless(defined(&R92C_FPGA1_TXINFO)) {
    sub R92C_FPGA1_TXINFO () {	0x90c;}
}
unless(defined(&R92C_CCK0_SYSTEM)) {
    sub R92C_CCK0_SYSTEM () {	0xa00;}
}
unless(defined(&R92C_CCK0_AFESETTING)) {
    sub R92C_CCK0_AFESETTING () {	0xa04;}
}
unless(defined(&R92C_OFDM0_TRXPATHENA)) {
    sub R92C_OFDM0_TRXPATHENA () {	0xc04;}
}
unless(defined(&R92C_OFDM0_TRMUXPAR)) {
    sub R92C_OFDM0_TRMUXPAR () {	0xc08;}
}
unless(defined(&R92C_OFDM0_AGCCORE1)) {
    sub R92C_OFDM0_AGCCORE1 {
	my($chain) = @_;
	eval q((0xc50 + ($chain) * 8));
    }
}
unless(defined(&R92C_OFDM0_AGCPARAM1)) {
    sub R92C_OFDM0_AGCPARAM1 () {	0xc70;}
}
unless(defined(&R92C_OFDM0_AGCRSSITABLE)) {
    sub R92C_OFDM0_AGCRSSITABLE () {	0xc78;}
}
unless(defined(&R92C_OFDM1_LSTF)) {
    sub R92C_OFDM1_LSTF () {	0xd00;}
}
unless(defined(&R92C_RFMOD_40MHZ)) {
    sub R92C_RFMOD_40MHZ () {	0x1;}
}
unless(defined(&R92C_RFMOD_JAPAN)) {
    sub R92C_RFMOD_JAPAN () {	0x2;}
}
unless(defined(&R92C_RFMOD_CCK_TXSC)) {
    sub R92C_RFMOD_CCK_TXSC () {	0x30;}
}
unless(defined(&R92C_RFMOD_CCK_EN)) {
    sub R92C_RFMOD_CCK_EN () {	0x1000000;}
}
unless(defined(&R92C_RFMOD_OFDM_EN)) {
    sub R92C_RFMOD_OFDM_EN () {	0x2000000;}
}
unless(defined(&R92C_HSSI_PARAM1_PI)) {
    sub R92C_HSSI_PARAM1_PI () {	0x100;}
}
unless(defined(&R92C_HSSI_PARAM2_CCK_HIPWR)) {
    sub R92C_HSSI_PARAM2_CCK_HIPWR () {	0x200;}
}
unless(defined(&R92C_HSSI_PARAM2_ADDR_LENGTH)) {
    sub R92C_HSSI_PARAM2_ADDR_LENGTH () {	0x400;}
}
unless(defined(&R92C_HSSI_PARAM2_DATA_LENGTH)) {
    sub R92C_HSSI_PARAM2_DATA_LENGTH () {	0x800;}
}
unless(defined(&R92C_HSSI_PARAM2_READ_ADDR_M)) {
    sub R92C_HSSI_PARAM2_READ_ADDR_M () {	0x7f800000;}
}
unless(defined(&R92C_HSSI_PARAM2_READ_ADDR_S)) {
    sub R92C_HSSI_PARAM2_READ_ADDR_S () {	23;}
}
unless(defined(&R92C_HSSI_PARAM2_READ_EDGE)) {
    sub R92C_HSSI_PARAM2_READ_EDGE () {	0x80000000;}
}
unless(defined(&R92C_TXAGC_A_CCK1_M)) {
    sub R92C_TXAGC_A_CCK1_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_A_CCK1_S)) {
    sub R92C_TXAGC_A_CCK1_S () {	8;}
}
unless(defined(&R92C_TXAGC_B_CCK11_M)) {
    sub R92C_TXAGC_B_CCK11_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_B_CCK11_S)) {
    sub R92C_TXAGC_B_CCK11_S () {	0;}
}
unless(defined(&R92C_TXAGC_A_CCK2_M)) {
    sub R92C_TXAGC_A_CCK2_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_A_CCK2_S)) {
    sub R92C_TXAGC_A_CCK2_S () {	8;}
}
unless(defined(&R92C_TXAGC_A_CCK55_M)) {
    sub R92C_TXAGC_A_CCK55_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_A_CCK55_S)) {
    sub R92C_TXAGC_A_CCK55_S () {	16;}
}
unless(defined(&R92C_TXAGC_A_CCK11_M)) {
    sub R92C_TXAGC_A_CCK11_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_A_CCK11_S)) {
    sub R92C_TXAGC_A_CCK11_S () {	24;}
}
unless(defined(&R92C_TXAGC_B_CCK1_M)) {
    sub R92C_TXAGC_B_CCK1_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_B_CCK1_S)) {
    sub R92C_TXAGC_B_CCK1_S () {	8;}
}
unless(defined(&R92C_TXAGC_B_CCK2_M)) {
    sub R92C_TXAGC_B_CCK2_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_B_CCK2_S)) {
    sub R92C_TXAGC_B_CCK2_S () {	16;}
}
unless(defined(&R92C_TXAGC_B_CCK55_M)) {
    sub R92C_TXAGC_B_CCK55_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_B_CCK55_S)) {
    sub R92C_TXAGC_B_CCK55_S () {	24;}
}
unless(defined(&R92C_TXAGC_RATE06_M)) {
    sub R92C_TXAGC_RATE06_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_RATE06_S)) {
    sub R92C_TXAGC_RATE06_S () {	0;}
}
unless(defined(&R92C_TXAGC_RATE09_M)) {
    sub R92C_TXAGC_RATE09_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_RATE09_S)) {
    sub R92C_TXAGC_RATE09_S () {	8;}
}
unless(defined(&R92C_TXAGC_RATE12_M)) {
    sub R92C_TXAGC_RATE12_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_RATE12_S)) {
    sub R92C_TXAGC_RATE12_S () {	16;}
}
unless(defined(&R92C_TXAGC_RATE18_M)) {
    sub R92C_TXAGC_RATE18_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_RATE18_S)) {
    sub R92C_TXAGC_RATE18_S () {	24;}
}
unless(defined(&R92C_TXAGC_RATE24_M)) {
    sub R92C_TXAGC_RATE24_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_RATE24_S)) {
    sub R92C_TXAGC_RATE24_S () {	0;}
}
unless(defined(&R92C_TXAGC_RATE36_M)) {
    sub R92C_TXAGC_RATE36_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_RATE36_S)) {
    sub R92C_TXAGC_RATE36_S () {	8;}
}
unless(defined(&R92C_TXAGC_RATE48_M)) {
    sub R92C_TXAGC_RATE48_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_RATE48_S)) {
    sub R92C_TXAGC_RATE48_S () {	16;}
}
unless(defined(&R92C_TXAGC_RATE54_M)) {
    sub R92C_TXAGC_RATE54_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_RATE54_S)) {
    sub R92C_TXAGC_RATE54_S () {	24;}
}
unless(defined(&R92C_TXAGC_MCS00_M)) {
    sub R92C_TXAGC_MCS00_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_MCS00_S)) {
    sub R92C_TXAGC_MCS00_S () {	0;}
}
unless(defined(&R92C_TXAGC_MCS01_M)) {
    sub R92C_TXAGC_MCS01_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_MCS01_S)) {
    sub R92C_TXAGC_MCS01_S () {	8;}
}
unless(defined(&R92C_TXAGC_MCS02_M)) {
    sub R92C_TXAGC_MCS02_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_MCS02_S)) {
    sub R92C_TXAGC_MCS02_S () {	16;}
}
unless(defined(&R92C_TXAGC_MCS03_M)) {
    sub R92C_TXAGC_MCS03_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_MCS03_S)) {
    sub R92C_TXAGC_MCS03_S () {	24;}
}
unless(defined(&R92C_TXAGC_MCS04_M)) {
    sub R92C_TXAGC_MCS04_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_MCS04_S)) {
    sub R92C_TXAGC_MCS04_S () {	0;}
}
unless(defined(&R92C_TXAGC_MCS05_M)) {
    sub R92C_TXAGC_MCS05_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_MCS05_S)) {
    sub R92C_TXAGC_MCS05_S () {	8;}
}
unless(defined(&R92C_TXAGC_MCS06_M)) {
    sub R92C_TXAGC_MCS06_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_MCS06_S)) {
    sub R92C_TXAGC_MCS06_S () {	16;}
}
unless(defined(&R92C_TXAGC_MCS07_M)) {
    sub R92C_TXAGC_MCS07_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_MCS07_S)) {
    sub R92C_TXAGC_MCS07_S () {	24;}
}
unless(defined(&R92C_TXAGC_MCS08_M)) {
    sub R92C_TXAGC_MCS08_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_MCS08_S)) {
    sub R92C_TXAGC_MCS08_S () {	0;}
}
unless(defined(&R92C_TXAGC_MCS09_M)) {
    sub R92C_TXAGC_MCS09_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_MCS09_S)) {
    sub R92C_TXAGC_MCS09_S () {	8;}
}
unless(defined(&R92C_TXAGC_MCS10_M)) {
    sub R92C_TXAGC_MCS10_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_MCS10_S)) {
    sub R92C_TXAGC_MCS10_S () {	16;}
}
unless(defined(&R92C_TXAGC_MCS11_M)) {
    sub R92C_TXAGC_MCS11_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_MCS11_S)) {
    sub R92C_TXAGC_MCS11_S () {	24;}
}
unless(defined(&R92C_TXAGC_MCS12_M)) {
    sub R92C_TXAGC_MCS12_M () {	0xff;}
}
unless(defined(&R92C_TXAGC_MCS12_S)) {
    sub R92C_TXAGC_MCS12_S () {	0;}
}
unless(defined(&R92C_TXAGC_MCS13_M)) {
    sub R92C_TXAGC_MCS13_M () {	0xff00;}
}
unless(defined(&R92C_TXAGC_MCS13_S)) {
    sub R92C_TXAGC_MCS13_S () {	8;}
}
unless(defined(&R92C_TXAGC_MCS14_M)) {
    sub R92C_TXAGC_MCS14_M () {	0xff0000;}
}
unless(defined(&R92C_TXAGC_MCS14_S)) {
    sub R92C_TXAGC_MCS14_S () {	16;}
}
unless(defined(&R92C_TXAGC_MCS15_M)) {
    sub R92C_TXAGC_MCS15_M () {	0xff000000;}
}
unless(defined(&R92C_TXAGC_MCS15_S)) {
    sub R92C_TXAGC_MCS15_S () {	24;}
}
unless(defined(&R92C_LSSI_PARAM_DATA_M)) {
    sub R92C_LSSI_PARAM_DATA_M () {	0xfffff;}
}
unless(defined(&R92C_LSSI_PARAM_DATA_S)) {
    sub R92C_LSSI_PARAM_DATA_S () {	0;}
}
unless(defined(&R92C_LSSI_PARAM_ADDR_M)) {
    sub R92C_LSSI_PARAM_ADDR_M () {	0x3f00000;}
}
unless(defined(&R92C_LSSI_PARAM_ADDR_S)) {
    sub R92C_LSSI_PARAM_ADDR_S () {	20;}
}
unless(defined(&R92C_FPGA0_ANAPARAM2_CBW20)) {
    sub R92C_FPGA0_ANAPARAM2_CBW20 () {	0x400;}
}
unless(defined(&R92C_LSSI_READBACK_DATA_M)) {
    sub R92C_LSSI_READBACK_DATA_M () {	0xfffff;}
}
unless(defined(&R92C_LSSI_READBACK_DATA_S)) {
    sub R92C_LSSI_READBACK_DATA_S () {	0;}
}
unless(defined(&R92C_OFDM0_AGCCORE1_GAIN_M)) {
    sub R92C_OFDM0_AGCCORE1_GAIN_M () {	0x7f;}
}
unless(defined(&R92C_OFDM0_AGCCORE1_GAIN_S)) {
    sub R92C_OFDM0_AGCCORE1_GAIN_S () {	0;}
}
unless(defined(&R92C_USB_INFO)) {
    sub R92C_USB_INFO () {	0xfe17;}
}
unless(defined(&R92C_USB_SPECIAL_OPTION)) {
    sub R92C_USB_SPECIAL_OPTION () {	0xfe55;}
}
unless(defined(&R92C_USB_HCPWM)) {
    sub R92C_USB_HCPWM () {	0xfe57;}
}
unless(defined(&R92C_USB_HRPWM)) {
    sub R92C_USB_HRPWM () {	0xfe58;}
}
unless(defined(&R92C_USB_DMA_AGG_TO)) {
    sub R92C_USB_DMA_AGG_TO () {	0xfe5b;}
}
unless(defined(&R92C_USB_AGG_TO)) {
    sub R92C_USB_AGG_TO () {	0xfe5c;}
}
unless(defined(&R92C_USB_AGG_TH)) {
    sub R92C_USB_AGG_TH () {	0xfe5d;}
}
unless(defined(&R92C_USB_VID)) {
    sub R92C_USB_VID () {	0xfe60;}
}
unless(defined(&R92C_USB_PID)) {
    sub R92C_USB_PID () {	0xfe62;}
}
unless(defined(&R92C_USB_OPTIONAL)) {
    sub R92C_USB_OPTIONAL () {	0xfe64;}
}
unless(defined(&R92C_USB_EP)) {
    sub R92C_USB_EP () {	0xfe65;}
}
unless(defined(&R92C_USB_PHY)) {
    sub R92C_USB_PHY () {	0xfe68;}
}
unless(defined(&R92C_USB_MAC_ADDR)) {
    sub R92C_USB_MAC_ADDR () {	0xfe70;}
}
unless(defined(&R92C_USB_STRING)) {
    sub R92C_USB_STRING () {	0xfe80;}
}
unless(defined(&R92C_USB_SPECIAL_OPTION_AGG_EN)) {
    sub R92C_USB_SPECIAL_OPTION_AGG_EN () {	0x8;}
}
unless(defined(&R92C_USB_EP_HQ_M)) {
    sub R92C_USB_EP_HQ_M () {	0xf;}
}
unless(defined(&R92C_USB_EP_HQ_S)) {
    sub R92C_USB_EP_HQ_S () {	0;}
}
unless(defined(&R92C_USB_EP_NQ_M)) {
    sub R92C_USB_EP_NQ_M () {	0xf0;}
}
unless(defined(&R92C_USB_EP_NQ_S)) {
    sub R92C_USB_EP_NQ_S () {	4;}
}
unless(defined(&R92C_USB_EP_LQ_M)) {
    sub R92C_USB_EP_LQ_M () {	0xf00;}
}
unless(defined(&R92C_USB_EP_LQ_S)) {
    sub R92C_USB_EP_LQ_S () {	8;}
}
unless(defined(&R92C_FW_START_ADDR)) {
    sub R92C_FW_START_ADDR () {	0x1000;}
}
unless(defined(&R92C_FW_PAGE_SIZE)) {
    sub R92C_FW_PAGE_SIZE () {	4096;}
}
unless(defined(&R92C_RF_AC)) {
    sub R92C_RF_AC () {	0x;}
}
unless(defined(&R92C_RF_IQADJ_G)) {
    sub R92C_RF_IQADJ_G {
	my($i) = @_;
	eval q((0x1 + ($i)));
    }
}
unless(defined(&R92C_RF_POW_TRSW)) {
    sub R92C_RF_POW_TRSW () {	0x5;}
}
unless(defined(&R92C_RF_GAIN_RX)) {
    sub R92C_RF_GAIN_RX () {	0x6;}
}
unless(defined(&R92C_RF_GAIN_TX)) {
    sub R92C_RF_GAIN_TX () {	0x7;}
}
unless(defined(&R92C_RF_TXM_IDAC)) {
    sub R92C_RF_TXM_IDAC () {	0x8;}
}
unless(defined(&R92C_RF_BS_IQGEN)) {
    sub R92C_RF_BS_IQGEN () {	0xf;}
}
unless(defined(&R92C_RF_MODE1)) {
    sub R92C_RF_MODE1 () {	0x10;}
}
unless(defined(&R92C_RF_MODE2)) {
    sub R92C_RF_MODE2 () {	0x11;}
}
unless(defined(&R92C_RF_RX_AGC_HP)) {
    sub R92C_RF_RX_AGC_HP () {	0x12;}
}
unless(defined(&R92C_RF_TX_AGC)) {
    sub R92C_RF_TX_AGC () {	0x13;}
}
unless(defined(&R92C_RF_BIAS)) {
    sub R92C_RF_BIAS () {	0x14;}
}
unless(defined(&R92C_RF_IPA)) {
    sub R92C_RF_IPA () {	0x15;}
}
unless(defined(&R92C_RF_POW_ABILITY)) {
    sub R92C_RF_POW_ABILITY () {	0x17;}
}
unless(defined(&R92C_RF_CHNLBW)) {
    sub R92C_RF_CHNLBW () {	0x18;}
}
unless(defined(&R92C_RF_RX_G1)) {
    sub R92C_RF_RX_G1 () {	0x1a;}
}
unless(defined(&R92C_RF_RX_G2)) {
    sub R92C_RF_RX_G2 () {	0x1b;}
}
unless(defined(&R92C_RF_RX_BB2)) {
    sub R92C_RF_RX_BB2 () {	0x1c;}
}
unless(defined(&R92C_RF_RX_BB1)) {
    sub R92C_RF_RX_BB1 () {	0x1d;}
}
unless(defined(&R92C_RF_RCK1)) {
    sub R92C_RF_RCK1 () {	0x1e;}
}
unless(defined(&R92C_RF_RCK2)) {
    sub R92C_RF_RCK2 () {	0x1f;}
}
unless(defined(&R92C_RF_TX_G)) {
    sub R92C_RF_TX_G {
	my($i) = @_;
	eval q((0x20 + ($i)));
    }
}
unless(defined(&R92C_RF_TX_BB1)) {
    sub R92C_RF_TX_BB1 () {	0x23;}
}
unless(defined(&R92C_RF_T_METER)) {
    sub R92C_RF_T_METER () {	0x24;}
}
unless(defined(&R92C_RF_SYN_G)) {
    sub R92C_RF_SYN_G {
	my($i) = @_;
	eval q((0x25 + ($i)));
    }
}
unless(defined(&R92C_RF_RCK_OS)) {
    sub R92C_RF_RCK_OS () {	0x30;}
}
unless(defined(&R92C_RF_TXPA_G)) {
    sub R92C_RF_TXPA_G {
	my($i) = @_;
	eval q((0x31 + ($i)));
    }
}
unless(defined(&R92C_RF_AC_MODE_M)) {
    sub R92C_RF_AC_MODE_M () {	0x70000;}
}
unless(defined(&R92C_RF_AC_MODE_S)) {
    sub R92C_RF_AC_MODE_S () {	16;}
}
unless(defined(&R92C_RF_AC_MODE_STANDBY)) {
    sub R92C_RF_AC_MODE_STANDBY () {	1;}
}
unless(defined(&R92C_RF_CHNLBW_CHNL_M)) {
    sub R92C_RF_CHNLBW_CHNL_M () {	0x3ff;}
}
unless(defined(&R92C_RF_CHNLBW_CHNL_S)) {
    sub R92C_RF_CHNLBW_CHNL_S () {	0;}
}
unless(defined(&R92C_RF_CHNLBW_BW20)) {
    sub R92C_RF_CHNLBW_BW20 () {	0x400;}
}
unless(defined(&R92C_RF_CHNLBW_LCSTART)) {
    sub R92C_RF_CHNLBW_LCSTART () {	0x8000;}
}
unless(defined(&R92C_CAM_ENTRY_COUNT)) {
    sub R92C_CAM_ENTRY_COUNT () {	32;}
}
unless(defined(&R92C_CAM_CTL0)) {
    sub R92C_CAM_CTL0 {
	my($entry) = @_;
	eval q((($entry) * 8+ 0));
    }
}
unless(defined(&R92C_CAM_CTL1)) {
    sub R92C_CAM_CTL1 {
	my($entry) = @_;
	eval q((($entry) * 8+ 1));
    }
}
unless(defined(&R92C_CAM_KEY)) {
    sub R92C_CAM_KEY {
	my($entry, $i) = @_;
	eval q((($entry) * 8+ 2+ ($i)));
    }
}
unless(defined(&R92C_CAM_KEYID_M)) {
    sub R92C_CAM_KEYID_M () {	0x3;}
}
unless(defined(&R92C_CAM_KEYID_S)) {
    sub R92C_CAM_KEYID_S () {	0;}
}
unless(defined(&R92C_CAM_ALGO_M)) {
    sub R92C_CAM_ALGO_M () {	0x1c;}
}
unless(defined(&R92C_CAM_ALGO_S)) {
    sub R92C_CAM_ALGO_S () {	2;}
}
unless(defined(&R92C_CAM_ALGO_NONE)) {
    sub R92C_CAM_ALGO_NONE () {	0;}
}
unless(defined(&R92C_CAM_ALGO_WEP40)) {
    sub R92C_CAM_ALGO_WEP40 () {	1;}
}
unless(defined(&R92C_CAM_ALGO_TKIP)) {
    sub R92C_CAM_ALGO_TKIP () {	2;}
}
unless(defined(&R92C_CAM_ALGO_AES)) {
    sub R92C_CAM_ALGO_AES () {	4;}
}
unless(defined(&R92C_CAM_ALGO_WEP104)) {
    sub R92C_CAM_ALGO_WEP104 () {	5;}
}
unless(defined(&R92C_CAM_VALID)) {
    sub R92C_CAM_VALID () {	0x8000;}
}
unless(defined(&R92C_CAM_MACLO_M)) {
    sub R92C_CAM_MACLO_M () {	0xffff0000;}
}
unless(defined(&R92C_CAM_MACLO_S)) {
    sub R92C_CAM_MACLO_S () {	16;}
}
unless(defined(&R92C_RAID_11GN)) {
    sub R92C_RAID_11GN () {	1;}
}
unless(defined(&R92C_RAID_11N)) {
    sub R92C_RAID_11N () {	3;}
}
unless(defined(&R92C_RAID_11BG)) {
    sub R92C_RAID_11BG () {	4;}
}
unless(defined(&R92C_RAID_11G)) {
    sub R92C_RAID_11G () {	5;}
}
unless(defined(&R92C_RAID_11B)) {
    sub R92C_RAID_11B () {	6;}
}
unless(defined(&LE_READ_2)) {
    sub LE_READ_2 {
	my($x) = @_;
	eval q((($x)[0] | ($x)[1] << 8));
    }
}
unless(defined(&LE_READ_4)) {
    sub LE_READ_4 {
	my($x) = @_;
	eval q((($x)[0] | ($x)[1] << 8| ($x)[2] << 16| ($x)[3] << 24));
    }
}
unless(defined(&MS)) {
    sub MS {
	my($val, $field) = @_;
	eval q(((($val) & $field &_M) >> $field &_S));
    }
}
unless(defined(&SM)) {
    sub SM {
	my($field, $val) = @_;
	eval q(((($val) << $field &_S) & $field &_M));
    }
}
unless(defined(&RW)) {
    sub RW {
	my($var, $field, $val) = @_;
	eval q(((($var) & ~$field &_M) |  &SM($field, $val)));
    }
}
unless(defined(&R92C_CMD_AP_OFFLOAD)) {
    sub R92C_CMD_AP_OFFLOAD () {	0;}
}
unless(defined(&R92C_CMD_SET_PWRMODE)) {
    sub R92C_CMD_SET_PWRMODE () {	1;}
}
unless(defined(&R92C_CMD_JOINBSS_RPT)) {
    sub R92C_CMD_JOINBSS_RPT () {	2;}
}
unless(defined(&R92C_CMD_RSVD_PAGE)) {
    sub R92C_CMD_RSVD_PAGE () {	3;}
}
unless(defined(&R92C_CMD_RSSI)) {
    sub R92C_CMD_RSSI () {	4;}
}
unless(defined(&R92C_CMD_RSSI_SETTING)) {
    sub R92C_CMD_RSSI_SETTING () {	5;}
}
unless(defined(&R92C_CMD_MACID_CONFIG)) {
    sub R92C_CMD_MACID_CONFIG () {	6;}
}
unless(defined(&R92C_CMD_MACID_PS_MODE)) {
    sub R92C_CMD_MACID_PS_MODE () {	7;}
}
unless(defined(&R92C_CMD_P2P_PS_OFFLOAD)) {
    sub R92C_CMD_P2P_PS_OFFLOAD () {	8;}
}
unless(defined(&R92C_CMD_SELECTIVE_SUSPEND)) {
    sub R92C_CMD_SELECTIVE_SUSPEND () {	9;}
}
unless(defined(&R92C_CMD_FLAG_EXT)) {
    sub R92C_CMD_FLAG_EXT () {	0x80;}
}
unless(defined(&URTWN_MACID_BSS)) {
    sub URTWN_MACID_BSS () {	0;}
}
unless(defined(&URTWN_MACID_BC)) {
    sub URTWN_MACID_BC () {	4;}
}
unless(defined(&URTWN_MACID_VALID)) {
    sub URTWN_MACID_VALID () {	0x80;}
}
unless(defined(&R92C_ROM_RF1_REGULATORY_M)) {
    sub R92C_ROM_RF1_REGULATORY_M () {	0x7;}
}
unless(defined(&R92C_ROM_RF1_REGULATORY_S)) {
    sub R92C_ROM_RF1_REGULATORY_S () {	0;}
}
unless(defined(&R92C_ROM_RF1_BOARD_TYPE_M)) {
    sub R92C_ROM_RF1_BOARD_TYPE_M () {	0xe0;}
}
unless(defined(&R92C_ROM_RF1_BOARD_TYPE_S)) {
    sub R92C_ROM_RF1_BOARD_TYPE_S () {	5;}
}
unless(defined(&R92C_BOARD_TYPE_DONGLE)) {
    sub R92C_BOARD_TYPE_DONGLE () {	0;}
}
unless(defined(&R92C_BOARD_TYPE_HIGHPA)) {
    sub R92C_BOARD_TYPE_HIGHPA () {	1;}
}
unless(defined(&R92C_BOARD_TYPE_MINICARD)) {
    sub R92C_BOARD_TYPE_MINICARD () {	2;}
}
unless(defined(&R92C_BOARD_TYPE_SOLO)) {
    sub R92C_BOARD_TYPE_SOLO () {	3;}
}
unless(defined(&R92C_BOARD_TYPE_COMBO)) {
    sub R92C_BOARD_TYPE_COMBO () {	4;}
}
unless(defined(&R92C_RXDW0_PKTLEN_M)) {
    sub R92C_RXDW0_PKTLEN_M () {	0x3fff;}
}
unless(defined(&R92C_RXDW0_PKTLEN_S)) {
    sub R92C_RXDW0_PKTLEN_S () {	0;}
}
unless(defined(&R92C_RXDW0_CRCERR)) {
    sub R92C_RXDW0_CRCERR () {	0x4000;}
}
unless(defined(&R92C_RXDW0_ICVERR)) {
    sub R92C_RXDW0_ICVERR () {	0x8000;}
}
unless(defined(&R92C_RXDW0_INFOSZ_M)) {
    sub R92C_RXDW0_INFOSZ_M () {	0xf0000;}
}
unless(defined(&R92C_RXDW0_INFOSZ_S)) {
    sub R92C_RXDW0_INFOSZ_S () {	16;}
}
unless(defined(&R92C_RXDW0_QOS)) {
    sub R92C_RXDW0_QOS () {	0x800000;}
}
unless(defined(&R92C_RXDW0_SHIFT_M)) {
    sub R92C_RXDW0_SHIFT_M () {	0x3000000;}
}
unless(defined(&R92C_RXDW0_SHIFT_S)) {
    sub R92C_RXDW0_SHIFT_S () {	24;}
}
unless(defined(&R92C_RXDW0_PHYST)) {
    sub R92C_RXDW0_PHYST () {	0x4000000;}
}
unless(defined(&R92C_RXDW0_DECRYPTED)) {
    sub R92C_RXDW0_DECRYPTED () {	0x8000000;}
}
unless(defined(&R92C_RXDW2_PKTCNT_M)) {
    sub R92C_RXDW2_PKTCNT_M () {	0xff0000;}
}
unless(defined(&R92C_RXDW2_PKTCNT_S)) {
    sub R92C_RXDW2_PKTCNT_S () {	16;}
}
unless(defined(&R92C_RXDW3_RATE_M)) {
    sub R92C_RXDW3_RATE_M () {	0x3f;}
}
unless(defined(&R92C_RXDW3_RATE_S)) {
    sub R92C_RXDW3_RATE_S () {	0;}
}
unless(defined(&R92C_RXDW3_HT)) {
    sub R92C_RXDW3_HT () {	0x40;}
}
unless(defined(&R92C_RXDW3_HTC)) {
    sub R92C_RXDW3_HTC () {	0x400;}
}
unless(defined(&R92C_TXDW0_PKTLEN_M)) {
    sub R92C_TXDW0_PKTLEN_M () {	0xffff;}
}
unless(defined(&R92C_TXDW0_PKTLEN_S)) {
    sub R92C_TXDW0_PKTLEN_S () {	0;}
}
unless(defined(&R92C_TXDW0_OFFSET_M)) {
    sub R92C_TXDW0_OFFSET_M () {	0xff0000;}
}
unless(defined(&R92C_TXDW0_OFFSET_S)) {
    sub R92C_TXDW0_OFFSET_S () {	16;}
}
unless(defined(&R92C_TXDW0_BMCAST)) {
    sub R92C_TXDW0_BMCAST () {	0x1000000;}
}
unless(defined(&R92C_TXDW0_LSG)) {
    sub R92C_TXDW0_LSG () {	0x4000000;}
}
unless(defined(&R92C_TXDW0_FSG)) {
    sub R92C_TXDW0_FSG () {	0x8000000;}
}
unless(defined(&R92C_TXDW0_OWN)) {
    sub R92C_TXDW0_OWN () {	0x80000000;}
}
unless(defined(&R92C_TXDW1_MACID_M)) {
    sub R92C_TXDW1_MACID_M () {	0x1f;}
}
unless(defined(&R92C_TXDW1_MACID_S)) {
    sub R92C_TXDW1_MACID_S () {	0;}
}
unless(defined(&R92C_TXDW1_AGGEN)) {
    sub R92C_TXDW1_AGGEN () {	0x20;}
}
unless(defined(&R92C_TXDW1_AGGBK)) {
    sub R92C_TXDW1_AGGBK () {	0x40;}
}
unless(defined(&R92C_TXDW1_QSEL_M)) {
    sub R92C_TXDW1_QSEL_M () {	0x1f00;}
}
unless(defined(&R92C_TXDW1_QSEL_S)) {
    sub R92C_TXDW1_QSEL_S () {	8;}
}
unless(defined(&R92C_TXDW1_QSEL_BE)) {
    sub R92C_TXDW1_QSEL_BE () {	0x;}
}
unless(defined(&R92C_TXDW1_QSEL_MGNT)) {
    sub R92C_TXDW1_QSEL_MGNT () {	0x12;}
}
unless(defined(&R92C_TXDW1_RAID_M)) {
    sub R92C_TXDW1_RAID_M () {	0xf0000;}
}
unless(defined(&R92C_TXDW1_RAID_S)) {
    sub R92C_TXDW1_RAID_S () {	16;}
}
unless(defined(&R92C_TXDW1_CIPHER_M)) {
    sub R92C_TXDW1_CIPHER_M () {	0xc00000;}
}
unless(defined(&R92C_TXDW1_CIPHER_S)) {
    sub R92C_TXDW1_CIPHER_S () {	22;}
}
unless(defined(&R92C_TXDW1_CIPHER_NONE)) {
    sub R92C_TXDW1_CIPHER_NONE () {	0;}
}
unless(defined(&R92C_TXDW1_CIPHER_RC4)) {
    sub R92C_TXDW1_CIPHER_RC4 () {	1;}
}
unless(defined(&R92C_TXDW1_CIPHER_AES)) {
    sub R92C_TXDW1_CIPHER_AES () {	3;}
}
unless(defined(&R92C_TXDW1_PKTOFF_M)) {
    sub R92C_TXDW1_PKTOFF_M () {	0x7c000000;}
}
unless(defined(&R92C_TXDW1_PKTOFF_S)) {
    sub R92C_TXDW1_PKTOFF_S () {	26;}
}
unless(defined(&R92C_TXDW4_RTSRATE_M)) {
    sub R92C_TXDW4_RTSRATE_M () {	0x3f;}
}
unless(defined(&R92C_TXDW4_RTSRATE_S)) {
    sub R92C_TXDW4_RTSRATE_S () {	0;}
}
unless(defined(&R92C_TXDW4_QOS)) {
    sub R92C_TXDW4_QOS () {	0x40;}
}
unless(defined(&R92C_TXDW4_HWSEQ)) {
    sub R92C_TXDW4_HWSEQ () {	0x80;}
}
unless(defined(&R92C_TXDW4_DRVRATE)) {
    sub R92C_TXDW4_DRVRATE () {	0x100;}
}
unless(defined(&R92C_TXDW4_CTS2SELF)) {
    sub R92C_TXDW4_CTS2SELF () {	0x800;}
}
unless(defined(&R92C_TXDW4_RTSEN)) {
    sub R92C_TXDW4_RTSEN () {	0x1000;}
}
unless(defined(&R92C_TXDW4_HWRTSEN)) {
    sub R92C_TXDW4_HWRTSEN () {	0x2000;}
}
unless(defined(&R92C_TXDW4_SCO_M)) {
    sub R92C_TXDW4_SCO_M () {	0x3f0000;}
}
unless(defined(&R92C_TXDW4_SCO_S)) {
    sub R92C_TXDW4_SCO_S () {	20;}
}
unless(defined(&R92C_TXDW4_SCO_SCA)) {
    sub R92C_TXDW4_SCO_SCA () {	1;}
}
unless(defined(&R92C_TXDW4_SCO_SCB)) {
    sub R92C_TXDW4_SCO_SCB () {	2;}
}
unless(defined(&R92C_TXDW4_40MHZ)) {
    sub R92C_TXDW4_40MHZ () {	0x2000000;}
}
unless(defined(&R92C_TXDW5_DATARATE_M)) {
    sub R92C_TXDW5_DATARATE_M () {	0x3f;}
}
unless(defined(&R92C_TXDW5_DATARATE_S)) {
    sub R92C_TXDW5_DATARATE_S () {	0;}
}
unless(defined(&R92C_TXDW5_SGI)) {
    sub R92C_TXDW5_SGI () {	0x40;}
}
unless(defined(&R92C_TXDW5_AGGNUM_M)) {
    sub R92C_TXDW5_AGGNUM_M () {	0xff000000;}
}
unless(defined(&R92C_TXDW5_AGGNUM_S)) {
    sub R92C_TXDW5_AGGNUM_S () {	24;}
}
unless(defined(&URTWN_RX_LIST_COUNT)) {
    sub URTWN_RX_LIST_COUNT () {	1;}
}
unless(defined(&URTWN_TX_LIST_COUNT)) {
    sub URTWN_TX_LIST_COUNT () {	8;}
}
unless(defined(&URTWN_HOST_CMD_RING_COUNT)) {
    sub URTWN_HOST_CMD_RING_COUNT () {	32;}
}
unless(defined(&URTWN_RXBUFSZ)) {
    sub URTWN_RXBUFSZ () {	(16* 1024);}
}
unless(defined(&URTWN_TXBUFSZ)) {
    sub URTWN_TXBUFSZ () {	($sizeof{'struct r92c_tx_desc'} +  &IEEE80211_MAX_LEN);}
}
unless(defined(&URTWN_RIDX_COUNT)) {
    sub URTWN_RIDX_COUNT () {	28;}
}
unless(defined(&URTWN_TX_TIMEOUT)) {
    sub URTWN_TX_TIMEOUT () {	5000;}
}
unless(defined(&URTWN_LED_LINK)) {
    sub URTWN_LED_LINK () {	0;}
}
unless(defined(&URTWN_LED_DATA)) {
    sub URTWN_LED_DATA () {	1;}
}
unless(defined(&URTWN_RX_RADIOTAP_PRESENT)) {
    sub URTWN_RX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_RATE | 1<<  &IEEE80211_RADIOTAP_CHANNEL | 1<<  &IEEE80211_RADIOTAP_DBM_ANTSIGNAL);}
}
unless(defined(&URTWN_TX_RADIOTAP_PRESENT)) {
    sub URTWN_TX_RADIOTAP_PRESENT () {	(1<<  &IEEE80211_RADIOTAP_FLAGS | 1<<  &IEEE80211_RADIOTAP_CHANNEL);}
}
unless(defined(&URTWN_FLAG_CCK_HIPWR)) {
    sub URTWN_FLAG_CCK_HIPWR () {	0x1;}
}
unless(defined(&URTWN_CHIP_92C)) {
    sub URTWN_CHIP_92C () {	0x1;}
}
unless(defined(&URTWN_CHIP_92C_1T2R)) {
    sub URTWN_CHIP_92C_1T2R () {	0x2;}
}
unless(defined(&URTWN_CHIP_UMC)) {
    sub URTWN_CHIP_UMC () {	0x4;}
}
unless(defined(&URTWN_CHIP_UMC_A_CUT)) {
    sub URTWN_CHIP_UMC_A_CUT () {	0x8;}
}
if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
    eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
    eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
}
1;
