require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SE_RX_RING_CNT)) {
    sub SE_RX_RING_CNT () {	1000;}
}
unless(defined(&SE_TX_RING_CNT)) {
    sub SE_TX_RING_CNT () {	1000;}
}
unless(defined(&SE_RX_RING_SZ)) {
    sub SE_RX_RING_SZ () {	( &SE_RX_RING_CNT * $sizeof{'struct se_desc'});}
}
unless(defined(&SE_TX_RING_SZ)) {
    sub SE_TX_RING_SZ () {	( &SE_TX_RING_CNT * $sizeof{'struct se_desc'});}
}
unless(defined(&SE_PCI_LOMEM)) {
    sub SE_PCI_LOMEM () {	0x10;}
}
eval("sub TxControl () { 0x00; }") unless defined(&TxControl);
eval("sub TxDescStartAddr () { 0x04; }") unless defined(&TxDescStartAddr);
eval("sub Reserved0 () { 0x08; }") unless defined(&Reserved0);
eval("sub TxNextDescAddr () { 0x0c; }") unless defined(&TxNextDescAddr);
eval("sub RxControl () { 0x10; }") unless defined(&RxControl);
eval("sub RxDescStartAddr () { 0x14; }") unless defined(&RxDescStartAddr);
eval("sub Reserved1 () { 0x18; }") unless defined(&Reserved1);
eval("sub RxNextDescAddr () { 0x1c; }") unless defined(&RxNextDescAddr);
eval("sub IntrStatus () { 0x20; }") unless defined(&IntrStatus);
eval("sub IntrMask () { 0x24; }") unless defined(&IntrMask);
eval("sub IntrControl () { 0x28; }") unless defined(&IntrControl);
eval("sub IntrTimer () { 0x2c; }") unless defined(&IntrTimer);
eval("sub PMControl () { 0x30; }") unless defined(&PMControl);
eval("sub Reserved2 () { 0x34; }") unless defined(&Reserved2);
eval("sub ROMControl () { 0x38; }") unless defined(&ROMControl);
eval("sub ROMInterface () { 0x3c; }") unless defined(&ROMInterface);
eval("sub StationControl () { 0x40; }") unless defined(&StationControl);
eval("sub GMIIControl () { 0x44; }") unless defined(&GMIIControl);
eval("sub GMacIOCR () { 0x48; }") unless defined(&GMacIOCR);
eval("sub GMacIOCTL () { 0x4c; }") unless defined(&GMacIOCTL);
eval("sub TxMacControl () { 0x50; }") unless defined(&TxMacControl);
eval("sub TxMacTimeLimit () { 0x54; }") unless defined(&TxMacTimeLimit);
eval("sub RGMIIDelay () { 0x58; }") unless defined(&RGMIIDelay);
eval("sub Reserved3 () { 0x5c; }") unless defined(&Reserved3);
eval("sub RxMacControl () { 0x60; }") unless defined(&RxMacControl);
eval("sub RxMacAddr () { 0x62; }") unless defined(&RxMacAddr);
eval("sub RxHashTable () { 0x68; }") unless defined(&RxHashTable);
eval("sub RxHashTable2 () { 0x6c; }") unless defined(&RxHashTable2);
eval("sub RxWakeOnLan () { 0x70; }") unless defined(&RxWakeOnLan);
eval("sub RxWakeOnLanData () { 0x74; }") unless defined(&RxWakeOnLanData);
eval("sub RxMPSControl () { 0x78; }") unless defined(&RxMPSControl);
eval("sub Reserved4 () { 0x7c; }") unless defined(&Reserved4);
eval("sub SoftInt () { 0x40000000; }") unless defined(&SoftInt);
eval("sub Timeup () { 0x20000000; }") unless defined(&Timeup);
eval("sub PauseFrame () { 0x00080000; }") unless defined(&PauseFrame);
eval("sub MagicPacket () { 0x00040000; }") unless defined(&MagicPacket);
eval("sub WakeupFrame () { 0x00020000; }") unless defined(&WakeupFrame);
eval("sub LinkChange () { 0x00010000; }") unless defined(&LinkChange);
eval("sub RxQEmpty () { 0x00000080; }") unless defined(&RxQEmpty);
eval("sub RxQInt () { 0x00000040; }") unless defined(&RxQInt);
eval("sub TxQ1Empty () { 0x00000020; }") unless defined(&TxQ1Empty);
eval("sub TxQ1Int () { 0x00000010; }") unless defined(&TxQ1Int);
eval("sub TxQEmpty () { 0x00000008; }") unless defined(&TxQEmpty);
eval("sub TxQInt () { 0x00000004; }") unless defined(&TxQInt);
eval("sub RxHalt () { 0x00000002; }") unless defined(&RxHalt);
eval("sub TxHalt () { 0x00000001; }") unless defined(&TxHalt);
eval("sub RxRES () { 0x00200000; }") unless defined(&RxRES);
eval("sub RxCRC () { 0x00080000; }") unless defined(&RxCRC);
eval("sub RxRUNT () { 0x00100000; }") unless defined(&RxRUNT);
eval("sub RxRWT () { 0x00400000; }") unless defined(&RxRWT);
eval("sub CmdReset () { 0x10; }") unless defined(&CmdReset);
eval("sub CmdRxEnb () { 0x01; }") unless defined(&CmdRxEnb);
eval("sub CmdTxEnb () { 0x01; }") unless defined(&CmdTxEnb);
eval("sub AcceptBroadcast () { 0x0800; }") unless defined(&AcceptBroadcast);
eval("sub AcceptMulticast () { 0x0400; }") unless defined(&AcceptMulticast);
eval("sub AcceptMyPhys () { 0x0200; }") unless defined(&AcceptMyPhys);
eval("sub AcceptAllPhys () { 0x0100; }") unless defined(&AcceptAllPhys);
eval("sub AcceptErr () { 0x0020; }") unless defined(&AcceptErr);
eval("sub AcceptRunt () { 0x0010; }") unless defined(&AcceptRunt);
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{se_btag}),  ($sc->{se_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{se_btag}),  ($sc->{se_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{se_btag}),  ($sc->{se_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{se_btag}),  ($sc->{se_bhandle}), $reg));
    }
}
unless(defined(&SE_PCI_COMMIT)) {
    sub SE_PCI_COMMIT () {
	eval q( &CSR_READ_4( &sc,  &IntrControl));
    }
}
unless(defined(&SE_SETBIT)) {
    sub SE_SETBIT {
	my($_sc, $_reg, $x) = @_;
	eval q( &CSR_WRITE_4($_sc, $_reg,  &CSR_READ_4($_sc, $_reg) | ($x)));
    }
}
unless(defined(&SE_CLRBIT)) {
    sub SE_CLRBIT {
	my($_sc, $_reg, $x) = @_;
	eval q( &CSR_WRITE_4($_sc, $_reg,  &CSR_READ_4($_sc, $_reg) & ~($x)));
    }
}
unless(defined(&DISABLE_INTERRUPTS)) {
    sub DISABLE_INTERRUPTS {
	my($sc) = @_;
	eval q( &CSR_WRITE_4($sc,  &IntrMask, 0x));
    }
}
unless(defined(&ENABLE_INTERRUPTS)) {
    sub ENABLE_INTERRUPTS {
	my($sc) = @_;
	eval q( &CSR_WRITE_4($sc,  &IntrMask,  &RxQEmpty |  &RxQInt |  &TxQInt |  &RxHalt |  &TxHalt));
    }
}
unless(defined(&GMI_DATA)) {
    sub GMI_DATA () {	0xffff0000;}
}
unless(defined(&GMI_DATA_SHIFT)) {
    sub GMI_DATA_SHIFT () {	16;}
}
unless(defined(&GMI_REG)) {
    sub GMI_REG () {	0xf800;}
}
unless(defined(&GMI_REG_SHIFT)) {
    sub GMI_REG_SHIFT () {	11;}
}
unless(defined(&GMI_PHY)) {
    sub GMI_PHY () {	0x7c0;}
}
unless(defined(&GMI_PHY_SHIFT)) {
    sub GMI_PHY_SHIFT () {	6;}
}
unless(defined(&GMI_OP)) {
    sub GMI_OP () {	0x20;}
}
unless(defined(&GMI_OP_SHIFT)) {
    sub GMI_OP_SHIFT () {	5;}
}
unless(defined(&GMI_OP_WR)) {
    sub GMI_OP_WR () {	(1<<  &GMI_OP_SHIFT);}
}
unless(defined(&GMI_OP_RD)) {
    sub GMI_OP_RD () {	(0<<  &GMI_OP_SHIFT);}
}
unless(defined(&GMI_REQ)) {
    sub GMI_REQ () {	0x10;}
}
unless(defined(&GMI_MDIO)) {
    sub GMI_MDIO () {	0x8;}
}
unless(defined(&GMI_MDDIR)) {
    sub GMI_MDDIR () {	0x4;}
}
unless(defined(&GMI_MDC)) {
    sub GMI_MDC () {	0x2;}
}
unless(defined(&GMI_MDEN)) {
    sub GMI_MDEN () {	0x1;}
}
eval("sub OWNbit () { 0x80000000; }") unless defined(&OWNbit);
eval("sub INTbit () { 0x40000000; }") unless defined(&INTbit);
eval("sub IPbit () { 0x20000000; }") unless defined(&IPbit);
eval("sub TCPbit () { 0x10000000; }") unless defined(&TCPbit);
eval("sub UDPbit () { 0x08000000; }") unless defined(&UDPbit);
eval("sub DEFbit () { 0x00200000; }") unless defined(&DEFbit);
eval("sub CRCbit () { 0x00020000; }") unless defined(&CRCbit);
eval("sub PADbit () { 0x00010000; }") unless defined(&PADbit);
unless(defined(&RDS_TAGON)) {
    sub RDS_TAGON () {	0x80000000;}
}
unless(defined(&RDS_DESCS)) {
    sub RDS_DESCS () {	0x3f000000;}
}
unless(defined(&RDS_ABORT)) {
    sub RDS_ABORT () {	0x800000;}
}
unless(defined(&RDS_SHORT)) {
    sub RDS_SHORT () {	0x400000;}
}
unless(defined(&RDS_LIMIT)) {
    sub RDS_LIMIT () {	0x200000;}
}
unless(defined(&RDS_MIIER)) {
    sub RDS_MIIER () {	0x100000;}
}
unless(defined(&RDS_OVRUN)) {
    sub RDS_OVRUN () {	0x80000;}
}
unless(defined(&RDS_NIBON)) {
    sub RDS_NIBON () {	0x40000;}
}
unless(defined(&RDS_COLON)) {
    sub RDS_COLON () {	0x20000;}
}
unless(defined(&RDS_CRCOK)) {
    sub RDS_CRCOK () {	0x10000;}
}
unless(defined(&RX_ERR_BITS)) {
    sub RX_ERR_BITS () {	( &RDS_COLON |  &RDS_NIBON |  &RDS_OVRUN |  &RDS_MIIER |  &RDS_LIMIT |  &RDS_SHORT |  &RDS_ABORT);}
}
unless(defined(&RING_END)) {
    sub RING_END () {	0x80000000;}
}
unless(defined(&SE_RXSIZE)) {
    sub SE_RXSIZE {
	my($x) = @_;
	eval q( &letoh32(($x)-> &se_sts_size & 0xffff));
    }
}
unless(defined(&SE_RXSTATUS)) {
    sub SE_RXSTATUS {
	my($x) = @_;
	eval q( &letoh32(($x)-> &se_sts_size & 0xffff0000));
    }
}
undef(&SE_OWNDESC) if defined(&SE_OWNDESC);
unless(defined(&SE_OWNDESC)) {
    sub SE_OWNDESC {
	my($x) = @_;
	eval q((($x)-> &se_cmdsts &  &OWNbit));
    }
}
unless(defined(&SE_INC)) {
    sub SE_INC {
	my($x, $y) = @_;
	eval q(($x) = ((($x) == (($y)-1)) ? 0: ($x)+1));
    }
}
unless(defined(&TDS_OWC)) {
    sub TDS_OWC () {	0x80000;}
}
unless(defined(&TDS_ABT)) {
    sub TDS_ABT () {	0x40000;}
}
unless(defined(&TDS_FIFO)) {
    sub TDS_FIFO () {	0x20000;}
}
unless(defined(&TDS_CRS)) {
    sub TDS_CRS () {	0x10000;}
}
unless(defined(&TDS_COLLS)) {
    sub TDS_COLLS () {	0xffff;}
}
unless(defined(&TX_ERR_BITS)) {
    sub TX_ERR_BITS () {	( &TDS_OWC |  &TDS_ABT |  &TDS_FIFO |  &TDS_CRS);}
}
unless(defined(&EI_DATA)) {
    sub EI_DATA () {	0xffff0000;}
}
unless(defined(&EI_DATA_SHIFT)) {
    sub EI_DATA_SHIFT () {	16;}
}
unless(defined(&EI_OFFSET)) {
    sub EI_OFFSET () {	0xfc00;}
}
unless(defined(&EI_OFFSET_SHIFT)) {
    sub EI_OFFSET_SHIFT () {	10;}
}
unless(defined(&EI_OP)) {
    sub EI_OP () {	0x300;}
}
unless(defined(&EI_OP_SHIFT)) {
    sub EI_OP_SHIFT () {	8;}
}
unless(defined(&EI_OP_RD)) {
    sub EI_OP_RD () {	(2<<  &EI_OP_SHIFT);}
}
unless(defined(&EI_OP_WR)) {
    sub EI_OP_WR () {	(1<<  &EI_OP_SHIFT);}
}
unless(defined(&EI_REQ)) {
    sub EI_REQ () {	0x80;}
}
unless(defined(&EI_DO)) {
    sub EI_DO () {	0x8;}
}
unless(defined(&EI_DI)) {
    sub EI_DI () {	0x4;}
}
unless(defined(&EI_CLK)) {
    sub EI_CLK () {	0x2;}
}
unless(defined(&EI_CS)) {
    sub EI_CS () {	0x1;}
}
unless(defined(&EEPROMSignature)) {
    sub EEPROMSignature () {	0x;}
}
unless(defined(&EEPROMCLK)) {
    sub EEPROMCLK () {	0x1;}
}
unless(defined(&EEPROMInfo)) {
    sub EEPROMInfo () {	0x2;}
}
unless(defined(&EEPROMMACAddr)) {
    sub EEPROMMACAddr () {	0x3;}
}
1;
