require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&MPI_DOORBELL)) {
    sub MPI_DOORBELL () {	0x;}
}
unless(defined(&MPI_DOORBELL_STATE)) {
    sub MPI_DOORBELL_STATE () {	(0xf<<28);}
}
unless(defined(&MPI_DOORBELL_STATE_RESET)) {
    sub MPI_DOORBELL_STATE_RESET () {	(0x<<28);}
}
unless(defined(&MPI_DOORBELL_STATE_READY)) {
    sub MPI_DOORBELL_STATE_READY () {	(0x1<<28);}
}
unless(defined(&MPI_DOORBELL_STATE_OPER)) {
    sub MPI_DOORBELL_STATE_OPER () {	(0x2<<28);}
}
unless(defined(&MPI_DOORBELL_STATE_FAULT)) {
    sub MPI_DOORBELL_STATE_FAULT () {	(0x4<<28);}
}
unless(defined(&MPI_DOORBELL_INUSE)) {
    sub MPI_DOORBELL_INUSE () {	(0x1<<27);}
}
unless(defined(&MPI_DOORBELL_WHOINIT)) {
    sub MPI_DOORBELL_WHOINIT () {	(0x7<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_NOONE)) {
    sub MPI_DOORBELL_WHOINIT_NOONE () {	(0x<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_SYSBIOS)) {
    sub MPI_DOORBELL_WHOINIT_SYSBIOS () {	(0x1<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_ROMBIOS)) {
    sub MPI_DOORBELL_WHOINIT_ROMBIOS () {	(0x2<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_PCIPEER)) {
    sub MPI_DOORBELL_WHOINIT_PCIPEER () {	(0x3<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_DRIVER)) {
    sub MPI_DOORBELL_WHOINIT_DRIVER () {	(0x4<<24);}
}
unless(defined(&MPI_DOORBELL_WHOINIT_MANUFACT)) {
    sub MPI_DOORBELL_WHOINIT_MANUFACT () {	(0x5<<24);}
}
unless(defined(&MPI_DOORBELL_FAULT)) {
    sub MPI_DOORBELL_FAULT () {	(0xffff<<0);}
}
unless(defined(&MPI_DOORBELL_FAULT_REQ_PCIPAR)) {
    sub MPI_DOORBELL_FAULT_REQ_PCIPAR () {	0x8111;}
}
unless(defined(&MPI_DOORBELL_FAULT_REQ_PCIBUS)) {
    sub MPI_DOORBELL_FAULT_REQ_PCIBUS () {	0x8112;}
}
unless(defined(&MPI_DOORBELL_FAULT_REP_PCIPAR)) {
    sub MPI_DOORBELL_FAULT_REP_PCIPAR () {	0x8113;}
}
unless(defined(&MPI_DOORBELL_FAULT_REP_PCIBUS)) {
    sub MPI_DOORBELL_FAULT_REP_PCIBUS () {	0x8114;}
}
unless(defined(&MPI_DOORBELL_FAULT_SND_PCIPAR)) {
    sub MPI_DOORBELL_FAULT_SND_PCIPAR () {	0x8115;}
}
unless(defined(&MPI_DOORBELL_FAULT_SND_PCIBUS)) {
    sub MPI_DOORBELL_FAULT_SND_PCIBUS () {	0x8116;}
}
unless(defined(&MPI_DOORBELL_FAULT_RCV_PCIPAR)) {
    sub MPI_DOORBELL_FAULT_RCV_PCIPAR () {	0x8117;}
}
unless(defined(&MPI_DOORBELL_FAULT_RCV_PCIBUS)) {
    sub MPI_DOORBELL_FAULT_RCV_PCIBUS () {	0x8118;}
}
unless(defined(&MPI_DOORBELL_FUNCTION_SHIFT)) {
    sub MPI_DOORBELL_FUNCTION_SHIFT () {	24;}
}
unless(defined(&MPI_DOORBELL_FUNCTION_MASK)) {
    sub MPI_DOORBELL_FUNCTION_MASK () {	(0xff <<  &MPI_DOORBELL_FUNCTION_SHIFT);}
}
unless(defined(&MPI_DOORBELL_FUNCTION)) {
    sub MPI_DOORBELL_FUNCTION {
	my($x) = @_;
	eval q(((($x) <<  &MPI_DOORBELL_FUNCTION_SHIFT) &  &MPI_DOORBELL_FUNCTION_MASK));
    }
}
unless(defined(&MPI_DOORBELL_DWORDS_SHIFT)) {
    sub MPI_DOORBELL_DWORDS_SHIFT () {	16;}
}
unless(defined(&MPI_DOORBELL_DWORDS_MASK)) {
    sub MPI_DOORBELL_DWORDS_MASK () {	(0xff <<  &MPI_DOORBELL_DWORDS_SHIFT);}
}
unless(defined(&MPI_DOORBELL_DWORDS)) {
    sub MPI_DOORBELL_DWORDS {
	my($x) = @_;
	eval q(((($x) <<  &MPI_DOORBELL_DWORDS_SHIFT) &  &MPI_DOORBELL_DWORDS_MASK));
    }
}
unless(defined(&MPI_DOORBELL_DATA_MASK)) {
    sub MPI_DOORBELL_DATA_MASK () {	0xffff;}
}
unless(defined(&MPI_WRITESEQ)) {
    sub MPI_WRITESEQ () {	0x4;}
}
unless(defined(&MPI_WRITESEQ_VALUE)) {
    sub MPI_WRITESEQ_VALUE () {	0xf;}
}
unless(defined(&MPI_WRITESEQ_1)) {
    sub MPI_WRITESEQ_1 () {	0x4;}
}
unless(defined(&MPI_WRITESEQ_2)) {
    sub MPI_WRITESEQ_2 () {	0xb;}
}
unless(defined(&MPI_WRITESEQ_3)) {
    sub MPI_WRITESEQ_3 () {	0x2;}
}
unless(defined(&MPI_WRITESEQ_4)) {
    sub MPI_WRITESEQ_4 () {	0x7;}
}
unless(defined(&MPI_WRITESEQ_5)) {
    sub MPI_WRITESEQ_5 () {	0xd;}
}
unless(defined(&MPI_HOSTDIAG)) {
    sub MPI_HOSTDIAG () {	0x8;}
}
unless(defined(&MPI_HOSTDIAG_CLEARFBS)) {
    sub MPI_HOSTDIAG_CLEARFBS () {	(1<<10);}
}
unless(defined(&MPI_HOSTDIAG_POICB)) {
    sub MPI_HOSTDIAG_POICB () {	(1<<9);}
}
unless(defined(&MPI_HOSTDIAG_DWRE)) {
    sub MPI_HOSTDIAG_DWRE () {	(1<<7);}
}
unless(defined(&MPI_HOSTDIAG_FBS)) {
    sub MPI_HOSTDIAG_FBS () {	(1<<6);}
}
unless(defined(&MPI_HOSTDIAG_RESET_HIST)) {
    sub MPI_HOSTDIAG_RESET_HIST () {	(1<<5);}
}
unless(defined(&MPI_HOSTDIAG_DIAGWR_EN)) {
    sub MPI_HOSTDIAG_DIAGWR_EN () {	(1<<4);}
}
unless(defined(&MPI_HOSTDIAG_RESET_ADAPTER)) {
    sub MPI_HOSTDIAG_RESET_ADAPTER () {	(1<<2);}
}
unless(defined(&MPI_HOSTDIAG_DISABLE_ARM)) {
    sub MPI_HOSTDIAG_DISABLE_ARM () {	(1<<1);}
}
unless(defined(&MPI_HOSTDIAG_DIAGMEM_EN)) {
    sub MPI_HOSTDIAG_DIAGMEM_EN () {	(1<<0);}
}
unless(defined(&MPI_TESTBASE)) {
    sub MPI_TESTBASE () {	0xc;}
}
unless(defined(&MPI_DIAGRWDATA)) {
    sub MPI_DIAGRWDATA () {	0x10;}
}
unless(defined(&MPI_DIAGRWADDR)) {
    sub MPI_DIAGRWADDR () {	0x18;}
}
unless(defined(&MPI_INTR_STATUS)) {
    sub MPI_INTR_STATUS () {	0x30;}
}
unless(defined(&MPI_INTR_STATUS_IOCDOORBELL)) {
    sub MPI_INTR_STATUS_IOCDOORBELL () {	(1<<31);}
}
unless(defined(&MPI_INTR_STATUS_REPLY)) {
    sub MPI_INTR_STATUS_REPLY () {	(1<<3);}
}
unless(defined(&MPI_INTR_STATUS_DOORBELL)) {
    sub MPI_INTR_STATUS_DOORBELL () {	(1<<0);}
}
unless(defined(&MPI_INTR_MASK)) {
    sub MPI_INTR_MASK () {	0x34;}
}
unless(defined(&MPI_INTR_MASK_REPLY)) {
    sub MPI_INTR_MASK_REPLY () {	(1<<3);}
}
unless(defined(&MPI_INTR_MASK_DOORBELL)) {
    sub MPI_INTR_MASK_DOORBELL () {	(1<<0);}
}
unless(defined(&MPI_REQ_QUEUE)) {
    sub MPI_REQ_QUEUE () {	0x40;}
}
unless(defined(&MPI_REPLY_QUEUE)) {
    sub MPI_REPLY_QUEUE () {	0x44;}
}
unless(defined(&MPI_REPLY_QUEUE_ADDRESS)) {
    sub MPI_REPLY_QUEUE_ADDRESS () {	(1<<31);}
}
unless(defined(&MPI_REPLY_QUEUE_ADDRESS_MASK)) {
    sub MPI_REPLY_QUEUE_ADDRESS_MASK () {	0x7fffffff;}
}
unless(defined(&MPI_REPLY_QUEUE_TYPE_MASK)) {
    sub MPI_REPLY_QUEUE_TYPE_MASK () {	(3<<29);}
}
unless(defined(&MPI_REPLY_QUEUE_TYPE_INIT)) {
    sub MPI_REPLY_QUEUE_TYPE_INIT () {	(0<<29);}
}
unless(defined(&MPI_REPLY_QUEUE_TYPE_TARGET)) {
    sub MPI_REPLY_QUEUE_TYPE_TARGET () {	(1<<29);}
}
unless(defined(&MPI_REPLY_QUEUE_TYPE_LAN)) {
    sub MPI_REPLY_QUEUE_TYPE_LAN () {	(2<<29);}
}
unless(defined(&MPI_REPLY_QUEUE_CONTEXT)) {
    sub MPI_REPLY_QUEUE_CONTEXT () {	0x1fffffff;}
}
unless(defined(&MPI_PRIREQ_QUEUE)) {
    sub MPI_PRIREQ_QUEUE () {	0x48;}
}
unless(defined(&MPI_SGE_FL_LAST)) {
    sub MPI_SGE_FL_LAST () {	(0x1<<31);}
}
unless(defined(&MPI_SGE_FL_EOB)) {
    sub MPI_SGE_FL_EOB () {	(0x1<<30);}
}
unless(defined(&MPI_SGE_FL_TYPE)) {
    sub MPI_SGE_FL_TYPE () {	(0x3<<28);}
}
unless(defined(&MPI_SGE_FL_TYPE_SIMPLE)) {
    sub MPI_SGE_FL_TYPE_SIMPLE () {	(0x1<<28);}
}
unless(defined(&MPI_SGE_FL_TYPE_CHAIN)) {
    sub MPI_SGE_FL_TYPE_CHAIN () {	(0x3<<28);}
}
unless(defined(&MPI_SGE_FL_TYPE_XACTCTX)) {
    sub MPI_SGE_FL_TYPE_XACTCTX () {	(0x<<28);}
}
unless(defined(&MPI_SGE_FL_LOCAL)) {
    sub MPI_SGE_FL_LOCAL () {	(0x1<<27);}
}
unless(defined(&MPI_SGE_FL_DIR)) {
    sub MPI_SGE_FL_DIR () {	(0x1<<26);}
}
unless(defined(&MPI_SGE_FL_DIR_OUT)) {
    sub MPI_SGE_FL_DIR_OUT () {	(0x1<<26);}
}
unless(defined(&MPI_SGE_FL_DIR_IN)) {
    sub MPI_SGE_FL_DIR_IN () {	(0x<<26);}
}
unless(defined(&MPI_SGE_FL_SIZE)) {
    sub MPI_SGE_FL_SIZE () {	(0x1<<25);}
}
unless(defined(&MPI_SGE_FL_SIZE_32)) {
    sub MPI_SGE_FL_SIZE_32 () {	(0x<<25);}
}
unless(defined(&MPI_SGE_FL_SIZE_64)) {
    sub MPI_SGE_FL_SIZE_64 () {	(0x1<<25);}
}
unless(defined(&MPI_SGE_FL_EOL)) {
    sub MPI_SGE_FL_EOL () {	(0x1<<24);}
}
unless(defined(&MPI_SGE_FLAGS_IOC_TO_HOST)) {
    sub MPI_SGE_FLAGS_IOC_TO_HOST () {	(0x);}
}
unless(defined(&MPI_SGE_FLAGS_HOST_TO_IOC)) {
    sub MPI_SGE_FLAGS_HOST_TO_IOC () {	(0x4);}
}
unless(defined(&MPI_FUNCTION_SCSI_IO_REQUEST)) {
    sub MPI_FUNCTION_SCSI_IO_REQUEST () {	(0x);}
}
unless(defined(&MPI_FUNCTION_SCSI_TASK_MGMT)) {
    sub MPI_FUNCTION_SCSI_TASK_MGMT () {	(0x1);}
}
unless(defined(&MPI_FUNCTION_IOC_INIT)) {
    sub MPI_FUNCTION_IOC_INIT () {	(0x2);}
}
unless(defined(&MPI_FUNCTION_IOC_FACTS)) {
    sub MPI_FUNCTION_IOC_FACTS () {	(0x3);}
}
unless(defined(&MPI_FUNCTION_CONFIG)) {
    sub MPI_FUNCTION_CONFIG () {	(0x4);}
}
unless(defined(&MPI_FUNCTION_PORT_FACTS)) {
    sub MPI_FUNCTION_PORT_FACTS () {	(0x5);}
}
unless(defined(&MPI_FUNCTION_PORT_ENABLE)) {
    sub MPI_FUNCTION_PORT_ENABLE () {	(0x6);}
}
unless(defined(&MPI_FUNCTION_EVENT_NOTIFICATION)) {
    sub MPI_FUNCTION_EVENT_NOTIFICATION () {	(0x7);}
}
unless(defined(&MPI_FUNCTION_EVENT_ACK)) {
    sub MPI_FUNCTION_EVENT_ACK () {	(0x8);}
}
unless(defined(&MPI_FUNCTION_FW_DOWNLOAD)) {
    sub MPI_FUNCTION_FW_DOWNLOAD () {	(0x9);}
}
unless(defined(&MPI_FUNCTION_TARGET_CMD_BUFFER_POST)) {
    sub MPI_FUNCTION_TARGET_CMD_BUFFER_POST () {	(0xa);}
}
unless(defined(&MPI_FUNCTION_TARGET_ASSIST)) {
    sub MPI_FUNCTION_TARGET_ASSIST () {	(0xb);}
}
unless(defined(&MPI_FUNCTION_TARGET_STATUS_SEND)) {
    sub MPI_FUNCTION_TARGET_STATUS_SEND () {	(0xc);}
}
unless(defined(&MPI_FUNCTION_TARGET_MODE_ABORT)) {
    sub MPI_FUNCTION_TARGET_MODE_ABORT () {	(0xd);}
}
unless(defined(&MPI_FUNCTION_TARGET_FC_BUF_POST_LINK_SRVC)) {
    sub MPI_FUNCTION_TARGET_FC_BUF_POST_LINK_SRVC () {	(0xe);}
}
unless(defined(&MPI_FUNCTION_TARGET_FC_RSP_LINK_SRVC)) {
    sub MPI_FUNCTION_TARGET_FC_RSP_LINK_SRVC () {	(0xf);}
}
unless(defined(&MPI_FUNCTION_TARGET_FC_EX_SEND_LINK_SRVC)) {
    sub MPI_FUNCTION_TARGET_FC_EX_SEND_LINK_SRVC () {	(0x10);}
}
unless(defined(&MPI_FUNCTION_TARGET_FC_ABORT)) {
    sub MPI_FUNCTION_TARGET_FC_ABORT () {	(0x11);}
}
unless(defined(&MPI_FUNCTION_FC_LINK_SRVC_BUF_POST)) {
    sub MPI_FUNCTION_FC_LINK_SRVC_BUF_POST () {	(0xe);}
}
unless(defined(&MPI_FUNCTION_FC_LINK_SRVC_RSP)) {
    sub MPI_FUNCTION_FC_LINK_SRVC_RSP () {	(0xf);}
}
unless(defined(&MPI_FUNCTION_FC_EX_LINK_SRVC_SEND)) {
    sub MPI_FUNCTION_FC_EX_LINK_SRVC_SEND () {	(0x10);}
}
unless(defined(&MPI_FUNCTION_FC_ABORT)) {
    sub MPI_FUNCTION_FC_ABORT () {	(0x11);}
}
unless(defined(&MPI_FUNCTION_FW_UPLOAD)) {
    sub MPI_FUNCTION_FW_UPLOAD () {	(0x12);}
}
unless(defined(&MPI_FUNCTION_FC_COMMON_TRANSPORT_SEND)) {
    sub MPI_FUNCTION_FC_COMMON_TRANSPORT_SEND () {	(0x13);}
}
unless(defined(&MPI_FUNCTION_FC_PRIMITIVE_SEND)) {
    sub MPI_FUNCTION_FC_PRIMITIVE_SEND () {	(0x14);}
}
unless(defined(&MPI_FUNCTION_RAID_ACTION)) {
    sub MPI_FUNCTION_RAID_ACTION () {	(0x15);}
}
unless(defined(&MPI_FUNCTION_RAID_SCSI_IO_PASSTHROUGH)) {
    sub MPI_FUNCTION_RAID_SCSI_IO_PASSTHROUGH () {	(0x16);}
}
unless(defined(&MPI_FUNCTION_TOOLBOX)) {
    sub MPI_FUNCTION_TOOLBOX () {	(0x17);}
}
unless(defined(&MPI_FUNCTION_SCSI_ENCLOSURE_PROCESSOR)) {
    sub MPI_FUNCTION_SCSI_ENCLOSURE_PROCESSOR () {	(0x18);}
}
unless(defined(&MPI_FUNCTION_MAILBOX)) {
    sub MPI_FUNCTION_MAILBOX () {	(0x19);}
}
unless(defined(&MPI_FUNCTION_LAN_SEND)) {
    sub MPI_FUNCTION_LAN_SEND () {	(0x20);}
}
unless(defined(&MPI_FUNCTION_LAN_RECEIVE)) {
    sub MPI_FUNCTION_LAN_RECEIVE () {	(0x21);}
}
unless(defined(&MPI_FUNCTION_LAN_RESET)) {
    sub MPI_FUNCTION_LAN_RESET () {	(0x22);}
}
unless(defined(&MPI_FUNCTION_IOC_MESSAGE_UNIT_RESET)) {
    sub MPI_FUNCTION_IOC_MESSAGE_UNIT_RESET () {	(0x40);}
}
unless(defined(&MPI_FUNCTION_IO_UNIT_RESET)) {
    sub MPI_FUNCTION_IO_UNIT_RESET () {	(0x41);}
}
unless(defined(&MPI_FUNCTION_HANDSHAKE)) {
    sub MPI_FUNCTION_HANDSHAKE () {	(0x42);}
}
unless(defined(&MPI_FUNCTION_REPLY_FRAME_REMOVAL)) {
    sub MPI_FUNCTION_REPLY_FRAME_REMOVAL () {	(0x43);}
}
unless(defined(&MPI_REP_FLAGS_CONT)) {
    sub MPI_REP_FLAGS_CONT () {	(1<<7);}
}
unless(defined(&MPI_REP_IOCSTATUS_AVAIL)) {
    sub MPI_REP_IOCSTATUS_AVAIL () {	(1<<15);}
}
unless(defined(&MPI_REP_IOCSTATUS)) {
    sub MPI_REP_IOCSTATUS () {	(0x7fff);}
}
unless(defined(&MPI_IOCSTATUS_SUCCESS)) {
    sub MPI_IOCSTATUS_SUCCESS () {	(0x);}
}
unless(defined(&MPI_IOCSTATUS_INVALID_FUNCTION)) {
    sub MPI_IOCSTATUS_INVALID_FUNCTION () {	(0x1);}
}
unless(defined(&MPI_IOCSTATUS_BUSY)) {
    sub MPI_IOCSTATUS_BUSY () {	(0x2);}
}
unless(defined(&MPI_IOCSTATUS_INVALID_SGL)) {
    sub MPI_IOCSTATUS_INVALID_SGL () {	(0x3);}
}
unless(defined(&MPI_IOCSTATUS_INTERNAL_ERROR)) {
    sub MPI_IOCSTATUS_INTERNAL_ERROR () {	(0x4);}
}
unless(defined(&MPI_IOCSTATUS_RESERVED)) {
    sub MPI_IOCSTATUS_RESERVED () {	(0x5);}
}
unless(defined(&MPI_IOCSTATUS_INSUFFICIENT_RESOURCES)) {
    sub MPI_IOCSTATUS_INSUFFICIENT_RESOURCES () {	(0x6);}
}
unless(defined(&MPI_IOCSTATUS_INVALID_FIELD)) {
    sub MPI_IOCSTATUS_INVALID_FIELD () {	(0x7);}
}
unless(defined(&MPI_IOCSTATUS_INVALID_STATE)) {
    sub MPI_IOCSTATUS_INVALID_STATE () {	(0x8);}
}
unless(defined(&MPI_IOCSTATUS_OP_STATE_NOT_SUPPORTED)) {
    sub MPI_IOCSTATUS_OP_STATE_NOT_SUPPORTED () {	(0x9);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_INVALID_ACTION)) {
    sub MPI_IOCSTATUS_CONFIG_INVALID_ACTION () {	(0x20);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_INVALID_TYPE)) {
    sub MPI_IOCSTATUS_CONFIG_INVALID_TYPE () {	(0x21);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_INVALID_PAGE)) {
    sub MPI_IOCSTATUS_CONFIG_INVALID_PAGE () {	(0x22);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_INVALID_DATA)) {
    sub MPI_IOCSTATUS_CONFIG_INVALID_DATA () {	(0x23);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_NO_DEFAULTS)) {
    sub MPI_IOCSTATUS_CONFIG_NO_DEFAULTS () {	(0x24);}
}
unless(defined(&MPI_IOCSTATUS_CONFIG_CANT_COMMIT)) {
    sub MPI_IOCSTATUS_CONFIG_CANT_COMMIT () {	(0x25);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_RECOVERED_ERROR)) {
    sub MPI_IOCSTATUS_SCSI_RECOVERED_ERROR () {	(0x40);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_INVALID_BUS)) {
    sub MPI_IOCSTATUS_SCSI_INVALID_BUS () {	(0x41);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_INVALID_TARGETID)) {
    sub MPI_IOCSTATUS_SCSI_INVALID_TARGETID () {	(0x42);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_DEVICE_NOT_THERE)) {
    sub MPI_IOCSTATUS_SCSI_DEVICE_NOT_THERE () {	(0x43);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_DATA_OVERRUN)) {
    sub MPI_IOCSTATUS_SCSI_DATA_OVERRUN () {	(0x44);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_DATA_UNDERRUN)) {
    sub MPI_IOCSTATUS_SCSI_DATA_UNDERRUN () {	(0x45);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_IO_DATA_ERROR)) {
    sub MPI_IOCSTATUS_SCSI_IO_DATA_ERROR () {	(0x46);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_PROTOCOL_ERROR)) {
    sub MPI_IOCSTATUS_SCSI_PROTOCOL_ERROR () {	(0x47);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_TASK_TERMINATED)) {
    sub MPI_IOCSTATUS_SCSI_TASK_TERMINATED () {	(0x48);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_RESIDUAL_MISMATCH)) {
    sub MPI_IOCSTATUS_SCSI_RESIDUAL_MISMATCH () {	(0x49);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_TASK_MGMT_FAILED)) {
    sub MPI_IOCSTATUS_SCSI_TASK_MGMT_FAILED () {	(0x4a);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_IOC_TERMINATED)) {
    sub MPI_IOCSTATUS_SCSI_IOC_TERMINATED () {	(0x4b);}
}
unless(defined(&MPI_IOCSTATUS_SCSI_EXT_TERMINATED)) {
    sub MPI_IOCSTATUS_SCSI_EXT_TERMINATED () {	(0x4c);}
}
unless(defined(&MPI_IOCSTATUS_EEDP_GUARD_ERROR)) {
    sub MPI_IOCSTATUS_EEDP_GUARD_ERROR () {	(0x4d);}
}
unless(defined(&MPI_IOCSTATUS_EEDP_REF_TAG_ERROR)) {
    sub MPI_IOCSTATUS_EEDP_REF_TAG_ERROR () {	(0x4e);}
}
unless(defined(&MPI_IOCSTATUS_EEDP_APP_TAG_ERROR)) {
    sub MPI_IOCSTATUS_EEDP_APP_TAG_ERROR () {	(0x4f);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_PRIORITY_IO)) {
    sub MPI_IOCSTATUS_TARGET_PRIORITY_IO () {	(0x60);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_INVALID_PORT)) {
    sub MPI_IOCSTATUS_TARGET_INVALID_PORT () {	(0x61);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_INVALID_IOCINDEX)) {
    sub MPI_IOCSTATUS_TARGET_INVALID_IOCINDEX () {	(0x62);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_INVALID_IO_INDEX)) {
    sub MPI_IOCSTATUS_TARGET_INVALID_IO_INDEX () {	(0x62);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_ABORTED)) {
    sub MPI_IOCSTATUS_TARGET_ABORTED () {	(0x63);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_NO_CONN_RETRYABLE)) {
    sub MPI_IOCSTATUS_TARGET_NO_CONN_RETRYABLE () {	(0x64);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_NO_CONNECTION)) {
    sub MPI_IOCSTATUS_TARGET_NO_CONNECTION () {	(0x65);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_XFER_COUNT_MISMATCH)) {
    sub MPI_IOCSTATUS_TARGET_XFER_COUNT_MISMATCH () {	(0x6a);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_STS_DATA_NOT_SENT)) {
    sub MPI_IOCSTATUS_TARGET_STS_DATA_NOT_SENT () {	(0x6b);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_DATA_OFFSET_ERROR)) {
    sub MPI_IOCSTATUS_TARGET_DATA_OFFSET_ERROR () {	(0x6d);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_TOO_MUCH_WRITE_DATA)) {
    sub MPI_IOCSTATUS_TARGET_TOO_MUCH_WRITE_DATA () {	(0x6e);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_IU_TOO_SHORT)) {
    sub MPI_IOCSTATUS_TARGET_IU_TOO_SHORT () {	(0x6f);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_FC_ABORTED)) {
    sub MPI_IOCSTATUS_TARGET_FC_ABORTED () {	(0x66);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_FC_RX_ID_INVALID)) {
    sub MPI_IOCSTATUS_TARGET_FC_RX_ID_INVALID () {	(0x67);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_FC_DID_INVALID)) {
    sub MPI_IOCSTATUS_TARGET_FC_DID_INVALID () {	(0x68);}
}
unless(defined(&MPI_IOCSTATUS_TARGET_FC_NODE_LOGGED_OUT)) {
    sub MPI_IOCSTATUS_TARGET_FC_NODE_LOGGED_OUT () {	(0x69);}
}
unless(defined(&MPI_IOCSTATUS_FC_ABORTED)) {
    sub MPI_IOCSTATUS_FC_ABORTED () {	(0x66);}
}
unless(defined(&MPI_IOCSTATUS_FC_RX_ID_INVALID)) {
    sub MPI_IOCSTATUS_FC_RX_ID_INVALID () {	(0x67);}
}
unless(defined(&MPI_IOCSTATUS_FC_DID_INVALID)) {
    sub MPI_IOCSTATUS_FC_DID_INVALID () {	(0x68);}
}
unless(defined(&MPI_IOCSTATUS_FC_NODE_LOGGED_OUT)) {
    sub MPI_IOCSTATUS_FC_NODE_LOGGED_OUT () {	(0x69);}
}
unless(defined(&MPI_IOCSTATUS_FC_EXCHANGE_CANCELED)) {
    sub MPI_IOCSTATUS_FC_EXCHANGE_CANCELED () {	(0x6c);}
}
unless(defined(&MPI_IOCSTATUS_LAN_DEVICE_NOT_FOUND)) {
    sub MPI_IOCSTATUS_LAN_DEVICE_NOT_FOUND () {	(0x80);}
}
unless(defined(&MPI_IOCSTATUS_LAN_DEVICE_FAILURE)) {
    sub MPI_IOCSTATUS_LAN_DEVICE_FAILURE () {	(0x81);}
}
unless(defined(&MPI_IOCSTATUS_LAN_TRANSMIT_ERROR)) {
    sub MPI_IOCSTATUS_LAN_TRANSMIT_ERROR () {	(0x82);}
}
unless(defined(&MPI_IOCSTATUS_LAN_TRANSMIT_ABORTED)) {
    sub MPI_IOCSTATUS_LAN_TRANSMIT_ABORTED () {	(0x83);}
}
unless(defined(&MPI_IOCSTATUS_LAN_RECEIVE_ERROR)) {
    sub MPI_IOCSTATUS_LAN_RECEIVE_ERROR () {	(0x84);}
}
unless(defined(&MPI_IOCSTATUS_LAN_RECEIVE_ABORTED)) {
    sub MPI_IOCSTATUS_LAN_RECEIVE_ABORTED () {	(0x85);}
}
unless(defined(&MPI_IOCSTATUS_LAN_PARTIAL_PACKET)) {
    sub MPI_IOCSTATUS_LAN_PARTIAL_PACKET () {	(0x86);}
}
unless(defined(&MPI_IOCSTATUS_LAN_CANCELED)) {
    sub MPI_IOCSTATUS_LAN_CANCELED () {	(0x87);}
}
unless(defined(&MPI_IOCSTATUS_SAS_SMP_REQUEST_FAILED)) {
    sub MPI_IOCSTATUS_SAS_SMP_REQUEST_FAILED () {	(0x90);}
}
unless(defined(&MPI_IOCSTATUS_SAS_SMP_DATA_OVERRUN)) {
    sub MPI_IOCSTATUS_SAS_SMP_DATA_OVERRUN () {	(0x91);}
}
unless(defined(&MPI_IOCSTATUS_INBAND_ABORTED)) {
    sub MPI_IOCSTATUS_INBAND_ABORTED () {	(0x98);}
}
unless(defined(&MPI_IOCSTATUS_INBAND_NO_CONNECTION)) {
    sub MPI_IOCSTATUS_INBAND_NO_CONNECTION () {	(0x99);}
}
unless(defined(&MPI_IOCSTATUS_DIAGNOSTIC_RELEASED)) {
    sub MPI_IOCSTATUS_DIAGNOSTIC_RELEASED () {	(0xa0);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE)) {
    sub MPI_REP_IOCLOGINFO_TYPE () {	(0xf<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE_NONE)) {
    sub MPI_REP_IOCLOGINFO_TYPE_NONE () {	(0x<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE_SCSI)) {
    sub MPI_REP_IOCLOGINFO_TYPE_SCSI () {	(0x1<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE_FC)) {
    sub MPI_REP_IOCLOGINFO_TYPE_FC () {	(0x2<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE_SAS)) {
    sub MPI_REP_IOCLOGINFO_TYPE_SAS () {	(0x3<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_TYPE_ISCSI)) {
    sub MPI_REP_IOCLOGINFO_TYPE_ISCSI () {	(0x4<<28);}
}
unless(defined(&MPI_REP_IOCLOGINFO_DATA)) {
    sub MPI_REP_IOCLOGINFO_DATA () {	(0xfffffff);}
}
unless(defined(&MPI_EVENT_NONE)) {
    sub MPI_EVENT_NONE () {	0x;}
}
unless(defined(&MPI_EVENT_LOG_DATA)) {
    sub MPI_EVENT_LOG_DATA () {	0x1;}
}
unless(defined(&MPI_EVENT_STATE_CHANGE)) {
    sub MPI_EVENT_STATE_CHANGE () {	0x2;}
}
unless(defined(&MPI_EVENT_UNIT_ATTENTION)) {
    sub MPI_EVENT_UNIT_ATTENTION () {	0x3;}
}
unless(defined(&MPI_EVENT_IOC_BUS_RESET)) {
    sub MPI_EVENT_IOC_BUS_RESET () {	0x4;}
}
unless(defined(&MPI_EVENT_EXT_BUS_RESET)) {
    sub MPI_EVENT_EXT_BUS_RESET () {	0x5;}
}
unless(defined(&MPI_EVENT_RESCAN)) {
    sub MPI_EVENT_RESCAN () {	0x6;}
}
unless(defined(&MPI_EVENT_LINK_STATUS_CHANGE)) {
    sub MPI_EVENT_LINK_STATUS_CHANGE () {	0x7;}
}
unless(defined(&MPI_EVENT_LOOP_STATE_CHANGE)) {
    sub MPI_EVENT_LOOP_STATE_CHANGE () {	0x8;}
}
unless(defined(&MPI_EVENT_LOGOUT)) {
    sub MPI_EVENT_LOGOUT () {	0x9;}
}
unless(defined(&MPI_EVENT_EVENT_CHANGE)) {
    sub MPI_EVENT_EVENT_CHANGE () {	0xa;}
}
unless(defined(&MPI_EVENT_INTEGRATED_RAID)) {
    sub MPI_EVENT_INTEGRATED_RAID () {	0xb;}
}
unless(defined(&MPI_EVENT_SCSI_DEVICE_STATUS_CHANGE)) {
    sub MPI_EVENT_SCSI_DEVICE_STATUS_CHANGE () {	0xc;}
}
unless(defined(&MPI_EVENT_ON_BUS_TIMER_EXPIRED)) {
    sub MPI_EVENT_ON_BUS_TIMER_EXPIRED () {	0xd;}
}
unless(defined(&MPI_EVENT_QUEUE_FULL)) {
    sub MPI_EVENT_QUEUE_FULL () {	0xe;}
}
unless(defined(&MPI_EVENT_SAS_DEVICE_STATUS_CHANGE)) {
    sub MPI_EVENT_SAS_DEVICE_STATUS_CHANGE () {	0xf;}
}
unless(defined(&MPI_EVENT_SAS_SES)) {
    sub MPI_EVENT_SAS_SES () {	0x10;}
}
unless(defined(&MPI_EVENT_PERSISTENT_TABLE_FULL)) {
    sub MPI_EVENT_PERSISTENT_TABLE_FULL () {	0x11;}
}
unless(defined(&MPI_EVENT_SAS_PHY_LINK_STATUS)) {
    sub MPI_EVENT_SAS_PHY_LINK_STATUS () {	0x12;}
}
unless(defined(&MPI_EVENT_SAS_DISCOVERY_ERROR)) {
    sub MPI_EVENT_SAS_DISCOVERY_ERROR () {	0x13;}
}
unless(defined(&MPI_EVENT_IR_RESYNC_UPDATE)) {
    sub MPI_EVENT_IR_RESYNC_UPDATE () {	0x14;}
}
unless(defined(&MPI_EVENT_IR2)) {
    sub MPI_EVENT_IR2 () {	0x15;}
}
unless(defined(&MPI_EVENT_SAS_DISCOVERY)) {
    sub MPI_EVENT_SAS_DISCOVERY () {	0x16;}
}
unless(defined(&MPI_EVENT_LOG_ENTRY_ADDED)) {
    sub MPI_EVENT_LOG_ENTRY_ADDED () {	0x21;}
}
unless(defined(&MPI_WHOINIT_NOONE)) {
    sub MPI_WHOINIT_NOONE () {	0x;}
}
unless(defined(&MPI_WHOINIT_SYSTEM_BIOS)) {
    sub MPI_WHOINIT_SYSTEM_BIOS () {	0x1;}
}
unless(defined(&MPI_WHOINIT_ROM_BIOS)) {
    sub MPI_WHOINIT_ROM_BIOS () {	0x2;}
}
unless(defined(&MPI_WHOINIT_PCI_PEER)) {
    sub MPI_WHOINIT_PCI_PEER () {	0x3;}
}
unless(defined(&MPI_WHOINIT_HOST_DRIVER)) {
    sub MPI_WHOINIT_HOST_DRIVER () {	0x4;}
}
unless(defined(&MPI_WHOINIT_MANUFACTURER)) {
    sub MPI_WHOINIT_MANUFACTURER () {	0x5;}
}
unless(defined(&MPI_PAGE_ADDRESS_FC_BTID)) {
    sub MPI_PAGE_ADDRESS_FC_BTID () {	(1<<24);}
}
unless(defined(&MPI_IOCINIT_F_DISCARD_FW)) {
    sub MPI_IOCINIT_F_DISCARD_FW () {	(1<<0);}
}
unless(defined(&MPI_IOCINIT_F_ENABLE_HOST_FIFO)) {
    sub MPI_IOCINIT_F_ENABLE_HOST_FIFO () {	(1<<1);}
}
unless(defined(&MPI_IOCINIT_F_HOST_PG_BUF_PERSIST)) {
    sub MPI_IOCINIT_F_HOST_PG_BUF_PERSIST () {	(1<<2);}
}
unless(defined(&MPI_IOCFACTS_EXCEPT_CONFIG_CHECKSUM_FAIL)) {
    sub MPI_IOCFACTS_EXCEPT_CONFIG_CHECKSUM_FAIL () {	(1<<0);}
}
unless(defined(&MPI_IOCFACTS_EXCEPT_RAID_CONFIG_INVALID)) {
    sub MPI_IOCFACTS_EXCEPT_RAID_CONFIG_INVALID () {	(1<<1);}
}
unless(defined(&MPI_IOCFACTS_EXCEPT_FW_CHECKSUM_FAIL)) {
    sub MPI_IOCFACTS_EXCEPT_FW_CHECKSUM_FAIL () {	(1<<2);}
}
unless(defined(&MPI_IOCFACTS_EXCEPT_PERSISTENT_TABLE_FULL)) {
    sub MPI_IOCFACTS_EXCEPT_PERSISTENT_TABLE_FULL () {	(1<<3);}
}
unless(defined(&MPI_IOCFACTS_FLAGS_FW_DOWNLOAD_BOOT)) {
    sub MPI_IOCFACTS_FLAGS_FW_DOWNLOAD_BOOT () {	(1<<0);}
}
unless(defined(&MPI_IOCFACTS_FLAGS_REPLY_FIFO_HOST_SIGNAL)) {
    sub MPI_IOCFACTS_FLAGS_REPLY_FIFO_HOST_SIGNAL () {	(1<<1);}
}
unless(defined(&MPI_IOCFACTS_FLAGS_HOST_PAGE_BUFFER_PERSISTENT)) {
    sub MPI_IOCFACTS_FLAGS_HOST_PAGE_BUFFER_PERSISTENT () {	(1<<2);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_HIGH_PRI_Q)) {
    sub MPI_IOCFACTS_CAPABILITY_HIGH_PRI_Q () {	(1<<0);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_REPLY_HOST_SIGNAL)) {
    sub MPI_IOCFACTS_CAPABILITY_REPLY_HOST_SIGNAL () {	(1<<1);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_QUEUE_FULL_HANDLING)) {
    sub MPI_IOCFACTS_CAPABILITY_QUEUE_FULL_HANDLING () {	(1<<2);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_DIAG_TRACE_BUFFER)) {
    sub MPI_IOCFACTS_CAPABILITY_DIAG_TRACE_BUFFER () {	(1<<3);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_SNAPSHOT_BUFFER)) {
    sub MPI_IOCFACTS_CAPABILITY_SNAPSHOT_BUFFER () {	(1<<4);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_EXTENDED_BUFFER)) {
    sub MPI_IOCFACTS_CAPABILITY_EXTENDED_BUFFER () {	(1<<5);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_EEDP)) {
    sub MPI_IOCFACTS_CAPABILITY_EEDP () {	(1<<6);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_BIDIRECTIONAL)) {
    sub MPI_IOCFACTS_CAPABILITY_BIDIRECTIONAL () {	(1<<7);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_MULTICAST)) {
    sub MPI_IOCFACTS_CAPABILITY_MULTICAST () {	(1<<8);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_SCSIIO32)) {
    sub MPI_IOCFACTS_CAPABILITY_SCSIIO32 () {	(1<<9);}
}
unless(defined(&MPI_IOCFACTS_CAPABILITY_NO_SCSIIO16)) {
    sub MPI_IOCFACTS_CAPABILITY_NO_SCSIIO16 () {	(1<<10);}
}
unless(defined(&MPI_PORTFACTS_PORTTYPE_INACTIVE)) {
    sub MPI_PORTFACTS_PORTTYPE_INACTIVE () {	0x;}
}
unless(defined(&MPI_PORTFACTS_PORTTYPE_SCSI)) {
    sub MPI_PORTFACTS_PORTTYPE_SCSI () {	0x1;}
}
unless(defined(&MPI_PORTFACTS_PORTTYPE_FC)) {
    sub MPI_PORTFACTS_PORTTYPE_FC () {	0x10;}
}
unless(defined(&MPI_PORTFACTS_PORTTYPE_ISCSI)) {
    sub MPI_PORTFACTS_PORTTYPE_ISCSI () {	0x20;}
}
unless(defined(&MPI_PORTFACTS_PORTTYPE_SAS)) {
    sub MPI_PORTFACTS_PORTTYPE_SAS () {	0x30;}
}
unless(defined(&MPI_PORTFACTS_PROTOCOL_LOGBUSADDR)) {
    sub MPI_PORTFACTS_PROTOCOL_LOGBUSADDR () {	(1<<0);}
}
unless(defined(&MPI_PORTFACTS_PROTOCOL_LAN)) {
    sub MPI_PORTFACTS_PROTOCOL_LAN () {	(1<<1);}
}
unless(defined(&MPI_PORTFACTS_PROTOCOL_TARGET)) {
    sub MPI_PORTFACTS_PROTOCOL_TARGET () {	(1<<2);}
}
unless(defined(&MPI_PORTFACTS_PROTOCOL_INITIATOR)) {
    sub MPI_PORTFACTS_PROTOCOL_INITIATOR () {	(1<<3);}
}
unless(defined(&MPI_EVENT_SWITCH_ON)) {
    sub MPI_EVENT_SWITCH_ON () {	(0x1);}
}
unless(defined(&MPI_EVENT_SWITCH_OFF)) {
    sub MPI_EVENT_SWITCH_OFF () {	(0x);}
}
unless(defined(&MPI_EVENT_ACK_REQUIRED)) {
    sub MPI_EVENT_ACK_REQUIRED () {	(0x1);}
}
unless(defined(&MPI_EVENT_FLAGS_REPLY_KEPT)) {
    sub MPI_EVENT_FLAGS_REPLY_KEPT () {	(1<<7);}
}
unless(defined(&MPI_EVT_LINK_STATUS_CHANGE_OFFLINE)) {
    sub MPI_EVT_LINK_STATUS_CHANGE_OFFLINE () {	0x;}
}
unless(defined(&MPI_EVT_LINK_STATUS_CHANGE_ACTIVE)) {
    sub MPI_EVT_LINK_STATUS_CHANGE_ACTIVE () {	0x1;}
}
unless(defined(&MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LIP)) {
    sub MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LIP () {	0x1;}
}
unless(defined(&MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LPE)) {
    sub MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LPE () {	0x2;}
}
unless(defined(&MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LPB)) {
    sub MPI_EVT_LOOP_STATUS_CHANGE_TYPE_LPB () {	0x3;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_CUR)) {
    sub MPI_EVT_SASPHY_LINK_CUR {
	my($x) = @_;
	eval q(((($x) & 0xf0) >> 4));
    }
}
unless(defined(&MPI_EVT_SASPHY_LINK_PREV)) {
    sub MPI_EVT_SASPHY_LINK_PREV {
	my($x) = @_;
	eval q((($x) & 0xf));
    }
}
unless(defined(&MPI_EVT_SASPHY_LINK_ENABLED)) {
    sub MPI_EVT_SASPHY_LINK_ENABLED () {	0x;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_DISABLED)) {
    sub MPI_EVT_SASPHY_LINK_DISABLED () {	0x1;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_NEGFAIL)) {
    sub MPI_EVT_SASPHY_LINK_NEGFAIL () {	0x2;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_SATAOOB)) {
    sub MPI_EVT_SASPHY_LINK_SATAOOB () {	0x3;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_1_5GBPS)) {
    sub MPI_EVT_SASPHY_LINK_1_5GBPS () {	0x8;}
}
unless(defined(&MPI_EVT_SASPHY_LINK_3_0GBPS)) {
    sub MPI_EVT_SASPHY_LINK_3_0GBPS () {	0x9;}
}
unless(defined(&MPI_EVT_SASCH_REASON_ADDED)) {
    sub MPI_EVT_SASCH_REASON_ADDED () {	0x3;}
}
unless(defined(&MPI_EVT_SASCH_REASON_NOT_RESPONDING)) {
    sub MPI_EVT_SASCH_REASON_NOT_RESPONDING () {	0x4;}
}
unless(defined(&MPI_EVT_SASCH_REASON_SMART_DATA)) {
    sub MPI_EVT_SASCH_REASON_SMART_DATA () {	0x5;}
}
unless(defined(&MPI_EVT_SASCH_REASON_NO_PERSIST_ADDED)) {
    sub MPI_EVT_SASCH_REASON_NO_PERSIST_ADDED () {	0x6;}
}
unless(defined(&MPI_EVT_SASCH_REASON_UNSUPPORTED)) {
    sub MPI_EVT_SASCH_REASON_UNSUPPORTED () {	0x7;}
}
unless(defined(&MPI_EVT_SASCH_REASON_INTERNAL_RESET)) {
    sub MPI_EVT_SASCH_REASON_INTERNAL_RESET () {	0x8;}
}
unless(defined(&MPI_EVT_SASCH_INFO_ATAPI)) {
    sub MPI_EVT_SASCH_INFO_ATAPI () {	(1<<13);}
}
unless(defined(&MPI_EVT_SASCH_INFO_LSI)) {
    sub MPI_EVT_SASCH_INFO_LSI () {	(1<<12);}
}
unless(defined(&MPI_EVT_SASCH_INFO_DIRECT_ATTACHED)) {
    sub MPI_EVT_SASCH_INFO_DIRECT_ATTACHED () {	(1<<11);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SSP)) {
    sub MPI_EVT_SASCH_INFO_SSP () {	(1<<10);}
}
unless(defined(&MPI_EVT_SASCH_INFO_STP)) {
    sub MPI_EVT_SASCH_INFO_STP () {	(1<<9);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SMP)) {
    sub MPI_EVT_SASCH_INFO_SMP () {	(1<<8);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SATA)) {
    sub MPI_EVT_SASCH_INFO_SATA () {	(1<<7);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SSP_INITIATOR)) {
    sub MPI_EVT_SASCH_INFO_SSP_INITIATOR () {	(1<<6);}
}
unless(defined(&MPI_EVT_SASCH_INFO_STP_INITIATOR)) {
    sub MPI_EVT_SASCH_INFO_STP_INITIATOR () {	(1<<5);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SMP_INITIATOR)) {
    sub MPI_EVT_SASCH_INFO_SMP_INITIATOR () {	(1<<4);}
}
unless(defined(&MPI_EVT_SASCH_INFO_SATA_HOST)) {
    sub MPI_EVT_SASCH_INFO_SATA_HOST () {	(1<<3);}
}
unless(defined(&MPI_EVT_SASCH_INFO_TYPE_MASK)) {
    sub MPI_EVT_SASCH_INFO_TYPE_MASK () {	0x7;}
}
unless(defined(&MPI_EVT_SASCH_INFO_TYPE_NONE)) {
    sub MPI_EVT_SASCH_INFO_TYPE_NONE () {	0x;}
}
unless(defined(&MPI_EVT_SASCH_INFO_TYPE_END)) {
    sub MPI_EVT_SASCH_INFO_TYPE_END () {	0x1;}
}
unless(defined(&MPI_EVT_SASCH_INFO_TYPE_EDGE)) {
    sub MPI_EVT_SASCH_INFO_TYPE_EDGE () {	0x2;}
}
unless(defined(&MPI_EVT_SASCH_INFO_TYPE_FANOUT)) {
    sub MPI_EVT_SASCH_INFO_TYPE_FANOUT () {	0x3;}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_IOC_FW)) {
    sub MPI_FWUPLOAD_IMAGETYPE_IOC_FW () {	(0x);}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_NV_FW)) {
    sub MPI_FWUPLOAD_IMAGETYPE_NV_FW () {	(0x1);}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_MPI_NV_FW)) {
    sub MPI_FWUPLOAD_IMAGETYPE_MPI_NV_FW () {	(0x2);}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_NV_DATA)) {
    sub MPI_FWUPLOAD_IMAGETYPE_NV_DATA () {	(0x3);}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_BOOT)) {
    sub MPI_FWUPLOAD_IMAGETYPE_BOOT () {	(0x4);}
}
unless(defined(&MPI_FWUPLOAD_IMAGETYPE_NV_BACKUP)) {
    sub MPI_FWUPLOAD_IMAGETYPE_NV_BACKUP () {	(0x5);}
}
unless(defined(&MPI_SCSIIO_EEDP)) {
    sub MPI_SCSIIO_EEDP () {	0xf0;}
}
unless(defined(&MPI_SCSIIO_CMD_DATA_DIR)) {
    sub MPI_SCSIIO_CMD_DATA_DIR () {	(1<<2);}
}
unless(defined(&MPI_SCSIIO_SENSE_BUF_LOC)) {
    sub MPI_SCSIIO_SENSE_BUF_LOC () {	(1<<1);}
}
unless(defined(&MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH)) {
    sub MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH () {	(1<<0);}
}
unless(defined(&MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH_32)) {
    sub MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH_32 () {	(0<<0);}
}
unless(defined(&MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH_64)) {
    sub MPI_SCSIIO_SENSE_BUF_ADDR_WIDTH_64 () {	(1<<0);}
}
unless(defined(&MPI_SCSIIO_ATTR_SIMPLE_Q)) {
    sub MPI_SCSIIO_ATTR_SIMPLE_Q () {	(0x);}
}
unless(defined(&MPI_SCSIIO_ATTR_HEAD_OF_Q)) {
    sub MPI_SCSIIO_ATTR_HEAD_OF_Q () {	(0x1);}
}
unless(defined(&MPI_SCSIIO_ATTR_ORDERED_Q)) {
    sub MPI_SCSIIO_ATTR_ORDERED_Q () {	(0x2);}
}
unless(defined(&MPI_SCSIIO_ATTR_ACA_Q)) {
    sub MPI_SCSIIO_ATTR_ACA_Q () {	(0x4);}
}
unless(defined(&MPI_SCSIIO_ATTR_UNTAGGED)) {
    sub MPI_SCSIIO_ATTR_UNTAGGED () {	(0x5);}
}
unless(defined(&MPI_SCSIIO_ATTR_NO_DISCONNECT)) {
    sub MPI_SCSIIO_ATTR_NO_DISCONNECT () {	(0x7);}
}
unless(defined(&MPI_SCSIIO_DIR_NONE)) {
    sub MPI_SCSIIO_DIR_NONE () {	(0x);}
}
unless(defined(&MPI_SCSIIO_DIR_WRITE)) {
    sub MPI_SCSIIO_DIR_WRITE () {	(0x1);}
}
unless(defined(&MPI_SCSIIO_DIR_READ)) {
    sub MPI_SCSIIO_DIR_READ () {	(0x2);}
}
unless(defined(&MPI_CDB_LEN)) {
    sub MPI_CDB_LEN () {	16;}
}
if((defined(&notyet) ? &notyet : undef)) {
    eval 'sub MPI_SCSIIO_ERR_STATUS_SUCCESS () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_SUCCESS);
    eval 'sub MPI_SCSIIO_ERR_STATUS_CHECK_COND () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_CHECK_COND);
    eval 'sub MPI_SCSIIO_ERR_STATUS_BUSY () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_BUSY);
    eval 'sub MPI_SCSIIO_ERR_STATUS_INTERMEDIATE () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_INTERMEDIATE);
    eval 'sub MPI_SCSIIO_ERR_STATUS_INTERMEDIATE_CONDMET () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_INTERMEDIATE_CONDMET);
    eval 'sub MPI_SCSIIO_ERR_STATUS_RESERVATION_CONFLICT () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_RESERVATION_CONFLICT);
    eval 'sub MPI_SCSIIO_ERR_STATUS_CMD_TERM () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_CMD_TERM);
    eval 'sub MPI_SCSIIO_ERR_STATUS_TASK_SET_FULL () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_TASK_SET_FULL);
    eval 'sub MPI_SCSIIO_ERR_STATUS_ACA_ACTIVE () {1;}' unless defined(&MPI_SCSIIO_ERR_STATUS_ACA_ACTIVE);
}
unless(defined(&MPI_SCSIIO_ERR_STATE_AUTOSENSE_VALID)) {
    sub MPI_SCSIIO_ERR_STATE_AUTOSENSE_VALID () {	(1<<0);}
}
unless(defined(&MPI_SCSIIO_ERR_STATE_AUTOSENSE_FAILED)) {
    sub MPI_SCSIIO_ERR_STATE_AUTOSENSE_FAILED () {	(1<<2);}
}
unless(defined(&MPI_SCSIIO_ERR_STATE_NO_SCSI_STATUS)) {
    sub MPI_SCSIIO_ERR_STATE_NO_SCSI_STATUS () {	(1<<3);}
}
unless(defined(&MPI_SCSIIO_ERR_STATE_TERMINATED)) {
    sub MPI_SCSIIO_ERR_STATE_TERMINATED () {	(1<<4);}
}
unless(defined(&MPI_SCSIIO_ERR_STATE_RESPONSE_INFO_VALID)) {
    sub MPI_SCSIIO_ERR_STATE_RESPONSE_INFO_VALID () {	(1<<5);}
}
unless(defined(&MPI_SCSIIO_ERR_STATE_QUEUE_TAG_REJECTED)) {
    sub MPI_SCSIIO_ERR_STATE_QUEUE_TAG_REJECTED () {	(1<<6);}
}
unless(defined(&MPI_MSG_SCSI_TASK_TYPE_ABORT_TASK)) {
    sub MPI_MSG_SCSI_TASK_TYPE_ABORT_TASK () {	(0x1);}
}
unless(defined(&MPI_MSG_SCSI_TASK_TYPE_ABRT_TASK_SET)) {
    sub MPI_MSG_SCSI_TASK_TYPE_ABRT_TASK_SET () {	(0x2);}
}
unless(defined(&MPI_MSG_SCSI_TASK_TYPE_TARGET_RESET)) {
    sub MPI_MSG_SCSI_TASK_TYPE_TARGET_RESET () {	(0x3);}
}
unless(defined(&MPI_MSG_SCSI_TASK_TYPE_RESET_BUS)) {
    sub MPI_MSG_SCSI_TASK_TYPE_RESET_BUS () {	(0x4);}
}
unless(defined(&MPI_MSG_SCSI_TASK_TYPE_LOGICAL_UNIT_RESET)) {
    sub MPI_MSG_SCSI_TASK_TYPE_LOGICAL_UNIT_RESET () {	(0x5);}
}
unless(defined(&MPI_MSG_RAID_ACTION_STATUS)) {
    sub MPI_MSG_RAID_ACTION_STATUS () {	(0x);}
}
unless(defined(&MPI_MSG_RAID_ACTION_INDICATOR_STRUCT)) {
    sub MPI_MSG_RAID_ACTION_INDICATOR_STRUCT () {	(0x1);}
}
unless(defined(&MPI_MSG_RAID_ACTION_CREATE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_CREATE_VOLUME () {	(0x2);}
}
unless(defined(&MPI_MSG_RAID_ACTION_DELETE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_DELETE_VOLUME () {	(0x3);}
}
unless(defined(&MPI_MSG_RAID_ACTION_DISABLE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_DISABLE_VOLUME () {	(0x4);}
}
unless(defined(&MPI_MSG_RAID_ACTION_ENABLE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_ENABLE_VOLUME () {	(0x5);}
}
unless(defined(&MPI_MSG_RAID_ACTION_QUIESCE_PHYSIO)) {
    sub MPI_MSG_RAID_ACTION_QUIESCE_PHYSIO () {	(0x6);}
}
unless(defined(&MPI_MSG_RAID_ACTION_ENABLE_PHYSIO)) {
    sub MPI_MSG_RAID_ACTION_ENABLE_PHYSIO () {	(0x7);}
}
unless(defined(&MPI_MSG_RAID_ACTION_CH_VOL_SETTINGS)) {
    sub MPI_MSG_RAID_ACTION_CH_VOL_SETTINGS () {	(0x8);}
}
unless(defined(&MPI_MSG_RAID_ACTION_PHYSDISK_OFFLINE)) {
    sub MPI_MSG_RAID_ACTION_PHYSDISK_OFFLINE () {	(0xa);}
}
unless(defined(&MPI_MSG_RAID_ACTION_PHYSDISK_ONLINE)) {
    sub MPI_MSG_RAID_ACTION_PHYSDISK_ONLINE () {	(0xb);}
}
unless(defined(&MPI_MSG_RAID_ACTION_CH_PHYSDISK_SETTINGS)) {
    sub MPI_MSG_RAID_ACTION_CH_PHYSDISK_SETTINGS () {	(0xc);}
}
unless(defined(&MPI_MSG_RAID_ACTION_CREATE_PHYSDISK)) {
    sub MPI_MSG_RAID_ACTION_CREATE_PHYSDISK () {	(0xd);}
}
unless(defined(&MPI_MSG_RAID_ACTION_DELETE_PHYSDISK)) {
    sub MPI_MSG_RAID_ACTION_DELETE_PHYSDISK () {	(0xe);}
}
unless(defined(&MPI_MSG_RAID_ACTION_PHYSDISK_FAIL)) {
    sub MPI_MSG_RAID_ACTION_PHYSDISK_FAIL () {	(0xf);}
}
unless(defined(&MPI_MSG_RAID_ACTION_ACTIVATE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_ACTIVATE_VOLUME () {	(0x11);}
}
unless(defined(&MPI_MSG_RAID_ACTION_DEACTIVATE_VOLUME)) {
    sub MPI_MSG_RAID_ACTION_DEACTIVATE_VOLUME () {	(0x12);}
}
unless(defined(&MPI_MSG_RAID_ACTION_SET_RESYNC_RATE)) {
    sub MPI_MSG_RAID_ACTION_SET_RESYNC_RATE () {	(0x13);}
}
unless(defined(&MPI_MSG_RAID_ACTION_SET_SCRUB_RATE)) {
    sub MPI_MSG_RAID_ACTION_SET_SCRUB_RATE () {	(0x14);}
}
unless(defined(&MPI_MSG_RAID_ACTION_DEVICE_FW_UPDATE_MODE)) {
    sub MPI_MSG_RAID_ACTION_DEVICE_FW_UPDATE_MODE () {	(0x15);}
}
unless(defined(&MPI_MSG_RAID_ACTION_SET_VOL_NAME)) {
    sub MPI_MSG_RAID_ACTION_SET_VOL_NAME () {	(0x16);}
}
unless(defined(&MPI_RAID_ACTION_STATUS_OK)) {
    sub MPI_RAID_ACTION_STATUS_OK () {	(0x);}
}
unless(defined(&MPI_RAID_ACTION_STATUS_INVALID)) {
    sub MPI_RAID_ACTION_STATUS_INVALID () {	(0x1);}
}
unless(defined(&MPI_RAID_ACTION_STATUS_FAILURE)) {
    sub MPI_RAID_ACTION_STATUS_FAILURE () {	(0x2);}
}
unless(defined(&MPI_RAID_ACTION_STATUS_IN_PROGRESS)) {
    sub MPI_RAID_ACTION_STATUS_IN_PROGRESS () {	(0x4);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_ATTRIBUTE)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_ATTRIBUTE () {	(0xf0);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_MASK)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_MASK () {	(0xf);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_IO_UNIT)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_IO_UNIT () {	(0x);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_IOC)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_IOC () {	(0x1);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_BIOS)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_BIOS () {	(0x2);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_SCSI_SPI_PORT)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_SCSI_SPI_PORT () {	(0x3);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_SCSI_SPI_DEV)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_SCSI_SPI_DEV () {	(0x4);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_FC_PORT)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_FC_PORT () {	(0x5);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_FC_DEV)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_FC_DEV () {	(0x6);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_LAN)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_LAN () {	(0x7);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_RAID_VOL)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_RAID_VOL () {	(0x8);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_MANUFACTURING)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_MANUFACTURING () {	(0x9);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_RAID_PD)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_RAID_PD () {	(0xa);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_INBAND)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_INBAND () {	(0xb);}
}
unless(defined(&MPI_CONFIG_REQ_PAGE_TYPE_EXTENDED)) {
    sub MPI_CONFIG_REQ_PAGE_TYPE_EXTENDED () {	(0xf);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_HEADER)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_HEADER () {	(0x);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_READ_CURRENT)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_READ_CURRENT () {	(0x1);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_WRITE_CURRENT () {	(0x2);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_DEFAULT)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_DEFAULT () {	(0x3);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_WRITE_NVRAM () {	(0x4);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_READ_DEFAULT () {	(0x5);}
}
unless(defined(&MPI_CONFIG_REQ_ACTION_PAGE_READ_NVRAM)) {
    sub MPI_CONFIG_REQ_ACTION_PAGE_READ_NVRAM () {	(0x6);}
}
unless(defined(&MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_IO_UNIT)) {
    sub MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_IO_UNIT () {	(0x10);}
}
unless(defined(&MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_EXPANDER)) {
    sub MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_EXPANDER () {	(0x11);}
}
unless(defined(&MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_DEVICE)) {
    sub MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_DEVICE () {	(0x12);}
}
unless(defined(&MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_PHY)) {
    sub MPI_CONFIG_REQ_EXTPAGE_TYPE_SAS_PHY () {	(0x13);}
}
unless(defined(&MPI_CONFIG_REQ_EXTPAGE_TYPE_LOG)) {
    sub MPI_CONFIG_REQ_EXTPAGE_TYPE_LOG () {	(0x14);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_PACKETIZED)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_PACKETIZED () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_DT)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_DT () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_QAS)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_QAS () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_IDP)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_IDP () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH_NARROW)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH_NARROW () {	(0<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH_WIDE)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_WIDTH_WIDE () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CAPABILITIES_AIP)) {
    sub MPI_CFG_SPI_PORT_0_CAPABILITIES_AIP () {	(1<<7);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_SIGNAL_HVD)) {
    sub MPI_CFG_SPI_PORT_0_SIGNAL_HVD () {	(0x1);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_SIGNAL_SE)) {
    sub MPI_CFG_SPI_PORT_0_SIGNAL_SE () {	(0x2);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_SIGNAL_LVD)) {
    sub MPI_CFG_SPI_PORT_0_SIGNAL_LVD () {	(0x3);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CONNECTEDID_BUSFREE)) {
    sub MPI_CFG_SPI_PORT_0_CONNECTEDID_BUSFREE () {	(0xfe);}
}
unless(defined(&MPI_CFG_SPI_PORT_0_CONNECTEDID_UNKNOWN)) {
    sub MPI_CFG_SPI_PORT_0_CONNECTEDID_UNKNOWN () {	(0xff);}
}
unless(defined(&MPI_CFG_SPI_PORT_1_TARGCFG_TARGET_ONLY)) {
    sub MPI_CFG_SPI_PORT_1_TARGCFG_TARGET_ONLY () {	(0x1);}
}
unless(defined(&MPI_CFG_SPI_PORT_1_TARGCFG_INIT_TARGET)) {
    sub MPI_CFG_SPI_PORT_1_TARGCFG_INIT_TARGET () {	(0x2);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_SCAN_HI2LOW)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_SCAN_HI2LOW () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_AVOID_RESET)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_AVOID_RESET () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_ALT_CHS)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_ALT_CHS () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_TERM_DISABLED)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_TERM_DISABLED () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_CTL)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_CTL () {	(0x3<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_BE)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_BE () {	(0x<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_B)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_B () {	(0x1<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_NONE)) {
    sub MPI_CFG_SPI_PORT_2_PORT_FLAGS_DV_HOST_NONE () {	(0x3<<5);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_HOST_ID)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_HOST_ID () {	(0x7<<0);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA () {	(0x3<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_DISABLED)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_DISABLED () {	(0x<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_BIOS)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_BIOS () {	(0x1<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_OS)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_OS () {	(0x2<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_BIOS_OS)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_INIT_HBA_BIOS_OS () {	(0x3<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_REMOVABLE)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_REMOVABLE () {	(0x3<<6);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_SPINUP_DELAY)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_SPINUP_DELAY () {	(0xf<<8);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_SYNC)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_SYNC () {	(0x3<<12);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_NEG_SUPPORTED)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_NEG_SUPPORTED () {	(0x<<12);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_NEG_NONE)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_NEG_NONE () {	(0x1<<12);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_PORT_SET_NEG_ALL)) {
    sub MPI_CFG_SPI_PORT_2_PORT_SET_NEG_ALL () {	(0x3<<12);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_DISCONNECT_EN)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_DISCONNECT_EN () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_SCAN_ID_EN)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_SCAN_ID_EN () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_SCAN_LUN_EN)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_SCAN_LUN_EN () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_TAQ_Q_EN)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_TAQ_Q_EN () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_WIDE_DIS)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_WIDE_DIS () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_PORT_2_DEV_FLAG_BOOT_CHOICE)) {
    sub MPI_CFG_SPI_PORT_2_DEV_FLAG_BOOT_CHOICE () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_PACKETIZED)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_PACKETIZED () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_DUALXFERS)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_DUALXFERS () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_QAS)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_QAS () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_HOLD_MCS)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_HOLD_MCS () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_WR_FLOW)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_WR_FLOW () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_RD_STRM)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_RD_STRM () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_RTI)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_RTI () {	(1<<6);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_PCOMP_EN)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_PCOMP_EN () {	(1<<7);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_IDP_EN)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_IDP_EN () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH_NARROW)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH_NARROW () {	(0<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH_WIDE)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_WIDTH_WIDE () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_NEGPARAMS_AIP)) {
    sub MPI_CFG_SPI_DEV_0_NEGPARAMS_AIP () {	(1<<7);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_INFO_NEG_OCCURRED)) {
    sub MPI_CFG_SPI_DEV_0_INFO_NEG_OCCURRED () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_INFO_SDTR_REJECTED)) {
    sub MPI_CFG_SPI_DEV_0_INFO_SDTR_REJECTED () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_INFO_WDTR_REJECTED)) {
    sub MPI_CFG_SPI_DEV_0_INFO_WDTR_REJECTED () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_DEV_0_INFO_PPR_REJECTED)) {
    sub MPI_CFG_SPI_DEV_0_INFO_PPR_REJECTED () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_PACKETIZED)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_PACKETIZED () {	(1<<0);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_DUALXFERS)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_DUALXFERS () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_QAS)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_QAS () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_HOLD_MCS)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_HOLD_MCS () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_WR_FLOW)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_WR_FLOW () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_RD_STRM)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_RD_STRM () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_RTI)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_RTI () {	(1<<6);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_PCOMP_EN)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_PCOMP_EN () {	(1<<7);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_IDP_EN)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_IDP_EN () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH_NARROW)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH_NARROW () {	(0<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH_WIDE)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_WIDTH_WIDE () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_REQPARAMS_AIP)) {
    sub MPI_CFG_SPI_DEV_1_REQPARAMS_AIP () {	(1<<7);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_CONF_WDTR_DISALLOWED)) {
    sub MPI_CFG_SPI_DEV_1_CONF_WDTR_DISALLOWED () {	(1<<1);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_CONF_SDTR_DISALLOWED)) {
    sub MPI_CFG_SPI_DEV_1_CONF_SDTR_DISALLOWED () {	(1<<2);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_CONF_EXTPARAMS)) {
    sub MPI_CFG_SPI_DEV_1_CONF_EXTPARAMS () {	(1<<3);}
}
unless(defined(&MPI_CFG_SPI_DEV_1_CONF_FORCE_PPR)) {
    sub MPI_CFG_SPI_DEV_1_CONF_FORCE_PPR () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_ISI_ENABLED)) {
    sub MPI_CFG_SPI_DEV_2_DV_ISI_ENABLED () {	(1<<4);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_SECONDARY_DRV_EN)) {
    sub MPI_CFG_SPI_DEV_2_DV_SECONDARY_DRV_EN () {	(1<<5);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_SLEW_RATE_CTL)) {
    sub MPI_CFG_SPI_DEV_2_DV_SLEW_RATE_CTL () {	(0x7<<7);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_PRIMARY_DRV_STRENGTH)) {
    sub MPI_CFG_SPI_DEV_2_DV_PRIMARY_DRV_STRENGTH () {	(0x7<<10);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_XCLKH_ST)) {
    sub MPI_CFG_SPI_DEV_2_DV_XCLKH_ST () {	(1<<28);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_XCLKS_ST)) {
    sub MPI_CFG_SPI_DEV_2_DV_XCLKS_ST () {	(1<<29);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_XCLKH_DT)) {
    sub MPI_CFG_SPI_DEV_2_DV_XCLKH_DT () {	(1<<30);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DV_XCLKS_DT)) {
    sub MPI_CFG_SPI_DEV_2_DV_XCLKS_DT () {	(1<<31);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_PARITY_PIPE_SELECT)) {
    sub MPI_CFG_SPI_DEV_2_PARITY_PIPE_SELECT () {	(0x3);}
}
unless(defined(&MPI_CFG_SPI_DEV_2_DATA_PIPE_SELECT)) {
    sub MPI_CFG_SPI_DEV_2_DATA_PIPE_SELECT {
	my($x) = @_;
	eval q((0x3<<(($x)*2)));
    }
}
unless(defined(&MPI_CFG_IOC_1_REPLY_COALESCING)) {
    sub MPI_CFG_IOC_1_REPLY_COALESCING () {	(1<<0);}
}
unless(defined(&MPI_CFG_IOC_1_CTX_REPLY_DISABLE)) {
    sub MPI_CFG_IOC_1_CTX_REPLY_DISABLE () {	(1<<4);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_IS)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_IS () {	(1<<0);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_IME)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_IME () {	(1<<1);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_IM)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_IM () {	(1<<2);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_RAID)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_RAID () {	(  &MPI_CFG_IOC_2_CAPABILITIES_IS |  &MPI_CFG_IOC_2_CAPABILITIES_IME |  &MPI_CFG_IOC_2_CAPABILITIES_IM);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_SES)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_SES () {	(1<<29);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_SAFTE)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_SAFTE () {	(1<<30);}
}
unless(defined(&MPI_CFG_IOC_2_CAPABILITIES_XCHANNEL)) {
    sub MPI_CFG_IOC_2_CAPABILITIES_XCHANNEL () {	(1<<31);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_IS)) {
    sub MPI_CFG_RAID_TYPE_RAID_IS () {	(0x);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_IME)) {
    sub MPI_CFG_RAID_TYPE_RAID_IME () {	(0x1);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_IM)) {
    sub MPI_CFG_RAID_TYPE_RAID_IM () {	(0x2);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_5)) {
    sub MPI_CFG_RAID_TYPE_RAID_5 () {	(0x3);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_6)) {
    sub MPI_CFG_RAID_TYPE_RAID_6 () {	(0x4);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_10)) {
    sub MPI_CFG_RAID_TYPE_RAID_10 () {	(0x5);}
}
unless(defined(&MPI_CFG_RAID_TYPE_RAID_50)) {
    sub MPI_CFG_RAID_TYPE_RAID_50 () {	(0x6);}
}
unless(defined(&MPI_CFG_RAID_VOL_INACTIVE)) {
    sub MPI_CFG_RAID_VOL_INACTIVE () {	(1<<3);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_WRITE_CACHE_EN)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_WRITE_CACHE_EN () {	(1<<0);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_OFFLINE_SMART_ERR)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_OFFLINE_SMART_ERR () {	(1<<1);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_OFFLINE_SMART)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_OFFLINE_SMART () {	(1<<2);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_AUTO_SWAP)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_AUTO_SWAP () {	(1<<3);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_HI_PRI_RESYNC)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_HI_PRI_RESYNC () {	(1<<4);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_PROD_SUFFIX)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_PROD_SUFFIX () {	(1<<5);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_FAST_SCRUB)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_FAST_SCRUB () {	(1<<6);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_SETTINGS_DEFAULTS)) {
    sub MPI_CFG_RAID_VOL_0_SETTINGS_DEFAULTS () {	(1<<15);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATUS_ENABLED)) {
    sub MPI_CFG_RAID_VOL_0_STATUS_ENABLED () {	(1<<0);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATUS_QUIESCED)) {
    sub MPI_CFG_RAID_VOL_0_STATUS_QUIESCED () {	(1<<1);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATUS_RESYNCING)) {
    sub MPI_CFG_RAID_VOL_0_STATUS_RESYNCING () {	(1<<2);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATUS_ACTIVE)) {
    sub MPI_CFG_RAID_VOL_0_STATUS_ACTIVE () {	(1<<3);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATUS_BADBLOCK_FULL)) {
    sub MPI_CFG_RAID_VOL_0_STATUS_BADBLOCK_FULL () {	(1<<4);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATE_OPTIMAL)) {
    sub MPI_CFG_RAID_VOL_0_STATE_OPTIMAL () {	(0x);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATE_DEGRADED)) {
    sub MPI_CFG_RAID_VOL_0_STATE_DEGRADED () {	(0x1);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATE_FAILED)) {
    sub MPI_CFG_RAID_VOL_0_STATE_FAILED () {	(0x2);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_STATE_MISSING)) {
    sub MPI_CFG_RAID_VOL_0_STATE_MISSING () {	(0x3);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_UNKNOWN)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_UNKNOWN () {	(0x);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_STALE_META)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_STALE_META () {	(0x1);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_FOREIGN_VOL)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_FOREIGN_VOL () {	(0x2);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_NO_RESOURCES)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_NO_RESOURCES () {	(0x3);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_CLONED_VOL)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_CLONED_VOL () {	(0x4);}
}
unless(defined(&MPI_CFG_RAID_VOL_0_INACTIVE_INSUF_META)) {
    sub MPI_CFG_RAID_VOL_0_INACTIVE_INSUF_META () {	(0x5);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_ENCTYPE_NONE)) {
    sub MPI_CFG_RAID_PHYDISK_0_ENCTYPE_NONE () {	(0x);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_ENCTYPE_SAFTE)) {
    sub MPI_CFG_RAID_PHYDISK_0_ENCTYPE_SAFTE () {	(0x1);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_ENCTYPE_SES)) {
    sub MPI_CFG_RAID_PHYDISK_0_ENCTYPE_SES () {	(0x2);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATUS_OUTOFSYNC)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATUS_OUTOFSYNC () {	(1<<0);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATUS_QUIESCED)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATUS_QUIESCED () {	(1<<1);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_ONLINE)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_ONLINE () {	(0x);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_MISSING)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_MISSING () {	(0x1);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_INCOMPAT)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_INCOMPAT () {	(0x2);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_FAILED)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_FAILED () {	(0x3);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_INIT)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_INIT () {	(0x4);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_OFFLINE)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_OFFLINE () {	(0x5);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_HOSTFAIL)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_HOSTFAIL () {	(0x6);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_0_STATE_OTHER)) {
    sub MPI_CFG_RAID_PHYDISK_0_STATE_OTHER () {	(0xff);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_PATH_INVALID)) {
    sub MPI_CFG_RAID_PHYDISK_PATH_INVALID () {	(1<<0);}
}
unless(defined(&MPI_CFG_RAID_PHYDISK_PATH_BROKEN)) {
    sub MPI_CFG_RAID_PHYDISK_PATH_BROKEN () {	(1<<1);}
}
unless(defined(&MPI_CFG_SAS_DEV_ADDR_NEXT)) {
    sub MPI_CFG_SAS_DEV_ADDR_NEXT () {	(0<<28);}
}
unless(defined(&MPI_CFG_SAS_DEV_ADDR_BUS)) {
    sub MPI_CFG_SAS_DEV_ADDR_BUS () {	(1<<28);}
}
unless(defined(&MPI_CFG_SAS_DEV_ADDR_HANDLE)) {
    sub MPI_CFG_SAS_DEV_ADDR_HANDLE () {	(2<<28);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_TYPE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_TYPE () {	(0x7);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_NONE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_NONE () {	(0x);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_END)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_END () {	(0x1);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_EDGE_EXPANDER)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_EDGE_EXPANDER () {	(0x2);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_FANOUT_EXPANDER)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_TYPE_FANOUT_EXPANDER () {	(0x3);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SATA_HOST)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SATA_HOST () {	(1<<3);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SMP_INITIATOR)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SMP_INITIATOR () {	(1<<4);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_STP_INITIATOR)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_STP_INITIATOR () {	(1<<5);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SSP_INITIATOR)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SSP_INITIATOR () {	(1<<6);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SATA_DEVICE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SATA_DEVICE () {	(1<<7);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SMP_TARGET)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SMP_TARGET () {	(1<<8);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_STP_TARGET)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_STP_TARGET () {	(1<<9);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SSP_TARGET)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SSP_TARGET () {	(1<<10);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_DIRECT_ATTACHED)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_DIRECT_ATTACHED () {	(1<<11);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_LSI_DEVICE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_LSI_DEVICE () {	(1<<12);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_ATAPI_DEVICE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_ATAPI_DEVICE () {	(1<<13);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_DEVINFO_SEP_DEVICE)) {
    sub MPI_CFG_SAS_DEV_0_DEVINFO_SEP_DEVICE () {	(1<<14);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_DEV_PRESENT)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_DEV_PRESENT () {	(1<<0);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED () {	(1<<1);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED_PERSISTENT)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_DEV_MAPPED_PERSISTENT () {	(1<<2);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_PORT_SELECTOR)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_PORT_SELECTOR () {	(1<<3);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_FUA)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_FUA () {	(1<<4);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_NCQ)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_NCQ () {	(1<<5);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_SMART)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_SMART () {	(1<<6);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_LBA48)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_LBA48 () {	(1<<7);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_UNSUPPORTED)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_UNSUPPORTED () {	(1<<8);}
}
unless(defined(&MPI_CFG_SAS_DEV_0_FLAGS_SATA_SETTINGS)) {
    sub MPI_CFG_SAS_DEV_0_FLAGS_SATA_SETTINGS () {	(1<<9);}
}
1;
