require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&CISS_BIGBIT)) {
    sub CISS_BIGBIT () {	0x80;}
}
unless(defined(&CISS_IDB)) {
    sub CISS_IDB () {	0x20;}
}
unless(defined(&CISS_IDB_CFG)) {
    sub CISS_IDB_CFG () {	0x1;}
}
unless(defined(&CISS_ISR)) {
    sub CISS_ISR () {	0x30;}
}
unless(defined(&CISS_IMR)) {
    sub CISS_IMR () {	0x34;}
}
unless(defined(&CISS_READYENAB)) {
    sub CISS_READYENAB () {	4;}
}
unless(defined(&CISS_READYENA)) {
    sub CISS_READYENA () {	8;}
}
unless(defined(&CISS_INQ)) {
    sub CISS_INQ () {	0x40;}
}
unless(defined(&CISS_OUTQ)) {
    sub CISS_OUTQ () {	0x44;}
}
unless(defined(&CISS_CFG_BAR)) {
    sub CISS_CFG_BAR () {	0xb4;}
}
unless(defined(&CISS_CFG_OFF)) {
    sub CISS_CFG_OFF () {	0xb8;}
}
unless(defined(&CISS_INQ64_LO)) {
    sub CISS_INQ64_LO () {	0xc0;}
}
unless(defined(&CISS_INQ64_HI)) {
    sub CISS_INQ64_HI () {	0xc4;}
}
unless(defined(&CISS_OUTQ64_LO)) {
    sub CISS_OUTQ64_LO () {	0xc8;}
}
unless(defined(&CISS_OUTQ64_HI)) {
    sub CISS_OUTQ64_HI () {	0xcc;}
}
unless(defined(&CISS_DRVMAP_SIZE)) {
    sub CISS_DRVMAP_SIZE () {	(128/ 8);}
}
unless(defined(&CISS_CMD_CTRL_GET)) {
    sub CISS_CMD_CTRL_GET () {	0x26;}
}
unless(defined(&CISS_CMD_CTRL_SET)) {
    sub CISS_CMD_CTRL_SET () {	0x27;}
}
unless(defined(&CISS_CMS_CTRL_LDID)) {
    sub CISS_CMS_CTRL_LDID () {	0x10;}
}
unless(defined(&CISS_CMS_CTRL_CTRL)) {
    sub CISS_CMS_CTRL_CTRL () {	0x11;}
}
unless(defined(&CISS_CMS_CTRL_LDSTAT)) {
    sub CISS_CMS_CTRL_LDSTAT () {	0x12;}
}
unless(defined(&CISS_CMS_CTRL_PDID)) {
    sub CISS_CMS_CTRL_PDID () {	0x15;}
}
unless(defined(&CISS_CMS_CTRL_PDBLINK)) {
    sub CISS_CMS_CTRL_PDBLINK () {	0x16;}
}
unless(defined(&CISS_CMS_CTRL_PDBLSENS)) {
    sub CISS_CMS_CTRL_PDBLSENS () {	0x17;}
}
unless(defined(&CISS_CMS_CTRL_LDIDEXT)) {
    sub CISS_CMS_CTRL_LDIDEXT () {	0x18;}
}
unless(defined(&CISS_CMS_CTRL_REDSTAT)) {
    sub CISS_CMS_CTRL_REDSTAT () {	0x82;}
}
unless(defined(&CISS_CMS_CTRL_FLUSH)) {
    sub CISS_CMS_CTRL_FLUSH () {	0xc2;}
}
unless(defined(&CISS_CMS_CTRL_ACCEPT)) {
    sub CISS_CMS_CTRL_ACCEPT () {	0xe0;}
}
unless(defined(&CISS_CMD_READ)) {
    sub CISS_CMD_READ () {	0xc0;}
}
unless(defined(&CISS_CMD_READ_EVENT)) {
    sub CISS_CMD_READ_EVENT () {	0xd0;}
}
unless(defined(&CISS_EVENT_RECENT)) {
    sub CISS_EVENT_RECENT () {	0x8;}
}
unless(defined(&CISS_EVENT_RSTOLD)) {
    sub CISS_EVENT_RSTOLD () {	0x4;}
}
unless(defined(&CISS_EVENT_ORDER)) {
    sub CISS_EVENT_ORDER () {	0x2;}
}
unless(defined(&CISS_EVENT_SYNC)) {
    sub CISS_EVENT_SYNC () {	0x1;}
}
unless(defined(&CISS_CMD_LDMAP)) {
    sub CISS_CMD_LDMAP () {	0xc2;}
}
unless(defined(&CISS_CMD_PDMAP)) {
    sub CISS_CMD_PDMAP () {	0xc3;}
}
unless(defined(&ciss_bitset)) {
    sub ciss_bitset {
	my($d, $v) = @_;
	eval q((($v)[($d) >> 3] & (1<< (($d) & 7))));
    }
}
unless(defined(&CISS_SIGNATURE)) {
    sub CISS_SIGNATURE () {	(*( &u_int32_t *)"CISS");}
}
unless(defined(&CISS_METH_READY)) {
    sub CISS_METH_READY () {	0x1;}
}
unless(defined(&CISS_METH_SIMPL)) {
    sub CISS_METH_SIMPL () {	0x2;}
}
unless(defined(&CISS_METH_PERF)) {
    sub CISS_METH_PERF () {	0x4;}
}
unless(defined(&CISS_METH_EMQ)) {
    sub CISS_METH_EMQ () {	0x8;}
}
unless(defined(&CISS_METH_BIT63)) {
    sub CISS_METH_BIT63 () {	0x8000000;}
}
unless(defined(&CISS_METH_FIFO64_RRO)) {
    sub CISS_METH_FIFO64_RRO () {	0x10000000;}
}
unless(defined(&CISS_METH_SHORT_TAG)) {
    sub CISS_METH_SHORT_TAG () {	0x20000000;}
}
unless(defined(&CISS_METH_MSIX)) {
    sub CISS_METH_MSIX () {	0x40000000;}
}
unless(defined(&CISS_METH_FIFO64)) {
    sub CISS_METH_FIFO64 () {	0x80000000;}
}
unless(defined(&CISS_BUS_U2)) {
    sub CISS_BUS_U2 () {	0x1;}
}
unless(defined(&CISS_BUS_U3)) {
    sub CISS_BUS_U3 () {	0x2;}
}
unless(defined(&CISS_BUS_FC1)) {
    sub CISS_BUS_FC1 () {	0x100;}
}
unless(defined(&CISS_BUS_FC2)) {
    sub CISS_BUS_FC2 () {	0x200;}
}
unless(defined(&CISS_DRV_UATT)) {
    sub CISS_DRV_UATT () {	0x1;}
}
unless(defined(&CISS_DRV_QINI)) {
    sub CISS_DRV_QINI () {	0x2;}
}
unless(defined(&CISS_DRV_LCKINT)) {
    sub CISS_DRV_LCKINT () {	0x4;}
}
unless(defined(&CISS_DRV_QTAGS)) {
    sub CISS_DRV_QTAGS () {	0x8;}
}
unless(defined(&CISS_DRV_ALPHA)) {
    sub CISS_DRV_ALPHA () {	0x10;}
}
unless(defined(&CISS_DRV_LUNS)) {
    sub CISS_DRV_LUNS () {	0x20;}
}
unless(defined(&CISS_DRV_MSGRQ)) {
    sub CISS_DRV_MSGRQ () {	0x80;}
}
unless(defined(&CISS_DRV_DBRD)) {
    sub CISS_DRV_DBRD () {	0x100;}
}
unless(defined(&CISS_DRV_PRF)) {
    sub CISS_DRV_PRF () {	0x200;}
}
unless(defined(&CISS_INQ_WIDE)) {
    sub CISS_INQ_WIDE () {	0x8;}
}
unless(defined(&CISS_INQ_BIGMAP)) {
    sub CISS_INQ_BIGMAP () {	0x80;}
}
unless(defined(&CISS_INQ_BITS)) {
    sub CISS_INQ_BITS () {	"\020\04WIDE\010BIGMAP";}
}
unless(defined(&CISS_FLUSH_ENABLE)) {
    sub CISS_FLUSH_ENABLE () {	0;}
}
unless(defined(&CISS_FLUSH_DISABLE)) {
    sub CISS_FLUSH_DISABLE () {	1;}
}
unless(defined(&CISS_BLINK_ALL)) {
    sub CISS_BLINK_ALL () {	1;}
}
unless(defined(&CISS_BLINK_TIMED)) {
    sub CISS_BLINK_TIMED () {	2;}
}
unless(defined(&CISS_LD_RAID0)) {
    sub CISS_LD_RAID0 () {	0;}
}
unless(defined(&CISS_LD_RAID4)) {
    sub CISS_LD_RAID4 () {	1;}
}
unless(defined(&CISS_LD_RAID1)) {
    sub CISS_LD_RAID1 () {	2;}
}
unless(defined(&CISS_LD_RAID5)) {
    sub CISS_LD_RAID5 () {	3;}
}
unless(defined(&CISS_LD_RAID51)) {
    sub CISS_LD_RAID51 () {	4;}
}
unless(defined(&CISS_LD_RAIDADG)) {
    sub CISS_LD_RAIDADG () {	5;}
}
unless(defined(&CISS_LD_OK)) {
    sub CISS_LD_OK () {	0;}
}
unless(defined(&CISS_LD_FAILED)) {
    sub CISS_LD_FAILED () {	1;}
}
unless(defined(&CISS_LD_UNCONF)) {
    sub CISS_LD_UNCONF () {	2;}
}
unless(defined(&CISS_LD_DEGRAD)) {
    sub CISS_LD_DEGRAD () {	3;}
}
unless(defined(&CISS_LD_RBLDRD)) {
    sub CISS_LD_RBLDRD () {	4;}
}
unless(defined(&CISS_LD_REBLD)) {
    sub CISS_LD_REBLD () {	5;}
}
unless(defined(&CISS_LD_PDINV)) {
    sub CISS_LD_PDINV () {	6;}
}
unless(defined(&CISS_LD_PDUNC)) {
    sub CISS_LD_PDUNC () {	7;}
}
unless(defined(&CISS_LD_EXPND)) {
    sub CISS_LD_EXPND () {	10;}
}
unless(defined(&CISS_LD_NORDY)) {
    sub CISS_LD_NORDY () {	11;}
}
unless(defined(&CISS_LD_QEXPND)) {
    sub CISS_LD_QEXPND () {	12;}
}
unless(defined(&CISS_LD_CONF)) {
    sub CISS_LD_CONF () {	0x1;}
}
unless(defined(&CISS_LD_RBLD)) {
    sub CISS_LD_RBLD () {	0x2;}
}
unless(defined(&CISS_LD_DONE)) {
    sub CISS_LD_DONE () {	0x4;}
}
unless(defined(&CISS_LD_FAIL)) {
    sub CISS_LD_FAIL () {	0x8;}
}
unless(defined(&CISS_LD_USED)) {
    sub CISS_LD_USED () {	0x10;}
}
unless(defined(&CISS_LD_AVAIL)) {
    sub CISS_LD_AVAIL () {	0x20;}
}
unless(defined(&CISS_LD_RBLD_READ)) {
    sub CISS_LD_RBLD_READ () {	0x1;}
}
unless(defined(&CISS_LD_RBLD_WRITE)) {
    sub CISS_LD_RBLD_WRITE () {	0x2;}
}
unless(defined(&CISS_PD_PRESENT)) {
    sub CISS_PD_PRESENT () {	0x1;}
}
unless(defined(&CISS_PD_NONDSK)) {
    sub CISS_PD_NONDSK () {	0x2;}
}
unless(defined(&CISS_PD_WIDE)) {
    sub CISS_PD_WIDE () {	0x4;}
}
unless(defined(&CISS_PD_SYNC)) {
    sub CISS_PD_SYNC () {	0x8;}
}
unless(defined(&CISS_PD_NARROW)) {
    sub CISS_PD_NARROW () {	0x10;}
}
unless(defined(&CISS_PD_W2NARR)) {
    sub CISS_PD_W2NARR () {	0x20;}
}
unless(defined(&CISS_PD_ULTRA)) {
    sub CISS_PD_ULTRA () {	0x40;}
}
unless(defined(&CISS_PD_ULTRA2)) {
    sub CISS_PD_ULTRA2 () {	0x80;}
}
unless(defined(&CISS_PD_SMART)) {
    sub CISS_PD_SMART () {	0x1;}
}
unless(defined(&CISS_PD_SMERRR)) {
    sub CISS_PD_SMERRR () {	0x2;}
}
unless(defined(&CISS_PD_SMERRE)) {
    sub CISS_PD_SMERRE () {	0x4;}
}
unless(defined(&CISS_PD_SMERRD)) {
    sub CISS_PD_SMERRD () {	0x8;}
}
unless(defined(&CISS_PD_EXT)) {
    sub CISS_PD_EXT () {	0x10;}
}
unless(defined(&CISS_PD_CONF)) {
    sub CISS_PD_CONF () {	0x20;}
}
unless(defined(&CISS_PD_SPARE)) {
    sub CISS_PD_SPARE () {	0x40;}
}
unless(defined(&CISS_PD_CASAVE)) {
    sub CISS_PD_CASAVE () {	0x80;}
}
unless(defined(&CISS_PD_CACHE)) {
    sub CISS_PD_CACHE () {	0x1;}
}
unless(defined(&CISS_PD_CASAFE)) {
    sub CISS_PD_CASAFE () {	0x1;}
}
unless(defined(&CISS_EVCLS_PROTO)) {
    sub CISS_EVCLS_PROTO () {	0;}
}
unless(defined(&CISS_EVCLS_PLUG)) {
    sub CISS_EVCLS_PLUG () {	1;}
}
unless(defined(&CISS_EVCLS_HW)) {
    sub CISS_EVCLS_HW () {	2;}
}
unless(defined(&CISS_EVCLS_ENV)) {
    sub CISS_EVCLS_ENV () {	3;}
}
unless(defined(&CISS_EVCLS_PD)) {
    sub CISS_EVCLS_PD () {	4;}
}
unless(defined(&CISS_EVCLS_LD)) {
    sub CISS_EVCLS_LD () {	5;}
}
unless(defined(&CISS_EVCLS_CTRL)) {
    sub CISS_EVCLS_CTRL () {	6;}
}
unless(defined(&CISS_EVCLS_CISS)) {
    sub CISS_EVCLS_CISS () {	8;}
}
unless(defined(&CISS_EVCLS_RESV)) {
    sub CISS_EVCLS_RESV () {	9;}
}
unless(defined(&CISS_EVPROTO_STAT)) {
    sub CISS_EVPROTO_STAT () {	0;}
}
unless(defined(&CISS_EVPROTO_ERR)) {
    sub CISS_EVPROTO_ERR () {	1;}
}
unless(defined(&CISS_EVPLUG_PDCHG)) {
    sub CISS_EVPLUG_PDCHG () {	0;}
}
unless(defined(&CISS_EVPLUG_POWER)) {
    sub CISS_EVPLUG_POWER () {	1;}
}
unless(defined(&CISS_EVPLUG_FAN)) {
    sub CISS_EVPLUG_FAN () {	2;}
}
unless(defined(&CISS_EVPLUG_UPS)) {
    sub CISS_EVPLUG_UPS () {	3;}
}
unless(defined(&CISS_EVPLUG_CTRL)) {
    sub CISS_EVPLUG_CTRL () {	4;}
}
unless(defined(&CISS_EVHW_CABLES)) {
    sub CISS_EVHW_CABLES () {	0;}
}
unless(defined(&CISS_EVHW_MEMORY)) {
    sub CISS_EVHW_MEMORY () {	1;}
}
unless(defined(&CISS_EVHW_FAN)) {
    sub CISS_EVHW_FAN () {	2;}
}
unless(defined(&CISS_EVHW_VRM)) {
    sub CISS_EVHW_VRM () {	3;}
}
unless(defined(&CISS_EVENV_TEMP)) {
    sub CISS_EVENV_TEMP () {	0;}
}
unless(defined(&CISS_EVENV_PS)) {
    sub CISS_EVENV_PS () {	1;}
}
unless(defined(&CISS_EVENV_CHASSIS)) {
    sub CISS_EVENV_CHASSIS () {	2;}
}
unless(defined(&CISS_EVENV_AC)) {
    sub CISS_EVENV_AC () {	3;}
}
unless(defined(&CISS_EVPD_STAT)) {
    sub CISS_EVPD_STAT () {	0;}
}
unless(defined(&CISS_EVLD_STAT)) {
    sub CISS_EVLD_STAT () {	0;}
}
unless(defined(&CISS_EVLD_ERR)) {
    sub CISS_EVLD_ERR () {	1;}
}
unless(defined(&CISS_EVLD_CHECK)) {
    sub CISS_EVLD_CHECK () {	2;}
}
unless(defined(&CISS_EVCTRL_STAT)) {
    sub CISS_EVCTRL_STAT () {	0;}
}
unless(defined(&CISS_EVSTAT_NONE)) {
    sub CISS_EVSTAT_NONE () {	0;}
}
unless(defined(&CISS_EVSTAT_DISABLE)) {
    sub CISS_EVSTAT_DISABLE () {	1;}
}
unless(defined(&CISS_EVSTAT_TMO)) {
    sub CISS_EVSTAT_TMO () {	2;}
}
unless(defined(&CISS_EVERR_OVERFLOW)) {
    sub CISS_EVERR_OVERFLOW () {	0;}
}
unless(defined(&CISS_EVPLUG_REMOVE)) {
    sub CISS_EVPLUG_REMOVE () {	0;}
}
unless(defined(&CISS_EVPLUG_INSERT)) {
    sub CISS_EVPLUG_INSERT () {	1;}
}
unless(defined(&CISS_EVFAN_FAULT)) {
    sub CISS_EVFAN_FAULT () {	0;}
}
unless(defined(&CISS_EVFAN_DEGRADED)) {
    sub CISS_EVFAN_DEGRADED () {	1;}
}
unless(defined(&CISS_EVFAN_OK)) {
    sub CISS_EVFAN_OK () {	2;}
}
unless(defined(&CISS_EVVRM_REMOVE)) {
    sub CISS_EVVRM_REMOVE () {	0;}
}
unless(defined(&CISS_EVVRM_INSERT)) {
    sub CISS_EVVRM_INSERT () {	1;}
}
unless(defined(&CISS_EVVRM_FAILED)) {
    sub CISS_EVVRM_FAILED () {	2;}
}
unless(defined(&CISS_EVVRM_OK)) {
    sub CISS_EVVRM_OK () {	3;}
}
unless(defined(&CISS_EVTEMP_LIMEX)) {
    sub CISS_EVTEMP_LIMEX () {	0;}
}
unless(defined(&CISS_EVTEMP_WARN)) {
    sub CISS_EVTEMP_WARN () {	1;}
}
unless(defined(&CISS_EVTEMP_OK)) {
    sub CISS_EVTEMP_OK () {	2;}
}
unless(defined(&CISS_EVPS_FAIL)) {
    sub CISS_EVPS_FAIL () {	0;}
}
unless(defined(&CISS_EVPS_OK)) {
    sub CISS_EVPS_OK () {	2;}
}
unless(defined(&CISS_EVCHAS_OPEN)) {
    sub CISS_EVCHAS_OPEN () {	0;}
}
unless(defined(&CISS_EVCHAS_CLOSE)) {
    sub CISS_EVCHAS_CLOSE () {	2;}
}
unless(defined(&CISS_EVAC_FAIL)) {
    sub CISS_EVAC_FAIL () {	0;}
}
unless(defined(&CISS_EVAC_BATTLOW)) {
    sub CISS_EVAC_BATTLOW () {	1;}
}
unless(defined(&CISS_EVPDSTAT_FAIL)) {
    sub CISS_EVPDSTAT_FAIL () {	0;}
}
unless(defined(&CISS_EVLDSTAT_CHG)) {
    sub CISS_EVLDSTAT_CHG () {	0;}
}
unless(defined(&CISS_EVLDSTAT_EXMEDIA)) {
    sub CISS_EVLDSTAT_EXMEDIA () {	1;}
}
unless(defined(&CISS_EVLDSTAT_RERDERR)) {
    sub CISS_EVLDSTAT_RERDERR () {	2;}
}
unless(defined(&CISS_EVLDSTAT_REWRERR)) {
    sub CISS_EVLDSTAT_REWRERR () {	3;}
}
unless(defined(&CISS_EVLDERR_FATAL)) {
    sub CISS_EVLDERR_FATAL () {	0;}
}
unless(defined(&CISS_EVCHECK_DONE)) {
    sub CISS_EVCHECK_DONE () {	0;}
}
unless(defined(&CISS_EVCTRLSTAT_CHG)) {
    sub CISS_EVCTRLSTAT_CHG () {	0;}
}
unless(defined(&CISS_CMD_ERR)) {
    sub CISS_CMD_ERR () {	0x2;}
}
unless(defined(&CISS_CMD_MODE_PERIPH)) {
    sub CISS_CMD_MODE_PERIPH () {	0x;}
}
unless(defined(&CISS_CMD_MODE_LD)) {
    sub CISS_CMD_MODE_LD () {	0x40000000;}
}
unless(defined(&CISS_CMD_TGT_MASK)) {
    sub CISS_CMD_TGT_MASK () {	0x40ffffff;}
}
unless(defined(&CISS_CMD_BUS_MASK)) {
    sub CISS_CMD_BUS_MASK () {	0x3f000000;}
}
unless(defined(&CISS_CMD_BUS_SHIFT)) {
    sub CISS_CMD_BUS_SHIFT () {	24;}
}
unless(defined(&CISS_CDB_CMD)) {
    sub CISS_CDB_CMD () {	0x;}
}
unless(defined(&CISS_CDB_MSG)) {
    sub CISS_CDB_MSG () {	0x1;}
}
unless(defined(&CISS_CDB_NOTAG)) {
    sub CISS_CDB_NOTAG () {	0x;}
}
unless(defined(&CISS_CDB_SIMPL)) {
    sub CISS_CDB_SIMPL () {	0x20;}
}
unless(defined(&CISS_CDB_QHEAD)) {
    sub CISS_CDB_QHEAD () {	0x28;}
}
unless(defined(&CISS_CDB_ORDR)) {
    sub CISS_CDB_ORDR () {	0x30;}
}
unless(defined(&CISS_CDB_AUTO)) {
    sub CISS_CDB_AUTO () {	0x38;}
}
unless(defined(&CISS_CDB_IN)) {
    sub CISS_CDB_IN () {	0x80;}
}
unless(defined(&CISS_CDB_OUT)) {
    sub CISS_CDB_OUT () {	0x40;}
}
unless(defined(&CISS_MAX_CDB)) {
    sub CISS_MAX_CDB () {	16;}
}
unless(defined(&CISS_SG_EXT)) {
    sub CISS_SG_EXT () {	0x1;}
}
unless(defined(&CISS_ERR_OK)) {
    sub CISS_ERR_OK () {	0;}
}
unless(defined(&CISS_ERR_TGTST)) {
    sub CISS_ERR_TGTST () {	1;}
}
unless(defined(&CISS_ERR_UNRUN)) {
    sub CISS_ERR_UNRUN () {	2;}
}
unless(defined(&CISS_ERR_OVRUN)) {
    sub CISS_ERR_OVRUN () {	3;}
}
unless(defined(&CISS_ERR_INVCMD)) {
    sub CISS_ERR_INVCMD () {	4;}
}
unless(defined(&CISS_ERR_PROTE)) {
    sub CISS_ERR_PROTE () {	5;}
}
unless(defined(&CISS_ERR_HWERR)) {
    sub CISS_ERR_HWERR () {	6;}
}
unless(defined(&CISS_ERR_CLOSS)) {
    sub CISS_ERR_CLOSS () {	7;}
}
unless(defined(&CISS_ERR_ABRT)) {
    sub CISS_ERR_ABRT () {	8;}
}
unless(defined(&CISS_ERR_FABRT)) {
    sub CISS_ERR_FABRT () {	9;}
}
unless(defined(&CISS_ERR_UABRT)) {
    sub CISS_ERR_UABRT () {	10;}
}
unless(defined(&CISS_ERR_TMO)) {
    sub CISS_ERR_TMO () {	11;}
}
unless(defined(&CISS_ERR_NABRT)) {
    sub CISS_ERR_NABRT () {	12;}
}
eval("sub CISS_CCB_FREE () { 0x01; }") unless defined(&CISS_CCB_FREE);
eval("sub CISS_CCB_READY () { 0x02; }") unless defined(&CISS_CCB_READY);
eval("sub CISS_CCB_ONQ () { 0x04; }") unless defined(&CISS_CCB_ONQ);
eval("sub CISS_CCB_PREQ () { 0x08; }") unless defined(&CISS_CCB_PREQ);
eval("sub CISS_CCB_POLL () { 0x10; }") unless defined(&CISS_CCB_POLL);
eval("sub CISS_CCB_FAIL () { 0x80#defineCISS_CCB_BITS"\020\01FREE\02READY\03ONQ\04PREQ\05POLL\010FAIL"; }") unless defined(&CISS_CCB_FAIL);
1;
