require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/malloc.ph';
require 'sys/pool.ph';
require 'sys/queue.ph';
unless(defined(&MLEN)) {
    sub MLEN () {	( &MSIZE - $sizeof{'struct m_hdr'});}
}
unless(defined(&MHLEN)) {
    sub MHLEN () {	( &MLEN - $sizeof{'struct pkthdr'});}
}
unless(defined(&MINCLSIZE)) {
    sub MINCLSIZE () {	( &MHLEN +  &MLEN + 1);}
}
unless(defined(&M_MAXCOMPRESS)) {
    sub M_MAXCOMPRESS () {	( &MHLEN / 2);}
}
unless(defined(&mtod)) {
    sub mtod {
	my($m,$t) = @_;
	eval q((($t)(($m)-> &m_data)));
    }
}
unless(defined(&PF_TAG_GENERATED)) {
    sub PF_TAG_GENERATED () {	0x1;}
}
unless(defined(&PF_TAG_FRAGCACHE)) {
    sub PF_TAG_FRAGCACHE () {	0x2;}
}
unless(defined(&PF_TAG_TRANSLATE_LOCALHOST)) {
    sub PF_TAG_TRANSLATE_LOCALHOST () {	0x4;}
}
unless(defined(&PF_TAG_DIVERTED)) {
    sub PF_TAG_DIVERTED () {	0x8;}
}
unless(defined(&PF_TAG_DIVERTED_PACKET)) {
    sub PF_TAG_DIVERTED_PACKET () {	0x10;}
}
unless(defined(&PF_TAG_REROUTE)) {
    sub PF_TAG_REROUTE () {	0x20;}
}
if(defined(&DEBUG)) {
}
unless(defined(&m_next)) {
    sub m_next () {	 ($m_hdr->{mh_next});}
}
unless(defined(&m_len)) {
    sub m_len () {	 ($m_hdr->{mh_len});}
}
unless(defined(&m_data)) {
    sub m_data () {	 ($m_hdr->{mh_data});}
}
unless(defined(&m_type)) {
    sub m_type () {	 ($m_hdr->{mh_type});}
}
unless(defined(&m_flags)) {
    sub m_flags () {	 ($m_hdr->{mh_flags});}
}
unless(defined(&m_nextpkt)) {
    sub m_nextpkt () {	 ($m_hdr->{mh_nextpkt});}
}
unless(defined(&m_act)) {
    sub m_act () {	 &m_nextpkt;}
}
unless(defined(&m_pkthdr)) {
    sub m_pkthdr () {	 ($M_dat->{MH}->{MH_pkthdr});}
}
unless(defined(&m_ext)) {
    sub m_ext () {	 ($M_dat->{MH}->{MH_dat}->{MH_ext});}
}
unless(defined(&m_pktdat)) {
    sub m_pktdat () {	 ($M_dat->{MH}->{MH_dat}->{MH_databuf});}
}
unless(defined(&m_dat)) {
    sub m_dat () {	 ($M_dat->{M_databuf});}
}
unless(defined(&M_EXT)) {
    sub M_EXT () {	0x1;}
}
unless(defined(&M_PKTHDR)) {
    sub M_PKTHDR () {	0x2;}
}
unless(defined(&M_EOR)) {
    sub M_EOR () {	0x4;}
}
unless(defined(&M_CLUSTER)) {
    sub M_CLUSTER () {	0x8;}
}
unless(defined(&M_PROTO1)) {
    sub M_PROTO1 () {	0x10;}
}
unless(defined(&M_VLANTAG)) {
    sub M_VLANTAG () {	0x20;}
}
unless(defined(&M_LOOP)) {
    sub M_LOOP () {	0x40;}
}
unless(defined(&M_FILDROP)) {
    sub M_FILDROP () {	0x80;}
}
unless(defined(&M_BCAST)) {
    sub M_BCAST () {	0x100;}
}
unless(defined(&M_MCAST)) {
    sub M_MCAST () {	0x200;}
}
unless(defined(&M_CONF)) {
    sub M_CONF () {	0x400;}
}
unless(defined(&M_AUTH)) {
    sub M_AUTH () {	0x800;}
}
unless(defined(&M_TUNNEL)) {
    sub M_TUNNEL () {	0x1000;}
}
unless(defined(&M_AUTH_AH)) {
    sub M_AUTH_AH () {	0x2000;}
}
unless(defined(&M_LINK0)) {
    sub M_LINK0 () {	0x8000;}
}
unless(defined(&M_COPYFLAGS)) {
    sub M_COPYFLAGS () {	( &M_PKTHDR| &M_EOR| &M_PROTO1| &M_BCAST| &M_MCAST| &M_CONF|  &M_AUTH| &M_LOOP| &M_TUNNEL| &M_LINK0| &M_VLANTAG| &M_FILDROP);}
}
unless(defined(&M_IPV4_CSUM_OUT)) {
    sub M_IPV4_CSUM_OUT () {	0x1;}
}
unless(defined(&M_TCPV4_CSUM_OUT)) {
    sub M_TCPV4_CSUM_OUT () {	0x2;}
}
unless(defined(&M_UDPV4_CSUM_OUT)) {
    sub M_UDPV4_CSUM_OUT () {	0x4;}
}
unless(defined(&M_IPV4_CSUM_IN_OK)) {
    sub M_IPV4_CSUM_IN_OK () {	0x8;}
}
unless(defined(&M_IPV4_CSUM_IN_BAD)) {
    sub M_IPV4_CSUM_IN_BAD () {	0x10;}
}
unless(defined(&M_TCP_CSUM_IN_OK)) {
    sub M_TCP_CSUM_IN_OK () {	0x20;}
}
unless(defined(&M_TCP_CSUM_IN_BAD)) {
    sub M_TCP_CSUM_IN_BAD () {	0x40;}
}
unless(defined(&M_UDP_CSUM_IN_OK)) {
    sub M_UDP_CSUM_IN_OK () {	0x80;}
}
unless(defined(&M_UDP_CSUM_IN_BAD)) {
    sub M_UDP_CSUM_IN_BAD () {	0x100;}
}
unless(defined(&MT_FREE)) {
    sub MT_FREE () {	0;}
}
unless(defined(&MT_DATA)) {
    sub MT_DATA () {	1;}
}
unless(defined(&MT_HEADER)) {
    sub MT_HEADER () {	2;}
}
unless(defined(&MT_SONAME)) {
    sub MT_SONAME () {	3;}
}
unless(defined(&MT_SOOPTS)) {
    sub MT_SOOPTS () {	4;}
}
unless(defined(&MT_FTABLE)) {
    sub MT_FTABLE () {	5;}
}
unless(defined(&MT_CONTROL)) {
    sub MT_CONTROL () {	6;}
}
unless(defined(&MT_OOBDATA)) {
    sub MT_OOBDATA () {	7;}
}
unless(defined(&M_DONTWAIT)) {
    sub M_DONTWAIT () {	 &M_NOWAIT;}
}
unless(defined(&M_WAIT)) {
    sub M_WAIT () {	 &M_WAITOK;}
}
unless(defined(&MGET)) {
    sub MGET {
	my($m, $how, $type) = @_;
	eval q($m =  &m_get(($how), ($type)));
    }
}
unless(defined(&MGETHDR)) {
    sub MGETHDR {
	my($m, $how, $type) = @_;
	eval q($m =  &m_gethdr(($how), ($type)));
    }
}
if(defined(&DEBUG)) {
    eval 'sub MCLREFDEBUGN {
        my($m, $file, $line) = @_;
	    eval q( &do { ($m)-> ($m_ext->{ext_nfile}) = ($file); ($m)-> ($m_ext->{ext_nline}) = ($line); }  &while ( 0));
    }' unless defined(&MCLREFDEBUGN);
    eval 'sub MCLREFDEBUGO {
        my($m, $file, $line) = @_;
	    eval q( &do { ($m)-> ($m_ext->{ext_ofile}) = ($file); ($m)-> ($m_ext->{ext_oline}) = ($line); }  &while ( 0));
    }' unless defined(&MCLREFDEBUGO);
} else {
    eval 'sub MCLREFDEBUGN {
        my($m, $file, $line) = @_;
	    eval q();
    }' unless defined(&MCLREFDEBUGN);
    eval 'sub MCLREFDEBUGO {
        my($m, $file, $line) = @_;
	    eval q();
    }' unless defined(&MCLREFDEBUGO);
}
unless(defined(&MCLISREFERENCED)) {
    sub MCLISREFERENCED {
	my($m) = @_;
	eval q((($m)-> ($m_ext->{ext_nextref}) != ($m)));
    }
}
unless(defined(&MCLADDREFERENCE)) {
    sub MCLADDREFERENCE {
	my($o, $n) = @_;
	eval q( &do { 'int'  &ms =  &splnet(); ($n)-> &m_flags |= (($o)-> &m_flags & ( &M_EXT| &M_CLUSTER)); ($n)-> ($m_ext->{ext_nextref}) = ($o)-> ($m_ext->{ext_nextref}); ($n)-> ($m_ext->{ext_prevref}) = ($o); ($o)-> ($m_ext->{ext_nextref}) = ($n); ($n)-> ($m_ext->{ext_nextref}->{m_ext}->{ext_prevref}) = ($n);  &splx( &ms);  &MCLREFDEBUGN(($n),  &__FILE__,  &__LINE__); }  &while ( 0));
    }
}
unless(defined(&MCLINITREFERENCE)) {
    sub MCLINITREFERENCE {
	my($m) = @_;
	eval q( &do { ($m)-> ($m_ext->{ext_prevref}) = ($m); ($m)-> ($m_ext->{ext_nextref}) = ($m);  &MCLREFDEBUGO(($m),  &__FILE__,  &__LINE__);  &MCLREFDEBUGN(($m),  &NULL, 0); }  &while ( 0));
    }
}
unless(defined(&MEXTADD)) {
    sub MEXTADD {
	my($m, $buf, $size, $type, $free, $arg) = @_;
	eval q( &do { -> &m_data = -> ($m_ext->{ext_buf}) = ($buf); ($m)-> &m_flags |=  &M_EXT; ($m)-> &m_flags &= ~ &M_CLUSTER; ($m)-> ($m_ext->{ext_size}) = ($size); ($m)-> ($m_ext->{ext_free}) = ($free); ($m)-> ($m_ext->{ext_arg}) = ($arg); ($m)-> ($m_ext->{ext_type}) = ($type);  &MCLINITREFERENCE($m); }  &while ( 0));
    }
}
unless(defined(&MCLGET)) {
    sub MCLGET {
	my($m, $how) = @_;
	eval q(( &void)  &m_clget(($m), ($how),  &NULL,  &MCLBYTES));
    }
}
unless(defined(&MCLGETI)) {
    sub MCLGETI {
	my($m, $how, $ifp, $l) = @_;
	eval q( &m_clget(($m), ($how), ($ifp), ($l)));
    }
}
unless(defined(&MFREE)) {
    sub MFREE {
	my($m, $n) = @_;
	eval q($n =  &m_free(($m)));
    }
}
unless(defined(&M_MOVE_HDR)) {
    sub M_MOVE_HDR {
	my($to, $from) = @_;
	eval q( &do { ($to)-> &m_pkthdr = ($from)-> &m_pkthdr; ($from)-> &m_flags &= ~ &M_PKTHDR; }  &while ( 0));
    }
}
unless(defined(&M_MOVE_PKTHDR)) {
    sub M_MOVE_PKTHDR {
	my($to, $from) = @_;
	eval q( &do { ($to)-> &m_flags = (($to)-> &m_flags & ( &M_EXT |  &M_CLUSTER)); ($to)-> &m_flags |= ($from)-> &m_flags &  &M_COPYFLAGS;  &M_MOVE_HDR(($to), ($from));  &if ((($to)-> &m_flags &  &M_EXT) == 0) ($to)-> &m_data = ($to)-> &m_pktdat; }  &while ( 0));
    }
}
unless(defined(&M_ALIGN)) {
    sub M_ALIGN {
	my($m, $len) = @_;
	eval q(($m)-> &m_data += ( &MLEN - ($len)) &~ ($sizeof{'long'} - 1));
    }
}
unless(defined(&MH_ALIGN)) {
    sub MH_ALIGN {
	my($m, $len) = @_;
	eval q(($m)-> &m_data += ( &MHLEN - ($len)) &~ ($sizeof{'long'} - 1));
    }
}
unless(defined(&M_READONLY)) {
    sub M_READONLY {
	my($m) = @_;
	eval q(((($m)-> &m_flags &  &M_EXT) != 0 && ((($m)-> &m_flags &  &M_CLUSTER) == 0||  &MCLISREFERENCED($m))));
    }
}
unless(defined(&M_LEADINGSPACE)) {
    sub M_LEADINGSPACE {
	my($m) = @_;
	eval q( &m_leadingspace($m));
    }
}
unless(defined(&M_TRAILINGSPACE)) {
    sub M_TRAILINGSPACE {
	my($m) = @_;
	eval q( &m_trailingspace($m));
    }
}
unless(defined(&M_PREPEND)) {
    sub M_PREPEND {
	my($m, $plen, $how) = @_;
	eval q(($m) =  &m_prepend(($m), ($plen), ($how)));
    }
}
unless(defined(&M_COPYALL)) {
    sub M_COPYALL () {	1000000000;}
}
unless(defined(&m_copy)) {
    sub m_copy {
	my($m, $o, $l) = @_;
	eval q( &m_copym(($m), ($o), ($l),  &M_DONTWAIT));
    }
}
if(defined(&_KERNEL)) {
    eval 'sub PACKET_TAG_IPSEC_IN_DONE () {0x1;}' unless defined(&PACKET_TAG_IPSEC_IN_DONE);
    eval 'sub PACKET_TAG_IPSEC_OUT_DONE () {0x2;}' unless defined(&PACKET_TAG_IPSEC_OUT_DONE);
    eval 'sub PACKET_TAG_IPSEC_IN_CRYPTO_DONE () {0x4;}' unless defined(&PACKET_TAG_IPSEC_IN_CRYPTO_DONE);
    eval 'sub PACKET_TAG_IPSEC_OUT_CRYPTO_NEEDED () {0x8;}' unless defined(&PACKET_TAG_IPSEC_OUT_CRYPTO_NEEDED);
    eval 'sub PACKET_TAG_IPSEC_PENDING_TDB () {0x10;}' unless defined(&PACKET_TAG_IPSEC_PENDING_TDB);
    eval 'sub PACKET_TAG_BRIDGE () {0x20;}' unless defined(&PACKET_TAG_BRIDGE);
    eval 'sub PACKET_TAG_GIF () {0x40;}' unless defined(&PACKET_TAG_GIF);
    eval 'sub PACKET_TAG_GRE () {0x80;}' unless defined(&PACKET_TAG_GRE);
    eval 'sub PACKET_TAG_DLT () {0x100;}' unless defined(&PACKET_TAG_DLT);
    eval 'sub PACKET_TAG_PF_DIVERT () {0x200;}' unless defined(&PACKET_TAG_PF_DIVERT);
    eval 'sub PACKET_TAG_PIPEX () {0x400;}' unless defined(&PACKET_TAG_PIPEX);
}
1;
