require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETBT_L2CAP_H_)) {
    eval 'sub _NETBT_L2CAP_H_ () {1;}' unless defined(&_NETBT_L2CAP_H_);
    require 'sys/types.ph';
    eval 'sub L2CAP_NULL_CID () {0x;}' unless defined(&L2CAP_NULL_CID);
    eval 'sub L2CAP_SIGNAL_CID () {0x1;}' unless defined(&L2CAP_SIGNAL_CID);
    eval 'sub L2CAP_CLT_CID () {0x2;}' unless defined(&L2CAP_CLT_CID);
    eval 'sub L2CAP_FIRST_CID () {0x40;}' unless defined(&L2CAP_FIRST_CID);
    eval 'sub L2CAP_LAST_CID () {0xffff;}' unless defined(&L2CAP_LAST_CID);
    eval 'sub L2CAP_MTU_MINIMUM () {48;}' unless defined(&L2CAP_MTU_MINIMUM);
    eval 'sub L2CAP_MTU_DEFAULT () {672;}' unless defined(&L2CAP_MTU_DEFAULT);
    eval 'sub L2CAP_MTU_MAXIMUM () {0xffff;}' unless defined(&L2CAP_MTU_MAXIMUM);
    eval 'sub L2CAP_FLUSH_TIMO_DEFAULT () {0xffff;}' unless defined(&L2CAP_FLUSH_TIMO_DEFAULT);
    eval 'sub L2CAP_LINK_TIMO_DEFAULT () {0xffff;}' unless defined(&L2CAP_LINK_TIMO_DEFAULT);
    eval 'sub L2CAP_REJ_NOT_UNDERSTOOD () {0x;}' unless defined(&L2CAP_REJ_NOT_UNDERSTOOD);
    eval 'sub L2CAP_REJ_MTU_EXCEEDED () {0x1;}' unless defined(&L2CAP_REJ_MTU_EXCEEDED);
    eval 'sub L2CAP_REJ_INVALID_CID () {0x2;}' unless defined(&L2CAP_REJ_INVALID_CID);
    eval 'sub L2CAP_PSM_ANY () {0x;}' unless defined(&L2CAP_PSM_ANY);
    eval 'sub L2CAP_PSM_SDP () {0x1;}' unless defined(&L2CAP_PSM_SDP);
    eval 'sub L2CAP_PSM_RFCOMM () {0x3;}' unless defined(&L2CAP_PSM_RFCOMM);
    eval 'sub L2CAP_PSM_TCP () {0x5;}' unless defined(&L2CAP_PSM_TCP);
    eval 'sub L2CAP_PSM_TCS () {0x7;}' unless defined(&L2CAP_PSM_TCS);
    eval 'sub L2CAP_PSM_BNEP () {0xf;}' unless defined(&L2CAP_PSM_BNEP);
    eval 'sub L2CAP_PSM_HID_CNTL () {0x11;}' unless defined(&L2CAP_PSM_HID_CNTL);
    eval 'sub L2CAP_PSM_HID_INTR () {0x13;}' unless defined(&L2CAP_PSM_HID_INTR);
    eval 'sub L2CAP_PSM_ESDP () {0x15;}' unless defined(&L2CAP_PSM_ESDP);
    eval 'sub L2CAP_PSM_AVCTP () {0x17;}' unless defined(&L2CAP_PSM_AVCTP);
    eval 'sub L2CAP_PSM_AVDTP () {0x19;}' unless defined(&L2CAP_PSM_AVDTP);
    eval 'sub L2CAP_PSM_INVALID {
        my($psm) = @_;
	    eval q(((($psm) & 0x101) != 0x1));
    }' unless defined(&L2CAP_PSM_INVALID);
    eval 'sub L2CAP_SUCCESS () {0x;}' unless defined(&L2CAP_SUCCESS);
    eval 'sub L2CAP_PENDING () {0x1;}' unless defined(&L2CAP_PENDING);
    eval 'sub L2CAP_PSM_NOT_SUPPORTED () {0x2;}' unless defined(&L2CAP_PSM_NOT_SUPPORTED);
    eval 'sub L2CAP_SECURITY_BLOCK () {0x3;}' unless defined(&L2CAP_SECURITY_BLOCK);
    eval 'sub L2CAP_NO_RESOURCES () {0x4;}' unless defined(&L2CAP_NO_RESOURCES);
    eval 'sub L2CAP_TIMEOUT () {0xeeee;}' unless defined(&L2CAP_TIMEOUT);
    eval 'sub L2CAP_UNKNOWN () {0xffff;}' unless defined(&L2CAP_UNKNOWN);
    eval 'sub L2CAP_NO_INFO () {0x;}' unless defined(&L2CAP_NO_INFO);
    eval 'sub L2CAP_AUTH_PENDING () {0x1;}' unless defined(&L2CAP_AUTH_PENDING);
    eval 'sub L2CAP_AUTZ_PENDING () {0x2;}' unless defined(&L2CAP_AUTZ_PENDING);
    eval 'sub L2CAP_UNACCEPTABLE_PARAMS () {0x1;}' unless defined(&L2CAP_UNACCEPTABLE_PARAMS);
    eval 'sub L2CAP_REJECT () {0x2;}' unless defined(&L2CAP_REJECT);
    eval 'sub L2CAP_UNKNOWN_OPTION () {0x3;}' unless defined(&L2CAP_UNKNOWN_OPTION);
    eval 'sub L2CAP_OPT_CFLAG_BIT () {0x1;}' unless defined(&L2CAP_OPT_CFLAG_BIT);
    eval 'sub L2CAP_OPT_CFLAG {
        my($flags) = @_;
	    eval q((($flags) &  &L2CAP_OPT_CFLAG_BIT));
    }' unless defined(&L2CAP_OPT_CFLAG);
    eval 'sub L2CAP_OPT_HINT_BIT () {0x80;}' unless defined(&L2CAP_OPT_HINT_BIT);
    eval 'sub L2CAP_OPT_HINT {
        my($type) = @_;
	    eval q((($type) &  &L2CAP_OPT_HINT_BIT));
    }' unless defined(&L2CAP_OPT_HINT);
    eval 'sub L2CAP_OPT_HINT_MASK () {0x7f;}' unless defined(&L2CAP_OPT_HINT_MASK);
    eval 'sub L2CAP_OPT_MTU () {0x1;}' unless defined(&L2CAP_OPT_MTU);
    eval 'sub L2CAP_OPT_MTU_SIZE () {$sizeof{ &uint16_t};}' unless defined(&L2CAP_OPT_MTU_SIZE);
    eval 'sub L2CAP_OPT_FLUSH_TIMO () {0x2;}' unless defined(&L2CAP_OPT_FLUSH_TIMO);
    eval 'sub L2CAP_OPT_FLUSH_TIMO_SIZE () {$sizeof{ &uint16_t};}' unless defined(&L2CAP_OPT_FLUSH_TIMO_SIZE);
    eval 'sub L2CAP_OPT_QOS () {0x3;}' unless defined(&L2CAP_OPT_QOS);
    eval 'sub L2CAP_OPT_QOS_SIZE () {$sizeof{ &l2cap_qos_t};}' unless defined(&L2CAP_OPT_QOS_SIZE);
    eval 'sub L2CAP_OPT_RFC () {0x4;}' unless defined(&L2CAP_OPT_RFC);
    eval 'sub L2CAP_OPT_RFC_SIZE () {$sizeof{ &l2cap_rfc_t};}' unless defined(&L2CAP_OPT_RFC_SIZE);
    eval 'sub L2CAP_CONNLESS_MTU () {0x1;}' unless defined(&L2CAP_CONNLESS_MTU);
    eval 'sub L2CAP_EXTENDED_FEATURES () {0x2;}' unless defined(&L2CAP_EXTENDED_FEATURES);
    eval 'sub L2CAP_NOT_SUPPORTED () {0x1;}' unless defined(&L2CAP_NOT_SUPPORTED);
    eval 'sub L2CAP_QOS_NO_TRAFFIC () {0x;}' unless defined(&L2CAP_QOS_NO_TRAFFIC);
    eval 'sub L2CAP_QOS_BEST_EFFORT () {0x1;}' unless defined(&L2CAP_QOS_BEST_EFFORT);
    eval 'sub L2CAP_QOS_GUARANTEED () {0x2;}' unless defined(&L2CAP_QOS_GUARANTEED);
    eval 'sub L2CAP_RFC_BASIC () {0x;}' unless defined(&L2CAP_RFC_BASIC);
    eval 'sub L2CAP_RFC_RETRANSMIT () {0x1;}' unless defined(&L2CAP_RFC_RETRANSMIT);
    eval 'sub L2CAP_RFC_FLOW () {0x2;}' unless defined(&L2CAP_RFC_FLOW);
    eval 'sub L2CAP_CLT_MTU_MAXIMUM () {( &L2CAP_MTU_MAXIMUM - $sizeof{ &l2cap_clt_hdr_t});}' unless defined(&L2CAP_CLT_MTU_MAXIMUM);
    eval 'sub L2CAP_COMMAND_REJ () {0x1;}' unless defined(&L2CAP_COMMAND_REJ);
    eval 'sub L2CAP_CONNECT_REQ () {0x2;}' unless defined(&L2CAP_CONNECT_REQ);
    eval 'sub L2CAP_CONNECT_RSP () {0x3;}' unless defined(&L2CAP_CONNECT_RSP);
    eval 'sub L2CAP_CONFIG_REQ () {0x4;}' unless defined(&L2CAP_CONFIG_REQ);
    eval 'sub L2CAP_CONFIG_RSP () {0x5;}' unless defined(&L2CAP_CONFIG_RSP);
    eval 'sub L2CAP_DISCONNECT_REQ () {0x6;}' unless defined(&L2CAP_DISCONNECT_REQ);
    eval 'sub L2CAP_DISCONNECT_RSP () {0x7;}' unless defined(&L2CAP_DISCONNECT_RSP);
    eval 'sub L2CAP_ECHO_REQ () {0x8;}' unless defined(&L2CAP_ECHO_REQ);
    eval 'sub L2CAP_ECHO_RSP () {0x9;}' unless defined(&L2CAP_ECHO_RSP);
    eval 'sub L2CAP_MAX_ECHO_SIZE () {( &L2CAP_MTU_MAXIMUM - $sizeof{ &l2cap_cmd_hdr_t});}' unless defined(&L2CAP_MAX_ECHO_SIZE);
    eval 'sub L2CAP_INFO_REQ () {0xa;}' unless defined(&L2CAP_INFO_REQ);
    eval 'sub L2CAP_INFO_RSP () {0xb;}' unless defined(&L2CAP_INFO_RSP);
    eval 'sub SO_L2CAP_IMTU () {1;}' unless defined(&SO_L2CAP_IMTU);
    eval 'sub SO_L2CAP_OMTU () {2;}' unless defined(&SO_L2CAP_OMTU);
    eval 'sub SO_L2CAP_IQOS () {3;}' unless defined(&SO_L2CAP_IQOS);
    eval 'sub SO_L2CAP_OQOS () {4;}' unless defined(&SO_L2CAP_OQOS);
    eval 'sub SO_L2CAP_FLUSH () {5;}' unless defined(&SO_L2CAP_FLUSH);
    eval 'sub SO_L2CAP_LM () {6;}' unless defined(&SO_L2CAP_LM);
    eval 'sub L2CAP_LM_AUTH () {(1<<0);}' unless defined(&L2CAP_LM_AUTH);
    eval 'sub L2CAP_LM_ENCRYPT () {(1<<1);}' unless defined(&L2CAP_LM_ENCRYPT);
    eval 'sub L2CAP_LM_SECURE () {(1<<2);}' unless defined(&L2CAP_LM_SECURE);
    if(defined(&_KERNEL)) {
	require 'net/if.ph';
	eval 'sub L2CAP_CLOSED () {0;}' unless defined(&L2CAP_CLOSED);
	eval 'sub L2CAP_WAIT_SEND_CONNECT_REQ () {1;}' unless defined(&L2CAP_WAIT_SEND_CONNECT_REQ);
	eval 'sub L2CAP_WAIT_RECV_CONNECT_RSP () {2;}' unless defined(&L2CAP_WAIT_RECV_CONNECT_RSP);
	eval 'sub L2CAP_WAIT_SEND_CONNECT_RSP () {3;}' unless defined(&L2CAP_WAIT_SEND_CONNECT_RSP);
	eval 'sub L2CAP_WAIT_CONFIG () {4;}' unless defined(&L2CAP_WAIT_CONFIG);
	eval 'sub L2CAP_OPEN () {5;}' unless defined(&L2CAP_OPEN);
	eval 'sub L2CAP_WAIT_DISCONNECT () {6;}' unless defined(&L2CAP_WAIT_DISCONNECT);
	eval 'sub L2CAP_SHUTDOWN () {(1<<0);}' unless defined(&L2CAP_SHUTDOWN);
	eval 'sub L2CAP_WAIT_CONFIG_REQ () {(1<<1);}' unless defined(&L2CAP_WAIT_CONFIG_REQ);
	eval 'sub L2CAP_WAIT_CONFIG_RSP () {(1<<2);}' unless defined(&L2CAP_WAIT_CONFIG_RSP);
    }
}
1;
