require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LMC_MTU)) {
    sub LMC_MTU () {	1500;}
}
unless(defined(&PPP_HEADER_LEN)) {
    sub PPP_HEADER_LEN () {	4;}
}
unless(defined(&BIG_PACKET)) {
    sub BIG_PACKET () {	1;}
}
unless(defined(&LMC_DATA_PER_DESC)) {
    sub LMC_DATA_PER_DESC () {	2032;}
}
if(0) {
    eval 'sub LMC_DEBUG () {1;}' unless defined(&LMC_DEBUG);
    eval("sub LMC_21040_GENERIC () { 0; }") unless defined(&LMC_21040_GENERIC);
    eval("sub LMC_21140_ISV () { 1; }") unless defined(&LMC_21140_ISV);
    eval("sub LMC_21142_ISV () { 2; }") unless defined(&LMC_21142_ISV);
    eval("sub LMC_21143_ISV () { 3; }") unless defined(&LMC_21143_ISV);
    eval("sub LMC_21140_DEC_EB () { 4; }") unless defined(&LMC_21140_DEC_EB);
    eval("sub LMC_21140_MII () { 5; }") unless defined(&LMC_21140_MII);
    eval("sub LMC_21140_DEC_DE500 () { 6; }") unless defined(&LMC_21140_DEC_DE500);
    eval("sub LMC_21140_SMC_9332 () { 7; }") unless defined(&LMC_21140_SMC_9332);
    eval("sub LMC_21140_COGENT_EM100 () { 8; }") unless defined(&LMC_21140_COGENT_EM100);
    eval("sub LMC_21140_ZNYX_ZX34X () { 9; }") unless defined(&LMC_21140_ZNYX_ZX34X);
    eval("sub LMC_21140_ASANTE () { 10; }") unless defined(&LMC_21140_ASANTE);
    eval("sub LMC_21140_EN1207 () { 11; }") unless defined(&LMC_21140_EN1207);
    eval("sub LMC_21041_GENERIC () { 12; }") unless defined(&LMC_21041_GENERIC);
    eval("sub LMC_MEDIAPOLL_TIMER () { 0; }") unless defined(&LMC_MEDIAPOLL_TIMER);
    eval("sub LMC_MEDIAPOLL_FASTTIMER () { 1; }") unless defined(&LMC_MEDIAPOLL_FASTTIMER);
    eval("sub LMC_MEDIAPOLL_LINKFAIL () { 2; }") unless defined(&LMC_MEDIAPOLL_LINKFAIL);
    eval("sub LMC_MEDIAPOLL_LINKPASS () { 3; }") unless defined(&LMC_MEDIAPOLL_LINKPASS);
    eval("sub LMC_MEDIAPOLL_START () { 4; }") unless defined(&LMC_MEDIAPOLL_START);
    eval("sub LMC_MEDIAPOLL_TXPROBE_OK () { 5; }") unless defined(&LMC_MEDIAPOLL_TXPROBE_OK);
    eval("sub LMC_MEDIAPOLL_TXPROBE_FAILED () { 6; }") unless defined(&LMC_MEDIAPOLL_TXPROBE_FAILED);
    eval("sub LMC_MEDIAPOLL_MAX () { 7; }") unless defined(&LMC_MEDIAPOLL_MAX);
    eval 'sub DP {
        my($x) = @_;
	    eval q( &printf $x);
    }' unless defined(&DP);
} else {
    eval 'sub DP {
        my($x) = @_;
	    eval q();
    }' unless defined(&DP);
}
unless(defined(&TULIP_DSTS_RxMIIERR)) {
    eval 'sub TULIP_DSTS_RxMIIERR () {0x8;}' unless defined(&TULIP_DSTS_RxMIIERR);
}
unless(defined(&LMC_DSTS_ERRSUM)) {
    sub LMC_DSTS_ERRSUM () {	( &TULIP_DSTS_RxMIIERR);}
}
unless(defined(&PCI_CFID)) {
    sub PCI_CFID () {	0x;}
}
unless(defined(&PCI_CFCS)) {
    sub PCI_CFCS () {	0x4;}
}
unless(defined(&PCI_CFRV)) {
    sub PCI_CFRV () {	0x8;}
}
unless(defined(&PCI_CFLT)) {
    sub PCI_CFLT () {	0xc;}
}
unless(defined(&PCI_CBIO)) {
    sub PCI_CBIO () {	0x10;}
}
unless(defined(&PCI_CBMA)) {
    sub PCI_CBMA () {	0x14;}
}
unless(defined(&PCI_SSID)) {
    sub PCI_SSID () {	0x2c;}
}
unless(defined(&PCI_CFIT)) {
    sub PCI_CFIT () {	0x3c;}
}
unless(defined(&PCI_CFDA)) {
    sub PCI_CFDA () {	0x40;}
}
unless(defined(&LMC_HZ)) {
    sub LMC_HZ () {	10;}
}
unless(defined(&TULIP_GP_PINSET)) {
    eval 'sub TULIP_GP_PINSET () {0x100;}' unless defined(&TULIP_GP_PINSET);
}
unless(defined(&TULIP_BUSMODE_READMULTIPLE)) {
    eval 'sub TULIP_BUSMODE_READMULTIPLE () {0x200000;}' unless defined(&TULIP_BUSMODE_READMULTIPLE);
}
unless(defined(&LMC_CSR_READ)) {
    sub LMC_CSR_READ {
	my($sc, $csr) = @_;
	eval q( &bus_space_read_4(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr})));
    }
}
unless(defined(&LMC_CSR_WRITE)) {
    sub LMC_CSR_WRITE {
	my($sc, $csr, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr}), ($val)));
    }
}
unless(defined(&LMC_CSR_READBYTE)) {
    sub LMC_CSR_READBYTE {
	my($sc, $csr) = @_;
	eval q( &bus_space_read_1(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr})));
    }
}
unless(defined(&LMC_CSR_WRITEBYTE)) {
    sub LMC_CSR_WRITEBYTE {
	my($sc, $csr, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr}), ($val)));
    }
}
unless(defined(&LMC_PCI_CSRSIZE)) {
    sub LMC_PCI_CSRSIZE () {	8;}
}
unless(defined(&LMC_PCI_CSROFFSET)) {
    sub LMC_PCI_CSROFFSET () {	0;}
}
unless(defined(&csr_enetrom)) {
    sub csr_enetrom () {	 &csr_9;}
}
unless(defined(&csr_reserved)) {
    sub csr_reserved () {	 &csr_10;}
}
unless(defined(&csr_full_duplex)) {
    sub csr_full_duplex () {	 &csr_11;}
}
unless(defined(&csr_bootrom)) {
    sub csr_bootrom () {	 &csr_10;}
}
unless(defined(&csr_gp)) {
    sub csr_gp () {	 &csr_12;}
}
unless(defined(&csr_watchdog)) {
    sub csr_watchdog () {	 &csr_15;}
}
unless(defined(&csr_gp_timer)) {
    sub csr_gp_timer () {	 &csr_11;}
}
unless(defined(&csr_srom_mii)) {
    sub csr_srom_mii () {	 &csr_9;}
}
unless(defined(&csr_sia_status)) {
    sub csr_sia_status () {	 &csr_12;}
}
unless(defined(&csr_sia_connectivity)) {
    sub csr_sia_connectivity () {	 &csr_13;}
}
unless(defined(&csr_sia_tx_rx)) {
    sub csr_sia_tx_rx () {	 &csr_14;}
}
unless(defined(&csr_sia_general)) {
    sub csr_sia_general () {	 &csr_15;}
}
unless(defined(&LMC_RXDESCS)) {
    sub LMC_RXDESCS () {	48;}
}
unless(defined(&LMC_TXDESCS)) {
    sub LMC_TXDESCS () {	128;}
}
unless(defined(&LMC_RXQ_TARGET)) {
    sub LMC_RXQ_TARGET () {	32;}
}
if((defined(&LMC_RXQ_TARGET) ? &LMC_RXQ_TARGET : undef) >= (defined(&LMC_RXDESCS) ? &LMC_RXDESCS : undef)) {
    die("LMC_RXQ_TARGET\ must\ be\ less\ than\ LMC_RXDESCS");
}
unless(defined(&LMC_RX_BUFLEN)) {
    sub LMC_RX_BUFLEN () {	(( &MCLBYTES < 2048?  &MCLBYTES : 2048) - 16);}
}
unless(defined(&LMC_LINK_UP)) {
    sub LMC_LINK_UP () {	1;}
}
unless(defined(&LMC_LINK_DOWN)) {
    sub LMC_LINK_DOWN () {	0;}
}
eval("sub LMC_21140 () { 0; }") unless defined(&LMC_21140);
eval("sub LMC_21140A () { 1; }") unless defined(&LMC_21140A);
eval("sub LMC_CHIPID_UNKNOWN () { 2; }") unless defined(&LMC_CHIPID_UNKNOWN);
unless(defined(&LMC_BIT)) {
    sub LMC_BIT {
	my($b) = @_;
	eval q((1 << (($b))));
    }
}
unless(defined(&lmc_if)) {
    sub lmc_if () {	 ($lmc_sppp->{pp_if});}
}
if(defined( &LMC_DEBUG)) {
}
unless(defined(&LMC_IFUP)) {
    sub LMC_IFUP () {	0x1;}
}
unless(defined(&LMC_00000002)) {
    sub LMC_00000002 () {	0x2;}
}
unless(defined(&LMC_00000004)) {
    sub LMC_00000004 () {	0x4;}
}
unless(defined(&LMC_00000008)) {
    sub LMC_00000008 () {	0x8;}
}
unless(defined(&LMC_00000010)) {
    sub LMC_00000010 () {	0x10;}
}
unless(defined(&LMC_MODEMOK)) {
    sub LMC_MODEMOK () {	0x20;}
}
unless(defined(&LMC_00000040)) {
    sub LMC_00000040 () {	0x40;}
}
unless(defined(&LMC_00000080)) {
    sub LMC_00000080 () {	0x80;}
}
unless(defined(&LMC_RXACT)) {
    sub LMC_RXACT () {	0x100;}
}
unless(defined(&LMC_INRESET)) {
    sub LMC_INRESET () {	0x200;}
}
unless(defined(&LMC_NEEDRESET)) {
    sub LMC_NEEDRESET () {	0x400;}
}
unless(defined(&LMC_00000800)) {
    sub LMC_00000800 () {	0x800;}
}
unless(defined(&LMC_00001000)) {
    sub LMC_00001000 () {	0x1000;}
}
unless(defined(&LMC_00002000)) {
    sub LMC_00002000 () {	0x2000;}
}
unless(defined(&LMC_WANTTXSTART)) {
    sub LMC_WANTTXSTART () {	0x4000;}
}
unless(defined(&LMC_NEWTXTHRESH)) {
    sub LMC_NEWTXTHRESH () {	0x8000;}
}
unless(defined(&LMC_NOAUTOSENSE)) {
    sub LMC_NOAUTOSENSE () {	0x10000;}
}
unless(defined(&LMC_PRINTLINKUP)) {
    sub LMC_PRINTLINKUP () {	0x20000;}
}
unless(defined(&LMC_LINKUP)) {
    sub LMC_LINKUP () {	0x40000;}
}
unless(defined(&LMC_RXBUFSLOW)) {
    sub LMC_RXBUFSLOW () {	0x80000;}
}
unless(defined(&LMC_NOMESSAGES)) {
    sub LMC_NOMESSAGES () {	0x100000;}
}
unless(defined(&LMC_SYSTEMERROR)) {
    sub LMC_SYSTEMERROR () {	0x200000;}
}
unless(defined(&LMC_TIMEOUTPENDING)) {
    sub LMC_TIMEOUTPENDING () {	0x400000;}
}
unless(defined(&LMC_00800000)) {
    sub LMC_00800000 () {	0x800000;}
}
unless(defined(&LMC_01000000)) {
    sub LMC_01000000 () {	0x1000000;}
}
unless(defined(&LMC_02000000)) {
    sub LMC_02000000 () {	0x2000000;}
}
unless(defined(&LMC_RXIGNORE)) {
    sub LMC_RXIGNORE () {	0x4000000;}
}
unless(defined(&LMC_08000000)) {
    sub LMC_08000000 () {	0x8000000;}
}
unless(defined(&LMC_10000000)) {
    sub LMC_10000000 () {	0x10000000;}
}
unless(defined(&LMC_20000000)) {
    sub LMC_20000000 () {	0x20000000;}
}
unless(defined(&LMC_40000000)) {
    sub LMC_40000000 () {	0x40000000;}
}
unless(defined(&LMC_80000000)) {
    sub LMC_80000000 () {	0x80000000;}
}
unless(defined(&LMC_HAVE_GPR)) {
    sub LMC_HAVE_GPR () {	0x1;}
}
unless(defined(&LMC_HAVE_RXBADOVRFLW)) {
    sub LMC_HAVE_RXBADOVRFLW () {	0x2;}
}
unless(defined(&LMC_HAVE_POWERMGMT)) {
    sub LMC_HAVE_POWERMGMT () {	0x4;}
}
unless(defined(&LMC_HAVE_MII)) {
    sub LMC_HAVE_MII () {	0x8;}
}
unless(defined(&LMC_HAVE_SIANWAY)) {
    sub LMC_HAVE_SIANWAY () {	0x10;}
}
unless(defined(&LMC_HAVE_DUALSENSE)) {
    sub LMC_HAVE_DUALSENSE () {	0x20;}
}
unless(defined(&LMC_HAVE_SIAGP)) {
    sub LMC_HAVE_SIAGP () {	0x40;}
}
unless(defined(&LMC_HAVE_BROKEN_HASH)) {
    sub LMC_HAVE_BROKEN_HASH () {	0x80;}
}
unless(defined(&LMC_HAVE_ISVSROM)) {
    sub LMC_HAVE_ISVSROM () {	0x100;}
}
unless(defined(&LMC_HAVE_BASEROM)) {
    sub LMC_HAVE_BASEROM () {	0x200;}
}
unless(defined(&LMC_HAVE_SLAVEDROM)) {
    sub LMC_HAVE_SLAVEDROM () {	0x400;}
}
unless(defined(&LMC_HAVE_SLAVEDINTR)) {
    sub LMC_HAVE_SLAVEDINTR () {	0x800;}
}
unless(defined(&LMC_HAVE_SHAREDINTR)) {
    sub LMC_HAVE_SHAREDINTR () {	0x1000;}
}
unless(defined(&LMC_HAVE_OKROM)) {
    sub LMC_HAVE_OKROM () {	0x2000;}
}
unless(defined(&LMC_HAVE_NOMEDIA)) {
    sub LMC_HAVE_NOMEDIA () {	0x4000;}
}
unless(defined(&LMC_HAVE_STOREFWD)) {
    sub LMC_HAVE_STOREFWD () {	0x8000;}
}
unless(defined(&LMC_HAVE_SIA100)) {
    sub LMC_HAVE_SIA100 () {	0x10000;}
}
if(0) {
}
unless(defined(&LMC_MAX_DEVICES)) {
    sub LMC_MAX_DEVICES () {	32;}
}
unless(defined(&LMC_RXDESC_PRESYNC)) {
    sub LMC_RXDESC_PRESYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &lmc_dmatag, -> &lmc_rxdescmap, $di - ($sc)-> &lmc_rxdescs, ($s),  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&LMC_RXDESC_POSTSYNC)) {
    sub LMC_RXDESC_POSTSYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &lmc_dmatag, -> &lmc_rxdescmap, $di - ($sc)-> &lmc_rxdescs, ($s),  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&LMC_RXMAP_PRESYNC)) {
    sub LMC_RXMAP_PRESYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &lmc_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&LMC_RXMAP_POSTSYNC)) {
    sub LMC_RXMAP_POSTSYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &lmc_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&LMC_RXMAP_CREATE)) {
    sub LMC_RXMAP_CREATE {
	my($sc, $mapp) = @_;
	eval q( &bus_dmamap_create(($sc)-> &lmc_dmatag,  &LMC_RX_BUFLEN, 2,  &LMC_DATA_PER_DESC, 0,  &BUS_DMA_NOWAIT| &BUS_DMA_ALLOCNOW, ($mapp)));
    }
}
unless(defined(&LMC_TXDESC_PRESYNC)) {
    sub LMC_TXDESC_PRESYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &lmc_dmatag, -> &lmc_txdescmap, $di - ($sc)-> &lmc_txdescs, ($s),  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&LMC_TXDESC_POSTSYNC)) {
    sub LMC_TXDESC_POSTSYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &lmc_dmatag, -> &lmc_txdescmap, $di - ($sc)-> &lmc_txdescs, ($s),  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&LMC_TXMAP_PRESYNC)) {
    sub LMC_TXMAP_PRESYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &lmc_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&LMC_TXMAP_POSTSYNC)) {
    sub LMC_TXMAP_POSTSYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &lmc_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&LMC_TXMAP_CREATE)) {
    sub LMC_TXMAP_CREATE {
	my($sc, $mapp) = @_;
	eval q( &bus_dmamap_create(($sc)-> &lmc_dmatag,  &LMC_DATA_PER_DESC,  &LMC_MAX_TXSEG,  &LMC_DATA_PER_DESC, 0,  &BUS_DMA_NOWAIT, ($mapp)));
    }
}
unless(defined(&LMC_UNIT_TO_SOFTC)) {
    sub LMC_UNIT_TO_SOFTC {
	my($unit) = @_;
	eval q((( &lmc_softc_t *)  ($lmc_cd->{cd_devs[$unit]})));
    }
}
unless(defined(&LMC_IFP_TO_SOFTC)) {
    sub LMC_IFP_TO_SOFTC {
	my($ifp) = @_;
	eval q((( &lmc_softc_t *)(($ifp)-> &if_softc)));
    }
}
unless(defined(&lmc_unit)) {
    sub lmc_unit () {	 ($lmc_dev->{dv_unit});}
}
unless(defined(&lmc_xname)) {
    sub lmc_xname () {	 ($lmc_if->{if_xname});}
}
unless(defined(&LMC_RAISESPL)) {
    sub LMC_RAISESPL () {
	eval q( &splnet());
    }
}
unless(defined(&LMC_RAISESOFTSPL)) {
    sub LMC_RAISESOFTSPL () {
	eval q( &splsoftnet());
    }
}
unless(defined(&LMC_RESTORESPL)) {
    sub LMC_RESTORESPL {
	my($s) = @_;
	eval q( &splx($s));
    }
}
unless(defined(&loudprintf)) {
    sub loudprintf () {	 &printf;}
}
unless(defined(&LMC_PRINTF_FMT)) {
    sub LMC_PRINTF_FMT () {	"%s";}
}
unless(defined(&LMC_PRINTF_ARGS)) {
    sub LMC_PRINTF_ARGS () {	 ($sc->{lmc_xname});}
}
unless(defined(&LMC_PRINTF_FMT)) {
    eval 'sub LMC_PRINTF_FMT () {"%s%d";}' unless defined(&LMC_PRINTF_FMT);
}
unless(defined(&LMC_PRINTF_ARGS)) {
    eval 'sub LMC_PRINTF_ARGS () { ($sc->{lmc_name}),  ($sc->{lmc_unit});}' unless defined(&LMC_PRINTF_ARGS);
}
unless(defined(&LMC_BURSTSIZE)) {
    eval 'sub LMC_BURSTSIZE {
        my($unit) = @_;
	    eval q(3);
    }' unless defined(&LMC_BURSTSIZE);
}
unless(defined(&lmc_unit)) {
    eval 'sub lmc_unit () { ($lmc_sppp->{pp_if}->{if_unit});}' unless defined(&lmc_unit);
}
unless(defined(&lmc_name)) {
    eval 'sub lmc_name () { ($lmc_sppp->{pp_if}->{if_name});}' unless defined(&lmc_name);
}
if(!defined( &lmc_bpf)) {
    eval 'sub lmc_bpf () { ($lmc_sppp->{pp_if}->{if_bpf});}' unless defined(&lmc_bpf);
}
unless(defined(&LMC_RAISESPL)) {
    eval 'sub LMC_RAISESPL () {
        eval q( &splnet());
    }' unless defined(&LMC_RAISESPL);
}
unless(defined(&LMC_RAISESOFTSPL)) {
    eval 'sub LMC_RAISESOFTSPL () {
        eval q( &splnet());
    }' unless defined(&LMC_RAISESOFTSPL);
}
unless(defined(&TULUP_RESTORESPL)) {
    eval 'sub LMC_RESTORESPL {
        my($s) = @_;
	    eval q( &splx($s));
    }' unless defined(&LMC_RESTORESPL);
}
if(!defined( &LMC_BPF_MTAP)  && (defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
    eval 'sub LMC_BPF_MTAP {
        my($sc, $m, $d) = @_;
	    eval q( &bpf_mtap(($sc)-> &lmc_bpf, $m, $d));
    }' unless defined(&LMC_BPF_MTAP);
    eval 'sub LMC_BPF_TAP {
        my($sc, $p, $l, $d) = @_;
	    eval q( &bpf_tap(($sc)-> &lmc_bpf, $p, $l, $d));
    }' unless defined(&LMC_BPF_TAP);
    eval 'sub LMC_BPF_ATTACH {
        my($sc) = @_;
	    eval q( &bpfattach(($sc)-> &lmc_bpf, ($sc)-> ($lmc_sppp->{pp_if}),  &DLT_PPP,  &PPP_HEADER_LEN));
    }' unless defined(&LMC_BPF_ATTACH);
}
if(!defined( &LMC_EADDR_FMT)) {
    eval 'sub LMC_EADDR_FMT () {"%s";}' unless defined(&LMC_EADDR_FMT);
    eval 'sub LMC_EADDR_ARGS {
        my($addr) = @_;
	    eval q( &ether_sprintf($addr));
    }' unless defined(&LMC_EADDR_ARGS);
}
unless(defined(&LMC_CRC32_POLY)) {
    sub LMC_CRC32_POLY () {	0xedb88320;}
}
unless(defined(&LMC_MAX_TXSEG)) {
    sub LMC_MAX_TXSEG () {	30;}
}
unless(defined(&LMC_ADDREQUAL)) {
    sub LMC_ADDREQUAL {
	my($a1, $a2) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == (( &u_int16_t *)$a2)[0]  && (( &u_int16_t *)$a1)[1] == (( &u_int16_t *)$a2)[1]  && (( &u_int16_t *)$a1)[2] == (( &u_int16_t *)$a2)[2]));
    }
}
unless(defined(&LMC_ADDRBRDCST)) {
    sub LMC_ADDRBRDCST {
	my($a1) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == 0xffff  && (( &u_int16_t *)$a1)[1] == 0xffff  && (( &u_int16_t *)$a1)[2] == 0xffff));
    }
}
unless(defined(&LMC_GETCTX)) {
    sub LMC_GETCTX {
	my($m, $t) = @_;
	eval q((($t) ($m)-> ($m_pkthdr->{rcvif}) + 0));
    }
}
unless(defined(&LMC_SETCTX)) {
    sub LMC_SETCTX {
	my($m, $c) = @_;
	eval q((( &void) (($m)-> ($m_pkthdr->{r$cvif}) = ( &void *) ($c))));
    }
}
1;
