#!/usr/bin/env perl
#
# $Id: uninstall-win32.pl 15131 2009-09-05 14:42:48Z trzeciak $
#
# Copyright 2008 Norbert Preining
#
# GUI for tlmgr
#

my $Master;

BEGIN {
  $^W = 1;
  $Master = `%COMSPEC% /c kpsewhich -var-value=SELFAUTOPARENT`;
  chomp($Master);
  unshift (@INC, "$Master/tlpkg");
}

use TeXLive::TLWinGoo;
use TeXLive::TLPDB;
use TeXLive::TLPOBJ;
use TeXLive::TLConfig;
use TeXLive::TLUtils;
use Tk;
use Tk::Dialog;

my $mw = MainWindow->new(-title => "remove tlmgr 2009");

my $lab = $mw->Label(-justify    => 'left',
                     -text => "Do you really want to remove TeX Live 2009?");

$lab->pack(-padx => "10m", -pady => "5m");

my $f = $mw->Frame;
$f->pack(-padx => "10m", -pady => "5m");

my $ok = $f->Button(-text => "Ok",
                    -command => sub { $mw->destroy; doit(); exit(0); });
my $cancel = $f->Button(-text => "Cancel",
                        -command => sub { $mw->destroy; exit(1); });

$ok->pack(-side => 'left', -padx => "3m");
$cancel->pack(-side => 'left' , -padx => "3m");

sub doit {
  # first we remove the whole bunch of shortcuts and menu entries
  # by calling all the post action codes for the installed packages
  my $localtlpdb = TeXLive::TLPDB->new ("root" => $Master);
  if (!defined($localtlpdb)) {
    tlwarn("Cannot load the TLPDB from $Master, are you sure there is an installation?\n");
  } else {
    # set the mode for windows uninstall according to the setting in
    # tlpdb
    if (TeXLive::TLWinGoo::admin() && !$localtlpdb->option("w32_multi_user")) {
      non_admin();
    }
    for my $pkg ($localtlpdb->list_packages) {
      &TeXLive::TLUtils::do_postaction("remove", $localtlpdb->get_package($pkg),
                                   $localtlpdb->option("file_assocs"),
                                   $localtlpdb->option("desktop_integration"),
                                   $localtlpdb->option("post_code"));
    }
  }
  my $menupath = &TeXLive::TLWinGoo::menu_path();
  $menupath =~ s!/!\\!g;
  `rmdir /q "$menupath\\$TeXLive::TLConfig::WindowsMainMenuName" 2>nul`;

  # remove bindir from PATH settings
  TeXLive::TLUtils::w32_remove_from_path("$Master/bin/win32", 
    $localtlpdb->option("w32_multi_user"));

  # unsetenv_reg("TEXBINDIR");
  # from_dvd case:
  # unsetenv_reg("TEXMFSYSVAR");
  unsetenv_reg("TEXMFCNF");
  unregister_uninstaller($localtlpdb->option("w32_multi_user"));
  exit if is_vista();
  broadcast_env();
  update_assocs();
}

Tk::MainLoop();

__END__


### Local Variables:
### perl-indent-level: 2
### tab-width: 2
### indent-tabs-mode: nil
### End:
# vim:set tabstop=2 expandtab: #
