/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP;

import gnu.CORBA.CDR.BigEndianInputStream;
import gnu.CORBA.CDR.BigEndianOutputStream;
import gnu.CORBA.CDR.LittleEndianInputStream;
import gnu.CORBA.CDR.LittleEndianOutputStream;
import gnu.CORBA.GIOP.ErrorMessage;
import gnu.CORBA.GIOP.v1_0.CancelHeader;
import gnu.CORBA.GIOP.v1_0.RequestHeader;
import gnu.CORBA.GIOP.v1_2.ReplyHeader;
import gnu.CORBA.Version;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IDLEntity;

public class MessageHeader
implements IDLEntity {
    private static final long serialVersionUID = 1L;
    public static final byte REQUEST = 0;
    public static final byte REPLY = 1;
    public static final byte CANCEL_REQUEST = 2;
    public static final byte LOCATE_REQUEST = 3;
    public static final byte LOCATE_REPLY = 4;
    public static final byte CLOSE_CONNECTION = 5;
    public static final byte MESSAGE_ERROR = 6;
    public static final byte FRAGMENT = 7;
    public static final byte[] MAGIC = new byte[]{71, 73, 79, 80};
    protected static String[] types = new String[]{"Request", "Reply", "Cancel", "Locate request", "Locate reply", "Close connection", "Error", "Fragment"};
    public Version version;
    public byte flags;
    public byte message_type;
    public int message_size;

    private /* synthetic */ void finit$() {
        this.flags = 0;
        this.message_type = 0;
        this.message_size = 0;
    }

    public MessageHeader() {
        this.finit$();
        this.version = new Version(1, 0);
    }

    public MessageHeader(int n, int n2) {
        this.finit$();
        this.version = new Version(n, n2);
    }

    public boolean isBigEndian() {
        return (this.flags & 1) == 0;
    }

    public boolean moreFragmentsFollow() {
        return (this.flags & 2) != 0;
    }

    public void setBigEndian(boolean bl) {
        this.flags = bl ? (byte)(this.flags & 0xFFFFFFFE) : (byte)(this.flags | 1);
    }

    public int getHeaderSize() {
        return 12;
    }

    public String getTypeString(int n) {
        try {
            return types[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "unknown type (" + n + ")";
        }
    }

    public gnu.CORBA.GIOP.ReplyHeader create_reply_header() {
        if (this.version.since_inclusive(1, 2)) {
            return new ReplyHeader();
        }
        return new gnu.CORBA.GIOP.v1_0.ReplyHeader();
    }

    public gnu.CORBA.GIOP.RequestHeader create_request_header() {
        if (this.version.since_inclusive(1, 2)) {
            return new gnu.CORBA.GIOP.v1_2.RequestHeader();
        }
        return new RequestHeader();
    }

    public gnu.CORBA.GIOP.CancelHeader create_cancel_header() {
        return new CancelHeader();
    }

    public ErrorMessage create_error_message() {
        return new ErrorMessage(this.version);
    }

    public void read(InputStream inputStream) throws MARSHAL, EOFException {
        try {
            byte[] byArray = new byte[MAGIC.length];
            int n = inputStream.read(byArray);
            if (!Arrays.equals(byArray, MAGIC)) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                if (n == -1) {
                    stringBuffer.append("Immediate EOF");
                    n2 = 1195573251;
                } else {
                    n2 = 1195573249;
                    stringBuffer.append(n + " bytes: ");
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
                        stringBuffer.append(' ');
                    }
                }
                MARSHAL mARSHAL = new MARSHAL("Not a GIOP message: " + stringBuffer);
                mARSHAL.minor = n2;
                throw mARSHAL;
            }
            this.version = Version.read_version(inputStream);
            this.flags = (byte)inputStream.read();
            FilterInputStream filterInputStream = this.isBigEndian() ? new BigEndianInputStream(inputStream) : new LittleEndianInputStream(inputStream);
            this.message_type = (byte)filterInputStream.read();
            this.message_size = filterInputStream.readInt();
        }
        catch (IOException iOException) {
            MARSHAL mARSHAL = new MARSHAL();
            mARSHAL.minor = 1195573250;
            mARSHAL.initCause(iOException);
            throw mARSHAL;
        }
    }

    public String toString() {
        return "GIOP " + this.version + ", " + (this.isBigEndian() ? "Big" : "Little") + " endian, " + this.getTypeString(this.message_type) + ", " + this.message_size + " bytes. ";
    }

    public void write(OutputStream outputStream) {
        try {
            FilterOutputStream filterOutputStream = this.isBigEndian() ? new BigEndianOutputStream(outputStream) : new LittleEndianOutputStream(outputStream);
            filterOutputStream.write(MAGIC);
            this.version.write(filterOutputStream);
            filterOutputStream.write(this.flags);
            filterOutputStream.write(this.message_type);
            filterOutputStream.writeInt(this.message_size);
        }
        catch (IOException iOException) {
            MARSHAL mARSHAL = new MARSHAL(iOException.getMessage());
            mARSHAL.minor = 1195573250;
            mARSHAL.initCause(iOException);
            throw mARSHAL;
        }
    }

    public byte[] readMessage(InputStream inputStream, Socket socket, int n, int n2) {
        try {
            byte[] byArray = new byte[this.message_size];
            int n3 = 0;
            if (socket != null) {
                socket.setSoTimeout(n);
            }
            while (n3 < byArray.length) {
                n3 += inputStream.read(byArray, n3, byArray.length - n3);
            }
            if (socket != null) {
                socket.setSoTimeout(n2);
            }
            if (this.moreFragmentsFollow()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * byArray.length);
                byteArrayOutputStream.write(byArray);
                if (byArray.length < 10) {
                    byArray = new byte[1024];
                }
                MessageHeader messageHeader = new MessageHeader();
                do {
                    messageHeader.read(inputStream);
                    n3 = 0;
                    while (n3 < messageHeader.message_size) {
                        int n4 = inputStream.read(byArray, 0, messageHeader.message_size - n3);
                        if (n3 == 0 && socket != null) {
                            socket.setSoTimeout(n);
                        }
                        if (n3 == 0 && this.version.since_inclusive(1, 2)) {
                            byteArrayOutputStream.write(byArray, 4, n4 - 4);
                        } else {
                            byteArrayOutputStream.write(byArray, 0, n4);
                        }
                        n3 = n4;
                    }
                    if (socket == null) continue;
                    socket.setSoTimeout(n2);
                } while (messageHeader.moreFragmentsFollow());
                return byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException iOException) {
            MARSHAL mARSHAL = new MARSHAL("Unable to read the message continuation.");
            mARSHAL.minor = 1195573250;
            mARSHAL.initCause(iOException);
            throw mARSHAL;
        }
    }
}

