'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/smtpd/smtpd.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "smtpd" n 1.4 smtpd "Tcl SMTP Server Package"
.BS
.SH NAME
smtpd \- Tcl SMTP server implementation
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBsmtpd  ?1.4?\fR
.sp
\fB::smtpd::start\fR ?\fImyaddr\fR? ?\fIport\fR?
.sp
\fB::smtpd::stop\fR
.sp
\fB::smptd::configure\fR ?\fIoption\fR \fIvalue\fR? ?\fIoption\fR \fIvalue\fR \fI...\fR?
.sp
\fB::smtpd::cget\fR ?\fIoption\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The \fBsmtpd\fR package provides a simple Tcl-only server library
for the Simple Mail Transfer Protocol as described in
RFC  821 (\fIhttp://www.rfc-editor.org/rfc/rfc821.txt\fR) and
RFC 2821 (\fIhttp://www.rfc-editor.org/rfc/rfc2821.txt\fR).
By default the server will bind to the default network address and the
standard SMTP port (25).
.PP
This package was designed to permit testing of Mail User Agent code
from a developers workstation. \fIIt does not attempt to deliver  mail to your mailbox.\fR Instead users of this package are expected to
write a procedure that will be called when mail arrives. Once this
procedure returns, the server has nothing further to do with the mail.
.SH SECURITY
On Unix platforms binding to the SMTP port requires root privileges. I
would not recommend running any script-based server as root unless
there is some method for dropping root privileges immediately after
the socket is bound. Under Windows platforms, it is not necessary to
have root or administrator privileges to bind low numbered
sockets. However, security on these platforms is weak anyway.
.PP
In short, this code should probably not be used as a permanently
running Mail Transfer Agent on an Internet connected server, even
though we are careful not to evaluate remote user input. There are
many other well tested and security audited programs that can be used
as mail servers for internet connected hosts.
.SH COMMANDS
.TP
\fB::smtpd::start\fR ?\fImyaddr\fR? ?\fIport\fR?
Start the service listening on \fIport\fR or the default port 25. If
\fImyaddr\fR is given as a domain-style name or numerical
dotted-quad IP address then the server socket will be bound to that
network interface. By default the server is bound to all network
interfaces. For example:
.sp
.nf

  set sock [::smtpd::start [info hostname] 0]

.fi
.sp
will bind to the hosts internet interface on the first available port.
.sp
At present the package only supports a single instance of a SMTP
server. This could be changed if required at the cost of making the
package a little more complicated to read. If there is a good reason
for running multiple SMTP services then it will only be necessary to
fix the \fBoptions\fR array and the \fB::smtpd::stopped\fR variable
usage.
.sp
As the server code uses \fBfileevent\fR(n) handlers to process the
input on sockets you will need to run the event loop. This means
either you should be running from within \fBwish\fR(1) or you
should \fBvwait\fR(n) on the \fB::smtpd::stopped\fR variable which is
set when the server is stopped.
.TP
\fB::smtpd::stop\fR
Halt the server and release the listening socket. If the server has
not been started then this command does nothing.
The \fB::smtpd::stopped\fR variable is set for use with
\fBvwait\fR(n).
.sp
It should be noted that stopping the server does not disconnect any
currently active sessions as these are operating over an independent
channel. Only explicitly tracking and closing these sessions, or
exiting the server process will close down all the running
sessions. This is similar to the usual unix daemon practice where the
server performs a \fBfork\fR(2) and the client session continues on
the child process.
.TP
\fB::smptd::configure\fR ?\fIoption\fR \fIvalue\fR? ?\fIoption\fR \fIvalue\fR \fI...\fR?
Set configuration options for the SMTP server. Most values are the
name of a callback procedure to be called at various points in the
SMTP protocol. See the \fBCALLBACKS\fR section for details of the
procedures.
.RS
.TP
\fB-validate_host\fR \fIproc\fR
Callback to authenticate new connections based on the ip-address of
the client.
.TP
\fB-validate_sender\fR \fIproc\fR
Callback to authenticate new connections based on the senders email
address.
.TP
\fB-validate_recipient\fR \fIproc\fR
Callback to validate and authorize a recipient email address
.TP
\fB-deliverMIME\fR \fIproc\fR
Callback used to deliver mail as a mime token created by the tcllib
\fBmime\fR package.
.TP
\fB-deliver\fR \fIproc\fR
Callback used to deliver email. This option has no effect if
the \fB-deliverMIME\fR option has been set.
.RE
.TP
\fB::smtpd::cget\fR ?\fIoption\fR?
If no \fIoption\fR is specified the command will return a list of all
options and their current values. If an option is specified it will
return the value of that option.
.PP
.SH CALLBACKS
.TP
\fBvalidate_host\fR callback
This procedure is called with the clients ip address as soon as a
connection request has been accepted and before any protocol commands
are processed. If you wish to deny access to a specific host then an
error should be returned by this callback. For example:
.sp
.nf

 proc validate_host {ipnum} {
    if {[string match "192.168.1.*" $ipnum]} {
       error "go away!"
    }
 }

.fi
.sp
If access is denied the client will receive a standard message that
includes the text of your error, such as:
.sp
.nf

 550 Access denied: I hate you.

.fi
.sp
As per the SMTP protocol, the connection is not closed but we wait for
the client to send a QUIT command. Any other commands cause a
\fB503 Bad Sequence\fR error.
.TP
\fBvalidate_sender\fR callback
The validate_sender callback is called with the senders mail address
during processing of a MAIL command to allow you to accept or reject
mail based upon the declared sender. To reject mail you should throw
an error. For example, to reject mail from user "denied":
.sp
.nf

 proc validate_sender {address} {
    eval array set addr [mime::parseaddress $address]
    if {[string match "denied" $addr(local)]} {
         error "mailbox $addr(local) denied"
    }
    return
 }

.fi
.sp
The content of any error message will not be passed back to the client.
.TP
\fBvalidate_recipient\fR callback
The validate_recipient callback is similar to the validate_sender
callback and permits you to verify a local mailbox and accept mail for
a local user address during RCPT command handling. To reject mail,
throw an error as above. The error message is ignored.
.TP
\fBdeliverMIME\fR callback
]
The deliverMIME callback is called once a mail message has been
successfully passed to the server. A mime token is constructed from
the sender, recipients and data and the users procedure it called with
this single argument. When the call returns, the mime token is cleaned
up so if the user wishes to preserve the data she must make a copy.
.sp
.nf

 proc deliverMIME {token} {
     set sender [lindex [mime::getheader $token From] 0]
     set recipients [lindex [mime::getheader $token To] 0]
     set mail "From $sender [clock format [clock seconds]]"
     append mail "\\n" [mime::buildmessage $token]
     puts $mail
 }

.fi
.TP
\fBdeliver\fR callback
The deliver callback is called once a mail message has been
successfully passed to the server and there is no -deliverMIME option
set. The procedure is called with the sender, a list of recipients and
the text of the mail as a list of lines. For example:
.sp
.nf

 proc deliver {sender recipients data} {
    set mail "From $sender  [clock format [clock seconds]]"
    append mail "\\n" [join $data "\\n"]
    puts "$mail"
 }

.fi
.sp
Note that the DATA command will return an error if no sender or
recipient has yet been defined.
.PP
.SH VARIABLES
.TP
\fB::smtpd::stopped\fR
This variable is set to \fBtrue\fR during the \fB::smtpd::stop\fR
command to permit the use of the \fBvwait\fR(n) command.
.PP
.SH AUTHOR
Written by Pat Thoyts \fImailto:patthoyts@users.sourceforge.net\fR.
.SH LICENSE
This software is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the file
"\fIlicense.terms\fR" for more details.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIsmtpd\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
rfc 2821, rfc 821, services, smtp, smtpd, socket, vwait
.SH COPYRIGHT
.nf
Copyright (c) Pat Thoyts <patthoyts@users.sourceforge.net>

.fi