'\"
'\" Generated from file '/usr/ports/pobj/tklib-0.5/tklib-0.5/modules/tkpiechart/pie.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2004 Jean-Luc Fontaine <jfontain@free.fr>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pie" n 6.6 tkpiechart "tkpiechart pie class"
.BS
.SH NAME
pie \- 2D or 3D pie chart object in a canvas
.SH SYNOPSIS
package require \fBstooop  4.1\fR
.sp
package require \fBswitched  2.2\fR
.sp
package require \fBtkpiechart  6.6\fR
.sp
\fBstooop::new\fR \fBpie\fR \fIcanvas\fR \fIx\fR \fIy\fR ?options?
.sp
\fBswitched::configure\fR \fIpieObject\fR ?options?
.sp
\fBswitched::cget\fR \fIpieObject\fR \fIoption\fR
.sp
\fBstooop::delete\fR \fIpieObject\fR
.sp
pie::newSlice \fIpieObject\fR ?labelText?
.sp
pie::deleteSlice \fIpieObject\fR \fIsliceObject\fR
.sp
pie::sizeSlice \fIpieObject\fR \fIsliceObject\fR \fIunitShare\fR ?displayedValue?
.sp
pie::labelSlice \fIpieObject\fR \fIsliceObject\fR \fIstring\fR
.sp
pie::selectedSlices \fIpieObject\fR
.sp
.BE
.SH DESCRIPTION
A pie object is used to visualize a set of values, usually as shares of a total. Each value is represented by a colored slice, which may have a 2 dimensional or 3 dimensional look. Each slice is associated with a label displaying the data name, and a numerical field showing the percentage taken by the slice. The labels are placed by the chosen labeler object (\fB-labeler\fR option). Each label color matches its related slice.
.PP
A pie chart is made of Tk canvas items, found in \fBpieBoxLabeler\fR, \fBpiePeripheralLabeler\fR and \fBcanvasLabel\fR objects, that compose the pie object. The pie constructor creates the pie itself and its background slice within the parent canvas. Once the pie object exists, slices can be created and resized. At the time the pie is created, the parent Tk \fBcanvas\fR widget must exist.
.PP
Slice colors are automatically generated, using a default color list for all pies, unless another list is used (using the \fB-colors\fR option). When a 3D look is used, the slice edge is darker than its top while using the same color tone.
.TP
\fBstooop::new\fR \fBpie\fR \fIcanvas\fR \fIx\fR \fIy\fR ?options?
Creates a pie object in the specified Tk canvas. The upper left corner of the pie is placed at the specified coordinates in the canvas. The pie object identifier is returned (referred to as \fIpieObject\fR in this document).
.TP
\fBswitched::configure\fR \fIpieObject\fR ?options?
Configures a pie object or returns all the options with their current values if no options are passed as parameters.
.TP
\fBswitched::cget\fR \fIpieObject\fR \fIoption\fR
Returns an option value for the specified pie object.
.TP
\fBstooop::delete\fR \fIpieObject\fR
Deletes the specified pie object.
.PP
.SH OVERVIEW
The pie class is part of the tkpiechart extension that allows the programmer to create and dynamically update 2D or 3D pie charts in a Tcl/Tk application. The tkpiechart package is written in Tcl only, using object oriented techniques thanks to the stooop package, included in tcllib.
.SH OPTIONS
.TP
\fB-autoupdate\fR boolean
Boolean value specifying whether all the slices and their labels are redrawn when a slice size is changed. On by default. Turn it off and invoke \fBpie::update\fR if you change many slices at once and want to improve performance.
.TP
\fB-background\fR color
Slices may or may not fill up the 100% of the pie. The unoccupied part of the pie is a slice that takes 100% of the pie. It is by default transparent with a black border. The color of this background slice may be set by the user using color names as in the \fB-background\fR standard option (see the Tk \fBoptions\fR manual page for more details). When the pie has a 3D look, the background of a slice edge is darker than the top and uses the same color tone.
.TP
\fB-colors\fR list
Specifies a list of colors for slices. In this case, the slice colors will successively be drawn from the list in the list order, cycling through if there are more slices than colors in the list. Colors are specified in the same format as the \fB-background\fR option.
.TP
\fB-height\fR value
Specifies the total height for the pie, including the room taken by the labeler labels. The pie slices are resized when labels are added or deleted (when adding or deleting slices) so that the total height remains constant. This value may be specified in any of the forms described in the \fBcanvas\fR \fICOORDINATES\fR manual section.
.TP
\fB-labeler\fR object
Specifies a placer object for the slice labels, so that, for example, slice values may be placed next to them. If not specified, the \fIpieBoxLabeler\fR (see corresponding manual) is used, the other option being the \fIpiePeripheralLabeler\fR class. Each labeler has a specific behavior which may be set via its options. The labeler object is automatically deleted when the pie object is itself deleted. The labeler cannot be changed once the pie is created.
.TP
\fB-selectable\fR boolean
Boolean value specifying whether slices are selectable or not. Acceptable values are those defined by the Tcl language itself for boolean values. If selectable, slices can be selected with the first mouse button, by clicking on either the slice or its label. Selection can be extended by using the classical \fIcontrol\fR or \fIshift\fR clicks. The list of currently selected slices can be retrieved at any time using the \fBselectedSlices\fR pie class member procedure.
.TP
\fB-title\fR text
Title text to be placed above the pie.
.TP
\fB-titlefont\fR value
Font for the title text.
.TP
\fB-titleoffset\fR value
Distance between the bottom of the title text and the top of the pie slices. This value may be specified in any of the forms described in the sizes section below.
.TP
\fB-thickness\fR value
The thickness is set to 0 by default, giving the pie a simple 2D shape, much faster to display. A positive thickness value will give the pie a 3D look with matched darker colors for the slices edges. These values may be specified in any of the forms described in the \fISIZES\fR section below.
.TP
\fB-width\fR value
Specifies the total width for the pie, including the room taken by the labeler labels. The pie slices are resized when labels are added or deleted (when adding or deleting slices) so that the total width remains constant. This value may be specified in any of the forms described in the \fBcanvas\fR \fICOORDINATES\fR manual section.
.PP
.SH "MEMBER PROCEDURES"
.TP
pie::newSlice \fIpieObject\fR ?labelText?
Creates a slice. A unique object identifier is returned (referred to as \fIsliceObject\fR in this document). The slice color is automatically allocated and the slice label placed using the specified labeler (using the \fB-labeler\fR option). The slice itself is placed after (clockwise) the existing slices. The slice object identifier will be used for sizing and resizing the slice.
.sp
If the label text is not specified, it will be set to \fI"slice n"\fR, \fIn\fR being the number of the slice in the order of creation (first slice is number 1).
.TP
pie::deleteSlice \fIpieObject\fR \fIsliceObject\fR
Deletes a slice. The following slices (clockwise) if any are then moved to compensate for the empty space left by the deleted slice.
.TP
pie::sizeSlice \fIpieObject\fR \fIsliceObject\fR \fIunitShare\fR ?displayedValue?
Sizes or resizes a slice. The slice is then automatically recalculated so it occupies the proper share of the whole pie. The \fIunitShare\fR parameter is a floating point number expressed in share (between 0 and 1) of the whole pie. The following slices (clockwise) are moved to accommodate the new slice size. The slice size value next to the slice label is also updated with the new share value or \fIdisplayedValue\fR if specified.
.TP
pie::labelSlice \fIpieObject\fR \fIsliceObject\fR \fIstring\fR
Updates a slice label. Can be invoked at any time.
.TP
pie::selectedSlices \fIpieObject\fR
Returns a list of currently selected slice objects.
.PP
.SH TAGS
The whole pie, the pie graphics (all slices), and each slice have the following specific tags:
.IP \(bu
\fBpie(pieObject)\fR
.IP \(bu
\fBpieSlices(pieObject)\fR
.IP \(bu
\fBslice(sliceObject)\fR
.PP
For example, the whole pie can be moved using the \fBcanvas\fR \fBmove\fR command on the pie tag, or bindings on slices can be set using the slice tags (see the \fBcanvas\fR manual page \fIITEM IDS AND TAGS\fR section for more information).
.SH SIZES
All sizes related to pies are stored as floating point numbers. The coordinates and sizes are specified in screen units, which are floating point numbers optionally followed by one of several letters as specified in the \fBcanvas\fR \fICOORDINATES\fR manual section.
.SH LIMITATIONS
If the number of slices is too big, identical colors will be used for some of the slices. You may set your own colors in this case.
.SH "SEE ALSO"
canvasLabel, pieBoxLabeler, piePeripheralLabeler
.SH KEYWORDS
canvas, labeler, pie, slice
.SH COPYRIGHT
.nf
Copyright (c) 1995-2004 Jean-Luc Fontaine <jfontain@free.fr>

.fi