<?php

//this script may only be included - so its better to die if called directly.
if (strpos($_SERVER["SCRIPT_NAME"],basename(__FILE__)) !== false) {
  header("location: index.php");
  exit;
}

/* Task properties:
   user, taskId, title, description, date, status, priority, completed, percentage
*/
class FaqLib extends TikiLib {
	function add_suggested_faq_question($faqId, $question, $answer, $user) {
		$question = strip_tags($question, '<a>');

		$answer = strip_tags($answer, '<a>');
		$query = "insert into `tiki_suggested_faq_questions`(`faqId`,`question`,`answer`,`user`,`created`)
    values(?,?,?,?,?)";
		$result = $this->query($query,array($faqId,$question,$answer,($user===null)?'':$user,$this->now));
	}

	function list_suggested_questions($offset, $maxRecords, $sort_mode, $find, $faqId) {
		$bindvars=array();
		if ($find || $faqId) {
			$mid = " where ";
			if ($find) {
				$findesc = '%' . $find . '%';
				$mid .= "(`question` like ? or `answer` like ?)";
				$bindvars[]=$findesc;
				$bindvars[]=$findesc;
				if ($faqId) {
					$mid .= " and ";
				}
			}
			if ($faqId) {
				$mid .= "`faqId`=?";
				$bindvars[]=$faqId;
			}
		} else {
			$mid = "";
		}

		$query = "select * from `tiki_suggested_faq_questions` $mid order by ".$this->convertSortMode($sort_mode);
		$query_cant = "select count(*) from `tiki_suggested_faq_questions` $mid";
		$result = $this->query($query,$bindvars,$maxRecords,$offset);
		$cant = $this->getOne($query_cant,$bindvars);
		$ret = array();

		while ($res = $result->fetchRow()) {
			$ret[] = $res;
		}

		$retval = array();
		$retval["data"] = $ret;
		$retval["cant"] = $cant;
		return $retval;
	}

	function list_all_faq_questions($offset, $maxRecords, $sort_mode, $find) {

		$bindvars=array();
		if ($find) {
			$findesc = '%' . $find . '%';

			$mid = " where (`question` like ? or `answer` like ?)";
			$bindvars[]=$findesc;
			$bindvars[]=$findesc;
		} else {
			$mid = "";
		}

		$query = "select * from `tiki_faq_questions` $mid order by ".$this->convertSortMode($sort_mode);
		$query_cant = "select count(*) from `tiki_faq_questions` $mid";
		$result = $this->query($query,$bindvars,$maxRecords,$offset);
		$cant = $this->getOne($query_cant,$bindvars);
		$ret = array();

		while ($res = $result->fetchRow()) {
			$ret[] = $res;
		}

		$retval = array();
		$retval["data"] = $ret;
		$retval["cant"] = $cant;
		return $retval;
	}

	function remove_faq($faqId) {
		$query = "delete from `tiki_faqs` where `faqId`=?";

		$result = $this->query($query,array($faqId));
		$query = "delete from `tiki_faq_questions` where `faqId`=?";
		$result = $this->query($query,array($faqId));
		// Remove comments and/or individual permissions for faqs
		$this->remove_object('faq', $faqId);
		return true;
	}

	function remove_faq_question($questionId) {
		$faqId = $this->getOne('select `faqId` from `tiki_faq_questions` where `questionId`=?', array($questionId));
		$result = $this->query('delete from `tiki_faq_questions` where `questionId`=?', array($questionId));
		return true;
	}

	function get_faq_question($questionId) {
		$query = "select * from `tiki_faq_questions` where `questionId`=?";

		$result = $this->query($query,array($questionId));

		if (!$result->numRows())
			return false;

		$res = $result->fetchRow();
		return $res;
	}

	function add_faq_hit($faqId) {
		global $prefs, $user;

		if ($prefs['count_admin_pvs'] == 'y' || $user != 'admin') {
			$query = "update `tiki_faqs` set `hits`=`hits`+1 where `faqId`=?";

			$result = $this->query($query,array($faqId));
		}
	}

	function replace_faq_question($faqId, $questionId, $question, $answer) {

		// Check the name
		if ( $questionId ) {
			$query = 'update `tiki_faq_questions` set `question`=?,`answer`=? where `questionId`=?';
			$bindvars = array($question, $answer, (int) $questionId);
			$result = $this->query($query, $bindvars);
		} else {
			$query = 'delete from `tiki_faq_questions` where `faqId`=? and question=?';
			$result = $this->query($query, array((int) $faqId, $question), -1, -1, false);
			$query = 'insert into `tiki_faq_questions`(`faqId`,`question`,`answer`, `created`) values(?,?,?,?)';
			$result = $this->query($query, array((int) $faqId, $question, $answer, $this->now));
			$questionId = $this->getOne('select max(questionId) from `tiki_faq_questions` where `faqId`=?', $faqId);
		}

		global $prefs;
		if ( $prefs['feature_search'] == 'y' && $prefs['feature_search_fulltext'] != 'y' && $prefs['search_refresh_index_mode'] == 'normal' ) {
			require_once('lib/search/refresh-functions.php');
			refresh_index('faq_questions', $questionId);
		}

		return true;
	}

	function replace_faq($faqId, $title, $description, $canSuggest) {

		// Check the name
		if ( $faqId ) {
			$query = 'update `tiki_faqs` set `title`=?,`description`=? ,`canSuggest`=? where `faqId`=?';
			$result = $this->query($query, array($title, $description, $canSuggest, (int) $faqId));
		} else {
			$query = 'delete from `tiki_faqs` where `title`=?';
			$result = $this->query($query, array($title), -1, -1, false);
			$query = 'insert into `tiki_faqs`(`title`,`description`,`created`,`hits`,`canSuggest`) values(?,?,?,?,?)';
			$result = $this->query($query, array($title, $description, (int) $this->now, 0, $canSuggest));
			$faqId = $this->getOne('select max(`faqId`) from `tiki_faqs` where `title`=? and `created`=?', array($title, (int) $this->now));
		}

		global $prefs;
		if ( $prefs['feature_search'] == 'y' && $prefs['feature_search_fulltext'] != 'y' && $prefs['search_refresh_index_mode'] == 'normal' ) {
			require_once('lib/search/refresh-functions.php');
			refresh_index('faqs', $faqId);
		}

		return $faqId;
	}

	function list_faq_questions($faqId=0, $offset=0, $maxRecords=-1, $sort_mode='question_asc', $find='') {
		if (!empty($faqId)) {
			$mid = ' where `faqId`=? ';
			$bindvars=array((int)$faqId);
		} else {
			$mid = '';
			$bindvars = array();
		}
		if (!empty($find)) {
			$findesc = '%' . $find . '%';
			if (empty($mid)) $mid = ' where ';
			$mid .= ' and (`question` like ? or `answer` like ?)';
			$bindvars=array($findesc, $findesc);
		}

		$query = "select * from `tiki_faq_questions` $mid order by ".$this->convertSortMode($sort_mode);
		$query_cant = "select count(*) from `tiki_faq_questions` $mid";
		$result = $this->query($query,$bindvars,$maxRecords,$offset);
		$cant = $this->getOne($query_cant,$bindvars);
		$ret = array();

		while ($res = $result->fetchRow()) {
			$res['parsed'] = $this->parse_data($res['answer']);

			$ret[] = $res;
		}

		$retval = array();
		$retval["data"] = $ret;
		$retval["cant"] = $cant;
		return $retval;
	}

	function remove_suggested_question($sfqId) {
		$query = "delete from `tiki_suggested_faq_questions` where `sfqId`=?";

		$result = $this->query($query,array((int) $sfqId));
	}

	function approve_suggested_question($sfqId) {
		$info = $this->get_suggested_question($sfqId);

		$this->replace_faq_question($info["faqId"], 0, $info["question"], $info["answer"]);
		$this->remove_suggested_question($sfqId);
	}

	function get_suggested_question($sfqId) {
		$query = "select * from `tiki_suggested_faq_questions` where `sfqId`=?";

		$result = $this->query($query,array($sfqId));

		if (!$result->numRows())
			return false;

		$res = $result->fetchRow();
		return $res;
	}
}
$faqlib = new FaqLib;
