#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <telepathy-glib/dbus-properties-mixin.h>

G_BEGIN_DECLS

/**
 * McSvcClient:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcClient McSvcClient;

/**
 * McSvcClientClass:
 *
 * The class of McSvcClient.
 */
typedef struct _McSvcClientClass McSvcClientClass;

GType mc_svc_client_get_type (void);
#define MC_TYPE_SVC_CLIENT \
  (mc_svc_client_get_type ())
#define MC_SVC_CLIENT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_CLIENT, McSvcClient))
#define MC_IS_SVC_CLIENT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_CLIENT))
#define MC_SVC_CLIENT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_CLIENT, McSvcClientClass))



/**
 * McSvcClientApprover:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcClientApprover McSvcClientApprover;

/**
 * McSvcClientApproverClass:
 *
 * The class of McSvcClientApprover.
 */
typedef struct _McSvcClientApproverClass McSvcClientApproverClass;

GType mc_svc_client_approver_get_type (void);
#define MC_TYPE_SVC_CLIENT_APPROVER \
  (mc_svc_client_approver_get_type ())
#define MC_SVC_CLIENT_APPROVER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_CLIENT_APPROVER, McSvcClientApprover))
#define MC_IS_SVC_CLIENT_APPROVER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_CLIENT_APPROVER))
#define MC_SVC_CLIENT_APPROVER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_CLIENT_APPROVER, McSvcClientApproverClass))


typedef void (*mc_svc_client_approver_add_dispatch_operation_impl) (McSvcClientApprover *self,
    const GPtrArray *in_Channels,
    const gchar *in_DispatchOperation,
    GHashTable *in_Properties,
    DBusGMethodInvocation *context);
void mc_svc_client_approver_implement_add_dispatch_operation (McSvcClientApproverClass *klass, mc_svc_client_approver_add_dispatch_operation_impl impl);
/**
 * mc_svc_client_approver_return_from_add_dispatch_operation:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_client_approver_return_from_add_dispatch_operation (DBusGMethodInvocation *context);
static inline void
mc_svc_client_approver_return_from_add_dispatch_operation (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * McSvcClientHandler:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcClientHandler McSvcClientHandler;

/**
 * McSvcClientHandlerClass:
 *
 * The class of McSvcClientHandler.
 */
typedef struct _McSvcClientHandlerClass McSvcClientHandlerClass;

GType mc_svc_client_handler_get_type (void);
#define MC_TYPE_SVC_CLIENT_HANDLER \
  (mc_svc_client_handler_get_type ())
#define MC_SVC_CLIENT_HANDLER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_CLIENT_HANDLER, McSvcClientHandler))
#define MC_IS_SVC_CLIENT_HANDLER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_CLIENT_HANDLER))
#define MC_SVC_CLIENT_HANDLER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_CLIENT_HANDLER, McSvcClientHandlerClass))


typedef void (*mc_svc_client_handler_handle_channels_impl) (McSvcClientHandler *self,
    const gchar *in_Account,
    const gchar *in_Connection,
    const GPtrArray *in_Channels,
    const GPtrArray *in_Requests_Satisfied,
    guint64 in_User_Action_Time,
    GHashTable *in_Handler_Info,
    DBusGMethodInvocation *context);
void mc_svc_client_handler_implement_handle_channels (McSvcClientHandlerClass *klass, mc_svc_client_handler_handle_channels_impl impl);
/**
 * mc_svc_client_handler_return_from_handle_channels:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_client_handler_return_from_handle_channels (DBusGMethodInvocation *context);
static inline void
mc_svc_client_handler_return_from_handle_channels (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * McSvcClientInterfaceRequests:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcClientInterfaceRequests McSvcClientInterfaceRequests;

/**
 * McSvcClientInterfaceRequestsClass:
 *
 * The class of McSvcClientInterfaceRequests.
 */
typedef struct _McSvcClientInterfaceRequestsClass McSvcClientInterfaceRequestsClass;

GType mc_svc_client_interface_requests_get_type (void);
#define MC_TYPE_SVC_CLIENT_INTERFACE_REQUESTS \
  (mc_svc_client_interface_requests_get_type ())
#define MC_SVC_CLIENT_INTERFACE_REQUESTS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_CLIENT_INTERFACE_REQUESTS, McSvcClientInterfaceRequests))
#define MC_IS_SVC_CLIENT_INTERFACE_REQUESTS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_CLIENT_INTERFACE_REQUESTS))
#define MC_SVC_CLIENT_INTERFACE_REQUESTS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_CLIENT_INTERFACE_REQUESTS, McSvcClientInterfaceRequestsClass))


typedef void (*mc_svc_client_interface_requests_add_request_impl) (McSvcClientInterfaceRequests *self,
    const gchar *in_Request,
    GHashTable *in_Properties,
    DBusGMethodInvocation *context);
void mc_svc_client_interface_requests_implement_add_request (McSvcClientInterfaceRequestsClass *klass, mc_svc_client_interface_requests_add_request_impl impl);
/**
 * mc_svc_client_interface_requests_return_from_add_request:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_client_interface_requests_return_from_add_request (DBusGMethodInvocation *context);
static inline void
mc_svc_client_interface_requests_return_from_add_request (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*mc_svc_client_interface_requests_remove_request_impl) (McSvcClientInterfaceRequests *self,
    const gchar *in_Request,
    const gchar *in_Error,
    const gchar *in_Message,
    DBusGMethodInvocation *context);
void mc_svc_client_interface_requests_implement_remove_request (McSvcClientInterfaceRequestsClass *klass, mc_svc_client_interface_requests_remove_request_impl impl);
/**
 * mc_svc_client_interface_requests_return_from_remove_request:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_client_interface_requests_return_from_remove_request (DBusGMethodInvocation *context);
static inline void
mc_svc_client_interface_requests_return_from_remove_request (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * McSvcClientObserver:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _McSvcClientObserver McSvcClientObserver;

/**
 * McSvcClientObserverClass:
 *
 * The class of McSvcClientObserver.
 */
typedef struct _McSvcClientObserverClass McSvcClientObserverClass;

GType mc_svc_client_observer_get_type (void);
#define MC_TYPE_SVC_CLIENT_OBSERVER \
  (mc_svc_client_observer_get_type ())
#define MC_SVC_CLIENT_OBSERVER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MC_TYPE_SVC_CLIENT_OBSERVER, McSvcClientObserver))
#define MC_IS_SVC_CLIENT_OBSERVER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MC_TYPE_SVC_CLIENT_OBSERVER))
#define MC_SVC_CLIENT_OBSERVER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MC_TYPE_SVC_CLIENT_OBSERVER, McSvcClientObserverClass))


typedef void (*mc_svc_client_observer_observe_channels_impl) (McSvcClientObserver *self,
    const gchar *in_Account,
    const gchar *in_Connection,
    const GPtrArray *in_Channels,
    const gchar *in_Dispatch_Operation,
    const GPtrArray *in_Requests_Satisfied,
    GHashTable *in_Observer_Info,
    DBusGMethodInvocation *context);
void mc_svc_client_observer_implement_observe_channels (McSvcClientObserverClass *klass, mc_svc_client_observer_observe_channels_impl impl);
/**
 * mc_svc_client_observer_return_from_observe_channels:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mc_svc_client_observer_return_from_observe_channels (DBusGMethodInvocation *context);
static inline void
mc_svc_client_observer_return_from_observe_channels (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}



G_END_DECLS
