# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{prawn-core}
  s.version = "0.5.0.1"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Gregory Brown"]
  s.date = %q{2009-06-14}
  s.description = %q{  Prawn is a fast, tiny, and nimble PDF generator for Ruby
}
  s.email = %q{  gregory.t.brown@gmail.com}
  s.extra_rdoc_files = ["README", "LICENSE", "COPYING"]
  s.files = ["examples/bounding_box/bounding_boxes.rb", "examples/bounding_box/russian_boxes.rb", "examples/column_box/column_box_example.rb", "examples/general/background.rb", "examples/general/canvas.rb", "examples/general/measurement_units.rb", "examples/general/metadata-info.rb", "examples/general/multi_page_layout.rb", "examples/general/page_geometry.rb", "examples/graphics/basic_images.rb", "examples/graphics/cmyk.rb", "examples/graphics/curves.rb", "examples/graphics/hexagon.rb", "examples/graphics/image_fit.rb", "examples/graphics/image_flow.rb", "examples/graphics/image_position.rb", "examples/graphics/line.rb", "examples/graphics/png_types.rb", "examples/graphics/polygons.rb", "examples/graphics/remote_images.rb", "examples/graphics/ruport_style_helpers.rb", "examples/graphics/stroke_bounds.rb", "examples/m17n/chinese_text_wrapping.rb", "examples/m17n/euro.rb", "examples/m17n/sjis.rb", "examples/m17n/utf8.rb", "examples/m17n/win_ansi_charset.rb", "examples/text/alignment.rb", "examples/text/dfont.rb", "examples/text/family_based_styling.rb", "examples/text/font_calculations.rb", "examples/text/font_size.rb", "examples/text/kerning.rb", "examples/text/simple_text.rb", "examples/text/simple_text_ttf.rb", "examples/text/span.rb", "examples/text/text_box.rb", "examples/text/text_flow.rb", "lib/prawn/compatibility.rb", "lib/prawn/core.rb", "lib/prawn/document/annotations.rb", "lib/prawn/document/bounding_box.rb", "lib/prawn/document/column_box.rb", "lib/prawn/document/destinations.rb", "lib/prawn/document/internals.rb", "lib/prawn/document/page_geometry.rb", "lib/prawn/document/span.rb", "lib/prawn/document/text/box.rb", "lib/prawn/document/text/wrapping.rb", "lib/prawn/document/text.rb", "lib/prawn/document.rb", "lib/prawn/encoding.rb", "lib/prawn/errors.rb", "lib/prawn/font/afm.rb", "lib/prawn/font/dfont.rb", "lib/prawn/font/ttf.rb", "lib/prawn/font.rb", "lib/prawn/graphics/color.rb", "lib/prawn/graphics.rb", "lib/prawn/images/jpg.rb", "lib/prawn/images/png.rb", "lib/prawn/images.rb", "lib/prawn/literal_string.rb", "lib/prawn/measurement_extensions.rb", "lib/prawn/measurements.rb", "lib/prawn/name_tree.rb", "lib/prawn/pdf_object.rb", "lib/prawn/reference.rb", "spec/annotations_spec.rb", "spec/bounding_box_spec.rb", "spec/destinations_spec.rb", "spec/document_spec.rb", "spec/font_spec.rb", "spec/graphics_spec.rb", "spec/images_spec.rb", "spec/jpg_spec.rb", "spec/measurement_units_spec.rb", "spec/name_tree_spec.rb", "spec/pdf_object_spec.rb", "spec/png_spec.rb", "spec/reference_spec.rb", "spec/span_spec.rb", "spec/spec_helper.rb", "spec/text_box_spec.rb", "spec/text_spec.rb", "vendor/pdf-inspector/lib/pdf/inspector/graphics.rb", "vendor/pdf-inspector/lib/pdf/inspector/page.rb", "vendor/pdf-inspector/lib/pdf/inspector/text.rb", "vendor/pdf-inspector/lib/pdf/inspector/xobject.rb", "vendor/pdf-inspector/lib/pdf/inspector.rb", "vendor/pdf-inspector/README", "vendor/ttfunk/data/fonts/comicsans.ttf", "vendor/ttfunk/data/fonts/DejaVuSans.ttf", "vendor/ttfunk/example.rb", "vendor/ttfunk/lib/ttfunk/directory.rb", "vendor/ttfunk/lib/ttfunk/encoding/mac_roman.rb", "vendor/ttfunk/lib/ttfunk/encoding/windows_1252.rb", "vendor/ttfunk/lib/ttfunk/reader.rb", "vendor/ttfunk/lib/ttfunk/resource_file.rb", "vendor/ttfunk/lib/ttfunk/subset/base.rb", "vendor/ttfunk/lib/ttfunk/subset/mac_roman.rb", "vendor/ttfunk/lib/ttfunk/subset/unicode.rb", "vendor/ttfunk/lib/ttfunk/subset/unicode_8bit.rb", "vendor/ttfunk/lib/ttfunk/subset/windows_1252.rb", "vendor/ttfunk/lib/ttfunk/subset.rb", "vendor/ttfunk/lib/ttfunk/subset_collection.rb", "vendor/ttfunk/lib/ttfunk/table/cmap/format00.rb", "vendor/ttfunk/lib/ttfunk/table/cmap/format04.rb", "vendor/ttfunk/lib/ttfunk/table/cmap/subtable.rb", "vendor/ttfunk/lib/ttfunk/table/cmap.rb", "vendor/ttfunk/lib/ttfunk/table/glyf/compound.rb", "vendor/ttfunk/lib/ttfunk/table/glyf/simple.rb", "vendor/ttfunk/lib/ttfunk/table/glyf.rb", "vendor/ttfunk/lib/ttfunk/table/head.rb", "vendor/ttfunk/lib/ttfunk/table/hhea.rb", "vendor/ttfunk/lib/ttfunk/table/hmtx.rb", "vendor/ttfunk/lib/ttfunk/table/kern/format0.rb", "vendor/ttfunk/lib/ttfunk/table/kern.rb", "vendor/ttfunk/lib/ttfunk/table/loca.rb", "vendor/ttfunk/lib/ttfunk/table/maxp.rb", "vendor/ttfunk/lib/ttfunk/table/name.rb", "vendor/ttfunk/lib/ttfunk/table/os2.rb", "vendor/ttfunk/lib/ttfunk/table/post/format10.rb", "vendor/ttfunk/lib/ttfunk/table/post/format20.rb", "vendor/ttfunk/lib/ttfunk/table/post/format25.rb", "vendor/ttfunk/lib/ttfunk/table/post/format30.rb", "vendor/ttfunk/lib/ttfunk/table/post/format40.rb", "vendor/ttfunk/lib/ttfunk/table/post.rb", "vendor/ttfunk/lib/ttfunk/table/simple.rb", "vendor/ttfunk/lib/ttfunk/table.rb", "vendor/ttfunk/lib/ttfunk.rb", "data/encodings/win_ansi.txt", "data/fonts/Action Man.dfont", "data/fonts/Activa.ttf", "data/fonts/Chalkboard.ttf", "data/fonts/comicsans.ttf", "data/fonts/Courier-Bold.afm", "data/fonts/Courier-BoldOblique.afm", "data/fonts/Courier-Oblique.afm", "data/fonts/Courier.afm", "data/fonts/DejaVuSans.ttf", "data/fonts/Dustismo_Roman.ttf", "data/fonts/gkai00mp.ttf", "data/fonts/Helvetica-Bold.afm", "data/fonts/Helvetica-BoldOblique.afm", "data/fonts/Helvetica-Oblique.afm", "data/fonts/Helvetica.afm", "data/fonts/MustRead.html", "data/fonts/Symbol.afm", "data/fonts/Times-Bold.afm", "data/fonts/Times-BoldItalic.afm", "data/fonts/Times-Italic.afm", "data/fonts/Times-Roman.afm", "data/fonts/ZapfDingbats.afm", "data/images/16bit.alpha", "data/images/16bit.dat", "data/images/16bit.png", "data/images/arrow.png", "data/images/arrow2.png", "data/images/barcode_issue.png", "data/images/dice.alpha", "data/images/dice.dat", "data/images/dice.png", "data/images/dice_interlaced.png", "data/images/fractal.jpg", "data/images/letterhead.jpg", "data/images/page_white_text.alpha", "data/images/page_white_text.dat", "data/images/page_white_text.png", "data/images/pigs.jpg", "data/images/rails.dat", "data/images/rails.png", "data/images/ruport.png", "data/images/ruport_data.dat", "data/images/ruport_transparent.png", "data/images/ruport_type0.png", "data/images/stef.jpg", "data/images/tru256.bmp", "data/images/web-links.dat", "data/images/web-links.png", "data/shift_jis_text.txt", "Rakefile", "README", "LICENSE", "COPYING"]
  s.homepage = %q{http://prawn.majesticseacreature.com}
  s.rdoc_options = ["--title", "Prawn Documentation", "--main", "README", "-q"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{prawn}
  s.rubygems_version = %q{1.3.5}
  s.summary = %q{A fast and nimble PDF generator for Ruby}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::RubyGemsVersion) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
