/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Date;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.HMAC;
import org.xbill.DNS.utils.base64;

public class TSIG {
    private static final String HMAC_MD5_STR = "HMAC-MD5.SIG-ALG.REG.INT.";
    private static final String HMAC_SHA1_STR = "hmac-sha1.";
    private static final String HMAC_SHA256_STR = "hmac-sha256.";
    public static final Name HMAC_MD5;
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA256;
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private String digest;
    private byte[] key;

    private final void getDigest() {
        if (this.alg.equals(HMAC_MD5)) {
            this.digest = "md5";
        } else if (this.alg.equals(HMAC_SHA1)) {
            this.digest = "sha-1";
        } else if (this.alg.equals(HMAC_SHA256)) {
            this.digest = "sha-256";
        } else {
            throw new IllegalArgumentException("Invalid algorithm");
        }
    }

    public static TSIG fromString(String string) {
        int n = string.indexOf(47);
        if (n < 0) {
            n = string.indexOf(58);
        }
        if (n < 0) {
            throw new IllegalArgumentException("String does not contain both name and secret");
        }
        return new TSIG(string.substring(0, n), string.substring(n + 1));
    }

    public TSIGRecord generate(Message message, byte[] byArray, int n, TSIGRecord tSIGRecord) {
        DNSOutput dNSOutput;
        int n2;
        Date date = n != 18 ? new Date() : tSIGRecord.getTimeSigned();
        HMAC hMAC = null;
        if (n == 0 || n == 18) {
            hMAC = new HMAC(this.digest, this.key);
        }
        if ((n2 = Options.intValue("tsigfudge")) < 0 || n2 > Short.MAX_VALUE) {
            n2 = 300;
        }
        if (tSIGRecord != null) {
            dNSOutput = new DNSOutput();
            dNSOutput.writeU16(tSIGRecord.getSignature().length);
            if (hMAC != null) {
                hMAC.update(dNSOutput.toByteArray());
                hMAC.update(tSIGRecord.getSignature());
            }
        }
        if (hMAC != null) {
            hMAC.update(byArray);
        }
        dNSOutput = new DNSOutput();
        this.name.toWireCanonical(dNSOutput);
        dNSOutput.writeU16(255);
        dNSOutput.writeU32(0L);
        this.alg.toWireCanonical(dNSOutput);
        long l = date.getTime() / 1000L;
        int n3 = (int)(l >> 32);
        long l2 = l & 0xFFFFFFFFL;
        dNSOutput.writeU16(n3);
        dNSOutput.writeU32(l2);
        dNSOutput.writeU16(n2);
        dNSOutput.writeU16(n);
        dNSOutput.writeU16(0);
        if (hMAC != null) {
            hMAC.update(dNSOutput.toByteArray());
        }
        byte[] byArray2 = hMAC != null ? hMAC.sign() : new byte[]{};
        byte[] byArray3 = null;
        if (n == 18) {
            dNSOutput = new DNSOutput();
            l = new Date().getTime() / 1000L;
            n3 = (int)(l >> 32);
            l2 = l & 0xFFFFFFFFL;
            dNSOutput.writeU16(n3);
            dNSOutput.writeU32(l2);
            byArray3 = dNSOutput.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, date, n2, byArray2, message.getHeader().getID(), n, byArray3);
    }

    public void apply(Message message, int n, TSIGRecord tSIGRecord) {
        TSIGRecord tSIGRecord2 = this.generate(message, message.toWire(), n, tSIGRecord);
        message.addRecord(tSIGRecord2, 3);
        message.tsigState = 3;
    }

    public void apply(Message message, TSIGRecord tSIGRecord) {
        this.apply(message, 0, tSIGRecord);
    }

    public void applyStream(Message message, TSIGRecord tSIGRecord, boolean bl) {
        if (bl) {
            this.apply(message, tSIGRecord);
            return;
        }
        Date date = new Date();
        HMAC hMAC = new HMAC(this.digest, this.key);
        int n = Options.intValue("tsigfudge");
        if (n < 0 || n > Short.MAX_VALUE) {
            n = 300;
        }
        DNSOutput dNSOutput = new DNSOutput();
        dNSOutput.writeU16(tSIGRecord.getSignature().length);
        hMAC.update(dNSOutput.toByteArray());
        hMAC.update(tSIGRecord.getSignature());
        hMAC.update(message.toWire());
        dNSOutput = new DNSOutput();
        long l = date.getTime() / 1000L;
        int n2 = (int)(l >> 32);
        long l2 = l & 0xFFFFFFFFL;
        dNSOutput.writeU16(n2);
        dNSOutput.writeU32(l2);
        dNSOutput.writeU16(n);
        hMAC.update(dNSOutput.toByteArray());
        byte[] byArray = hMAC.sign();
        byte[] byArray2 = null;
        TSIGRecord tSIGRecord2 = new TSIGRecord(this.name, 255, 0L, this.alg, date, n, byArray, message.getHeader().getID(), 0, byArray2);
        message.addRecord(tSIGRecord2, 3);
        message.tsigState = 3;
    }

    public byte verify(Message message, byte[] byArray, int n, TSIGRecord tSIGRecord) {
        Object object;
        TSIGRecord tSIGRecord2 = message.getTSIG();
        HMAC hMAC = new HMAC(this.digest, this.key);
        if (tSIGRecord2 == null) {
            return 1;
        }
        if (!tSIGRecord2.getName().equals(this.name) || !tSIGRecord2.getAlgorithm().equals(this.alg)) {
            if (Options.check("verbose")) {
                System.err.println("BADKEY failure");
            }
            return 17;
        }
        long l = System.currentTimeMillis();
        long l2 = tSIGRecord2.getTimeSigned().getTime();
        long l3 = tSIGRecord2.getFudge();
        if (Math.abs(l - l2) > l3 * 1000L) {
            if (Options.check("verbose")) {
                System.err.println("BADTIME failure");
            }
            return 18;
        }
        if (tSIGRecord != null && tSIGRecord2.getError() != 17 && tSIGRecord2.getError() != 16) {
            object = new DNSOutput();
            ((DNSOutput)object).writeU16(tSIGRecord.getSignature().length);
            hMAC.update(((DNSOutput)object).toByteArray());
            hMAC.update(tSIGRecord.getSignature());
        }
        message.getHeader().decCount(3);
        object = message.getHeader().toWire();
        message.getHeader().incCount(3);
        hMAC.update((byte[])object);
        int n2 = message.tsigstart - ((Object)object).length;
        hMAC.update(byArray, ((Object)object).length, n2);
        DNSOutput dNSOutput = new DNSOutput();
        tSIGRecord2.getName().toWireCanonical(dNSOutput);
        dNSOutput.writeU16(tSIGRecord2.dclass);
        dNSOutput.writeU32(tSIGRecord2.ttl);
        tSIGRecord2.getAlgorithm().toWireCanonical(dNSOutput);
        long l4 = tSIGRecord2.getTimeSigned().getTime() / 1000L;
        int n3 = (int)(l4 >> 32);
        long l5 = l4 & 0xFFFFFFFFL;
        dNSOutput.writeU16(n3);
        dNSOutput.writeU32(l5);
        dNSOutput.writeU16(tSIGRecord2.getFudge());
        dNSOutput.writeU16(tSIGRecord2.getError());
        if (tSIGRecord2.getOther() != null) {
            dNSOutput.writeU16(tSIGRecord2.getOther().length);
            dNSOutput.writeByteArray(tSIGRecord2.getOther());
        } else {
            dNSOutput.writeU16(0);
        }
        hMAC.update(dNSOutput.toByteArray());
        if (hMAC.verify(tSIGRecord2.getSignature())) {
            return 0;
        }
        if (Options.check("verbose")) {
            System.err.println("BADSIG failure");
        }
        return 16;
    }

    public int verify(Message message, byte[] byArray, TSIGRecord tSIGRecord) {
        return this.verify(message, byArray, byArray.length, tSIGRecord);
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    public TSIG(Name name, Name name2, byte[] byArray) {
        this.name = name2;
        this.alg = name;
        this.key = byArray;
        this.getDigest();
    }

    public TSIG(Name name, byte[] byArray) {
        this(HMAC_MD5, name, byArray);
    }

    public TSIG(Name name, String string, String string2) {
        this.key = base64.fromString(string2);
        if (this.key == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(string, Name.root);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = name;
        this.getDigest();
    }

    public TSIG(String string, String string2) {
        this(HMAC_MD5, string, string2);
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString(HMAC_MD5_STR);
        HMAC_SHA1 = Name.fromConstantString(HMAC_SHA1_STR);
        HMAC_SHA256 = Name.fromConstantString(HMAC_SHA256_STR);
    }

    public static class StreamVerifier {
        private TSIG key;
        private HMAC verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public int verify(Message message, byte[] byArray) {
            TSIGRecord tSIGRecord = message.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int n = this.key.verify(message, byArray, this.lastTSIG);
                if (n == 0) {
                    byte[] byArray2 = tSIGRecord.getSignature();
                    DNSOutput dNSOutput = new DNSOutput();
                    dNSOutput.writeU16(byArray2.length);
                    this.verifier.update(dNSOutput.toByteArray());
                    this.verifier.update(byArray2);
                }
                this.lastTSIG = tSIGRecord;
                return n;
            }
            if (tSIGRecord != null) {
                message.getHeader().decCount(3);
            }
            byte[] byArray3 = message.getHeader().toWire();
            if (tSIGRecord != null) {
                message.getHeader().incCount(3);
            }
            this.verifier.update(byArray3);
            int n = tSIGRecord == null ? byArray.length - byArray3.length : message.tsigstart - byArray3.length;
            this.verifier.update(byArray, byArray3.length, n);
            if (tSIGRecord == null) {
                boolean bl;
                boolean bl2 = false;
                if (this.nresponses - this.lastsigned >= 100) {
                    bl2 = true;
                }
                if (bl = bl2) {
                    return 1;
                }
                return 0;
            }
            this.lastsigned = this.nresponses;
            this.lastTSIG = tSIGRecord;
            if (!tSIGRecord.getName().equals(this.key.name) || !tSIGRecord.getAlgorithm().equals(this.key.alg)) {
                if (Options.check("verbose")) {
                    System.err.println("BADKEY failure");
                }
                return 17;
            }
            DNSOutput dNSOutput = new DNSOutput();
            long l = tSIGRecord.getTimeSigned().getTime() / 1000L;
            int n2 = (int)(l >> 32);
            long l2 = l & 0xFFFFFFFFL;
            dNSOutput.writeU16(n2);
            dNSOutput.writeU32(l2);
            dNSOutput.writeU16(tSIGRecord.getFudge());
            this.verifier.update(dNSOutput.toByteArray());
            if (!this.verifier.verify(tSIGRecord.getSignature())) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG failure");
                }
                return 16;
            }
            this.verifier.clear();
            dNSOutput = new DNSOutput();
            dNSOutput.writeU16(tSIGRecord.getSignature().length);
            this.verifier.update(dNSOutput.toByteArray());
            this.verifier.update(tSIGRecord.getSignature());
            return 0;
        }

        public StreamVerifier(TSIG tSIG, TSIGRecord tSIGRecord) {
            this.key = tSIG;
            this.verifier = new HMAC(this.key.digest, this.key.key);
            this.nresponses = 0;
            this.lastTSIG = tSIGRecord;
        }
    }
}

